<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Ripple_Button_v2 extends \Bricks\Element {
    public $category     = 'Next Bricks - Buttons';
    public $name         = 'ripple_button_v2';
    public $icon         = 'fa-solid fa-square-minus';
    public $tag      = 'div';
    public $scripts      = ['ripple_button_v2'];

    public function get_label() {
        return esc_html__( 'Ripple Button v2', 'bricks' );
    }

    public function set_controls() {
        $this->controls['tag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'HTML tag', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'div' => 'div',
                'span' => 'span',
                'button' => 'button',
                'custom' => 'custom',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'div',
            'default'     => 'div',
        ];
        $this->controls['customTag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Custom tag', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'placeholder' => 'div',
            'required'    => [ 'tag', '=', 'custom' ],
        ];
        $this->controls['link'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Link to', 'bricks' ),
            'type'  => 'link',
        ];
        $this->controls['type'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Ripple Type', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'fromTop' => 'from top',
                'fromBottom' => 'from bottom'
            ],
            'inline' => true,
            'placeholder' => 'from bottom',
        ];
        $this->controls['generalStyleSeparator'] = [
            'label'      => esc_html__( 'General style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['padding'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Padding', 'bricks' ),
            'type'        => 'spacing',
            'css'     => [
                [
                  'property' => 'padding',
                  'selector' => '&{pseudo} .next-ripple-button-v2__ripple-mask--top',
                ],
                                [
                  'property' => 'padding',
                  'selector' => '&{pseudo} .next-ripple-button-v2__ripple-mask--bottom',
                ],
            ],
            'rerender' => true,
      'default' => [
        'top' => '10px',
        'right' => '25px',
        'bottom' => '10px',
        'left' => '25px',
      ],
    ];
        $this->controls['typography'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Typography', 'bricks' ),
            'type'        => 'typography',
            'inline'      => true,
            'css'     => [
                [
                  'property' => 'typography',
                  'selector' => '&{pseudo} .next-ripple-button-v2__ripple-mask--top',
                ],
                [
                    'property' => 'typography',
                    'selector' => '&{pseudo} .next-ripple-button-v2__ripple-mask--bottom',
                ],
              ],
            'exclude' => [
              'color',
            ],
            'rerender' => true,
        ];
        $this->controls['border'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Border', 'bricks' ),
            'type'        => 'border',
            'inline'      => true,
            'css'     => [
                [
                  'property' => 'border',
                  'selector' => '',
                ],
            ],
            'rerender' => true,
        ];

        $this->controls['topRippleSeparator'] = [
            'label'      => esc_html__( 'Top Ripple', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['topRippleInnerTitle'] = [
            'tab'            => 'content',
            'type'           => 'text',
            'hasDynamicData' => 'text',
            'default'        => esc_html__( 'Top Ripple', 'bricks' ),
            'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
        ];
        $this->controls['topRippleBackground'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Background', 'bricks' ),
            'type'        => 'background',
            'inline'      => true,
            'css'     => [
                [
                  'property' => 'background',
                  'selector' => '&{pseudo} .next-ripple-button-v2__ripple-mask--top',
                ],
            ],
      'default' => [
        'color' => [
          'hex' => '#000000',
        ],
      ],
    ];
        $this->controls['topRippleColor'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Color', 'bricks' ),
            'type'        => 'color',
            'inline'      => true,
            'css'     => [
                [
                  'property' => 'color',
                  'selector' => '&{pseudo} .next-ripple-button-v2__ripple-mask--top',
                ],
            ],
      'default' => [
        'hex' => '#ffffff',
      ],
    ];

        $this->controls['bottomRippleSeparator'] = [
            'label'      => esc_html__( 'Bottom Ripple', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['bottomRippleInnerTitle'] = [
            'tab'            => 'content',
            'type'           => 'text',
            'hasDynamicData' => 'text',
            'default'        => esc_html__( 'Bottom Ripple', 'bricks' ),
            'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
        ];
        $this->controls['bottomRippleBackground'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Background', 'bricks' ),
            'type'        => 'background',
            'inline'      => true,
            'css'     => [
                [
                  'property' => 'background',
                  'selector' => '&{pseudo} .next-ripple-button-v2__ripple-mask--bottom',
                ],
            ],
      'default' => [
        'color' => [
          'hex' => '#0099FE',
        ],
      ],
    ];
        $this->controls['bottomRippleColor'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Color', 'bricks' ),
            'type'        => 'color',
            'inline'      => true,
            'css'     => [
                [
                  'property' => 'color',
                  'selector' => '&{pseudo} .next-ripple-button-v2__ripple-mask--bottom',
                ],
            ],
      'default' => [
        'hex' => '#ffffff',
      ],
    ];

        /*scale animation*/
        $this->controls['scaleAnimationSeparator'] = [
            'label'      => esc_html__( 'Scale Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['scale'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Scale', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'css'     => [
                [
                  'property' => '--scale',
                  'selector' => '',
                ],
            ],
            'placeholder' => '1.1',
            'default' => '1.1',
        ];
        $this->controls['scaleAnimationDuration'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Duration', 'bricks' ),
            'type'        => 'number',
            'unit'        => 's',
            'inline'      => true,
            'css'     => [
                [
                  'property' => '--scale-animation-duration',
                  'selector' => '',
                ],
            ],
            'placeholder' => '0.5s',
            'default' => '.5s',
        ];
        $this->controls['scaleAnimationDelay'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Delay', 'bricks' ),
            'type'        => 'number',
            'unit'        => 's',
            'inline'      => true,
            'css'     => [
                [
                  'property' => '--scale-animation-delay',
                  'selector' => '',
                ],
            ],
            'placeholder' => '0s',
            'default' => '0s',
        ];
        $this->controls['scaleAnimationEasing'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'CSS Easing', 'bricks' ),
            'type'        => 'text',
            'css'     => [
                [
                  'property' => '--scale-animation-easing',
                  'selector' => '',
                ],
            ],
            'placeholder' => 'cubic-bezier(.76,0,.24,1)',
            'default' => 'cubic-bezier(.76,0,.24,1)',
        ];

        /*translate animation*/
        $this->controls['translateAnimationSeparator'] = [
            'label'      => esc_html__( 'Translate Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['textTranslate'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Text translate', 'bricks' ),
            'type'        => 'number',
            'units'        => true,
            'inline'      => true,
            'css'     => [
                [
                  'property' => '--text-translate',
                  'selector' => '&{pseudo} .next-ripple-button-v2__ripple-masks',
                ],
            ],
            'placeholder' => '15px',
        ];
        $this->controls['translateAnimationDuration'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Duration', 'bricks' ),
            'type'        => 'number',
            'unit'        => 's',
            'inline'      => true,
            'css'     => [
                [
                  'property' => '--translate-animation-duration',
                  'selector' => '&{pseudo} .next-ripple-button-v2__ripple-masks',
                ],
            ],
            'placeholder' => '0.5s',
        ];
        $this->controls['translateAnimationDelay'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Delay', 'bricks' ),
            'type'        => 'number',
            'unit'        => 's',
            'inline'      => true,
            'css'     => [
                [
                  'property' => '--translate-animation-delay',
                  'selector' => '&{pseudo} .next-ripple-button-v2__ripple-masks',
                ],
            ],
            'placeholder' => '0s',
        ];
        $this->controls['translateAnimationEasing'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'CSS Easing', 'bricks' ),
            'type'        => 'text',
            'css'     => [
                [
                  'property' => '--translate-animation-easing',
                  'selector' => '&{pseudo} .next-ripple-button-v2__ripple-masks',
                ],
            ],
            'placeholder' => 'cubic-bezier(.76,0,.24,1)',
        ];

        /*rotate animation*/
        $this->controls['textRotateAnimationSeparator'] = [
            'label'      => esc_html__( 'Text Rotate Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['textRotate'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Text rotate', 'bricks' ),
            'type'        => 'number',
            'unit'        => 'deg',
            'inline'      => true,
            'css'     => [
                [
                  'property' => '--text-rotate',
                  'selector' => '&{pseudo} .next-ripple-button-v2__ripple-masks',
                ],
            ],
            'placeholder' => '90deg',
        ];
        $this->controls['textRotateAnimationDuration'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Duration', 'bricks' ),
            'type'        => 'number',
            'unit'        => 's',
            'inline'      => true,
            'css'     => [
                [
                  'property' => '--text-rotate-animation-duration',
                  'selector' => '&{pseudo} .next-ripple-button-v2__ripple-masks',
                ],
            ],
            'placeholder' => '0.75s',
        ];
        $this->controls['textRotateAnimationDelay'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Delay', 'bricks' ),
            'type'        => 'number',
            'unit'        => 's',
            'inline'      => true,
            'css'     => [
                [
                  'property' => '--text-rotate-animation-delay',
                  'selector' => '&{pseudo} .next-ripple-button-v2__ripple-masks',
                ],
            ],
            'placeholder' => '0.2s',
        ];
        $this->controls['textRotateAnimationEasing'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'CSS Easing', 'bricks' ),
            'type'        => 'text',
            'css'     => [
                [
                  'property' => '--text-rotate-animation-easing',
                  'selector' => '&{pseudo} .next-ripple-button-v2__ripple-masks',
                ],
            ],
            'placeholder' => 'cubic-bezier(.76,0,.24,1)',
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next-ripple-button-v2', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_ripple_button_v2.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $topRippleInnerTitle    = ! empty( $settings['topRippleInnerTitle'] ) ? $settings['topRippleInnerTitle'] : 'Top Ripple';
        $bottomRippleInnerTitle    = ! empty( $settings['bottomRippleInnerTitle'] ) ? $settings['bottomRippleInnerTitle'] : 'Bottom Ripple';

        if ( ! empty( $settings['link'] ) ) {
            $this->set_link_attributes( '_root', $settings['link'] );
            $root_tag = 'a';
        }else{
            $root_tag = $this->tag;
        }

        $this->set_attribute( '_root', 'class', 'next-ripple-button-v2' );
        $this->set_attribute( '_root', 'data-next-hide', '' );

        $type    = ! empty( $settings['type'] ) ? $settings['type'] : 'fromBottom';
        if ( $type == 'fromTop' ) {
            $this->set_attribute( '_root', 'data-from-top', '' );
        }

        $output = "
        <$root_tag {$this->render_attributes( '_root' )}>
            <div class='next-ripple-button-v2__ripple-masks'>
                <div class='next-ripple-button-v2__ripple-mask--top'>
                    <div class='next-ripple-button-v2__ripple-title--top-hide'>$topRippleInnerTitle</div>
                    <div class='next-ripple-button-v2__ripple-title--top-show'>$topRippleInnerTitle</div>
                </div>
                <div class='next-ripple-button-v2__ripple-mask--bottom'>
                    <div class='next-ripple-button-v2__ripple-title--bottom-hide'>$bottomRippleInnerTitle</div>
                    <div class='next-ripple-button-v2__ripple-title--bottom-show'>$bottomRippleInnerTitle</div>
                </div>
            </div>
        </$root_tag>
        ";

        echo $output;
    }
}