<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Ripple_Button_V4 extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'next-ripple-button-v4';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';

  public function get_label() {
    return esc_html__( 'Ripple Button v4', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Ripple Button v4', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['padding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '',
            ],
        ],
        'default' => [
            'top'    => 16,
            'right'  => 20, 
            'bottom' => 16,
            'left'   => 20,
        ],
    ];
    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'font-weight' => '600',
            'color' => [
                'hex' => '#000000',
              ]
        ],
    ];
    $this->controls['background'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--bg-color',
                'selector' => '&{pseudo} .nb-ripple-button-v4__bg',
            ],
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];
    $this->controls['border'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Border', 'bricks'),
        'type'    => 'border',
        'css'     => [
          [
            'property' => 'border',
            'selector' => '&{pseudo} .nb-ripple-button-v4__bg',
          ],
        ],
        'default' => [
            'radius' => [
                'top' => 100,
                'right' => 100,
                'bottom' => 100,
                'left' => 100,
            ],
        ]
    ];

    $this->controls['rippleAnimationSeparator'] = [
        'label'      => esc_html__( 'Ripple Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['layer1Color'] = [
        'tab'     => 'content',
        'label'   => esc_html__('First Color', 'bricks'),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--layer-1-color',
                'selector' => '',
            ],
        ],
        'default' => [
            'hex' => 'rgb(33, 144, 234)',
        ],
    ];
    $this->controls['layer2Color'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Second Color', 'bricks'),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--layer-2-color',
                'selector' => '',
            ],
        ],
        'default' => [
            'hex' => 'rgb(59, 217, 228)',
        ],
    ];
    $this->controls['layersTransformDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Duration', 'bricks'),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
            [
                'property' => '--layers-transform-duration',
                'selector' => '',
            ],
        ],
        'default' => '1.4s',
    ];
    $this->controls['delayBetweenLayers'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Stagger', 'bricks'),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
            [
                'property' => '--delay-between-layers',
                'selector' => '',
            ],
        ],
        'default' => '0.1s',
    ];
    $this->controls['layersTransformEasing'] = [
        'tab'     => 'content',
        'label'   => esc_html__('CSS Easing', 'bricks'),
        'type'    => 'text',
        'inline'  => true,
        'css'     => [
            [
                'property' => '--layers-transform-easing',
                'selector' => '',
            ],
        ],
        'default' => 'cubic-bezier(0.19, 1, 0.22, 1)',
    ];

    $this->controls['swapAnimationSeparator'] = [
        'label'      => esc_html__( 'Swap Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['lineTransformDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Duration', 'bricks'),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
            [
                'property' => '--line-transform-duration',
                'selector' => '',
            ],
        ],
        'default' => '1.3s',
    ];
    $this->controls['lineTransformEasing'] = [
        'tab'     => 'content',
        'label'   => esc_html__('CSS Easing', 'bricks'),
        'type'    => 'text',
        'inline'  => true,
        'css'     => [
            [
                'property' => '--line-transform-easing',
                'selector' => '',
            ],
        ],
        'default' => 'cubic-bezier(0.19, 1, 0.22, 1)',
    ];
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Ripple Button v4';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $this->set_attribute( '_root', 'class', 'nb-ripple-button-v4' );

    $output = "
    <$root_tag  {$this->render_attributes( '_root' )}>
        <span class='nb-ripple-button-v4__bg'>
          <span class='nb-ripple-button-v4__bg-layers'>
            <span class='nb-ripple-button-v4__bg-layer nb-ripple-button-v4__bg-layer--1'></span>
            <span class='nb-ripple-button-v4__bg-layer nb-ripple-button-v4__bg-layer--2'></span>
            <span class='nb-ripple-button-v4__bg-layer nb-ripple-button-v4__bg-layer--3'></span>
          </span>
        </span>
        <span class='nb-ripple-button-v4__inner'>
          <span class='nb-ripple-button-v4__inner-static'>$inner_title</span>
          <span class='nb-ripple-button-v4__inner-hover'>$inner_title</span>
        </span>
    </$root_tag>
    ";

	echo $output;
  }
}