<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Ripple_Button_V7 extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'next-ripple-button-v7';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';

  public function get_label() {
    return esc_html__( 'Ripple Button v7', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Ripple Button v7', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['padding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '',
            ],
        ],
        'default' => [
            'top'    => 15,
            'right'  => 20, 
            'bottom' => 15,
            'left'   => 20,
        ],
    ];
    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'font-weight' => '500',
            'color' => [
                'hex' => '#ffffff',
              ]
        ],
    ];
    $this->controls['background'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '',
            ],
        ],
        'default' => [
            'hex' => '#000000',
        ],
    ];
    $this->controls['border'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Border', 'bricks'),
        'type'    => 'border',
        'css'     => [
          [
            'property' => 'border',
            'selector' => '',
          ],
        ],
        'default' => [
            'radius' => [
                'top' => 100,
                'right' => 100,
                'bottom' => 100,
                'left' => 100,
            ],
        ]
    ];

    $this->controls['rippleAnimationSeparator'] = [
        'label'      => esc_html__( 'Ripple Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['rippleFrom'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'From', 'bricks' ),
        'type'    => 'select',
        'options' => [
            'top'    => esc_html__( 'Top', 'bricks' ),
            'bottom' => esc_html__( 'Bottom', 'bricks' ),
        ],
        'inline'    => true,
        'default'   => 'top',
        'required'  => false,
    ];
    $this->controls['rippleColor'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&{pseudo} .nb-ripple-button-v7__mask',
            ],
        ],
        'default' => [
            'hex' => '#ff6600',
        ],
    ];
    $this->controls['rippleDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Duration', 'bricks' ),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
            [
                'property' => '--ripple-duration',
                'selector' => '',
            ],
        ],
        'default' => '0.7s',
    ];
    $this->controls['rippleEase'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'CSS Easing', 'bricks' ),
        'type'    => 'text',
        'inline'  => true,
        'css'     => [
            [
                'property' => '--ripple-ease',
                'selector' => '',
            ],
        ],
        'default' => 'ease',
    ];

    $this->controls['swapAnimationSeparator'] = [
        'label'      => esc_html__( 'Swap Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['textFrom'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'From', 'bricks' ),
        'type'    => 'select',
        'options' => [
            'top'    => esc_html__( 'Top', 'bricks' ),
            'bottom' => esc_html__( 'Bottom', 'bricks' ),
        ],
        'inline'    => true,
        'default'   => 'top',
        'required'  => false,
    ];
    $this->controls['textTranslate'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Translate', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => '--text-translate',
                'selector' => '',
            ],
        ],
        'default' => '15px',
    ];
    $this->controls['textTranslateDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Duration', 'bricks' ),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
            [
                'property' => '--text-translate-duration',
                'selector' => '',
            ],
        ],
        'default' => '0.35s',
    ];
    $this->controls['textTranslateEase'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'CSS Easing', 'bricks' ),
        'type'    => 'text',
        'inline'  => true,
        'css'     => [
            [
                'property' => '--text-translate-ease',
                'selector' => '',
            ],
        ],
        'default' => 'ease',
    ];
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Ripple Button v7';
    $rippleFrom     = ! empty( $settings['rippleFrom'] ) ? $settings['rippleFrom'] : 'bottom';
    $textFrom       = ! empty( $settings['textFrom'] ) ? $settings['textFrom'] : 'bottom';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $this->set_attribute( '_root', 'class', 'nb-ripple-button-v7' );
    $this->set_attribute( '_root', 'data-text', $inner_title );
    $this->set_attribute( '_root', 'data-mask-to', $rippleFrom );
    $this->set_attribute( '_root', 'data-text-to', $textFrom );

    $output = "
    <$root_tag  {$this->render_attributes( '_root' )}>
        <span class='nb-ripple-button-v7__text'>$inner_title</span>
        <div class='nb-ripple-button-v7__mask'></div>
    </$root_tag>
    ";

	echo $output;
  }
}