<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Scrolling_Background extends \Bricks\Element {
  public $category     = 'Next Bricks - Backgrounds';
  public $name         = 'next_scrolling_background';
  public $icon         = 'ti-layout-media-center-alt';
  public $tag      = 'div';
  public $scripts      = ['next_scrolling_background'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Scrolling Background', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
        'div' => 'div',
        'section' => 'section',
        'article' => 'article',
        'aside' => 'aside',
        'header' => 'header',
        'footer' => 'footer',
        'main' => 'main',
        'nav' => 'nav',
        'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['note'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Scrolling Background is a nestable block element. You can put any elements at it and edit its display settings at the Style tab.', 'bricks' )))
    ];

    /*css*/
    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Block Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['width'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'width',
            'selector' => '',
          ]
        ],
        'default' => '100%',
    ];
    $this->controls['height'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'height',
            'selector' => '',
          ]
        ],
        'default' => '400svh',
    ];

    /*js settings*/
    $this->controls['scrollingBackgroundSeparator'] = [
        'label'      => esc_html__( 'Scrolling Background', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['note2'] = [
        'tab' => 'content',
        'description' => sprintf(html_entity_decode(esc_html__( 'Scrolling Background Height will be divided by the number of colors, resulting in X pixels. A color switch will happen every those X pixels.', 'bricks' )))
    ];
    $this->controls['colors'] = [
        'tab'           => 'content',
        'type'          => 'repeater',
        'label'         => esc_html__( 'Colors', 'bricks' ),
        'titleProperty' => 'title',
        'fields'        => [
            'gradientcolor'       => [
                'type'    => 'color',
                'label'   => esc_html__( 'Color', 'bricks' ),
            ],
        ],
        'default' => [
            [
                'gradientcolor' => [
                    'hex' => '#ff6b8a',
                ]
            ],
            [
                'gradientcolor' => [
                    'hex' => '#ffb347',
                ]
            ],
            [
                'gradientcolor' => [
                    'hex' => '#ffe4b5',
                ]
            ],
            [
                'gradientcolor' => [
                    'hex' => '#ff8a4d',
                ]
            ],
        ],
    ];
    $this->controls['transition'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Transition', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'fade'        => esc_html__( 'Fade', 'bricks' ),
            'progressive' => esc_html__( 'Progressive', 'bricks' ),
        ],
        'inline'      => true,
        'default'     => 'fade',
    ];
    $this->controls['duration'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Duration', 'bricks' ),
        'type'        => 'number',
        'inline'      => true,
        'default'     => '3s',
    ];
    $this->controls['ease'] = [
        'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'GSAP easing', 'bricks' ),
          'type' => 'select',
          'options'     => [
            'none' => 'none',
            'power1' => 'power1',
            'power2' => 'power2',
            'power3' => 'power3',
            'power4' => 'power4',
            'back' => 'back',
            'bounce' => 'bounce',
            'circ' => 'circ',
            'elastic' => 'elastic',
            'expo' => 'expo',
            'sine' => 'sine',
            'steps' => 'steps',
            'custom' => 'custom'
          ],
          'inline' => true,
          'default' => 'expo',
    ];
    $this->controls['customEase'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'ease', '=', 'custom' ],
    ];



  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'next_scrolling_background', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_scrolling_background.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $colors = ! empty( $settings['colors'] ) ? $settings['colors'] : '';
    if ($colors) {
        $gradientcolors = '';
        $initialColor = '';
        
        // Get the first color for initial background
        if (isset($colors[0]['gradientcolor']) && is_array($colors[0]['gradientcolor'])) {
            if (isset($colors[0]['gradientcolor']['rgb'])) {
                $initialColor = $colors[0]['gradientcolor']['rgb'];
            } else if(isset($colors[0]['gradientcolor']['raw'])) {
                $initialColor = $colors[0]['gradientcolor']['raw'];
            } else if(isset($colors[0]['gradientcolor']['hex'])) {
                $initialColor = $colors[0]['gradientcolor']['hex'];
            } else {
                $initialColor = 'unset';
            }
        } else {
            $initialColor = 'unset';
        }
        
        foreach ( $colors as $color ) {
            if ( isset($color['gradientcolor']) && is_array($color['gradientcolor'])) {
                if (isset($color['gradientcolor']['rgb'])) {
                  $gradientcolor = $color['gradientcolor']['rgb'];
                } else if(isset($color['gradientcolor']['raw'])) {
                  $gradientcolor = $color['gradientcolor']['raw'];
                } else if(isset($color['gradientcolor']['hex'])) {
                  $gradientcolor = $color['gradientcolor']['hex'];
                }
                $gradientcolors .= $gradientcolor . ($color === end($colors) ? '' : ',');
            } else {
                $gradientcolors .= 'unset' . ',';
            }
        }
    } else {
        $gradientcolors = 'unset';
        $initialColor = 'unset';
    }
    $this->set_attribute( '_root', 'data-colors', $gradientcolors);
    $this->set_attribute('_root', 'style', 'background-color: ' . $initialColor);

    $duration = isset($settings['duration']) ? $settings['duration'] : '3';
    $ease = isset($settings['ease']) ? $settings['ease'] : 'expo';
    if ($ease === 'custom') {
      $ease = ! empty( $settings['customEase'] ) ? $settings['customEase'] : 'expo';
    }
    $transition = isset($settings['transition']) ? $settings['transition'] : 'fade';

    $this->set_attribute( '_root', 'class', "nb-scrolling-background");
    $this->set_attribute('_root', 'data-duration', $duration);
    $this->set_attribute('_root', 'data-ease', $ease);
    $this->set_attribute('_root', 'data-transition', $transition);

    $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
    $output .= Frontend::render_children( $this );
    $output .= "</{$this->tag}>";

	echo $output;
  }
}