<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Scrolling_Gallery extends \Bricks\Element {
    public $category     = 'Next Bricks - Medias';
    public $name         = 'next_scrolling_gallery';
    public $icon         = 'ti-layout-media-center-alt';
    public $tag      = 'div';
    public $scripts      = ['next_scroll_gallery'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Scrolling Gallery', 'bricks' );
    }

    public function set_controls() {
        $this->controls['elements'] = [
            'tab'           => 'content',
            'type'          => 'repeater',
            'label'         => esc_html__( 'Gallery Images', 'bricks' ),
            'placeholder'   => esc_html__( 'Image', 'bricks' ),
            'titleProperty' => 'title',
            'default' => [
                [
                    'image'  => [
                        'url' => 'https://images.pexels.com/photos/31887348/pexels-photo-31887348.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2',
                    ],
                    'alt' => 'gallery-image',
                ],
                [
                    'image'  => [
                        'url' => 'https://images.pexels.com/photos/27085501/pexels-photo-27085501/free-photo-of-planta-ventanas-descuidado-cubierto-de-vegetacion.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2',
                    ],
                    'alt' => 'gallery-image',
                ],
                [
                    'image'  => [
                        'url' => 'https://images.pexels.com/photos/1048035/pexels-photo-1048035.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2',
                    ],
                    'alt' => 'gallery-image',
                ],
                [
                    'image'  => [
                        'url' => 'https://images.pexels.com/photos/15676265/pexels-photo-15676265/free-photo-of-hojas-verde-flora-tropical.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2',
                    ],
                    'alt' => 'gallery-image',
                ],
                [
                    'image'  => [
                        'url' => 'https://images.pexels.com/photos/1207978/pexels-photo-1207978.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2',
                    ],
                    'alt' => 'gallery-image',
                ],
                [
                    'image'  => [
                        'url' => 'https://images.pexels.com/photos/1122639/pexels-photo-1122639.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2',
                    ],
                    'alt' => 'gallery-image',
                ],
                [
                    'image'  => [
                        'url' => 'https://images.pexels.com/photos/2718447/pexels-photo-2718447.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2',
                    ],
                    'alt' => 'gallery-image',
                ],
                [
                    'image'  => [
                        'url' => 'https://images.pexels.com/photos/1407305/pexels-photo-1407305.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2',
                    ],
                    'alt' => 'gallery-image',
                ],
              ],
            'fields'        => [
                'image'       => [
                    'type'    => 'image',
                    'label'   => esc_html__( 'Image', 'bricks' ),
                ],
                'alt'       => [
                    'type'    => 'text',
                    'label'   => esc_html__( 'Alt', 'bricks' ),
                    'inline'    => true,
                ],
            ],
        ];

        $this->controls['blockStyleSeparator'] = [
            'label'      => esc_html__( 'Block Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'You can also use the Style Tab to edit Scrolling Gallery Block styles, especially to change the display styles as needed.', 'bricks' )))
        ];
        $this->controls['padding'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type'  => 'spacing',
            'css' => [
              [
                'property' => 'padding',
                'selector' => '', 
              ]
            ],
            'default' => [
                'top' => '20',
                'right' => '20',
                'bottom' => '20',
                'left' => '20',
            ],
        ];
        $this->controls['width'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'width',
                'selector' => '', 
              ]
            ],
            'default' => '100%',
        ];
        $this->controls['maxWidth'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Max Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'max-width',
                'selector' => '', 
              ]
            ],
            'default' => '1200px',
        ];
        $this->controls['gap'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Gap', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'gap',
                'selector' => '', 
              ]
            ],
            'default' => '50px',
        ];

        $this->controls['thumbnailsContainerSeparator'] = [
            'label'      => esc_html__( 'Thumbnails Container', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['thumbnailsContainerPadding'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type'  => 'spacing',
            'css' => [
              [
                'property' => 'padding',
                'selector' => '.nb-scroll-gallery__map', 
              ]
            ],
            'default' => [
                'top' => '25',
                'right' => '15',
                'bottom' => '25',
                'left' => '15',
            ],
        ];
        $this->controls['thumbnailsContainerWidth'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'width',
                'selector' => '.nb-scroll-gallery__map', 
              ]
            ],
            'default' => '20%',
        ];
        $this->controls['thumbnailsContainerHeight'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'height',
                'selector' => '.nb-scroll-gallery__map', 
              ]
            ],
            'default' => '100vh',
        ];
        $this->controls['gap'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Gap', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'gap',
                'selector' => '.nb-scroll-gallery__preview', 
              ]
            ],
            'default' => '0',
        ];

        $this->controls['thumbnailSeparator'] = [
            'label'      => esc_html__( 'Thumbnail', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['thumbnailWidth'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'width',
                'selector' => '.nb-scroll-gallery__thumbnail', 
              ]
            ],
            'default' => '50px',
        ];
        $this->controls['thumbnailBorder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type'  => 'border',
            'inline' => true,
            'css' => [
              [
                'property' => 'border',
                'selector' => '.nb-scroll-gallery__thumbnail', 
              ]
            ],
            'default' => [
                'radius' => [
                    'top' => '10',
                    'right' => '10',
                    'bottom' => '10',
                    'left' => '10',
                ],
            ],
        ];
        $this->controls['thumbnailOpacity'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Opacity', 'bricks' ),
            'type' => 'slider',
            'inline' => true,
            'units'    => [
              'px' => [
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
              ],
            ],
            'css' => [
              [
                'property' => 'opacity',
                'selector' => '.nb-scroll-gallery__thumbnail', 
              ]
            ],
            'default' => 0.5,
        ];
        $this->controls['thumbnailActiveScale'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Active Scale', 'bricks' ),
            'type' => 'number',
            'units' => false,
            'inline' => true,
            'css' => [
              [
                'property' => '--active-scale',
                'selector' => '.nb-scroll-gallery__thumbnail', 
              ]
            ],
            'default' => 1.3,
        ];
        $this->controls['thumbnailActiveBorder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Active Border', 'bricks' ),
            'type' => 'border',
            'inline' => true,
            'css' => [
              [
                'property' => 'border',
                'selector' => '.nb-scroll-gallery__thumbnail--active', 
              ]
            ],
            'default' => [
                'width' => [
                    'top' => 1,
                    'right' => 1,
                    'bottom' => 1,
                    'left' => 1,
                ],
                'style' => 'solid',
                'color' => [
                    'hex' => '#ffffff',
                ]
            ],
        ];
        $this->controls['thumbnailActiveDuration'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Active Duration', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => '--active-duration',
                'selector' => '.nb-scroll-gallery__thumbnail', 
              ]
            ],
            'default' => '0.3s',
        ];
        $this->controls['thumbnailActiveEasing'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Active CSS Easing', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'css' => [
              [
                'property' => '--active-easing',
                'selector' => '.nb-scroll-gallery__thumbnail', 
              ]
            ],
            'default' => 'ease-in-out',
        ];

        $this->controls['imagesContainerSeparator'] = [
            'label'      => esc_html__( 'Images Container', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['imagesContainerPadding'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type'  => 'spacing',
            'css' => [
              [
                'property' => 'padding',
                'selector' => '.nb-scroll-gallery__images', 
              ]
            ],
            'default' => [
                'top' => '50',
                'right' => '100',
                'bottom' => '50',
                'left' => '100',
            ],
        ];
        $this->controls['imagesContainerWidth'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'width',
                'selector' => '.nb-scroll-gallery__images', 
              ]
            ],
            'default' => '80%',
        ];
        $this->controls['imagesContainerGap'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Gap', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'gap',
                'selector' => '.nb-scroll-gallery__images', 
              ]
            ],
            'default' => '50',
        ];

        $this->controls['imageSeparator'] = [
            'label'      => esc_html__( 'Image', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['imageWidth'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'width',
                'selector' => '.nb-scroll-gallery__image', 
              ]
            ],
            'default' => '100%',
        ];
        $this->controls['imageMaxWidth'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Max Width', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'max-width',
                'selector' => '.nb-scroll-gallery__image', 
              ]
            ],
            'default' => '800px',
        ];
        $this->controls['imageHeight'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'height',
                'selector' => '.nb-scroll-gallery__image', 
              ]
            ],
            'default' => '100%',
        ];
        $this->controls['imageMaxHeight'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Max Height', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'max-height',
                'selector' => '.nb-scroll-gallery__image', 
              ]
            ],
            'default' => '1000px',
        ];
        $this->controls['imageBorder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type' => 'border',
            'inline' => true,
            'css' => [
              [
                'property' => 'border',
                'selector' => '.nb-scroll-gallery__image', 
              ]
            ],
            'default' => [
                'radius' => [
                    'top' => '50',
                    'right' => '50',
                    'bottom' => '50',
                    'left' => '50',
                ],
            ],
        ];

        $this->controls['animationSeparator'] = [
            'label'      => esc_html__( 'Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['note2'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Random Margin Thumbnails must be at least equal to Thumbnails Container horizontal padding.', 'bricks' )))
        ];
        $this->controls['randomMarginThumbnails'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Random Margin Thumbnails', 'bricks' ),
            'type' => 'number',
            'inline' => true,
            'default' => '15',
        ];
        $this->controls['randomMarginImages'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Random Margin Images', 'bricks' ),
            'type' => 'number',
            'inline' => true,
            'default' => '100',
        ];
        $this->controls['start'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Start', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'default' => 'top center',
        ];
        $this->controls['end'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'End', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'default' => 'bottom center-=50px',
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_scrolling_gallery', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_scrolling_gallery.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $is_builder = bricks_is_builder();
        $elements = ! empty( $settings['elements'] ) ? $settings['elements'] : false;
        $randomMarginThumbnails = ! empty( $settings['randomMarginThumbnails'] ) ? $settings['randomMarginThumbnails'] : '15';
        $randomMarginImages = ! empty( $settings['randomMarginImages'] ) ? $settings['randomMarginImages'] : '100';
        $start = ! empty( $settings['start'] ) ? $settings['start'] : 'top center';
        $end = ! empty( $settings['end'] ) ? $settings['end'] : 'bottom center-=50px';
        
        $this->set_attribute( '_root', 'class', "nb-scroll-gallery");

        if ( ! $is_builder ) {
            $this->set_attribute( '_root', 'data-flickering', "1");
        }
        $this->set_attribute( '_root', 'data-random-margin-thumbnails', $randomMarginThumbnails);
        $this->set_attribute( '_root', 'data-random-margin-images', $randomMarginImages);
        $this->set_attribute( '_root', 'data-start', $start);
        $this->set_attribute( '_root', 'data-end', $end);

        $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
            $output .= "
            <div class='nb-scroll-gallery__map'>
                <div class='nb-scroll-gallery__preview'>";
                    if ($elements) {
                        foreach ( $elements as $element ) {
                            $src;
                            $alt;
                            
                            //Get source
                            if ( !isset($element['image'])) {
                                $src = 'https://images.pexels.com/photos/31887348/pexels-photo-31887348.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2'; //defalt image
                            }else if ( isset($element['image']['mediaData']['url'])) {
                                $src = $element['image']['mediaData']['url'];
                            }else if ( isset($element['image']['url'])) {
                                $src = $element['image']['url'];
                            }else{
                                $src = 'https://images.pexels.com/photos/31887348/pexels-photo-31887348.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2'; //defalt image
                            }
            
                            //Get alt
                            if ( isset($element['alt'])) {
                                $alt = $element['alt'];
                            }
                            else{
                                $alt = 'gallery-image';
                            }

                            $output .= "
                            <div class='nb-scroll-gallery__thumbnail' tabindex='0' role='button' aria-label='Thumbnail'>
                                <img src='{$src}' alt='{$alt}'>
                            </div>
                            ";
                        }
                    }
                $output .= "</div>
            </div>
            <div class='nb-scroll-gallery__images'>";
                if ($elements) {
                    foreach ( $elements as $element ) {
                        $src;
                        $alt;
                        
                        //Get source
                        if ( !isset($element['image'])) {
                            $src = 'https://images.pexels.com/photos/31887348/pexels-photo-31887348.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2'; //default image
                        }else if ( isset($element['image']['mediaData']['url'])) {
                            $src = $element['image']['mediaData']['url'];
                        }else if ( isset($element['image']['url'])) {
                            $src = $element['image']['url'];
                        }else{
                            $src = 'https://images.pexels.com/photos/31887348/pexels-photo-31887348.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2'; //default image
                        }

                        //Get alt
                        if ( isset($element['alt'])) {
                            $alt = $element['alt'];
                        }
                        else{
                            $alt = 'gallery-image';
                        }

                        if (strpos($src, 'cloudinary.com') !== false) {
                            $src_decoding = 'decoding="async"';
                        } else {
                            $src_decoding = '';
                        }

                        $output .= "
                        <div class='nb-scroll-gallery__image'>
                            <img src='{$src}' alt='{$alt}' $src_decoding>
                        </div>
                        ";
                    }
                }
            $output .= "</div>";
        $output .= "</{$this->tag}>";

        echo $output;
    }
}
