<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Shiny_Button extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'next-shiny-button';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';
  public $scripts      = ['next_shiny_button'];

  public function get_label() {
    return esc_html__( 'Shiny Button', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Shiny Button', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['iconsSeparator'] = [
      'label'      => esc_html__( 'Icons', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['includeLeftIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Left Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['leftIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .nb-shiny-button__left-icon',
        ],
      ],
      'required'   => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .nb-shiny-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .nb-shiny-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .nb-shiny-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['includeRightIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Right Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['rightIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .nb-shiny-button__right-icon',
        ],
      ],
      'required'   => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .nb-shiny-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .nb-shiny-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .nb-shiny-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['padding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '',
            ],
        ],
        'default' => [
            'top'    => 12,
            'right'  => 25, 
            'bottom' => 12,
            'left'   => 25,
        ],
    ];
    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '&{pseudo} .nb-shiny-button__text',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'font-weight' => '400',
            'color' => [
                'hex' => '#e3e3e3',
              ]
        ],
    ];
    $this->controls['background'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '',
            ],
        ],
        'default' => [
            'hex' => '#272727',
        ],
    ];
    $this->controls['borderWidth'] = [
      'tab'     => 'content',
      'label'   => esc_html__('Border Width', 'bricks'),
      'type'    => 'number',
      'units'   => true,
      'css'     => [
        [
          'property' => '--border-width',
          'selector' => '',
        ],
      ],
      'default' => '2px',
    ];

    $this->controls['borderRadius'] = [
      'tab'     => 'content', 
      'label'   => esc_html__('Border Radius', 'bricks'),
      'type'    => 'number',
      'units'   => true,
      'css'     => [
        [
          'property' => '--border-radius',
          'selector' => '',
        ],
      ],
      'default' => '10px',
    ];

    $this->controls['animationSeparator'] = [
        'tab'   => 'content', 
        'label' => esc_html__('Animation', 'bricks'),
        'type'  => 'separator',
    ];

    $this->controls['shinyColor'] = [
      'tab'     => 'content',
      'label'   => esc_html__('Shiny Color', 'bricks'),
      'type'    => 'color',
      'css'     => [
        [
          'property' => '--shiny-color',
          'selector' => '',
        ],
      ],
      'default' => [
        'rgb' => 'rgba(255, 255, 255, 0.27)',
      ],
    ];
    $this->controls['shinyBackground'] = [
      'tab'     => 'content', 
      'label'   => esc_html__('Shiny Background', 'bricks'),
      'type'    => 'color',
      'css'     => [
        [
          'property' => '--shiny-background',
          'selector' => '',
        ],
      ],
      'default' => [
        'rgb' => 'rgba(27, 27, 27, 0.75)',
      ],
    ];

    $this->controls['fadeDuration'] = [
      'tab'     => 'content',
      'label'   => esc_html__('Fade Duration', 'bricks'),
      'type'    => 'number',
      'unit'   => 's',
      'css'     => [
        [
          'property' => '--fade-duration',
          'selector' => '',
        ],
      ],
      'default' => '0.3s',
    ];
  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'next-shiny-button', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_shiny_button.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $is_builder = bricks_is_builder();
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $includeLeftIcon = ! empty( $settings['includeLeftIcon'] ) ? $settings['includeLeftIcon'] : 0;
    $includeRightIcon = ! empty( $settings['includeRightIcon'] ) ? $settings['includeRightIcon'] : 0;
    if ( $includeLeftIcon !== 0 ) {
      $leftIcon = self::render_icon( $settings['leftIcon'], [ 'nb-shiny-button__left-icon' ] );
    }else{
      $leftIcon = '';
    }
    if ( $includeRightIcon !== 0 ) {
      $rightIcon = self::render_icon( $settings['rightIcon'], [ 'nb-shiny-button__right-icon' ] );
    }else{
      $rightIcon = '';
    }

    $this->set_attribute( '_root', 'class', 'nb-shiny-button' );

    if ( ! $is_builder ) {
      $this->set_attribute( '_root', 'data-flickering', '1' );
    }

    $output = "
    <$root_tag  {$this->render_attributes( '_root' )}>
        <div class='nb-shiny-button__effects'>
            <div class='nb-shiny-button__glow'></div>
            <div class='nb-shiny-button__shine'></div>
        </div>
        <div class='nb-shiny-button__background'></div>
        <div class='nb-shiny-button__text'>$leftIcon$inner_title$rightIcon</div>
    </$root_tag>
    ";

	echo $output;
  }
}
