<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Site_Loader extends \Bricks\Element {
  public $category     = 'Next Bricks - Cores';
  public $name         = 'next_site_loader';
  public $icon         = 'fas fa-spinner';
  public $scripts      = ['next_site_loader'];

  public function get_label() {
    return esc_html__( 'Site Loader', 'bricks' );
  }

  public function set_control_groups() {
    $this->control_groups['animation'] = [
      'title' => esc_html__( 'Animation', 'bricks' ),
      'tab'   => 'content',
    ];
    $this->control_groups['style'] = [
      'title' => esc_html__( 'Style', 'bricks' ),
      'tab'   => 'content',
    ];
  }

  public function set_controls() {
    $this->controls['note'] = [
        'tab' => 'content',
        'description' => sprintf(html_entity_decode(esc_html__( 'The loading animation will only be visible on the front. In the builder the site loader will be displayed to edit its appearance. Enable the following switch when you finish editing to hide it.', 'bricks' )))
    ];
    $this->controls['disablebuilder'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
        'type'     => 'checkbox',
        'default' => false,
    ];
    $this->controls['type'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Site Loader', 'bricks' ),
        'type' => 'select',
        'options'     => [
            'type1' => 'Type 1',
            'type2' => 'Type 2',
            'type3' => 'Type 3',
            'type4' => 'Type 4',
            'type5' => 'Type 5',
            'type6' => 'Type 6',
            'type7' => 'Type 7',
            'type8' => 'Type 8',
            'type9' => 'Type 9',
            'type10' => 'Type 10',
            'type11' => 'Type 11',
            'type12' => 'Type 12'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'type1',
    ];

    /*ANIMATION*/
    $this->controls['noteDuration'] = [
        'group' => 'animation',
        'tab' => 'content',
        'description' => sprintf(html_entity_decode(esc_html__( 'Loading time is extremely short in most cases, so it is recommended to set at least a minimum loading time.', 'bricks' ))),
        'required' => ['type', '!=', 'type10'],
    ];
    $this->controls['minDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Min. loading time', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '4s',
        'required' => ['type', '!=', 'type10'],
    ];

    /*ANIMATION - TYPE 1*/
    $this->controls['TYPE1textsSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Texts', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type1' ],
    ];
    $this->controls['TYPE1loadingText'] = [
        'group' => 'animation',
      'hasDynamicData' => true,
      'tab' => 'content',
      'label' => esc_html__( 'Loading Text', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'default' => 'Loading',
      'required' => ['type', '=', 'type1'],
    ];
    $this->controls['TYPE1completeText'] = [
        'group' => 'animation',
      'hasDynamicData' => true,
      'tab' => 'content',
      'label' => esc_html__( 'Complete Text', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'default' => 'Complete',
      'required' => ['type', '=', 'type1'],
    ];
    $this->controls['TYPE1swapSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Swap', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type1' ],
    ];
    $this->controls['TYPE1swapDuration'] = [
        'group' => 'animation',
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Duration', 'bricks' ),
      'type' => 'number',
      'unit' => 's',
      'inline' => true,
      'default' => '0.7s',
      'required' => ['type', '=', 'type1'],
    ];
    $this->controls['TYPE1swapStagger'] = [
        'group' => 'animation',
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Stagger', 'bricks' ),
      'type' => 'number',
      'unit' => 's',
      'inline' => true,
      'default' => '0.03s',
      'required' => ['type', '=', 'type1'],
    ];
    $this->controls['TYPE1swapEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'none' => 'none',
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'power2',
        'required' => ['type', '=', 'type1'],  
    ];
    $this->controls['customTYPE1swapEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE1swapEase', '=', 'custom' ],
    ];





    $this->controls['TYPE1slideSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Slide', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type1' ],
    ];
    $this->controls['TYPE1slideDuration'] = [
        'group' => 'animation',
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Duration', 'bricks' ),
      'type' => 'number',
      'unit' => 's',
      'inline' => true,
      'default' => '1s',
      'required' => ['type', '=', 'type1'],
    ];
    $this->controls['TYPE1slideDelay'] = [
        'group' => 'animation',
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Delay', 'bricks' ),
      'type' => 'number',
      'unit' => 's',
      'inline' => true,
      'default' => '0.4s',
      'required' => ['type', '=', 'type1'],
    ];
    $this->controls['TYPE1slideEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'none' => 'none',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'power2',
        'required' => ['type', '=', 'type1'],  
    ];
    $this->controls['customTYPE1slideEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE1slideEase', '=', 'custom' ],
    ];





    $this->controls['TYPE1progressBarSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Progress Bar', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type1' ],
    ];
    $this->controls['TYPE1progressBarEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'none' => 'none',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'power1',
        'required' => ['type', '=', 'type1'],
    ];
    $this->controls['customTYPE1progressBarEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE1progressBarEase', '=', 'custom' ],
    ];






    /*ANIMATION - TYPE 2*/
    $this->controls['TYPE2progressBarSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Progress Bar', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type2' ],
    ];
    $this->controls['TYPE2progressBarEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'none' => 'none',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'power1',
        'required' => ['type', '=', 'type2'],
    ];
    $this->controls['customTYPE2progressBarEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE2progressBarEase', '=', 'custom' ],
    ];





    $this->controls['TYPE2percentageSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Percentage', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type2' ],
    ];
    $this->controls['TYPE2percentageEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'none' => 'none',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'power1',
        'required' => ['type', '=', 'type2'],
    ];
    $this->controls['customTYPE2percentageEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE2percentageEase', '=', 'custom' ],
    ];





    $this->controls['TYPE2slideSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Slide', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type2' ],
    ];
    $this->controls['TYPE2slideDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '1s',
        'required' => ['type', '=', 'type2'],
    ];
    $this->controls['TYPE2slideDelay'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Delay', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '0.4s',
        'required' => ['type', '=', 'type2'],
    ];
    $this->controls['TYPE2slideEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'none' => 'none',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'power2',
        'required' => ['type', '=', 'type2'],
    ];
    $this->controls['customTYPE2slideEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE2slideEase', '=', 'custom' ],
    ];






    /*ANIMATION - TYPE 3*/
    $this->controls['TYPE3commandlineSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Command Lines', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3symbol'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Symbol', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'default' => '$',
        'required' => ['type', '=', 'type3'],
    ];
    $this->controls['TYPE3commandline1'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Line 1', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'default' => 'Removing the boring WordPress website',
        'required' => ['type', '=', 'type3'],
    ];
    $this->controls['TYPE3commandline2'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Line 2', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'default' => 'Acccessing Bricks Builder',
        'required' => ['type', '=', 'type3'],
    ];
    $this->controls['TYPE3commandline3'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Line 3', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'default' => 'Launching Next Bricks',
        'required' => ['type', '=', 'type3'],
    ];
    $this->controls['TYPE3commandline4'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Line 4', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'default' => 'Decoding Elements',
        'required' => ['type', '=', 'type3'],
    ];
    $this->controls['TYPE3terminalAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Terminal', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3terminalFinishScale'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Finish Scale', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => '0.95',
        'required' => ['type', '=', 'type3'],
    ];
    $this->controls['TYPE3terminalScaleDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '0.5s',
        'required' => ['type', '=', 'type3'],
    ];
    $this->controls['TYPE3terminalScaleEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'none' => 'none',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'power2',
        'required' => ['type', '=', 'type3'],
    ];
    $this->controls['customTYPE3terminalScaleEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE3terminalScaleEase', '=', 'custom' ],
    ];





    $this->controls['TYPE3commandsAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Commands', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3translateCommandsFrom'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Translate From', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'default' => '20px',
        'required' => ['type', '=', 'type3'],
    ];
    $this->controls['TYPE3commandsDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '0.5s',
        'required' => ['type', '=', 'type3'],
    ];
    $this->controls['TYPE3commandsEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'none' => 'none',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'power2',
        'required' => ['type', '=', 'type3'],
    ];
    $this->controls['customTYPE3commandsEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE3commandsEase', '=', 'custom' ],
    ];





    $this->controls['TYPE3exitFadeSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Exit Fade', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3exitFadeDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '0.5s',
        'required' => ['type', '=', 'type3'],
    ];
    $this->controls['TYPE3exitFadeEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'none' => 'none',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'power2',
        'required' => ['type', '=', 'type3'],
    ];
    $this->controls['customTYPE3exitFadeEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE3exitFadeEase', '=', 'custom' ],
    ];





    $this->controls['TYPE3cursorBlinkSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Cursor Blink', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3cursorBlinkDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '1s',
        'css' => [
            [
                'property' => '--blink-duration',
                'selector' => '.nb-site-loader--type3__cursor--active',
            ],
        ],
        'required' => ['type', '=', 'type3'],
    ];
    $this->controls['TYPE3cursorBlinkEasing'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'CSS Easing', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'default' => 'ease-in-out',
        'css' => [
            [
                'property' => '--blink-easing',
                'selector' => '.nb-site-loader--type3__cursor--active',
            ],
        ],
        'required' => ['type', '=', 'type3'],
    ];

    /*ANIMATION - TYPE 4*/
    $this->controls['TYPE4progressTextAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Text', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type4' ],
    ];
    $this->controls['TYPE4progressText'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Progress Text', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'default' => 'loading',
        'required' => ['type', '=', 'type4'],
    ];
    $this->controls['TYPE4initialLoadingAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Initial Loading', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type4' ],
    ];
    $this->controls['TYPE4initialLoadingDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '1.5s',
        'required' => ['type', '=', 'type4'],
    ];
    $this->controls['TYPE4initialLoadingDelay'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Delay', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '0.5s',
        'required' => ['type', '=', 'type4'],
    ];
    $this->controls['TYPE4initialLoadingEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'none' => 'none',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'expo',
        'required' => ['type', '=', 'type4'],
    ];
    $this->controls['customTYPE4initialLoadingEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE4initialLoadingEase', '=', 'custom' ],
    ];





    $this->controls['TYPE4progressAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Progress', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type4' ],
    ];
    $this->controls['TYPE4progressEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'none' => 'none',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'expo',
        'required' => ['type', '=', 'type4'],
    ];
    $this->controls['customTYPE4progressEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE4progressEase', '=', 'custom' ],
    ];





    $this->controls['TYPE4exitSlidesAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Exit Slides', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type4' ],
    ];
    $this->controls['TYPE4exitSlidesDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '1s',
        'required' => ['type', '=', 'type4'],
    ];
    $this->controls['TYPE4exitSlidesEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'none' => 'none',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'power3',
        'required' => ['type', '=', 'type4'],
    ];
    $this->controls['customTYPE4exitSlidesEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE4exitSlidesEase', '=', 'custom' ],
    ];






    /*ANIMATION - TYPE 5*/
    $this->controls['TYPE5textAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Text', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type5' ],
    ];
    $this->controls['TYPE5brand'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Brand Text', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'default' => 'Next Bricks',
        'required' => ['type', '=', 'type5'],
    ];
    $this->controls['TYPE5countExitFadeAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Count Exit Fade', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type5' ],
    ];
    $this->controls['TYPE5countExitFadeDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '0.5s',
        'required' => ['type', '=', 'type5'],
    ];
    $this->controls['TYPE5countExitFadeEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'none' => 'none',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'power2',
        'required' => ['type', '=', 'type5'],
    ];
    $this->controls['customTYPE5countExitFadeEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE5countExitFadeEase', '=', 'custom' ],
    ];





    $this->controls['TYPE5swapAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Swap', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type5' ],
    ];
    $this->controls['TYPE5swapDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '1.5s',
        'required' => ['type', '=', 'type5'],
    ];
    $this->controls['TYPE5swapStagger'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Stagger', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '0.03s',
        'required' => ['type', '=', 'type5'],
    ];
    $this->controls['TYPE5swapEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'none' => 'none',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'expo',
        'required' => ['type', '=', 'type5'],
    ];
    $this->controls['customTYPE5swapEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE5swapEase', '=', 'custom' ],
    ];





    $this->controls['TYPE5loaderScaleAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Loader Scale', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type5' ],
    ];
    $this->controls['TYPE5loaderScale'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Scale', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => '0.5',
        'required' => ['type', '=', 'type5'],
    ];
    $this->controls['TYPE5loaderScaleDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '2s',
        'required' => ['type', '=', 'type5'],
    ];
    $this->controls['TYPE5loaderScaleEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'none' => 'none',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'power4',
        'required' => ['type', '=', 'type5'],
    ];
    $this->controls['customTYPE5loaderScaleEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE5loaderScaleEase', '=', 'custom' ],
    ];





    $this->controls['TYPE5exitSlidesAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Exit Slides', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type5' ],
    ];
    $this->controls['TYPE5exitSlidesDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '1.5s',
        'required' => ['type', '=', 'type5'],
    ];
    $this->controls['TYPE5exitSlidesEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'none' => 'none',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'power4',
        'required' => ['type', '=', 'type5'],
    ];
    $this->controls['customTYPE5exitSlidesEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE5exitSlidesEase', '=', 'custom' ],
    ];






    /*ANIMATION - TYPE 6*/
    $this->controls['TYPE6counterSwapAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Counter Swap', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type6' ],
    ];
    $this->controls['TYPE6counterSwapDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '1s',
        'required' => ['type', '=', 'type6'],
    ];
    $this->controls['TYPE6counterSwapStagger'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Stagger', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '0.1s',
        'required' => ['type', '=', 'type6'],
    ];
    $this->controls['TYPE6counterSwapEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'none' => 'none',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'expo',
        'required' => ['type', '=', 'type6'],
    ];
    $this->controls['customTYPE6counterSwapEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE6counterSwapEase', '=', 'custom' ],
    ];





    $this->controls['TYPE6exitTypeAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Exit Animation', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type6' ],
    ];
    $this->controls['TYPE6exitType'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Type', 'bricks' ),
        'type' => 'select',
        'options' => [
          'toTop' => 'To Top',
          'toBottom' => 'To Bottom',
          'toLeft' => 'To Left',
          'toRight' => 'To Right'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'toTop',
        'required' => ['type', '=', 'type6'],
    ];
    $this->controls['TYPE6exitTypeDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '1s',
        'required' => ['type', '=', 'type6'],
    ];
    $this->controls['TYPE6exitTypeEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'none' => 'none',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'expo',
        'required' => ['type', '=', 'type6'],
    ];
    $this->controls['customTYPE6exitTypeEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE6exitTypeEase', '=', 'custom' ],
    ];






    /*ANIMATION - TYPE 7*/
    $this->controls['TYPE7image'] = [
        'hasDynamicData' => true,
        'tab' => 'content',
        'label' => esc_html__( 'Image', 'bricks' ),
        'type' => 'image',
        'default'  => [
            'url' => 'https://nextbricks.io/wp-content/uploads/2024/07/logo-next-bricks.png',
        ],
        'required' => ['type', '=', 'type7'],
    ];
    $this->controls['TYPE7alt'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Alt text', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'default' => 'Next Bricks',
        'required' => ['type', '=', 'type7'],
    ];
    $this->controls['TYPE7progressAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Progress', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type7' ],
    ];
    $this->controls['TYPE7progressEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'none' => 'none',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'power2',
        'required' => ['type', '=', 'type7'],
    ];
    $this->controls['customTYPE7progressEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE7progressEase', '=', 'custom' ],
    ];





    $this->controls['TYPE7barScaleAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Bar Scale', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type7' ],
    ];
    $this->controls['TYPE7barScale'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Scale', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => '200',
        'required' => ['type', '=', 'type7'],
    ];
    $this->controls['TYPE7barScaleDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '1s',
        'required' => ['type', '=', 'type7'],
    ];
    $this->controls['TYPE7barScaleEasing'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'none' => 'none',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'power2',
        'required' => ['type', '=', 'type7'],
    ];
    $this->controls['customTYPE7barScaleEasing'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE7barScaleEasing', '=', 'custom' ],
    ];





    $this->controls['TYPE7exitFadeAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Exit Fade', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type7' ],
    ];
    $this->controls['TYPE7exitFadeDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '0.5s',
        'required' => ['type', '=', 'type7'],
    ];
    $this->controls['TYPE7exitFadeEasing'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'none' => 'none',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'power1',
        'required' => ['type', '=', 'type7'],
    ];
    $this->controls['customTYPE7exitFadeEasing'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE7exitFadeEasing', '=', 'custom' ],
    ];






    /*ANIMATION - TYPE 8*/
    $this->controls['TYPE8barsAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Bars', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type8' ],
    ];
    $this->controls['TYPE8barsDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '0.8s',
        'required' => ['type', '=', 'type8'],
    ];
    $this->controls['TYPE8barsStagger'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Stagger', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '0.03s',
        'required' => ['type', '=', 'type8'],
    ];
    $this->controls['TYPE8barsEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'none' => 'none',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'power3',
        'required' => ['type', '=', 'type8'],
    ];
    $this->controls['customTYPE8barsEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE8barsEase', '=', 'custom' ],
    ];





    $this->controls['TYPE8counterExitFadeAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Counter Exit Fade', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type8' ],
    ];
    $this->controls['TYPE8counterExitFadeDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '0.5s',
        'required' => ['type', '=', 'type8'],
    ];
    $this->controls['TYPE8counterExitFadeEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'none' => 'none',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'expo',
        'required' => ['type', '=', 'type8'],
    ];
    $this->controls['customTYPE8counterExitFadeEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE8counterExitFadeEase', '=', 'custom' ],
    ];






    /*ANIMATION - TYPE 9*/
    $this->controls['TYPE9exitDirectionAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Exit', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type9' ],
    ];
    $this->controls['TYPE9exitDirection'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Direction', 'bricks' ),
        'type' => 'select',
        'options' => [
            'top' => 'Top',
            'bottom' => 'Bottom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'bottom',
        'required' => ['type', '=', 'type9'],
    ];
    $this->controls['TYPE9barsAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Bars', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type9' ],
    ];
    $this->controls['TYPE9barsDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '0.8s',
        'required' => ['type', '=', 'type9'],
    ];
    $this->controls['TYPE9barsStagger'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Stagger', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '0.03s',
        'required' => ['type', '=', 'type9'],
    ];
    $this->controls['TYPE9barsEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'none' => 'none',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'power3',
        'required' => ['type', '=', 'type9'],
    ];
    $this->controls['customTYPE9barsEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE9barsEase', '=', 'custom' ],
    ];





    $this->controls['TYPE9counterExitFadeAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Counter Exit Fade', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type9' ],
    ];
    $this->controls['TYPE9counterExitFadeDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '0.5s',
        'required' => ['type', '=', 'type9'],
    ];
    $this->controls['TYPE9counterExitFadeEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'none' => 'none',
          'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'expo',
        'required' => ['type', '=', 'type9'],
    ];
    $this->controls['customTYPE9counterExitFadeEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE9counterExitFadeEase', '=', 'custom' ],
    ];






    /*ANIMATION - TYPE 10*/
    $this->controls['TYPE10image1'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Image 1', 'bricks' ),
        'type' => 'image',
        'default' => [
            'url' => 'https://cdn.cosmos.so/5f8d5539-943c-4df5-bae8-8e714633ddd0.jpeg'
        ],
        'required' => ['type', '=', 'type10'],
    ];
    $this->controls['TYPE10image1Alt'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Image 1 Alt Text', 'bricks' ),
        'default' => 'Image 1',
        'inline' => true,
        'type' => 'text',
        'placeholder' => esc_html__( 'Enter alt text', 'bricks' ),
        'required' => ['type', '=', 'type10'],
    ];
    $this->controls['TYPE10image2'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Image 2', 'bricks' ),
        'type' => 'image',
        'default' => [
            'url' => 'https://cdn.cosmos.so/0098a074-f8a2-4821-bcb0-433c093ae255.jpeg'
        ],
        'required' => ['type', '=', 'type10'],
    ];
    $this->controls['TYPE10image2Alt'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Image 2 Alt Text', 'bricks' ),
        'default' => 'Image 2',
        'type' => 'text',
        'placeholder' => esc_html__( 'Enter alt text', 'bricks' ),
        'inline' => true,
        'required' => ['type', '=', 'type10'],
    ];
    $this->controls['TYPE10image3'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Image 3', 'bricks' ),
        'type' => 'image',
        'default' => [
            'url' => 'https://cdn.cosmos.so/ce9f9fd7-a2a5-476d-9757-481ca01b5861.jpeg'
        ],
        'required' => ['type', '=', 'type10'],
    ];
    $this->controls['TYPE10image3Alt'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Image 3 Alt Text', 'bricks' ),
        'default' => 'Image 3',
        'type' => 'text',
        'placeholder' => esc_html__( 'Enter alt text', 'bricks' ),
        'inline' => true,
        'required' => ['type', '=', 'type10'],
    ];
    $this->controls['TYPE10image4'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Image 4', 'bricks' ),
        'type' => 'image',
        'default' => [
            'url' => 'https://cdn.cosmos.so/94579ea4-daee-43f9-b778-84156b731361.jpeg'
        ],
        'required' => ['type', '=', 'type10'],
    ];
    $this->controls['TYPE10image4Alt'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Image 4 Alt Text', 'bricks' ),
        'default' => 'Image 4',
        'inline' => true,
        'type' => 'text',
        'placeholder' => esc_html__( 'Enter alt text', 'bricks' ),
        'required' => ['type', '=', 'type10'],
    ];
    $this->controls['noteType10'] = [
        'group' => 'animation',
        'tab' => 'content',
        'description' => sprintf(html_entity_decode(esc_html__( 'Type 10 isnt a loader but a site reveal instead so there is no minimum duration.', 'bricks' ))),
        'required' => ['type', '=', 'type10'],
    ];
    $this->controls['TYPE10imgRevealAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Image Reveal', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type10' ],
    ];
    $this->controls['TYPE10imgRevealDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '0.65s',
        'required' => ['type', '=', 'type10'],
    ];
    $this->controls['TYPE10imgRevealStagger'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Stagger', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '0.15s',
        'required' => ['type', '=', 'type10'],
    ];
    $this->controls['TYPE10imgRevealEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
            'power1' => 'power1',
            'power2' => 'power2',
            'power3' => 'power3',
            'power4' => 'power4',
            'back' => 'back',
            'bounce' => 'bounce',
            'circ' => 'circ',
            'elastic' => 'elastic',
            'expo' => 'expo',
            'sine' => 'sine',
            'steps' => 'steps',
            'smoothBlur' => 'smoothBlur',
            'none' => 'none',
            'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'smoothBlur',
        'required' => ['type', '=', 'type10'],
    ];
    $this->controls['customTYPE10imgRevealEase'] = [
      'group' => 'animation',
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE10imgRevealEase', '=', 'custom' ],
    ];
    $this->controls['TYPE10imgScaleAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Image Scale', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type10' ],
    ];
    $this->controls['TYPE10imgScaleDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '1.2s',
        'required' => ['type', '=', 'type10'],
    ];
    $this->controls['TYPE10imgScaleEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
            'power1' => 'power1',
            'power2' => 'power2',
            'power3' => 'power3',
            'power4' => 'power4',
            'back' => 'back',
            'bounce' => 'bounce',
            'circ' => 'circ',
            'elastic' => 'elastic',
            'expo' => 'expo',
            'sine' => 'sine',
            'steps' => 'steps',
            'none' => 'none',
            'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'power3',
        'required' => ['type', '=', 'type10'],
    ];
    $this->controls['customTYPE10imgScaleEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE10imgScaleEase', '=', 'custom' ],
    ];





    $this->controls['TYPE10pauseAfterZoomAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Zoom', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type10' ],
    ];
    $this->controls['TYPE10pauseAfterZoom'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Pause After Zoom', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '0.2s',
        'required' => ['type', '=', 'type10'],
    ];

    /*ANIMATION - TYPE 11*/
    $this->controls['TYPE11textsAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Texts', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type11' ],
    ];
    $this->controls['TYPE11textLeft'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Left', 'bricks' ),
        'type' => 'text',
        'default' => 'Next',
        'inline' => true,
        'required' => ['type', '=', 'type11'],
    ];
    $this->controls['TYPE11textRight'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Right', 'bricks' ),
        'type' => 'text',
        'default' => 'Bricks',
        'inline' => true,
        'required' => ['type', '=', 'type11'],
    ];
    $this->controls['TYPE11progressAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Progress', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type11' ],
    ];
    $this->controls['TYPE11progressEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
            'power1' => 'power1',
            'power2' => 'power2',
            'power3' => 'power3',
            'power4' => 'power4',
            'back' => 'back',
            'bounce' => 'bounce',
            'circ' => 'circ',
            'elastic' => 'elastic',
            'expo' => 'expo',
            'sine' => 'sine',
            'steps' => 'steps',
            'none' => 'none',
            'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'power3',
        'required' => ['type', '=', 'type11'],
    ];
    $this->controls['customTYPE11progressEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE11progressEase', '=', 'custom' ],
    ];





    $this->controls['TYPE11progressExitFadeAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Progress Exit Fade', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type11' ],
    ];
    $this->controls['TYPE11progressExitFadeDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '0.2s',
        'required' => ['type', '=', 'type11'],
    ];
    $this->controls['TYPE11progressExitFadeEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
            'power1' => 'power1',
            'power2' => 'power2',
            'power3' => 'power3',
            'power4' => 'power4',
            'back' => 'back',
            'bounce' => 'bounce',
            'circ' => 'circ',
            'elastic' => 'elastic',
            'expo' => 'expo',
            'sine' => 'sine',
            'steps' => 'steps',
            'none' => 'none',
            'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'power3',
        'required' => ['type', '=', 'type11'],
    ];
    $this->controls['customTYPE11progressExitFadeEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE11progressExitFadeEase', '=', 'custom' ],
    ];





    $this->controls['TYPE11slidesAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Slides', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type11' ],
    ];
    $this->controls['TYPE11slidesDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '2s',
        'required' => ['type', '=', 'type11'],
    ];
    $this->controls['TYPE11slidesEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
            'power1' => 'power1',
            'power2' => 'power2',
            'power3' => 'power3',
            'power4' => 'power4',
            'back' => 'back',
            'bounce' => 'bounce',
            'circ' => 'circ',
            'elastic' => 'elastic',
            'expo' => 'expo',
            'sine' => 'sine',
            'steps' => 'steps',
            'none' => 'none',
            'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'power4',
        'required' => ['type', '=', 'type11'],
    ];
    $this->controls['customTYPE11slidesEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE11slidesEase', '=', 'custom' ],
    ];






    /*ANIMATION - TYPE 12*/
    $this->controls['TYPE12image'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Logo', 'bricks' ),
        'type' => 'image',
        'default' => [
            'url' => 'https://nextbricks.io/wp-content/uploads/2024/07/logo-next-bricks.png'
        ],
        'css' => [
            [
              'property' => 'background-image',
              'selector' => '.nb-site-loader--type12__logo-fill',
            ],
        ],
        'required' => ['type', '=', 'type12'],
    ];
    $this->controls['TYPE12imageAlt'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Logo Alt Text', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'default' => 'Next Bricks logo',
        'placeholder' => esc_html__( 'Enter alt text', 'bricks' ),
        'required' => ['type', '=', 'type12'],
    ];
    $this->controls['TYPE12progressAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Progress', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type12' ],
    ];
    $this->controls['TYPE12progressFrom'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'From', 'bricks' ),
        'type' => 'select',
        'options' => [
            'left' => 'Left',
            'top' => 'Top'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'left',
        'required' => ['type', '=', 'type12'],
    ];
    $this->controls['TYPE12progressEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
            'power1' => 'power1',
            'power2' => 'power2',
            'power3' => 'power3',
            'power4' => 'power4',
            'back' => 'back',
            'bounce' => 'bounce',
            'circ' => 'circ',
            'elastic' => 'elastic',
            'expo' => 'expo',
            'sine' => 'sine',
            'steps' => 'steps',
            'none' => 'none',
            'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'power3',
        'required' => ['type', '=', 'type12'],
    ];
    $this->controls['customTYPE12progressEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE12progressEase', '=', 'custom' ],
    ];





    $this->controls['TYPE12exitFadeAnimSeparator'] = [
        'group' => 'animation',
        'label'      => esc_html__( 'Exit Fade', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type12' ],
    ];
    $this->controls['TYPE12exitFadeDuration'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '0.5s',
        'required' => ['type', '=', 'type12'],
    ];
    $this->controls['TYPE12exitFadeEase'] = [
        'group' => 'animation',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options' => [
            'power1' => 'power1',
            'power2' => 'power2',
            'power3' => 'power3',
            'power4' => 'power4',
            'back' => 'back',
            'bounce' => 'bounce',
            'circ' => 'circ',
            'elastic' => 'elastic',
            'expo' => 'expo',
            'sine' => 'sine',
            'steps' => 'steps',
            'none' => 'none',
            'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'power3',
        'required' => ['type', '=', 'type12'],
    ];
    $this->controls['customTYPE12exitFadeEase'] = [
      'hasDynamicData' => false,
      'group' => 'animation',
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'TYPE12exitFadeEase', '=', 'custom' ],
    ];







    /*STYLE - TYPE 1+TYPE2*/
    $this->controls['TYPE1TYPE2siteLoaderSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Site Loader', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', [ 'type1', 'type2' ] ],
    ];
    $this->controls['TYPE1TYPE2background'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--type1-type2-background',
                'selector' => '&.nb-site-loader',
            ],
        ],
        'default' => [
            'rgb' => 'rgb(60, 66, 55)',
        ],
        'required'    => [ 'type', '=', [ 'type1', 'type2' ] ],
    ];
    $this->controls['TYPE1TYPE2zIndex'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Z-Index', 'bricks' ),
        'type'    => 'number',
        'css'     => [
            [
                'property' => '--type1-type2-z-index',
                'selector' => '&.nb-site-loader',
            ],
        ],
        'default' => 1000,
        'required'    => [ 'type', '=', [ 'type1', 'type2' ] ],
    ];
    $this->controls['TYPE1TYPE2progressSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Progress', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', [ 'type1', 'type2' ] ],
    ];
    $this->controls['TYPE1progressContainerMargin'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Container Margin', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'margin',
                'selector' => '.nb-site-loader--type1__progress-container',
            ],
        ],
        'required'    => [ 'type', '=', 'type1' ],
    ];
    $this->controls['TYPE1progressWidth'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Width', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'max-width',
                'selector' => '.nb-site-loader--type1__progress-container',
            ],
        ],
        'default' => '300px',
        'required'    => [ 'type', '=', 'type1' ],
    ];
    $this->controls['TYPE1progressHeight'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Height', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'height',
                'selector' => '.nb-site-loader--type1__progress-container',
            ],
        ],
        'default' => '2px',
        'required'    => [ 'type', '=', 'type1' ],
    ];
    $this->controls['TYPE1TYPE2progressBarColor'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '.nb-site-loader--type1__progress-bar, .nb-site-loader--type2__progress-bar',
            ],
        ],
        'default' => [
            'rgb' => '#ffffff',
        ],
        'required'    => [ 'type', '=', [ 'type1', 'type2' ] ],
    ];
    $this->controls['TYPE1progressPathColor'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Path Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '.nb-site-loader--type1__progress-container',
            ],
        ],
        'default' => [
            'rgb' => 'rgba(255, 255, 255, 0.1)',
        ],
        'required'    => [ 'type', '=', 'type1' ],
    ];
    $this->controls['TYPE1TYPE2percentageSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Percentage', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', [ 'type1', 'type2' ] ],
    ];
    $this->controls['TYPE1TYPE2percentageTypography'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '.nb-site-loader--type1__percentage, .nb-site-loader--type2__percentage',
            ],
        ],
        'default' => [
            'font-size' => '256px',
            'font-weight' => '700',
            'line-height' => '0.8',
            'color' => [
                'rgb' => '#ffffff',
            ],
        ],
        'required'    => [ 'type', '=', [ 'type1', 'type2' ] ],
    ];
    $this->controls['TYPE1TYPE2percentageBottom'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Bottom', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'bottom',
                'selector' => '.nb-site-loader--type1__percentage, .nb-site-loader--type2__percentage',
            ],
        ],
        'default' => 20,
        'required'    => [ 'type', '=', [ 'type1', 'type2' ] ],
    ];
    $this->controls['TYPE1percentageLeft'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Left', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'left',
                'selector' => '.nb-site-loader--type1__percentage',
            ],
        ],
        'required'    => [ 'type', '=', 'type1' ],
    ];
    $this->controls['TYPE1percentageRight'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Right', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'right',
                'selector' => '.nb-site-loader--type1__percentage',
            ],
        ],
        'default' => 20,
        'required'    => [ 'type', '=', 'type1' ],
    ];
    $this->controls['TYPE1percentageOpacity'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Opacity', 'bricks' ),
        'type'    => 'slider',
        'units'    => [
            'px' => [
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
            ],
        ],
        'css'     => [
            [
                'property' => 'opacity',
                'selector' => '.nb-site-loader--type1__percentage',
            ],
        ],
        'default' => 0.1,
        'required'    => [ 'type', '=', 'type1' ],
    ];
    $this->controls['TYPE2percentageBlendMode'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Blend Mode', 'bricks' ),
        'type'    => 'select',
        'options' => [
            'normal'      => esc_html__( 'Normal', 'bricks' ),
            'multiply'    => esc_html__( 'Multiply', 'bricks' ),
            'screen'      => esc_html__( 'Screen', 'bricks' ),
            'overlay'     => esc_html__( 'Overlay', 'bricks' ),
            'darken'      => esc_html__( 'Darken', 'bricks' ),
            'lighten'     => esc_html__( 'Lighten', 'bricks' ),
            'color-dodge' => esc_html__( 'Color Dodge', 'bricks' ),
            'color-burn'  => esc_html__( 'Color Burn', 'bricks' ),
            'difference'  => esc_html__( 'Difference', 'bricks' ),
            'exclusion'   => esc_html__( 'Exclusion', 'bricks' ),
        ],
        'css'     => [
            [
                'property' => 'mix-blend-mode',
                'selector' => '.nb-site-loader--type2__percentage',
            ],
        ],
        'default' => 'difference',
        'inline' => true,
        'required'    => [ 'type', '=', 'type2' ],
    ];
    $this->controls['TYPE1textSeparator'] = [
        'group' => 'style',
        'tab'   => 'content',
        'label' => esc_html__( 'Text', 'bricks' ),
        'type'  => 'separator',
        'required'    => [ 'type', '=', 'type1' ],
    ];
    $this->controls['TYPE1textContainerMargin'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Margin', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'margin',
                'selector' => '.nb-site-loader--type1__text-container',
            ],
        ],
        'default' => [
            'top' => 20,
            'bottom' => 20,
            'left' => 0,
            'right' => 0,
        ],
        'required'    => [ 'type', '=', 'type1' ],
    ];
    $this->controls['TYPE1loadingTextTypography'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '.nb-site-loader--type1__loading-text',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'font-weight' => '300',
            'color' => [
                'rgb' => '#ffffff',
            ],
            'text-transform' => 'uppercase',
            'text-align' => 'center',
        ],
        'required'    => [ 'type', '=', 'type1' ],
    ];

    /*STYLE - TYPE 3*/
    $this->controls['TYPE3siteLoaderSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Site Loader', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3background'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'background',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&.nb-site-loader--type3',
            ],
        ],
        'default' => [
            'color' => [
                'hex' => '#000000',
            ],
        ],
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3zIndex'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Z-Index', 'bricks' ),
        'type'    => 'number',
        'css'     => [
            [
                'property' => 'z-index',
                'selector' => '&.nb-site-loader--type3',
            ],
        ],
        'default' => 1000,
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3terminalSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Terminal', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3terminalPadding'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '.nb-site-loader--type3__terminal',
            ],
        ],
        'default' => [
            'top' => 32,
            'right' => 32,
            'bottom' => 32,
            'left' => 32,
        ],
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3terminalWidth'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Width', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'width',
                'selector' => '.nb-site-loader--type3__terminal',
            ],
        ],
        'default' => '100%',
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3terminalMaxWidth'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Max Width', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'max-width',
                'selector' => '.nb-site-loader--type3__terminal',
            ],
        ],
        'default' => 600,
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3terminalHeight'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Height', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'height',
                'selector' => '.nb-site-loader--type3__terminal',
            ],
        ],
        'default' => '100%',
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3terminalMaxHeight'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Max Height', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'max-height',
                'selector' => '.nb-site-loader--type3__terminal',
            ],
        ],
        'default' => 400,
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3terminalBackground'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'background',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '.nb-site-loader--type3__terminal',
            ],
        ],
        'default' => [
            'color' => [
                'hex' => '#000000',
            ],
        ],
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3terminalBorder'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Border', 'bricks' ),
        'type'    => 'border',
        'css'     => [
            [
                'property' => 'border',
                'selector' => '.nb-site-loader--type3__terminal',
            ],
        ],
        'default' => [
            'width' => [
                'top' => 1,
                'right' => 1,
                'bottom' => 1,
                'left' => 1,
            ],
            'style' => 'solid',
            'color' => [
                'hex' => '#333333',
            ],
            'radius' => [
                'top' => 4,
                'right' => 4,
                'bottom' => 4,
                'left' => 4,
            ],
        ],
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3terminalBoxShadow'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Box Shadow', 'bricks' ),
        'type'    => 'box-shadow',
        'css'     => [
            [
                'property' => 'box-shadow',
                'selector' => '.nb-site-loader--type3__terminal',
            ],
        ],
        'default' => [
            'color' => [
                'rgb' => 'rgba(90, 90, 90, 0.1)',
            ],
            'values' => [
                'offsetX' => 0,
                'offsetY' => 0,
                'blur' => 20,
                'spread' => 0,
            ],
        ],
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3terminalContentGap'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Gap between items', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'gap',
                'selector' => '.nb-site-loader--type3__terminal-content',
            ],
        ],
        'default' => 16,
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3commandsSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Commands', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3commandsGap'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Gap between commands', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'gap',
                'selector' => '.nb-site-loader--type3__commands-container',
            ],
        ],
        'default' => 8,
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3commandsGapSymbol'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Gap between symbol and line', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'gap',
                'selector' => '.nb-site-loader--type3__command-line',
            ],
        ],
        'default' => 8,
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3promptTypography'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Prompt Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '.nb-site-loader--type3__prompt',
            ],
        ],
        'default' => [
            'font-family' => 'IBM Plex Mono',
            'font-size' => '14px',
            'color' => [
                'hex' => '#ffffff',
            ],
        ],
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3commandsTypography'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Commands Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '.nb-site-loader--type3__command',
            ],
        ],
        'default' => [
            'font-family' => 'IBM Plex Mono',
            'font-size' => '14px',
            'color' => [
                'hex' => '#ffffff',
            ],
        ],
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3cursorSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Cursor', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3cursorWidth'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Width', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'width',
                'selector' => '.nb-site-loader--type3__cursor',
            ],
        ],
        'default' => 8,
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3cursorHeight'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Height', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'height',
                'selector' => '.nb-site-loader--type3__cursor',
            ],
        ],
        'default' => 16,
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3cursorColor'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '.nb-site-loader--type3__cursor',
            ],
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3loadingSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Loading Container', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3loadingContainerMargin'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Margin', 'bricks' ),
        'type'    => 'spacing',
        'units'   => true,
        'css'     => [
            [
                'property' => 'margin',
                'selector' => '.nb-site-loader--type3__loading-container',
            ],
        ],
        'default' => [
            'top' => 0,
            'right' => 0,
            'bottom' => 64,
            'left' => 0,
        ],
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3loadingContainerPadding'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'units'   => true,
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '.nb-site-loader--type3__loading-container',
            ],
        ],
        'default' => [
            'top' => 16,
            'right' => 16,
            'bottom' => 16,
            'left' => 16,
        ],
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3loadingContainerBackground'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'background',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '.nb-site-loader--type3__loading-container',
            ],
        ],
        'default' => [
            'color' => [
                'rgb' => 'rgba(90, 90, 90, 0.05)',
            ],
        ],
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3loadingContainerBorder'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Border', 'bricks' ),
        'type'    => 'border',
        'css'     => [
            [
                'property' => 'border',
                'selector' => '.nb-site-loader--type3__loading-container',
            ],
        ],
        'default' => [
            'width' => [
                'top' => 1,
                'right' => 1,
                'bottom' => 1,
                'left' => 1,
            ],
            'style' => 'solid',
            'color' => [
                'hex' => '#333333',
            ],
            'radius' => [
                'top' => 2,
                'right' => 2,
                'bottom' => 2,
                'left' => 2,
            ],
        ],
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3loadingBarSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Progress Bar', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3loadingBarHeight'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Height', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'height',
                'selector' => '.nb-site-loader--type3__loading-bar',
            ],
        ],
        'default' => 20,
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3loadingBarBorder'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Border', 'bricks' ),
        'type'    => 'border',
        'css'     => [
            [
                'property' => 'border',
                'selector' => '.nb-site-loader--type3__loading-bar',
            ],
        ],
        'default' => [
            'width' => [
                'top' => 1,
                'right' => 1,
                'bottom' => 1,
                'left' => 1,
            ],
            'style' => 'solid',
            'color' => [
                'hex' => '#333333',
            ],
        ],
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3loadingProgressColor'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '.nb-site-loader--type3__loading-progress',
            ],
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3loadingBarBackground'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Path Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '.nb-site-loader--type3__loading-bar',
            ],
        ],
        'default' => [
            'hex' => '#000000',
        ],
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3loadingProgressShadow'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Box Shadow', 'bricks' ),
        'type'    => 'box-shadow',
        'css'     => [
            [
                'property' => 'box-shadow',
                'selector' => '.nb-site-loader--type3__loading-progress',
            ],
        ],
        'default' => [
            'color' => [
                'hex' => '#ffffff',
            ],
            'values' => [
                'offsetX' => 0,
                'offsetY' => 0,
                'blur' => 15,
                'spread' => 0,
            ],
        ],
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3percentageSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Percentage', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3percentagePositionTop'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Top', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'top',
                'selector' => '.nb-site-loader--type3__percentage-wrap',
            ],
        ],
        'required'    => [ 'type', '=', 'type3' ],
    ];
    
    $this->controls['TYPE3percentagePositionRight'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Right', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'right',
                'selector' => '.nb-site-loader--type3__percentage-wrap',
            ],
        ],
        'default' => 32,
        'required'    => [ 'type', '=', 'type3' ],
    ];
    
    $this->controls['TYPE3percentagePositionBottom'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Bottom', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'bottom',
                'selector' => '.nb-site-loader--type3__percentage-wrap',
            ],
        ],
        'default' => 32,
        'required'    => [ 'type', '=', 'type3' ],
    ];
    
    $this->controls['TYPE3percentagePositionLeft'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Left', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'left',
                'selector' => '.nb-site-loader--type3__percentage-wrap',
            ],
        ],
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3percentageTypography'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '.nb-site-loader--type3__percentage',
            ],
        ],
        'default' => [
            'font-family' => 'IBM Plex Mono',
            'font-size' => '24px',
            'font-weight' => '700',
            'letter-spacing' => '2px',
            'color' => [
                'hex' => '#ffffff',
            ],
        ],
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3percentageBracketsSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Percentage Brackets', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3percentageBeforeBracket'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Before Symbol', 'bricks' ),
        'type'    => 'text',
        'css'     => [
            [
                'property' => '--before-bracket-symbol',
                'selector' => '.nb-site-loader--type3__percentage',
            ],
        ],
        'inline' => true,
        'small'   => true,
        'default' => '"["',
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3percentageAfterBracket'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'After Symbol', 'bricks' ),
        'type'    => 'text',
        'css'     => [
            [
                'property' => '--after-bracket-symbol',
                'selector' => '.nb-site-loader--type3__percentage',
            ],
        ],
        'inline' => true,
        'small'   => true,
        'default' => '"]"',
        'required'    => [ 'type', '=', 'type3' ],
    ];
    $this->controls['TYPE3percentageBracketsGap'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Gap', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => '--brackets-gap',
                'selector' => '.nb-site-loader--type3__percentage',
            ],
        ],
        'default' => 5,
        'required'    => [ 'type', '=', 'type3' ],
    ];

    /*STYLE - TYPE 4*/
    $this->controls['TYPE4siteLoaderSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Site Loader', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type4' ],
    ];
    $this->controls['TYPE4background'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--background',
                'selector' => '&.nb-site-loader--type4',
            ],
        ],
        'default' => [
            'hex' => '#555555',
        ],
        'required'    => [ 'type', '=', 'type4' ],
    ];
    $this->controls['TYPE4zIndex'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Z-Index', 'bricks' ),
        'type'    => 'number',
        'css'     => [
            [
                'property' => 'z-index',
                'selector' => '&.nb-site-loader--type4',
            ],
        ],
        'default' => 1000,
        'required'    => [ 'type', '=', 'type4' ],
    ];
    $this->controls['TYPE4progressSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Progress', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type4' ],
    ];
    $this->controls['TYPE4progressPadding'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '.nb-site-loader--type4__progress-bar',
            ],
        ],
        'default' => [
            'top' => 32,
            'right' => 32,
            'bottom' => 32,
            'left' => 32,
        ],
        'required'    => [ 'type', '=', 'type4' ],
    ];
    $this->controls['TYPE4progressWidth'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Initial Width', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'width',
                'selector' => '.nb-site-loader--type4__progress-bar',
            ],
        ],
        'default' => '25vw',
        'required'    => [ 'type', '=', 'type4' ],
    ];
    $this->controls['TYPE4progressTypography'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '.nb-site-loader--type4__progress-bar',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'font-weight' => 500,
            'color' => [
                'hex' => '#ffffff',
            ],
        ],
        'required'    => [ 'type', '=', 'type4' ],
    ];
    $this->controls['TYPE4progressBackground'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background-color',
                'selector' => '.nb-site-loader--type4__progress-bar',
            ],
        ],
        'default' => [
            'hex' => '#000000',
        ],
        'required'    => [ 'type', '=', 'type4' ],
    ];

    /*STYLE - TYPE 5*/
    $this->controls['TYPE5siteLoaderSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Site Loader', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type5' ],
    ];
    $this->controls['TYPE5background'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '.nb-site-loader--type5__loader',
            ],
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
        'required'    => [ 'type', '=', 'type5' ],
    ];
    $this->controls['TYPE5zIndex'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Z-Index', 'bricks' ),
        'type'    => 'number',
        'css'     => [
            [
                'property' => 'z-index',
                'selector' => '&.nb-site-loader--type5',
            ],
        ],
        'default' => 1000,
        'required'    => [ 'type', '=', 'type5' ],
    ];
    $this->controls['TYPE5countSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Count', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type5' ],
    ];
    $this->controls['TYPE5countPadding'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '.nb-site-loader--type5__count',
            ],
        ],
        'default' => [
            'top' => 0,
            'right' => 8,
            'bottom' => 0,
            'left' => 8,
        ],
        'required' => ['type', '=', 'type5'],
    ];
    
    $this->controls['TYPE5countTypography'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '.nb-site-loader--type5__count',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'line-height' => 1,
            'font-weight' => 500,
            'color' => [
                'hex' => '#000000',
            ],
        ],
        'required' => ['type', '=', 'type5'],
    ];
    $this->controls['TYPE5copySeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Text', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type5' ],
    ];
    $this->controls['TYPE5copyTypography'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '.nb-site-loader--type5__copy',
            ],
        ],
        'default' => [
            'font-size' => '30px',
            'line-height' => 1,
            'text-transform' => 'uppercase',
        ],
        'required' => ['type', '=', 'type5'],
    ];
    $this->controls['TYPE5slidesSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Slides', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type5' ],
    ];
    $this->controls['TYPE5slideMaskColor'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Slide Mask Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '.nb-site-loader--type5__loader-bg',
            ],
        ],
        'default' => [
            'hex' => '#ed4026',
        ],
        'required'    => [ 'type', '=', 'type5' ],
    ];
    $this->controls['TYPE5slideUpColor'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Slide Up Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '.nb-site-loader--type5__loader-2',
            ],
        ],
        'default' => [
            'hex' => '#666666',
        ],
        'required'    => [ 'type', '=', 'type5' ],
    ];

    /*STYLE - TYPE 6*/
    $this->controls['TYPE6siteLoaderSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Site Loader', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type6' ],
    ];
    $this->controls['TYPE6background'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&.nb-site-loader--type6',
            ],
        ],
        'default' => [
            'hex' => '#333333',
        ],
        'required'    => [ 'type', '=', 'type6' ],
    ];
    $this->controls['TYPE6zIndex'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Z-Index', 'bricks' ),
        'type'    => 'number',
        'css'     => [
            [
                'property' => 'z-index',
                'selector' => '&.nb-site-loader--type6',
            ],
        ],
        'default' => 1000,
        'required'    => [ 'type', '=', 'type6' ],
    ];
    $this->controls['TYPE6counterSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Counter', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type6' ],
    ];
    $this->controls['TYPE6counterPositionTop'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Top', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'top',
                'selector' => '.nb-site-loader--type6__counter',
            ],
        ],
        'required'    => [ 'type', '=', 'type6' ],
    ];
    $this->controls['TYPE6counterPositionRight'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Right', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'right',
                'selector' => '.nb-site-loader--type6__counter',
            ],
        ],
        'required'    => [ 'type', '=', 'type6' ],
    ];
    $this->controls['TYPE6counterPositionBottom'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Bottom', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'bottom',
                'selector' => '.nb-site-loader--type6__counter',
            ],
        ],
        'default' => 50,
        'required'    => [ 'type', '=', 'type6' ],
    ];
    $this->controls['TYPE6counterPositionLeft'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Left', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'left',
                'selector' => '.nb-site-loader--type6__counter',
            ],
        ],
        'default' => 50,
        'required'    => [ 'type', '=', 'type6' ],
    ];
    $this->controls['TYPE6counterTypography'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '.nb-site-loader--type6__counter',
            ],
        ],
        'default' => [
            'font-size' => '256px',
            'color' => [
                'hex' => '#ffffff',
            ],
            'font-weight' => 400,
        ],
        'required'    => [ 'type', '=', 'type6' ],
    ];

    /*STYLE - TYPE 7*/
    $this->controls['TYPE7siteLoaderSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Site Loader', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type7' ],
    ];
    $this->controls['TYPE7background'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&.nb-site-loader--type7',
            ],
        ],
        'default' => [
            'hex' => '#000000',
        ],
        'required'    => [ 'type', '=', 'type7' ],
    ];
    $this->controls['TYPE7zIndex'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Z-Index', 'bricks' ),
        'type'    => 'number',
        'css'     => [
            [
                'property' => 'z-index',
                'selector' => '&.nb-site-loader--type7',
            ],
        ],
        'default' => 1000,
        'required'    => [ 'type', '=', 'type7' ],
    ];
    $this->controls['TYPE7logoSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Logo', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type7' ],
    ];
    $this->controls['TYPE7logoGap'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Gap', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'gap',
                'selector' => '.nb-site-loader--type7__logo-loader',
            ],
        ],
        'default' => 24,
        'required'    => [ 'type', '=', 'type7' ],
    ];
    $this->controls['TYPE7logoWidth'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Width', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'width',
                'selector' => '.nb-site-loader--type7__logo',
            ],
        ],
        'default' => 40,
        'required'    => [ 'type', '=', 'type7' ],
    ];
    $this->controls['TYPE7logoHeight'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Height', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'height',
                'selector' => '.nb-site-loader--type7__logo',
            ],
        ],
        'default' => 'auto',
        'required'    => [ 'type', '=', 'type7' ],
    ];
    $this->controls['TYPE7progressSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Progress', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type7' ],
    ];
    $this->controls['TYPE7progressWidth'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Width', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'max-width',
                'selector' => '.nb-site-loader--type7__logo-loader',
            ],
        ],
        'default' => '300px',
        'required'    => [ 'type', '=', 'type7' ],
    ];
    $this->controls['TYPE7progressHeight'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Height', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'height',
                'selector' => '.nb-site-loader--type7__bar',
            ],
        ],
        'default' => 10,
        'required'    => [ 'type', '=', 'type7' ],
    ];
    $this->controls['TYPE7progressBorder'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Border', 'bricks' ),
        'type'    => 'border',
        'css'     => [
            [
                'property' => 'border',
                'selector' => '.nb-site-loader--type7__loader',
            ],
        ],
        'required'    => [ 'type', '=', 'type7' ],
    ];
    $this->controls['TYPE7progressPathColor'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Path Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '.nb-site-loader--type7__loader',
            ],
        ],
        'default' => [
            'hex' => '#808080',
        ],
        'required'    => [ 'type', '=', 'type7' ],
    ];
    $this->controls['TYPE7progressColor'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Progress Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '.nb-site-loader--type7__loader-1',
            ],
        ],
        'default' => [
            'hex' => '#e3e3e3',
        ],
        'required'    => [ 'type', '=', 'type7' ],
    ];

    /*STYLE - TYPE 8*/
    $this->controls['TYPE8siteLoaderSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Site Loader', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type8' ],
    ];
    $this->controls['TYPE8background'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&.nb-site-loader--type8',
            ],
        ],
        'default' => [
            'hex' => '#000000',
        ],
        'required'    => [ 'type', '=', 'type8' ],
    ];
    $this->controls['TYPE8zIndex'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Z-Index', 'bricks' ),
        'type'    => 'number',
        'css'     => [
            [
                'property' => 'z-index',
                'selector' => '&.nb-site-loader--type8',
            ],
        ],
        'default' => 1000,
        'required'    => [ 'type', '=', 'type8' ],
    ];
    $this->controls['TYPE8barsSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Bars', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type8' ],
    ];
    $this->controls['TYPE8barsNumber'] = [
        'group' => 'style',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Number', 'bricks' ),
        'type' => 'number',
        'css'     => [
            [
                'property' => '--bars-number',
                'selector' => '&.nb-site-loader--type8',
            ],
        ],
        'inline' => true,
        'default' => 10,
        'required' => ['type', '=', 'type8'],
    ];
    $this->controls['TYPE8barsBackground'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Color', 'bricks' ),
        'type'    => 'background',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '.nb-site-loader--type8__bar',
            ],
        ],
        'default' => [
            'color' => [
                'hex' => '#FFFFFF',
            ],
        ],
        'required'    => [ 'type', '=', 'type8' ],
    ];
    $this->controls['TYPE8counterSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Counter', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type8' ],
    ];
    $this->controls['TYPE8counterTypography'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '.nb-site-loader--type8__counter',
            ],
        ],
        'default' => [
            'font-size' => '256px',
            'color' => [
                'hex' => '#e3e3e3',
            ],
        ],
        'required'    => [ 'type', '=', 'type8' ],
    ];
    $this->controls['TYPE8counterMixBlendMode'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Mix Blend Mode', 'bricks' ),
        'type'    => 'select',
        'inline' => true,
        'options' => [
            'normal'      => esc_html__( 'Normal', 'bricks' ),
            'multiply'    => esc_html__( 'Multiply', 'bricks' ),
            'screen'      => esc_html__( 'Screen', 'bricks' ),
            'overlay'     => esc_html__( 'Overlay', 'bricks' ),
            'darken'      => esc_html__( 'Darken', 'bricks' ),
            'lighten'     => esc_html__( 'Lighten', 'bricks' ),
            'color-dodge' => esc_html__( 'Color Dodge', 'bricks' ),
            'color-burn'  => esc_html__( 'Color Burn', 'bricks' ),
            'hard-light'  => esc_html__( 'Hard Light', 'bricks' ),
            'soft-light'  => esc_html__( 'Soft Light', 'bricks' ),
            'difference'  => esc_html__( 'Difference', 'bricks' ),
            'exclusion'   => esc_html__( 'Exclusion', 'bricks' ),
            'hue'         => esc_html__( 'Hue', 'bricks' ),
            'saturation'  => esc_html__( 'Saturation', 'bricks' ),
            'color'       => esc_html__( 'Color', 'bricks' ),
            'luminosity'  => esc_html__( 'Luminosity', 'bricks' ),
        ],
        'css'     => [
            [
                'property' => 'mix-blend-mode',
                'selector' => '.nb-site-loader--type8__counter',
            ],
        ],
        'default' => 'exclusion',
        'required'    => [ 'type', '=', 'type8' ],
    ];

    /*STYLE - TYPE 9*/
    $this->controls['TYPE9siteLoaderSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Site Loader', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type9' ],
    ];
    $this->controls['TYPE9background'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&.nb-site-loader--type9',
            ],
        ],
        'default' => [
            'hex' => '#000000',
        ],
        'required'    => [ 'type', '=', 'type9' ],
    ];
    $this->controls['TYPE9zIndex'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Z-Index', 'bricks' ),
        'type'    => 'number',
        'css'     => [
            [
                'property' => 'z-index',
                'selector' => '&.nb-site-loader--type9',
            ],
        ],
        'default' => 1000,
        'required'    => [ 'type', '=', 'type9' ],
    ];
    $this->controls['TYPE9barsSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Bars', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type9' ],
    ];
    $this->controls['TYPE9barsNumber'] = [
        'group' => 'style',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Number', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'css'     => [
            [
                'property' => '--bars-number',
                'selector' => '&.nb-site-loader--type9',
            ],
        ],
        'default' => 20,
        'required' => ['type', '=', 'type9'],
    ];
    $this->controls['TYPE9barsBackground'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Color', 'bricks' ),
        'type'    => 'background',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '.nb-site-loader--type9__bar',
            ],
        ],
        'default' => [
            'color' => [
                'hex' => '#FFFFFF',
            ],
        ],
        'required'    => [ 'type', '=', 'type9' ],
    ];
    $this->controls['TYPE9horizontalTransform'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Horizontal Transform', 'bricks' ),
        'type'    => 'select',
        'inline' => true,
        'options' => [
            'left'    => esc_html__( 'Left', 'bricks' ),
            'right'   => esc_html__( 'Right', 'bricks' ),
            'center'  => esc_html__( 'Center', 'bricks' ),
        ],
        'css'     => [
            [
                'property' => '--horizontal-transform',
                'selector' => '.nb-site-loader--type9__bar',
            ],
        ],
        'default' => 'left',
        'required'    => [ 'type', '=', 'type9' ],
    ];
    $this->controls['TYPE9verticalTransform'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Vertical Transform', 'bricks' ),
        'type'    => 'select',
        'inline' => true,
        'options' => [
            'top'     => esc_html__( 'Top', 'bricks' ),
            'bottom'  => esc_html__( 'Bottom', 'bricks' ),
            'center'  => esc_html__( 'Center', 'bricks' ),
        ],
        'css'     => [
            [
                'property' => '--vertical-transform',
                'selector' => '.nb-site-loader--type9__bar',
            ],
        ],
        'default' => 'top',
        'required'    => [ 'type', '=', 'type9' ],
    ];
    $this->controls['TYPE9counterSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Counter', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type9' ],
    ];
    $this->controls['TYPE9counterTypography'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '.nb-site-loader--type9__counter',
            ],
        ],
        'default' => [
            'font-size' => '256px',
            'color' => [
                'hex' => '#e3e3e3',
            ],
        ],
        'required'    => [ 'type', '=', 'type9' ],
    ];
    $this->controls['TYPE9counterMixBlendMode'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Mix Blend Mode', 'bricks' ),
        'type'    => 'select',
        'inline' => true,
        'options' => [
            'normal'      => esc_html__( 'Normal', 'bricks' ),
            'multiply'    => esc_html__( 'Multiply', 'bricks' ),
            'screen'      => esc_html__( 'Screen', 'bricks' ),
            'overlay'     => esc_html__( 'Overlay', 'bricks' ),
            'darken'      => esc_html__( 'Darken', 'bricks' ),
            'lighten'     => esc_html__( 'Lighten', 'bricks' ),
            'color-dodge' => esc_html__( 'Color Dodge', 'bricks' ),
            'color-burn'  => esc_html__( 'Color Burn', 'bricks' ),
            'hard-light'  => esc_html__( 'Hard Light', 'bricks' ),
            'soft-light'  => esc_html__( 'Soft Light', 'bricks' ),
            'difference'  => esc_html__( 'Difference', 'bricks' ),
            'exclusion'   => esc_html__( 'Exclusion', 'bricks' ),
            'hue'         => esc_html__( 'Hue', 'bricks' ),
            'saturation'  => esc_html__( 'Saturation', 'bricks' ),
            'color'       => esc_html__( 'Color', 'bricks' ),
            'luminosity'  => esc_html__( 'Luminosity', 'bricks' ),
        ],
        'css'     => [
            [
                'property' => 'mix-blend-mode',
                'selector' => '.nb-site-loader--type9__counter',
            ],
        ],
        'default' => 'exclusion',
        'required'    => [ 'type', '=', 'type9' ],
    ];

    /*STYLE - TYPE 10*/
    $this->controls['note2Type10'] = [
        'group' => 'style',
        'tab' => 'content',
        'description' => sprintf(html_entity_decode(esc_html__( 'The last image will occupy the whole viewport. You should wrap your content in a wrapper that occupies the whole viewport also and reveal it after the Site Loader ends.', 'bricks' ))),
        'required' => ['type', '=', 'type10'],
    ];
    $this->controls['TYPE10siteLoaderSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Site Loader', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type10' ],
    ];
    $this->controls['TYPE10background'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&.nb-site-loader--type10',
            ],
        ],
        'default' => [
            'hex' => '#000000',
        ],
        'required'    => [ 'type', '=', 'type10' ],
    ];
    $this->controls['TYPE10zIndex'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Z-Index', 'bricks' ),
        'type'    => 'number',
        'css'     => [
            [
                'property' => 'z-index',
                'selector' => '&.nb-site-loader--type10',
            ],
        ],
        'default' => '-1',
        'required'    => [ 'type', '=', 'type10' ],
    ];
    $this->controls['TYPE10imagesSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Images Wrapper', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type10' ],
    ];
    $this->controls['TYPE10imgsWrapperWidth'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Width', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'width',
                'selector' => '.nb-site-loader--type10__preloader-container',
            ],
        ],
        'default' => 400,
        'required'    => [ 'type', '=', 'type10' ],
    ];
    $this->controls['TYPE10imgsWrapperHeight'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Height', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'height',
                'selector' => '.nb-site-loader--type10__preloader-container',
            ],
        ],
        'default' => 300,
        'required'    => [ 'type', '=', 'type10' ],
    ];

    /*STYLE - TYPE 11*/
    $this->controls['TYPE11siteLoaderSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Site Loader', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type11' ],
    ];
    $this->controls['TYPE11background'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--background',
                'selector' => '&.nb-site-loader--type11',
            ],
        ],
        'default' => [
            'hex' => '#272727',
        ],
        'required'    => [ 'type', '=', 'type11' ],
    ];
    $this->controls['TYPE11zIndex'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Z-Index', 'bricks' ),
        'type'    => 'number',
        'css'     => [
            [
                'property' => 'z-index',
                'selector' => '&.nb-site-loader--type11',
            ],
        ],
        'default' => 1000,
        'required'    => [ 'type', '=', 'type11' ],
    ];
    $this->controls['TYPE11LoadingTextSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Loading Text', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type11' ],
    ];
    $this->controls['TYPE11LoadingTextPadding'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '.nb-site-loader--type11__loader-text',
            ],
        ],
        'default' => [
            'top' => 0,
            'right' => 32,
            'bottom' => 0,
            'left' => 32,
        ],
        'required'    => [ 'type', '=', 'type11' ],
    ];
    $this->controls['TYPE11LoadingTextTypography'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '.nb-site-loader--type11__loader-text',
            ],
        ],
        'default' => [
            'font-size' => '18px',
            'font-weight' => '500',
            'color' => [
                'hex' => '#FFFFFF',
            ],
        ],
        'required'    => [ 'type', '=', 'type11' ],
    ];
    $this->controls['TYPE11progressSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Progress', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type11' ],
    ];
    $this->controls['TYPE11progressWidth'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Width', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'width',
                'selector' => '.nb-site-loader--type11__loader-wrapper',
            ],
        ],
        'default' => 2,
        'required'    => [ 'type', '=', 'type11' ],
    ];
    $this->controls['TYPE11progressHeight'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Height', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'height',
                'selector' => '.nb-site-loader--type11__loader-wrapper',
            ],
        ],
        'default' => 140,
        'required'    => [ 'type', '=', 'type11' ],
    ];
    $this->controls['TYPE11progressBorder'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Border', 'bricks' ),
        'type'    => 'border',
        'css'     => [
            [
                'property' => 'border',
                'selector' => '.nb-site-loader--type11__loader-wrapper',
            ],
        ],
        'default' => [
            'radius' => [
                'top' => 2,
                'right' => 2,
                'bottom' => 2,
                'left' => 2,
            ],
        ],
        'required'    => [ 'type', '=', 'type11' ],
    ];
    $this->controls['TYPE11progressPathColor'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Path Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '.nb-site-loader--type11__loader-wrapper',
            ],
        ],
        'default' => [
            'hex' => '#333333',
        ],
        'required'    => [ 'type', '=', 'type11' ],
    ];
    $this->controls['TYPE11progressColor'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Progress Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '.nb-site-loader--type11__loader',
            ],
        ],
        'default' => [
            'hex' => '#FFFFFF',
        ],
        'required'    => [ 'type', '=', 'type11' ],
    ];

    /*STYLE - TYPE 12*/
    $this->controls['TYPE12siteLoaderSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Site Loader', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type12' ],
    ];
    $this->controls['TYPE12background'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&.nb-site-loader--type12',
            ],
        ],
        'default' => [
            'hex' => '#000000',
        ],
        'required'    => [ 'type', '=', 'type12' ],
    ];
    $this->controls['TYPE12zIndex'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Z-Index', 'bricks' ),
        'type'    => 'number',
        'css'     => [
            [
                'property' => 'z-index',
                'selector' => '&.nb-site-loader--type12',
            ],
        ],
        'default' => 1000,
        'required'    => [ 'type', '=', 'type12' ],
    ];
    $this->controls['TYPE12logoSeparator'] = [
        'group' => 'style',
        'label'      => esc_html__( 'Logo', 'bricks' ),
        'type'       => 'separator',
        'required'    => [ 'type', '=', 'type12' ],
    ];
    $this->controls['TYPE12logoWidth'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Width', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'width',
                'selector' => '.nb-site-loader--type12__logo',
            ],
        ],
        'default' => 100,
        'required'    => [ 'type', '=', 'type12' ],
    ];
    $this->controls['TYPE12logoHeight'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Height', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'height',
                'selector' => '.nb-site-loader--type12__logo',
            ],
        ],
        'default' => 'auto',
        'required'    => [ 'type', '=', 'type12' ],
    ];
    $this->controls['TYPE12logoOpacity'] = [
        'group' => 'style',
        'tab'     => 'content',
        'label'   => esc_html__( 'Logo Opacity', 'bricks' ),
        'type'    => 'slider',
        'units'    => [
            'px' => [
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
            ],
        ],
        'css'     => [
            [
                'property' => 'opacity',
                'selector' => '.nb-site-loader--type12__logo',
            ],
        ],
        'default' => 0.3,
        'required'    => [ 'type', '=', 'type12' ],
    ];
  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'next_site_loader', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_site_loader.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
    $type = ! empty( $settings['type'] ) ? $settings['type'] : 'type1';
    $minDuration = ! empty( $settings['minDuration'] ) ? $settings['minDuration'] : '4s';

    $this->set_attribute( '_root', 'class', 'nb-site-loader' );
    $this->set_attribute( '_root', 'data-disable-builder', $disablebuilder);
    $this->set_attribute( '_root', 'data-type', $type );
    $this->set_attribute( '_root', 'data-min-duration', $minDuration );

    /*ANIMATION - TYPE 1*/
    $TYPE1swapDuration = ! empty( $settings['TYPE1swapDuration'] ) ? $settings['TYPE1swapDuration'] : '0.7s';
    $TYPE1swapEase = ! empty( $settings['TYPE1swapEase'] ) ? $settings['TYPE1swapEase'] : 'power2';
    if ($TYPE1swapEase === 'custom') {
      $TYPE1swapEase = ! empty( $settings['customTYPE1swapEase'] ) ? $settings['customTYPE1swapEase'] : 'power2';
    }
    $TYPE1swapStagger = ! empty( $settings['TYPE1swapStagger'] ) ? $settings['TYPE1swapStagger'] : '0.03s';
    $TYPE1progressBarEase = ! empty( $settings['TYPE1progressBarEase'] ) ? $settings['TYPE1progressBarEase'] : 'power1';
    if ($TYPE1progressBarEase === 'custom') {
      $TYPE1progressBarEase = ! empty( $settings['customTYPE1progressBarEase'] ) ? $settings['customTYPE1progressBarEase'] : 'power1';
    }
    $TYPE1slideDuration = ! empty( $settings['TYPE1slideDuration'] ) ? $settings['TYPE1slideDuration'] : '1s';
    $TYPE1slideEase = ! empty( $settings['TYPE1slideEase'] ) ? $settings['TYPE1slideEase'] : 'power2';
    if ($TYPE1slideEase === 'custom') {
      $TYPE1slideEase = ! empty( $settings['customTYPE1slideEase'] ) ? $settings['customTYPE1slideEase'] : 'power2';
    }
    $TYPE1slideDelay = ! empty( $settings['TYPE1slideDelay'] ) ? $settings['TYPE1slideDelay'] : '0.4s';
    $TYPE1loadingText = ! empty( $settings['TYPE1loadingText'] ) ? $settings['TYPE1loadingText'] : 'Loading';
    $TYPE1completeText = ! empty( $settings['TYPE1completeText'] ) ? $settings['TYPE1completeText'] : 'Complete';

    /*ANIMATION - TYPE 2*/
    $TYPE2progressBarEase = ! empty( $settings['TYPE2progressBarEase'] ) ? $settings['TYPE2progressBarEase'] : 'power1';
    if ($TYPE2progressBarEase === 'custom') {
      $TYPE2progressBarEase = ! empty( $settings['customTYPE2progressBarEase'] ) ? $settings['customTYPE2progressBarEase'] : 'power1';
    }
    $TYPE2percentageEase = ! empty( $settings['TYPE2percentageEase'] ) ? $settings['TYPE2percentageEase'] : 'power1';
    if ($TYPE2percentageEase === 'custom') {
      $TYPE2percentageEase = ! empty( $settings['customTYPE2percentageEase'] ) ? $settings['customTYPE2percentageEase'] : 'power1';
    }
    $TYPE2slideDuration = ! empty( $settings['TYPE2slideDuration'] ) ? $settings['TYPE2slideDuration'] : '1s';
    $TYPE2slideEase = ! empty( $settings['TYPE2slideEase'] ) ? $settings['TYPE2slideEase'] : 'power2';
    if ($TYPE2slideEase === 'custom') {
      $TYPE2slideEase = ! empty( $settings['customTYPE2slideEase'] ) ? $settings['customTYPE2slideEase'] : 'power2';
    }
    $TYPE2slideDelay = ! empty( $settings['TYPE2slideDelay'] ) ? $settings['TYPE2slideDelay'] : '0.4s';

    /*ANIMATION - TYPE 3*/
    $TYPE3symbol = ! empty( $settings['TYPE3symbol'] ) ? $settings['TYPE3symbol'] : '$';
    $TYPE3commandline1 = ! empty( $settings['TYPE3commandline1'] ) ? $settings['TYPE3commandline1'] : 'Removing the boring WordPress website';
    $TYPE3commandline2 = ! empty( $settings['TYPE3commandline2'] ) ? $settings['TYPE3commandline2'] : 'Acccessing Bricks Builder';
    $TYPE3commandline3 = ! empty( $settings['TYPE3commandline3'] ) ? $settings['TYPE3commandline3'] : 'Launching Next Bricks';
    $TYPE3commandline4 = ! empty( $settings['TYPE3commandline4'] ) ? $settings['TYPE3commandline4'] : 'Decoding Elements';
    $TYPE3terminalFinishScale = ! empty( $settings['TYPE3terminalFinishScale'] ) ? $settings['TYPE3terminalFinishScale'] : '0.95';
    $TYPE3terminalScaleDuration = ! empty( $settings['TYPE3terminalScaleDuration'] ) ? $settings['TYPE3terminalScaleDuration'] : '0.5s';
    $TYPE3terminalScaleEase = ! empty( $settings['TYPE3terminalScaleEase'] ) ? $settings['TYPE3terminalScaleEase'] : 'power2';
    if ($TYPE3terminalScaleEase === 'custom') {
      $TYPE3terminalScaleEase = ! empty( $settings['customTYPE3terminalScaleEase'] ) ? $settings['customTYPE3terminalScaleEase'] : 'power2';
    }
    $TYPE3translateCommandsFrom = ! empty( $settings['TYPE3translateCommandsFrom'] ) ? $settings['TYPE3translateCommandsFrom'] : '20px';
    $TYPE3commandsDuration = ! empty( $settings['TYPE3commandsDuration'] ) ? $settings['TYPE3commandsDuration'] : '0.5s';
    $TYPE3commandsEase = ! empty( $settings['TYPE3commandsEase'] ) ? $settings['TYPE3commandsEase'] : 'power2';
    if ($TYPE3commandsEase === 'custom') {
      $TYPE3commandsEase = ! empty( $settings['customTYPE3commandsEase'] ) ? $settings['customTYPE3commandsEase'] : 'power2';
    }
    $TYPE3exitFadeDuration = ! empty( $settings['TYPE3exitFadeDuration'] ) ? $settings['TYPE3exitFadeDuration'] : '0.5s';
    $TYPE3exitFadeEase = ! empty( $settings['TYPE3exitFadeEase'] ) ? $settings['TYPE3exitFadeEase'] : 'power2';
    if ($TYPE3exitFadeEase === 'custom') {
      $TYPE3exitFadeEase = ! empty( $settings['customTYPE3exitFadeEase'] ) ? $settings['customTYPE3exitFadeEase'] : 'power2';
    }

    /*ANIMATION - TYPE 4*/
    $TYPE4progressText = ! empty( $settings['TYPE4progressText'] ) ? $settings['TYPE4progressText'] : 'loading';
    $TYPE4initialLoadingDuration = ! empty( $settings['TYPE4initialLoadingDuration'] ) ? $settings['TYPE4initialLoadingDuration'] : '1.5s';
    $TYPE4initialLoadingEase = ! empty( $settings['TYPE4initialLoadingEase'] ) ? $settings['TYPE4initialLoadingEase'] : 'expo';
    if ($TYPE4initialLoadingEase === 'custom') {
      $TYPE4initialLoadingEase = ! empty( $settings['customTYPE4initialLoadingEase'] ) ? $settings['customTYPE4initialLoadingEase'] : 'expo';
    }
    $TYPE4initialLoadingDelay = ! empty( $settings['TYPE4initialLoadingDelay'] ) ? $settings['TYPE4initialLoadingDelay'] : '0.5s';
    $TYPE4progressEase = ! empty( $settings['TYPE4progressEase'] ) ? $settings['TYPE4progressEase'] : 'expo';
    if ($TYPE4progressEase === 'custom') {
      $TYPE4progressEase = ! empty( $settings['customTYPE4progressEase'] ) ? $settings['customTYPE4progressEase'] : 'expo';
    }
    $TYPE4exitSlidesDuration = ! empty( $settings['TYPE4exitSlidesDuration'] ) ? $settings['TYPE4exitSlidesDuration'] : '1s';
    $TYPE4exitSlidesEase = ! empty( $settings['TYPE4exitSlidesEase'] ) ? $settings['TYPE4exitSlidesEase'] : 'power3';
    if ($TYPE4exitSlidesEase === 'custom') {
      $TYPE4exitSlidesEase = ! empty( $settings['customTYPE4exitSlidesEase'] ) ? $settings['customTYPE4exitSlidesEase'] : 'power3';
    }

    /*ANIMATION - TYPE 5*/
    $TYPE5brand = ! empty( $settings['TYPE5brand'] ) ? $settings['TYPE5brand'] : 'Next Bricks';
    $TYPE5countExitFadeDuration = ! empty( $settings['TYPE5countExitFadeDuration'] ) ? $settings['TYPE5countExitFadeDuration'] : '0.5s';
    $TYPE5countExitFadeEase = ! empty( $settings['TYPE5countExitFadeEase'] ) ? $settings['TYPE5countExitFadeEase'] : 'power2';
    if ($TYPE5countExitFadeEase === 'custom') {
      $TYPE5countExitFadeEase = ! empty( $settings['customTYPE5countExitFadeEase'] ) ? $settings['customTYPE5countExitFadeEase'] : 'power2';
    }
    $TYPE5swapDuration = ! empty( $settings['TYPE5swapDuration'] ) ? $settings['TYPE5swapDuration'] : '1.5s';
    $TYPE5swapEase = ! empty( $settings['TYPE5swapEase'] ) ? $settings['TYPE5swapEase'] : 'expo';
    if ($TYPE5swapEase === 'custom') {
      $TYPE5swapEase = ! empty( $settings['customTYPE5swapEase'] ) ? $settings['customTYPE5swapEase'] : 'expo';
    }
    $TYPE5swapStagger = ! empty( $settings['TYPE5swapStagger'] ) ? $settings['TYPE5swapStagger'] : '0.03s';
    $TYPE5loaderScale = ! empty( $settings['TYPE5loaderScale'] ) ? $settings['TYPE5loaderScale'] : '0.5';
    $TYPE5loaderScaleDuration = ! empty( $settings['TYPE5loaderScaleDuration'] ) ? $settings['TYPE5loaderScaleDuration'] : '2s';
    $TYPE5loaderScaleEase = ! empty( $settings['TYPE5loaderScaleEase'] ) ? $settings['TYPE5loaderScaleEase'] : 'power4';
    if ($TYPE5loaderScaleEase === 'custom') {
      $TYPE5loaderScaleEase = ! empty( $settings['customTYPE5loaderScaleEase'] ) ? $settings['customTYPE5loaderScaleEase'] : 'power4';
    }
    $TYPE5exitSlidesDuration = ! empty( $settings['TYPE5exitSlidesDuration'] ) ? $settings['TYPE5exitSlidesDuration'] : '1.5s';
    $TYPE5exitSlidesEase = ! empty( $settings['TYPE5exitSlidesEase'] ) ? $settings['TYPE5exitSlidesEase'] : 'power4';
    if ($TYPE5exitSlidesEase === 'custom') {
      $TYPE5exitSlidesEase = ! empty( $settings['customTYPE5exitSlidesEase'] ) ? $settings['customTYPE5exitSlidesEase'] : 'power4';
    }
    
    /*ANIMATION - TYPE 6*/
    $TYPE6counterSwapDuration = ! empty( $settings['TYPE6counterSwapDuration'] ) ? $settings['TYPE6counterSwapDuration'] : '1s';
    $TYPE6counterSwapEase = ! empty( $settings['TYPE6counterSwapEase'] ) ? $settings['TYPE6counterSwapEase'] : 'power2';
    if ($TYPE6counterSwapEase === 'custom') {
      $TYPE6counterSwapEase = ! empty( $settings['customTYPE6counterSwapEase'] ) ? $settings['customTYPE6counterSwapEase'] : 'power2';
    }
    $TYPE6counterSwapStagger = ! empty( $settings['TYPE6counterSwapStagger'] ) ? $settings['TYPE6counterSwapStagger'] : '0.1s';
    $TYPE6exitType = ! empty( $settings['TYPE6exitType'] ) ? $settings['TYPE6exitType'] : 'toTop';
    $TYPE6exitTypeDuration = ! empty( $settings['TYPE6exitTypeDuration'] ) ? $settings['TYPE6exitTypeDuration'] : '1s';
    $TYPE6exitTypeEase = ! empty( $settings['TYPE6exitTypeEase'] ) ? $settings['TYPE6exitTypeEase'] : 'power2';
    if ($TYPE6exitTypeEase === 'custom') {
      $TYPE6exitTypeEase = ! empty( $settings['customTYPE6exitTypeEase'] ) ? $settings['customTYPE6exitTypeEase'] : 'power2';
    }
    $TYPE6exitTypeStagger = ! empty( $settings['TYPE6exitTypeStagger'] ) ? $settings['TYPE6exitTypeStagger'] : '0.1s';

    /*ANIMATION - TYPE 7*/
    if ( isset($settings['TYPE7image'])) {
        if ( isset($settings['TYPE7image']['mediaData']['url'])) {
          $TYPE7image = $settings['TYPE7image']['mediaData']['url'];
        }
        else if ( isset($settings['TYPE7image']['url'])) {
          $TYPE7image = $settings['TYPE7image']['url'];
        }
    }
    $TYPE7alt = ! empty( $settings['TYPE7alt'] ) ? $settings['TYPE7alt'] : '';
    $TYPE7progressEase = ! empty( $settings['TYPE7progressEase'] ) ? $settings['TYPE7progressEase'] : 'power2';
    if ($TYPE7progressEase === 'custom') {
      $TYPE7progressEase = ! empty( $settings['customTYPE7progressEase'] ) ? $settings['customTYPE7progressEase'] : 'power2';
    }
    $TYPE7barScale = ! empty( $settings['TYPE7barScale'] ) ? $settings['TYPE7barScale'] : '200';
    $TYPE7barScaleDuration = ! empty( $settings['TYPE7barScaleDuration'] ) ? $settings['TYPE7barScaleDuration'] : '1s';
    $TYPE7barScaleEasing = ! empty( $settings['TYPE7barScaleEasing'] ) ? $settings['TYPE7barScaleEasing'] : 'power2';
    if ($TYPE7barScaleEasing === 'custom') {
      $TYPE7barScaleEasing = ! empty( $settings['customTYPE7barScaleEasing'] ) ? $settings['customTYPE7barScaleEasing'] : 'power2';
    }
    $TYPE7exitFadeDuration = ! empty( $settings['TYPE7exitFadeDuration'] ) ? $settings['TYPE7exitFadeDuration'] : '0.5s';
    $TYPE7exitFadeEasing = ! empty( $settings['TYPE7exitFadeEasing'] ) ? $settings['TYPE7exitFadeEasing'] : 'power1';
    if ($TYPE7exitFadeEasing === 'custom') {
      $TYPE7exitFadeEasing = ! empty( $settings['customTYPE7exitFadeEasing'] ) ? $settings['customTYPE7exitFadeEasing'] : 'power1';
    }

    /*ANIMATION - TYPE 8*/
    $TYPE8barsNumber = ! empty( $settings['TYPE8barsNumber'] ) ? $settings['TYPE8barsNumber'] : 10;
    $TYPE8barsDuration = ! empty( $settings['TYPE8barsDuration'] ) ? $settings['TYPE8barsDuration'] : '0.8s';
    $TYPE8barsEase = ! empty( $settings['TYPE8barsEase'] ) ? $settings['TYPE8barsEase'] : 'power3';
    if ($TYPE8barsEase === 'custom') {
      $TYPE8barsEase = ! empty( $settings['customTYPE8barsEase'] ) ? $settings['customTYPE8barsEase'] : 'power3';
    }
    $TYPE8barsStagger = ! empty( $settings['TYPE8barsStagger'] ) ? $settings['TYPE8barsStagger'] : '0.03s';
    $TYPE8counterExitFadeDuration = ! empty( $settings['TYPE8counterExitFadeDuration'] ) ? $settings['TYPE8counterExitFadeDuration'] : '0.5s';
    $TYPE8counterExitFadeEase = ! empty( $settings['TYPE8counterExitFadeEase'] ) ? $settings['TYPE8counterExitFadeEase'] : 'expo';
    if ($TYPE8counterExitFadeEase === 'custom') {
      $TYPE8counterExitFadeEase = ! empty( $settings['customTYPE8counterExitFadeEase'] ) ? $settings['customTYPE8counterExitFadeEase'] : 'expo';
    }

    /*ANIMATION - TYPE 9*/
    $TYPE9barsNumber = ! empty( $settings['TYPE9barsNumber'] ) ? $settings['TYPE9barsNumber'] : 20;
    $TYPE9exitDirection = ! empty( $settings['TYPE9exitDirection'] ) ? $settings['TYPE9exitDirection'] : 'bottom';
    $TYPE9barsDuration = ! empty( $settings['TYPE9barsDuration'] ) ? $settings['TYPE9barsDuration'] : '0.8s';
    $TYPE9barsEase = ! empty( $settings['TYPE9barsEase'] ) ? $settings['TYPE9barsEase'] : 'power3';
    if ($TYPE9barsEase === 'custom') {
      $TYPE9barsEase = ! empty( $settings['customTYPE9barsEase'] ) ? $settings['customTYPE9barsEase'] : 'power3';
    }
    $TYPE9barsStagger = ! empty( $settings['TYPE9barsStagger'] ) ? $settings['TYPE9barsStagger'] : '0.03s';
    $TYPE9counterExitFadeDuration = ! empty( $settings['TYPE9counterExitFadeDuration'] ) ? $settings['TYPE9counterExitFadeDuration'] : '0.5s';
    $TYPE9counterExitFadeEase = ! empty( $settings['TYPE9counterExitFadeEase'] ) ? $settings['TYPE9counterExitFadeEase'] : 'expo';
    if ($TYPE9counterExitFadeEase === 'custom') {
      $TYPE9counterExitFadeEase = ! empty( $settings['customTYPE9counterExitFadeEase'] ) ? $settings['customTYPE9counterExitFadeEase'] : 'expo';
    }

    /*ANIMATION - TYPE 10*/
    if ( isset($settings['TYPE10image1'])) {
        if ( isset($settings['TYPE10image1']['mediaData']['url'])) {
          $TYPE10image1 = $settings['TYPE10image1']['mediaData']['url'];
        }
        else if ( isset($settings['TYPE10image1']['url'])) {
          $TYPE10image1 = $settings['TYPE10image1']['url'];
        }
    }
    $TYPE10image1Alt = ! empty( $settings['TYPE10image1Alt'] ) ? $settings['TYPE10image1Alt'] : '';
    if ( isset($settings['TYPE10image2'])) {
        if ( isset($settings['TYPE10image2']['mediaData']['url'])) {
          $TYPE10image2 = $settings['TYPE10image2']['mediaData']['url'];
        }
        else if ( isset($settings['TYPE10image2']['url'])) {
          $TYPE10image2 = $settings['TYPE10image2']['url'];
        }
    }
    $TYPE10image2Alt = ! empty( $settings['TYPE10image2Alt'] ) ? $settings['TYPE10image2Alt'] : '';
    if ( isset($settings['TYPE10image3'])) {
        if ( isset($settings['TYPE10image3']['mediaData']['url'])) {
          $TYPE10image3 = $settings['TYPE10image3']['mediaData']['url'];
        }
        else if ( isset($settings['TYPE10image3']['url'])) {
          $TYPE10image3 = $settings['TYPE10image3']['url'];
        }
    }
    $TYPE10image3Alt = ! empty( $settings['TYPE10image3Alt'] ) ? $settings['TYPE10image3Alt'] : '';
    if ( isset($settings['TYPE10image4'])) {
        if ( isset($settings['TYPE10image4']['mediaData']['url'])) {
          $TYPE10image4 = $settings['TYPE10image4']['mediaData']['url'];
        }
        else if ( isset($settings['TYPE10image4']['url'])) {
          $TYPE10image4 = $settings['TYPE10image4']['url'];
        }
    }
    $TYPE10image4Alt = ! empty( $settings['TYPE10image4Alt'] ) ? $settings['TYPE10image4Alt'] : '';
    $TYPE10imgRevealDuration = ! empty( $settings['TYPE10imgRevealDuration'] ) ? $settings['TYPE10imgRevealDuration'] : '1.2s';
    $TYPE10imgRevealStagger = ! empty( $settings['TYPE10imgRevealStagger'] ) ? $settings['TYPE10imgRevealStagger'] : '0.15s';
    $TYPE10imgRevealEase = ! empty( $settings['TYPE10imgRevealEase'] ) ? $settings['TYPE10imgRevealEase'] : 'smoothBlur';
    if ($TYPE10imgRevealEase === 'custom') {
      $TYPE10imgRevealEase = ! empty( $settings['customTYPE10imgRevealEase'] ) ? $settings['customTYPE10imgRevealEase'] : 'smoothBlur';
    }
    $TYPE10imgScaleDuration = ! empty( $settings['TYPE10imgScaleDuration'] ) ? $settings['TYPE10imgScaleDuration'] : '1.2s';
    $TYPE10imgScaleEase = ! empty( $settings['TYPE10imgScaleEase'] ) ? $settings['TYPE10imgScaleEase'] : 'power3';
    if ($TYPE10imgScaleEase === 'custom') {
      $TYPE10imgScaleEase = ! empty( $settings['customTYPE10imgScaleEase'] ) ? $settings['customTYPE10imgScaleEase'] : 'power3';
    }
    $TYPE10pauseAfterZoom = ! empty( $settings['TYPE10pauseAfterZoom'] ) ? $settings['TYPE10pauseAfterZoom'] : '0.2s';

    /*ANIMATION - TYPE 11*/
    $TYPE11progressEase = ! empty( $settings['TYPE11progressEase'] ) ? $settings['TYPE11progressEase'] : 'power2';
    if ($TYPE11progressEase === 'custom') {
      $TYPE11progressEase = ! empty( $settings['customTYPE11progressEase'] ) ? $settings['customTYPE11progressEase'] : 'power2';
    }
    $TYPE11progressExitFadeDuration = ! empty( $settings['TYPE11progressExitFadeDuration'] ) ? $settings['TYPE11progressExitFadeDuration'] : '0.5s';
    $TYPE11progressExitFadeEase = ! empty( $settings['TYPE11progressExitFadeEase'] ) ? $settings['TYPE11progressExitFadeEase'] : 'power2';
    if ($TYPE11progressExitFadeEase === 'custom') {
      $TYPE11progressExitFadeEase = ! empty( $settings['customTYPE11progressExitFadeEase'] ) ? $settings['customTYPE11progressExitFadeEase'] : 'power2';
    }
    $TYPE11slidesDuration = ! empty( $settings['TYPE11slidesDuration'] ) ? $settings['TYPE11slidesDuration'] : '1s';
    $TYPE11slidesEase = ! empty( $settings['TYPE11slidesEase'] ) ? $settings['TYPE11slidesEase'] : 'power2';
    if ($TYPE11slidesEase === 'custom') {
      $TYPE11slidesEase = ! empty( $settings['customTYPE11slidesEase'] ) ? $settings['customTYPE11slidesEase'] : 'power2';
    }
    $TYPE11textLeft = ! empty( $settings['TYPE11textLeft'] ) ? $settings['TYPE11textLeft'] : 'Next';
    $TYPE11textRight = ! empty( $settings['TYPE11textRight'] ) ? $settings['TYPE11textRight'] : 'Bricks';

    /*ANIMATION - TYPE 12*/
    if ( isset($settings['TYPE12image'])) {
        if ( isset($settings['TYPE12image']['mediaData']['url'])) {
          $TYPE12image = $settings['TYPE12image']['mediaData']['url'];
        }
        else if ( isset($settings['TYPE12image']['url'])) {
          $TYPE12image = $settings['TYPE12image']['url'];
        }
    }
    $TYPE12imageAlt = ! empty( $settings['TYPE12imageAlt'] ) ? $settings['TYPE12imageAlt'] : '';
    $TYPE12progressFrom = ! empty( $settings['TYPE12progressFrom'] ) ? $settings['TYPE12progressFrom'] : 'left';
    $TYPE12progressEase = ! empty( $settings['TYPE12progressEase'] ) ? $settings['TYPE12progressEase'] : 'power2';
    if ($TYPE12progressEase === 'custom') {
      $TYPE12progressEase = ! empty( $settings['customTYPE12progressEase'] ) ? $settings['customTYPE12progressEase'] : 'power2';
    }
    $TYPE12progressExitFadeDuration = ! empty( $settings['TYPE12progressExitFadeDuration'] ) ? $settings['TYPE12progressExitFadeDuration'] : '0.5s';
    $TYPE12progressExitFadeEase = ! empty( $settings['TYPE12progressExitFadeEase'] ) ? $settings['TYPE12progressExitFadeEase'] : 'power2';
    
    switch ($type) {
    case 'type1':
        $this->set_attribute( '_root', 'class', 'nb-site-loader--type1' );
        $this->set_attribute( '_root', 'data-swap-duration', $TYPE1swapDuration );
        $this->set_attribute( '_root', 'data-swap-ease', $TYPE1swapEase );
        $this->set_attribute( '_root', 'data-swap-stagger', $TYPE1swapStagger );
        $this->set_attribute( '_root', 'data-progress-bar-ease', $TYPE1progressBarEase );
        $this->set_attribute( '_root', 'data-slide-duration', $TYPE1slideDuration );
        $this->set_attribute( '_root', 'data-slide-ease', $TYPE1slideEase );
        $this->set_attribute( '_root', 'data-slide-delay', $TYPE1slideDelay );
        $output = "
            <div
            {$this->render_attributes( '_root' )}
            >
                <div class='nb-site-loader--type1__progress-container'>
                    <div class='nb-site-loader--type1__progress-bar'></div>
                </div>
                <div class='nb-site-loader--type1__text-container'>
                    <div class='nb-site-loader--type1__loading-text nb-site-loader--type1__loading-text--initial'>$TYPE1loadingText</div>
                    <div class='nb-site-loader--type1__loading-text nb-site-loader--type1__loading-text--complete'>$TYPE1completeText</div>
                </div>
                <div class='nb-site-loader--type1__percentage'>0</div>
            </div>
        ";
        break;
    case 'type2':
        $this->set_attribute( '_root', 'class', 'nb-site-loader--type2' );
        $this->set_attribute( '_root', 'data-progress-bar-ease', $TYPE2progressBarEase );
        $this->set_attribute( '_root', 'data-percentage-ease', $TYPE2percentageEase );
        $this->set_attribute( '_root', 'data-slide-duration', $TYPE2slideDuration );
        $this->set_attribute( '_root', 'data-slide-ease', $TYPE2slideEase );
        $this->set_attribute( '_root', 'data-slide-delay', $TYPE2slideDelay );
        $output = "
            <div
            {$this->render_attributes( '_root' )}
            >
                <div class='nb-site-loader--type2__progress-bar'></div>
                <div class='nb-site-loader--type2__percentage-wrap'>
                    <div class='nb-site-loader--type2__percentage nb-site-loader--type2__percentage--display'>0</div>
                    <div class='nb-site-loader--type2__percentage nb-site-loader--type2__percentage--calc-100'>100</div>
                </div>
            </div>
        ";
        break;
    case 'type3':
        $this->set_attribute( '_root', 'class', 'nb-site-loader--type3' );
        $this->set_attribute( '_root', 'data-symbol', $TYPE3symbol );
        $this->set_attribute( '_root', 'data-terminal-finish-scale', $TYPE3terminalFinishScale );
        $this->set_attribute( '_root', 'data-terminal-scale-duration', $TYPE3terminalScaleDuration );
        $this->set_attribute( '_root', 'data-terminal-scale-ease', $TYPE3terminalScaleEase );
        $this->set_attribute( '_root', 'data-translate-commands-from', $TYPE3translateCommandsFrom );
        $this->set_attribute( '_root', 'data-commands-duration', $TYPE3commandsDuration );
        $this->set_attribute( '_root', 'data-commands-ease', $TYPE3commandsEase );
        $this->set_attribute( '_root', 'data-exit-fade-duration', $TYPE3exitFadeDuration );
        $this->set_attribute( '_root', 'data-exit-fade-ease', $TYPE3exitFadeEase );
        $output = "
            <div
            {$this->render_attributes( '_root' )}
            >
                <div class='nb-site-loader--type3__terminal'>
                    <div class='nb-site-loader--type3__terminal-content'>
                        <div class='nb-site-loader--type3__commands-container'>
                        <div class='nb-site-loader--type3__command-line nb-site-loader--type3__command-line--1'>
                            <span class='nb-site-loader--type3__prompt'>$TYPE3symbol</span> <!--type3 -- command prompt-->
                            <span class='nb-site-loader--type3__command'>$TYPE3commandline1</span> <!--type3 -- command line 1-->
                            <span class='nb-site-loader--type3__cursor'></span>
                        </div>
                        <div class='nb-site-loader--type3__command-line nb-site-loader--type3__command-line--2'>
                            <span class='nb-site-loader--type3__prompt'>$TYPE3symbol</span> <!--type3 -- command prompt-->
                            <span class='nb-site-loader--type3__command'>$TYPE3commandline2</span> <!--type3 -- command line 2-->
                            <span class='nb-site-loader--type3__cursor'></span>
                        </div>
                        <div class='nb-site-loader--type3__command-line nb-site-loader--type3__command-line--3'>
                            <span class='nb-site-loader--type3__prompt'>$TYPE3symbol</span> <!--type3 -- command prompt-->
                            <span class='nb-site-loader--type3__command'>$TYPE3commandline3</span> <!--type3 -- command line 3-->
                            <span class='nb-site-loader--type3__cursor'></span>
                        </div>
                        <div class='nb-site-loader--type3__command-line nb-site-loader--type3__command-line--4'>
                            <span class='nb-site-loader--type3__prompt'>$TYPE3symbol</span> <!--type3 -- command prompt-->
                            <span class='nb-site-loader--type3__command'>$TYPE3commandline4</span> <!--type3 -- command line 4-->
                            <span class='nb-site-loader--type3__cursor'></span>
                        </div>
                        </div>
                        <div class='nb-site-loader--type3__loading-container'>
                        <div class='nb-site-loader--type3__loading-bar'>
                            <div class='nb-site-loader--type3__loading-progress'></div>
                        </div>
                        </div>
                        <div class='nb-site-loader--type3__percentage-wrap'>
                        <div class='nb-site-loader--type3__percentage'>00%</div>
                        </div>
                    </div>
                </div>
            </div>
        ";
        break;
    case 'type4':
        $this->set_attribute( '_root', 'class', 'nb-site-loader--type4' );
        $this->set_attribute( '_root', 'data-initial-loading-duration', $TYPE4initialLoadingDuration );
        $this->set_attribute( '_root', 'data-initial-loading-ease', $TYPE4initialLoadingEase );
        $this->set_attribute( '_root', 'data-initial-loading-delay', $TYPE4initialLoadingDelay );
        $this->set_attribute( '_root', 'data-progress-ease', $TYPE4progressEase );
        $this->set_attribute( '_root', 'data-exit-slides-duration', $TYPE4exitSlidesDuration );
        $this->set_attribute( '_root', 'data-exit-slides-ease', $TYPE4exitSlidesEase );
        $output = "
            <div
            {$this->render_attributes( '_root' )}
            >
                <div class='nb-site-loader--type4__mask-top'></div>
                <div class='nb-site-loader--type4__mask-bottom'></div>

                <div class='nb-site-loader--type4__container'>
                    <div class='nb-site-loader--type4__progress-bar'>
                        <span>$TYPE4progressText</span> <!--type4 -- progress text-->
                        <span>/<span class='nb-site-loader--type4__counter'>0</span></span> <!--type4 -- symbol-->
                    </div>
                </div>
            </div>
        ";
        break;
    case 'type5':
        $this->set_attribute( '_root', 'class', 'nb-site-loader--type5' );
        $this->set_attribute( '_root', 'data-count-exit-fade-duration', $TYPE5countExitFadeDuration );
        $this->set_attribute( '_root', 'data-count-exit-fade-ease', $TYPE5countExitFadeEase );
        $this->set_attribute( '_root', 'data-swap-duration', $TYPE5swapDuration );
        $this->set_attribute( '_root', 'data-swap-ease', $TYPE5swapEase );
        $this->set_attribute( '_root', 'data-swap-stagger', $TYPE5swapStagger );
        $this->set_attribute( '_root', 'data-loader-scale', $TYPE5loaderScale );
        $this->set_attribute( '_root', 'data-loader-scale-duration', $TYPE5loaderScaleDuration );
        $this->set_attribute( '_root', 'data-loader-scale-ease', $TYPE5loaderScaleEase );
        $this->set_attribute( '_root', 'data-exit-slides-duration', $TYPE5exitSlidesDuration );
        $this->set_attribute( '_root', 'data-exit-slides-ease', $TYPE5exitSlidesEase );
        $output = "
            <div
            {$this->render_attributes( '_root' )}
            >
                <div class='nb-site-loader--type5__pre-loader'>
                    <div class='nb-site-loader--type5__loader'></div>
                    <div class='nb-site-loader--type5__loader-bg'></div>
                </div>
                <div class='nb-site-loader--type5__loader-content'>
                    <div class='nb-site-loader--type5__count'>
                        <span>0</span>
                    </div>
                    <div class='nb-site-loader--type5__copy'>
                        <div class='nb-site-loader--type5__ml16'>$TYPE5brand</div> <!--type5 -- brand-->
                    </div>
                </div>
                <div class='nb-site-loader--type5__loader-2'></div>
            </div>
        ";
        break;
    case 'type6':
        $this->set_attribute( '_root', 'class', 'nb-site-loader--type6' );
        $this->set_attribute( '_root', 'data-exit-counter-swap-duration', $TYPE6counterSwapDuration );
        $this->set_attribute( '_root', 'data-exit-counter-swap-ease', $TYPE6counterSwapEase );
        $this->set_attribute( '_root', 'data-exit-counter-swap-stagger', $TYPE6counterSwapStagger );
        $this->set_attribute( '_root', 'data-exit-type', $TYPE6exitType );
        $this->set_attribute( '_root', 'data-exit-type-duration', $TYPE6exitTypeDuration );
        $this->set_attribute( '_root', 'data-exit-type-ease', $TYPE6exitTypeEase );
        $output = "
            <div
            {$this->render_attributes( '_root' )}
            >
                <div class='nb-site-loader--type6__counter'>
                    <div class='nb-site-loader--type6__counter-1 nb-site-loader--type6__digit'>
                        <div class='nb-site-loader--type6__num'>0</div>
                        <div class='nb-site-loader--type6__num nb-site-loader--type6__num1offset1'>1</div>
                    </div>
                    <div class='nb-site-loader--type6__counter-2 nb-site-loader--type6__digit'>
                        <div class='nb-site-loader--type6__num'>0</div>
                        <div class='nb-site-loader--type6__num nb-site-loader--type6__num1offset2'>1</div>
                        <div class='nb-site-loader--type6__num'>2</div>
                        <div class='nb-site-loader--type6__num'>3</div>
                        <div class='nb-site-loader--type6__num'>4</div>
                        <div class='nb-site-loader--type6__num'>5</div>
                        <div class='nb-site-loader--type6__num'>6</div>
                        <div class='nb-site-loader--type6__num'>7</div>
                        <div class='nb-site-loader--type6__num'>8</div>
                        <div class='nb-site-loader--type6__num'>9</div>
                        <div class='nb-site-loader--type6__num'>0</div>
                    </div>
                    <div class='nb-site-loader--type6__counter-3 nb-site-loader--type6__digit'>
                        <div class='nb-site-loader--type6__num'>0</div>
                        <div class='nb-site-loader--type6__num'>1</div>
                        <div class='nb-site-loader--type6__num'>2</div>
                        <div class='nb-site-loader--type6__num'>3</div>
                        <div class='nb-site-loader--type6__num'>4</div>
                        <div class='nb-site-loader--type6__num'>5</div>
                        <div class='nb-site-loader--type6__num'>6</div>
                        <div class='nb-site-loader--type6__num'>7</div>
                        <div class='nb-site-loader--type6__num'>8</div>
                        <div class='nb-site-loader--type6__num'>9</div>
                    </div>
                </div>
            </div>
        ";
        break;
    case 'type7':
        $this->set_attribute( '_root', 'class', 'nb-site-loader--type7' );
        $this->set_attribute( '_root', 'data-progress-ease', $TYPE7progressEase );
        $this->set_attribute( '_root', 'data-bar-scale', $TYPE7barScale );
        $this->set_attribute( '_root', 'data-bar-scale-duration', $TYPE7barScaleDuration );
        $this->set_attribute( '_root', 'data-bar-scale-easing', $TYPE7barScaleEasing );
        $this->set_attribute( '_root', 'data-exit-fade-duration', $TYPE7exitFadeDuration );
        $this->set_attribute( '_root', 'data-exit-fade-easing', $TYPE7exitFadeEasing );
        $output = "
            <div
            {$this->render_attributes( '_root' )}
            >
                <div class='nb-site-loader--type7__logo-loader'>
                    <img class='nb-site-loader--type7__logo' src='$TYPE7image' alt='$TYPE7alt'> <!--type7 -- logo-->

                    <div class='nb-site-loader--type7__loader'>
                        <div class='nb-site-loader--type7__loader-1 nb-site-loader--type7__bar'></div>
                    </div>
                </div>
            </div>
        ";
        break;
    case 'type8':
        $this->set_attribute( '_root', 'class', 'nb-site-loader--type8' );
        $this->set_attribute( '_root', 'data-bars-number', $TYPE8barsNumber );
        $this->set_attribute( '_root', 'data-bars-duration', $TYPE8barsDuration );
        $this->set_attribute( '_root', 'data-bars-ease', $TYPE8barsEase );
        $this->set_attribute( '_root', 'data-bars-stagger', $TYPE8barsStagger );
        $this->set_attribute( '_root', 'data-counter-exit-fade-duration', $TYPE8counterExitFadeDuration );
        $this->set_attribute( '_root', 'data-counter-exit-fade-ease', $TYPE8counterExitFadeEase );
        $output = "
            <div
            {$this->render_attributes( '_root' )}
            >
                <span class='nb-site-loader--type8__counter'>00</span>

                <div class='nb-site-loader--type8__overlay'>";
                    for ($i = 0; $i < $TYPE8barsNumber; $i++) {
                        $output .= "<div class='nb-site-loader--type8__bar'></div>";
                    }
        $output .= "</div>
            </div>
        ";
        break;
    case 'type9':
        $this->set_attribute( '_root', 'class', 'nb-site-loader--type9' );
        $this->set_attribute( '_root', 'data-bars-number', $TYPE9barsNumber );
        $this->set_attribute( '_root', 'data-exit-direction', $TYPE9exitDirection );
        $this->set_attribute( '_root', 'data-bars-duration', $TYPE9barsDuration );
        $this->set_attribute( '_root', 'data-bars-ease', $TYPE9barsEase );
        $this->set_attribute( '_root', 'data-bars-stagger', $TYPE9barsStagger );
        $this->set_attribute( '_root', 'data-counter-exit-fade-duration', $TYPE9counterExitFadeDuration );
        $this->set_attribute( '_root', 'data-counter-exit-fade-ease', $TYPE9counterExitFadeEase );
        $output = "
            <div
            {$this->render_attributes( '_root' )}
            >
                <span class='nb-site-loader--type9__counter'>00</span>

                <div class='nb-site-loader--type9__overlay'>";
                    for ($i = 0; $i < $TYPE9barsNumber; $i++) {
                        $output .= "<div class='nb-site-loader--type9__bar'></div>";
                    }
        $output .= "</div>
            </div>
        ";
        break;
    case 'type10':
        $this->set_attribute( '_root', 'class', 'nb-site-loader--type10' );
        $this->set_attribute( '_root', 'data-img-reveal-duration', $TYPE10imgRevealDuration );
        $this->set_attribute( '_root', 'data-img-reveal-stagger', $TYPE10imgRevealStagger );
        $this->set_attribute( '_root', 'data-img-reveal-ease', $TYPE10imgRevealEase );
        $this->set_attribute( '_root', 'data-img-scale-duration', $TYPE10imgScaleDuration );
        $this->set_attribute( '_root', 'data-img-scale-ease', $TYPE10imgScaleEase );
        $this->set_attribute( '_root', 'data-pause-after-zoom', $TYPE10pauseAfterZoom );
        $output = "
            <div
            {$this->render_attributes( '_root' )}
            >
                <div class='nb-site-loader--type10__preloader-container'>
                    <div class='nb-site-loader--type10__image-wrapper'>
                        <img src='https://cdn.cosmos.so/5f8d5539-943c-4df5-bae8-8e714633ddd0.jpeg' alt='Image 1'>
                    </div>
                    <div class='nb-site-loader--type10__image-wrapper'>
                        <img src='https://cdn.cosmos.so/0098a074-f8a2-4821-bcb0-433c093ae255.jpeg' alt='Image 2'>
                    </div>
                    <div class='nb-site-loader--type10__image-wrapper'>
                        <img src='https://cdn.cosmos.so/ce9f9fd7-a2a5-476d-9757-481ca01b5861.jpeg' alt='Image 3'>
                    </div>
                    <div class='nb-site-loader--type10__image-wrapper'>
                        <img src='https://cdn.cosmos.so/94579ea4-daee-43f9-b778-84156b731361.jpeg' alt='Image 4'>
                    </div>
                </div>
            </div>
        ";
        break;
    case 'type11':
        $this->set_attribute( '_root', 'class', 'nb-site-loader--type11' );
        $this->set_attribute( '_root', 'data-progress-ease', $TYPE11progressEase );
        $this->set_attribute( '_root', 'data-progress-exit-fade-duration', $TYPE11progressExitFadeDuration );
        $this->set_attribute( '_root', 'data-progress-exit-fade-ease', $TYPE11progressExitFadeEase );
        $this->set_attribute( '_root', 'data-slides-duration', $TYPE11slidesDuration );
        $this->set_attribute( '_root', 'data-slides-ease', $TYPE11slidesEase );
        $output = "
            <div
            {$this->render_attributes( '_root' )}
            >
                <div class='nb-site-loader--type11__pre-loader'>
                    <div class='nb-site-loader--type11__loader-wrapper'>
                    <div class='nb-site-loader--type11__loader'></div>
                    </div>
                </div>
                <div class='nb-site-loader--type11__clipper-left'>
                    <div class='nb-site-loader--type11__loader-text'>$TYPE11textLeft</div>
                </div>
                <div class='nb-site-loader--type11__clipper-right'>
                    <div class='nb-site-loader--type11__loader-text'>$TYPE11textRight</div>
                </div>
            </div>
        ";
        break;
    case 'type12':
        $this->set_attribute( '_root', 'class', 'nb-site-loader--type12' );
        $this->set_attribute( '_root', 'data-progress-from', $TYPE12progressFrom );
        $this->set_attribute( '_root', 'data-progress-ease', $TYPE12progressEase );
        $this->set_attribute( '_root', 'data-exit-fade-duration', $TYPE12progressExitFadeDuration );
        $this->set_attribute( '_root', 'data-exit-fade-ease', $TYPE12progressExitFadeEase );
        $output = "
            <div
            {$this->render_attributes( '_root' )}
            >
                <div class='nb-site-loader--type12__logo-wrapper'>
                    <img class='nb-site-loader--type12__logo' src='$TYPE12image' alt='$TYPE12imageAlt'>
                    <div class='nb-site-loader--type12__logo-fill'></div>
                </div>
            </div>
        ";
        break;
    }

	echo $output;
  }
}