<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Spotlight_v2 extends \Bricks\Element {
    public $name         = 'next_spotlight_v2';
    public $icon         = 'fa-solid fa-slash';
    public $scripts      = ['next_spotlight_v2'];

    public function get_label() {
        return esc_html__( 'Spotlight v2 element', 'bricks' );
    }

    public function set_controls() {
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Spotlight v2 element can be placed in a block other than Spotlight v2 (container).<br>
            It has an absolute position so the new parent requires a relative position and overflow hidden with the appropriate dimensions.', 'bricks' )))
        ];
        /*Spotlight style*/
        $this->controls['spotlightStyleSeparator'] = [
            'label'      => esc_html__( 'Spotlight style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['spotlightzIndex'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'zIndex', 'bricks' ),
            'type'    => 'text',
            'css'     => [
                [
                    'property' => 'z-index',
                    'selector' => '',
                ],
            ],
            'inline'   => true,
            'small'   => true,
            'placeholder'    => '1',
            'default' => '1',
        ];
        $this->controls['spotlightWidth'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Width', 'bricks' ),
            'type'    => 'number',
            'units'   => true,
            'css'     => [
                [
                    'property' => '--width',
                    'selector' => '',
                ],
            ],
            'placeholder' => '750px',
            'default' => '750px',
        ];
        $this->controls['spotlightHeight'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Height', 'bricks' ),
            'type'    => 'number',
            'units'   => true,
            'css'     => [
                [
                    'property' => '--height',
                    'selector' => '',
                ],
            ],
            'placeholder' => '750px',
            'default' => '750px',
        ];
        $this->controls['spotlightTop'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Top', 'bricks' ),
            'type'    => 'number',
            'units'   => true,
            'css'     => [
                [
                    'property' => 'top',
                    'selector' => '',
                ],
            ],
            'placeholder' => '-50px',
            'default' => '-50px',
        ];
        $this->controls['spotlightLeft'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Left', 'bricks' ),
            'type'    => 'number',
            'units'   => true,
            'css'     => [
                [
                    'property' => 'left',
                    'selector' => '',
                ],
            ],
            'placeholder' => 'auto',
            'default' => 'auto',
        ];
        $this->controls['spotlightColor'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Color', 'bricks' ),
            'type'    => 'color',
            'css'     => [
                [
                    'property' => 'fill',
                    'selector' => 'ellipse',
                ],
            ],
        ];
        $this->controls['spotlightOpacity'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Opacity', 'bricks' ),
            'type'    => 'number',
            'css'     => [
                [
                    'property' => 'fill-opacity',
                    'selector' => 'ellipse',
                ],
            ],
            'placeholder' => '0.21',
        ];

        /*Animation*/
        $this->controls['animationSeparator'] = [
            'label'      => esc_html__( 'Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['spotlightScale'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'From scale', 'bricks' ),
            'type'    => 'text',
            'css'     => [
                [
                    'property' => '--from-scale',
                    'selector' => '',
                ],
            ],
            'inline'   => true,
            'rerender'   => true,
            'placeholder' => '0.5',
            'default' => '0.5',
        ];
        $this->controls['trigger'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Trigger', 'bricks' ),
            'type'    => 'text',
            'placeholder' => 'this',
            'inline' => true,
        ];
        $this->controls['start'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Start', 'bricks' ),
            'type'    => 'text',
            'placeholder' => 'top bottom',
            'inline' => true,
        ];
        $this->controls['duration'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Duration', 'bricks' ),
            'type'    => 'number',
            'unit'    => 's',
            'placeholder' => '2s',
        ];
        $this->controls['delay'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Delay', 'bricks' ),
            'type'    => 'number',
            'unit'    => 's',
            'placeholder' => '0s',
        ];
        $this->controls['ease'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'GSAP easing', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'none' => 'none',
                'power1' => 'power1',
                'power2' => 'power2',
                'power3' => 'power3',
                'power4' => 'power4',
                'back' => 'back',
                'bounce' => 'bounce',
                'circ' => 'circ',
                'elastic' => 'elastic',
                'expo' => 'expo',
                'sine' => 'sine',
                'steps' => 'steps',
                'custom' => 'custom'
            ],
            'inline' => true,
            'placeholder' => 'power3',
        ];
        $this->controls['customEase'] = [
          'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'Custom easing', 'bricks' ),
          'type' => 'text',
          'inline' => true,
          'placeholder' => 'back.out(1.7)',
          'default' => 'back.out(1.7)',
          'required' => [ 'ease', '=', 'custom' ],
        ];

        $this->controls['toggleActions'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Toggle actions', 'bricks' ),
            'type'    => 'text',
            'placeholder' => 'play none none none',
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next-spotlight-v2', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_spotlight_v2.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;

        $start = ! empty( $settings['start'] ) ? $settings['start'] : 'top bottom';
        $duration = ! empty( $settings['duration'] ) ? $settings['duration'] : 2;
        $delay = ! empty( $settings['delay'] ) ? $settings['delay'] : 0;
        $trigger = ! empty( $settings['trigger'] ) ? $settings['trigger'] : 'this';
        $easing = ! empty( $settings['ease'] ) ? $settings['ease'] : 'power3';
        if ($easing === 'custom') {
      $easing = ! empty( $settings['customEase'] ) ? $settings['customEase'] : 'power3';
    }
        $toggleActions = ! empty( $settings['toggleActions'] ) ? $settings['toggleActions'] : 'play none none none';

        $this->set_attribute( '_root', 'class', 'next-spotlight-v2' );
        $this->set_attribute( '_root', 'data-start', "$start");
        $this->set_attribute( '_root', 'data-duration', "$duration");
        $this->set_attribute( '_root', 'data-delay', "$delay");
        $this->set_attribute( '_root', 'data-trigger', "$trigger");
        $this->set_attribute( '_root', 'data-easing', "$easing");
        $this->set_attribute( '_root', 'data-toggleActions', "play none none none");

        $output = "
        <div>
            <svg {$this->render_attributes( '_root' )} xmlns='http://www.w3.org/2000/svg' viewBox='0 0 3787 2842' fill='none''>
                <g filter='url(#next-spotlight-v2__filter)'>
                    <ellipse cx='1924.71' cy='273.501' rx='1924.71' ry='273.501' transform='matrix(-0.822377 -0.568943 -0.568943 0.822377 3631.88 2291.09)'></ellipse>
                </g>
                <defs>
                    <filter id='next-spotlight-v2__filter' x='0.860352' y='0.838989' width='3785.16' height='2840.26' filterUnits='userSpaceOnUse' color-interpolation-filters='sRGB'>
                        <feFlood flood-opacity='0' result='BackgroundImageFix'></feFlood>
                        <feBlend mode='normal' in='SourceGraphic' in2='BackgroundImageFix' result='shape'></feBlend>
                        <feGaussianBlur stdDeviation='151' result='effect1_foregroundBlur_1065_8'></feGaussianBlur>
                    </filter>
                </defs>
            </svg>
        </div>";

        echo $output;
    }
}