<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Squeezy_Radius_Button extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'next-squeezy-radius-button';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';

  public function get_label() {
    return esc_html__( 'Squeezy Radius Button', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Squeezy Radius Button', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['iconsSeparator'] = [
        'label'      => esc_html__( 'Icons', 'bricks' ),
        'type'       => 'separator',
      ];
      $this->controls['includeLeftIcon'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Left Icon', 'bricks' ),
        'type' => 'checkbox',
        'default' => false,
      ];
      $this->controls['leftIcon'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Icon', 'bricks' ),
        'type' => 'icon',
        'css' => [
          [
            'selector' => '&{pseudo} .nb-squeezy-radius-button__left-icon',
          ],
        ],
        'required'   => [ 'includeLeftIcon', '=', true ],
      ];
      $this->controls['leftIconMargin'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Margin', 'bricks' ),
        'type'  => 'spacing',
        'css'   => [
          [
            'property' => 'margin',
            'selector' => '&{pseudo} .nb-squeezy-radius-button__left-icon',
          ],
        ],
        'required' => [ 'includeLeftIcon', '=', true ],
      ];
      $this->controls['leftIconSize'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Size', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'css'   => [
          [
            'property' => 'font-size',
            'selector' => '&{pseudo} .nb-squeezy-radius-button__left-icon',
          ],
        ],
        'required' => [ 'includeLeftIcon', '=', true ],
      ];
      $this->controls['leftIconColor'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Color', 'bricks' ),
        'type'  => 'color',
        'css'   => [
          [
            'property' => 'color',
            'selector' => '&{pseudo} .nb-squeezy-radius-button__left-icon',
          ],
        ],
        'required' => [ 'includeLeftIcon', '=', true ],
      ];
      $this->controls['includeRightIcon'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Right Icon', 'bricks' ),
        'type' => 'checkbox',
        'default' => false,
      ];
      $this->controls['rightIcon'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Icon', 'bricks' ),
        'type' => 'icon',
        'css' => [
          [
            'selector' => '&{pseudo} .nb-squeezy-radius-button__right-icon',
          ],
        ],
        'required'   => [ 'includeRightIcon', '=', true ],
      ];
      $this->controls['rightIconMargin'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Margin', 'bricks' ),
        'type'  => 'spacing',
        'css'   => [
          [
            'property' => 'margin',
            'selector' => '&{pseudo} .nb-squeezy-radius-button__right-icon',
          ],
        ],
        'required' => [ 'includeRightIcon', '=', true ],
      ];
      $this->controls['rightIconSize'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Size', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'css'   => [
          [
            'property' => 'font-size',
            'selector' => '&{pseudo} .nb-squeezy-radius-button__right-icon',
          ],
        ],
        'required' => [ 'includeRightIcon', '=', true ],
      ];
      $this->controls['rightIconColor'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Color', 'bricks' ),
        'type'  => 'color',
        'css'   => [
          [
            'property' => 'color',
            'selector' => '&{pseudo} .nb-squeezy-radius-button__right-icon',
          ],
        ],
        'required' => [ 'includeRightIcon', '=', true ],
      ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['padding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => '--padding',
                'selector' => '',
            ],
        ],
        'default' => [
            'top'    => 10,
            'right'  => 15, 
            'bottom' => 10,
            'left'   => 15,
        ],
    ];
    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '',
            ],
        ],
        'exclude' => [
            [
              'color'
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'font-weight' => '500',
        ],
    ];
    $this->controls['color'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Text Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--text-color',
                'selector' => '',
            ],
        ],
        'default' => [
            'hex' => '#000000',
        ],
    ];
    $this->controls['background'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--background',
                'selector' => '',
            ],
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];
    $this->controls['border'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Border', 'bricks'),
        'type'    => 'border',
        'css'     => [
          [
            'property' => 'border',
            'selector' => '&{pseudo} .nb-squeezy-radius-button__background--bubblegum-dash',
          ],
        ],
        'default' => [
            'radius' => [
                'top' => 8,
                'right' => 8,
                'bottom' => 8,
                'left' => 8,
            ],
        ]
    ];

    $this->controls['squeezyAnimationSeparator'] = [
        'label'      => esc_html__( 'Squeezy Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['toBorderRadius'] = [
        'tab'     => 'content',
        'label'   => esc_html__('To Border Radius', 'bricks'),
        'type'    => 'border',
        'css'     => [
          [
            'property' => 'border',
            'selector' => '&{pseudo}:hover .nb-squeezy-radius-button__background',
            'important' => true,
          ],
            [
            'property' => 'border',
            'selector' => '&{pseudo}:focus-visible .nb-squeezy-radius-button__background',
            'important' => true,
          ],
        ],
        'exclude' => [
            'width',
            'style',
            'color',
        ],
        'default' => [
            'radius' => [
                'top' => 20,
                'right' => 20,
                'bottom' => 20,
                'left' => 20,
            ],
        ]
    ];
    $this->controls['squeezyDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Duration', 'bricks'),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
          [
            'property' => '--squeezy-duration',
            'selector' => '',
          ],
        ],
        'default' => '0.3s',
    ];

    $this->controls['swapAnimationSeparator'] = [
        'label'      => esc_html__( 'Swap Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['swapTranslate'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Translate', 'bricks'),
        'type'    => 'number',
        'units'    => true,
        'css'     => [
          [
            'property' => '--swap-translate',
            'selector' => '',
          ],
        ],
        'default' => '2em',
    ];
    $this->controls['swapDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Duration', 'bricks'),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
          [
            'property' => '--swap-duration',
            'selector' => '',
          ],
        ],
        'default' => '0.3s',
    ];
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Squeezy Radius Button';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $includeLeftIcon = ! empty( $settings['includeLeftIcon'] ) ? $settings['includeLeftIcon'] : 0;
    $includeRightIcon = ! empty( $settings['includeRightIcon'] ) ? $settings['includeRightIcon'] : 0;
    if ( $includeLeftIcon !== 0 ) {
      $leftIcon = self::render_icon( $settings['leftIcon'], [ 'nb-squeezy-radius-button__left-icon' ] );
    }else{
      $leftIcon = '';
    }
    if ( $includeRightIcon !== 0 ) {
      $rightIcon = self::render_icon( $settings['rightIcon'], [ 'nb-squeezy-radius-button__right-icon' ] );
    }else{
      $rightIcon = '';
    }

    $this->set_attribute( '_root', 'class', 'nb-squeezy-radius-button' );

    $output = "
    <$root_tag  {$this->render_attributes( '_root' )}>
        <span class='nb-squeezy-radius-button__container'>
            <span class='nb-squeezy-radius-button__text'>$leftIcon$inner_title$rightIcon</span>
        </span>
        <span class='nb-squeezy-radius-button__background nb-squeezy-radius-button__background--bubblegum-dash'></span>
    </$root_tag>
    ";

	echo $output;
  }
}