<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Stretchy_Button extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'next-stretchy-button';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';

  public function get_label() {
    return esc_html__( 'Stretchy Button', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Stretchy Button', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['padding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '&{pseudo} .nb-stretchy-button__inner',
            ],
        ],
        'default' => [
            'top'    => 10,
            'right'  => 15, 
            'bottom' => 10,
            'left'   => 15,
        ],
    ];
    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'font-weight' => '500',
            'color' => [
                'hex' => '#ffffff',
              ]
        ],
    ];
    $this->controls['background'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&{pseudo} .nb-stretchy-button__bg',
            ],
        ],
        'default' => [
            'hex' => '#000000',
        ],
    ];
    $this->controls['border'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Border', 'bricks'),
        'type'    => 'border',
        'css'     => [
          [
            'property' => 'border',
            'selector' => '&{pseudo} .nb-stretchy-button__bg',
          ],
        ],
        'default' => [
            'radius' => [
                'top' => 8,
                'right' => 8,
                'bottom' => 8,
                'left' => 8,
            ],
        ]
    ];

    $this->controls['stretchAnimationSeparator'] = [
        'label'      => esc_html__( 'Stretch Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['stretchAmount'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Stretch Amount', 'bricks'),
        'type'    => 'number',
        'unit'    => 'deg',
        'css'     => [
          [
            'property' => '--stretch-amount',
            'selector' => '',
          ],
        ],
        'default' => '60deg',
    ];
    $this->controls['stretchText'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Stretch Text', 'bricks'),
        'type'    => 'number',
        'css'     => [
          [
            'property' => '--stretch-text',
            'selector' => '',
          ],
        ],
        'default' => '3',
    ];
    $this->controls['stretchDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Duration', 'bricks'),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
          [
            'property' => '--stretch-duration',
            'selector' => '',
          ],
        ],
        'default' => '0.25s',
    ];
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Stretchy Button';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $this->set_attribute( '_root', 'class', 'nb-stretchy-button' );

    $output = "
    <$root_tag  {$this->render_attributes( '_root' )}>
      <span class='nb-stretchy-button__container'>
        <span class='nb-stretchy-button__bg'></span>
        <span data-text='$inner_title' class='nb-stretchy-button__inner'>
            <span class='nb-stretchy-button__text'>$inner_title</span>
        </span>
      </span>
    </$root_tag>
    ";

	echo $output;
  }
}