<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Swap_Reading extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'next-swap-reading';
  public $icon         = 'ti-text';
  public $tag      = 'h3';
  public $scripts      = ['next_swap_reading'];

  public function get_label() {
    return esc_html__( 'Swap Reading', 'bricks' );
  }

  public function set_controls() {
    $this->controls['inner_title'] = [
        'hasDynamicData'      => true,
        'tab'            => 'content',
        'type'           => 'textarea',
        'default'        => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis nec leo et mi mollis dictum. Vivamus bibendum est vel elit eleifend sodales. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis nec leo et mi mollis dictum. Vivamus bibendum est vel elit eleifend sodales. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis nec leo et mi mollis dictum. Vivamus bibendum est vel elit eleifend sodales. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis nec leo et mi mollis dictum. Vivamus bibendum est vel elit eleifend sodales.', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
      ];

    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'h1' => 'h1',
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
            'p' => 'p',
            'span' => 'span',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'p',
        'default'     => 'p',
    ];
    $this->controls['customTag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Custom tag', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'placeholder' => 'p',
        'required'    => [ 'tag', '=', 'custom' ],
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['typography'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Typography', 'bricks' ),
        'type'  => 'typography',
        'css'   => [
            [
                'property' => 'typography',
                'selector' => '.next-swap-reading__paragraph',
            ],
        ],
        'default' => [
            'font-size' => '64px',
            'text-align' => 'center',
            'line-height' => '1.1',
        ],
    ];
    $this->controls['width'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'css'   => [
            [
                'property' => 'width',
                'selector' => '',
            ],
        ],
        'default' => '100%',
    ];

    $this->controls['maxWidth'] = [
        'tab'   => 'content', 
        'label' => esc_html__( 'Paragraph Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'css'   => [
            [
                'property' => 'max-width',
                'selector' => '.next-swap-reading__paragraph',
            ],
        ],
        'default' => 800,
    ];

    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['duration'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'units' => true,
        'inline' => true,
        'default' => '0.5',
    ];
    $this->controls['ease'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
            'none' => 'none',
            'power1' => 'power1',
            'power2' => 'power2',
            'power3' => 'power3',
            'power4' => 'power4',
            'back' => 'back',
            'bounce' => 'bounce',
            'circ' => 'circ',
            'elastic' => 'elastic',
            'expo' => 'expo',
            'sine' => 'sine',
            'steps' => 'steps',
            'custom' => 'custom'
        ],
        'inline' => true,
        'default' => 'none',
    ];
    $this->controls['customEase'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'ease', '=', 'custom' ],
    ];




    $this->controls['scrolltrigger'] = [
        'label'      => esc_html__( 'ScrollTrigger', 'bricks' ),
        'type'       => 'separator',
        'description' => sprintf(esc_html__( 'Scrolltrigger %s', 'bricks' ), '<a href="https://greensock.com/docs/v3/Plugins/ScrollTrigger" target="_blank">documentation</a>'),
    ];
    $this->controls['start'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Start', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'default' => 'top center+=300',
    ];
    $this->controls['end'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'End', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'default' => 'bottom center-=100',
    ];
    $this->controls['scroller'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Scroller', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'default' => 'body',
    ];
  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'next-swap-reading', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_swap_reading.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : '';
    $duration = ! empty( $settings['duration'] ) ? $settings['duration'] : '0.5';
    $ease = ! empty( $settings['ease'] ) ? $settings['ease'] : 'none';
    if ($ease === 'custom') {
      $ease = ! empty( $settings['customEase'] ) ? $settings['customEase'] : 'none';
    }
    $start = ! empty( $settings['start'] ) ? $settings['start'] : 'top center+=300';
    $end = ! empty( $settings['end'] ) ? $settings['end'] : 'bottom center-=100';
    $scroller = ! empty( $settings['scroller'] ) ? $settings['scroller'] : 'body';

    $this->set_attribute( '_root', 'class', 'next-swap-reading' );
    $this->set_attribute( '_root', 'data-duration', $duration );
    $this->set_attribute( '_root', 'data-ease', $ease );
    $this->set_attribute( '_root', 'data-start', $start );
    $this->set_attribute( '_root', 'data-end', $end );
    $this->set_attribute( '_root', 'data-scroller', $scroller );

    $output ="
    <{$this->tag} {$this->render_attributes( '_root' )}>
        <span class='next-swap-reading__paragraph'>$inner_title</div>
    </{$this->tag}>
    ";

    echo $output;
  }
}

