<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Variable_Font_Hover extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'next-variable-font-hover';
  public $icon         = 'ti-text';
  public $tag      = 'h3';
  public $scripts      = ['next_variable_font_hover'];

  public function get_label() {
    return esc_html__( 'Variable Font Hover', 'bricks' );
  }

  public function set_controls() {
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'textarea',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Variable Font Hover', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];

    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'h1' => 'h1',
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
            'p' => 'p',
            'span' => 'span',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'h3',
        'default'     => 'h3',
    ];
    $this->controls['customTag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Custom tag', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'placeholder' => 'h3',
        'required'    => [ 'tag', '=', 'custom' ],
    ];

    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['typography'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Typography', 'bricks' ),
        'type'  => 'typography',
        'css'   => [
            [
                'property' => 'typography',
                'selector' => '',
            ],
        ],
        'default' => [
            'font-size' => '32px',
        ],
    ];

    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['direction'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Direction', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'left' => 'left',
            'center'   => 'center',
            'right' => 'right',
        ],
        'clearable'   => false,
        'inline'      => true,
        'default'     => 'left',
        'rerender' => true,
    ];

    $this->controls['split'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Split type', 'bricks' ),
        'type' => 'select',
        'options'     => [
          'chars' => 'chars',
          'words' => 'words',
          'lines' => 'lines',
      ],
        'inline' => true,
        'default' => 'chars',
    ];
    $this->controls['enterWeight'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Enter Weight', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'default' => 900,
    ];
    $this->controls['leaveWeight'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Leave Weight', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'default' => 400,
    ];
    $this->controls['skewEnter'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Skew Enter', 'bricks' ),
        'type'    => 'number',
        'unit'   => 'deg',
        'default' => -15,
    ];
    $this->controls['skewLeave'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Skew Leave', 'bricks' ),
        'type'    => 'number',
        'unit'   => 'deg',
        'default' => '0',
    ];
    $this->controls['duration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Duration', 'bricks' ),
        'type'    => 'number',
        'unit'   => 's',
        'default' => 0.2,
    ];
    $this->controls['stagger'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Stagger', 'bricks' ),
        'type'    => 'number',
        'unit'   => 's',
        'default' => 0.02,
    ];
    $this->controls['ease'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
            'none' => 'none',
            'power1' => 'power1',
            'power2' => 'power2',
            'power3' => 'power3',
            'power4' => 'power4',
            'back' => 'back',
            'bounce' => 'bounce',
            'circ' => 'circ',
            'elastic' => 'elastic',
            'expo' => 'expo',
            'sine' => 'sine',
            'steps' => 'steps',
            'custom' => 'custom'
        ],
        'inline' => true,
        'clearable' => false,
        'default' => 'none',
    ];
    $this->controls['customEase'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'ease', '=', 'custom' ],
    ];



  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'next-variable-font-hover', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_variable_font_hover.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : '';
    $enterWeight = ! empty( $settings['enterWeight'] ) ? $settings['enterWeight'] : 900;
    $leaveWeight = ! empty( $settings['leaveWeight'] ) ? $settings['leaveWeight'] : 400;
    $skewEnter = ! empty( $settings['skewEnter'] ) ? $settings['skewEnter'] : -15;
    $skewLeave = ! empty( $settings['skewLeave'] ) ? $settings['skewLeave'] : 0;
    $duration = ! empty( $settings['duration'] ) ? $settings['duration'] : 0.2;
    $stagger = ! empty( $settings['stagger'] ) ? $settings['stagger'] : 0.02;
    $direction = ! empty( $settings['direction'] ) ? $settings['direction'] : 'left';
    $ease = ! empty( $settings['ease'] ) ? $settings['ease'] : 'none';
    if ($ease === 'custom') {
      $ease = ! empty( $settings['customEase'] ) ? $settings['customEase'] : 'none';
    }
    $split = ! empty( $settings['split'] ) ? $settings['split'] : 'chars';

    $this->set_attribute( '_root', 'class', 'next-variable-font-hover' );
    $this->set_attribute( '_inner', 'class', 'next-variable-font-hover__text' );


    if ( ! empty( $settings['link'] ) ) {
        $this->set_link_attributes( '_link', $settings['link'] );
        $output ="
        <{$this->tag} {$this->render_attributes( '_root' )}>
            <a class='next-variable-font-hover__anchor' {$this->render_attributes( '_link' )}>
                <span {$this->render_attributes( '_inner' )}
                data-enter-weight=\"$enterWeight\"
                data-leave-weight=\"$leaveWeight\"
                data-skew-enter=\"$skewEnter\"
                data-skew-leave=\"$skewLeave\"
                data-duration=\"$duration\"
                data-stagger-each=\"$stagger\"
                data-direction=\"$direction\"
                data-ease=\"$ease\"
                data-split-type=\"$split\">$inner_title</span>
            </a>
        </{$this->tag}>
        ";
    }else{
        $output ="
        <{$this->tag} {$this->render_attributes( '_root' )}>
            <span {$this->render_attributes( '_inner' )}
            data-enter-weight=\"$enterWeight\"
            data-leave-weight=\"$leaveWeight\"
            data-skew-enter=\"$skewEnter\"
            data-skew-leave=\"$skewLeave\"
            data-duration=\"$duration\"
            data-stagger-each=\"$stagger\"
            data-direction=\"$direction\"
            data-ease=\"$ease\"
            data-split-type=\"$split\">$inner_title</span>
        </{$this->tag}>
        ";
    }

    echo $output;
  }
}

