<?php

namespace NextBricks;

class Initialize {
	public function __construct() {
        // Initialize the SureCart client
        if ( ! class_exists( 'SureCart\NextBricksLicensing\Client' ) ) {
            require_once NEXTBRICKS_PLUGIN_DIR . '/licensing/src/Client.php';
        }

        $client = new \SureCart\NextBricksLicensing\Client( 'brickscore', 'pt_v7YkTVRoVwrLbHWKCb97fp2X', NEXTBRICKS_FILE);
        
        // Add the license & front-end settings page.
        $client->settings()->add_page(
            [
            'type'                 => 'submenu',
            'parent_slug'          => 'Next Bricks',
            'page_title'           => 'Next Bricks',
            'menu_title'           => 'Next Bricks',
            'capability'           => 'manage_options',
            'menu_slug'            => 'nextbricks',
            'icon_url'             => '',
            'position'             => null,
            'parent_slug'          => 'bricks',
            ]
        );

        add_action('plugins_loaded', array($this, 'wp_load_nextbricks'));
        add_filter('plugin_action_links_' . NEXTBRICKS_FILE_NAME, array($this, 'nextbricks_settings_link'));        
	}

    public static function wp_load_nextbricks() {
        $activate_nextbricks = get_option('activate_brickscore');
    
        if (($activate_nextbricks == true && self::is_bricks_theme_active())) {
            require_once 'elements.php';
            new NextBricks_Elements();
        }
    }
    
    // Next Bricks settings link at plugins
    public static function nextbricks_settings_link( $links ) {
        $links[] = '<a href="' . admin_url( 'admin.php?page=nextbricks' ) . '">' . __('Settings') . '</a>';
        return $links;
    }
    
    // Check if Bricks parent theme or Bricks child theme are active
    public static function is_bricks_theme_active() {
        $theme = wp_get_theme();
        $theme_folder = basename($theme->get_stylesheet_directory());
        $parent_theme_folder = basename($theme->get_template_directory());
    
        if ($theme_folder === 'bricks' || $parent_theme_folder === 'bricks' || strpos($theme_folder, 'brick') !== false || strpos($parent_theme_folder, 'brick') !== false) {
            return true;
        }
        return false;
    }
}