<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_3DSwap_Title extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = '3d-swap-title';
  public $icon         = 'ti-text';
  public $tag      = 'h3';
  public $css_selector = '';
  public $scripts      = ['threed_swap_title'];

  public function get_label() {
    return esc_html__( '3D Swap Hover', 'bricks' );
  }

  public function set_control_groups() {
    $this->control_groups['gradient'] = [
      'title' => esc_html__( 'Gradient', 'bricks' ),
      'tab'   => 'content',
    ];
  }

  public function set_controls() {
    $this->controls['inner_title'] = [
      'tab'            => 'content',
      'type'           => 'text',
	    'hasDynamicData' => 'text',
      'default'        => esc_html__( '3D Swap Hover', 'bricks' ),
      'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'h1' => 'h1',
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
            'p' => 'p',
            'span' => 'span',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'h3',
        'default'     => 'h3',
    ];
    $this->controls['customTag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Custom tag', 'bricks' ),
			'type'        => 'text',
			'inline'      => true,
			'placeholder' => 'h3',
			'required'    => [ 'tag', '=', 'custom' ],
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];
    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['titleTypography'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Typography', 'bricks' ),
      'type'    => 'typography',
            'css'     => [
        [
          'property' => 'typography',
          'selector' => '',
        ],
      ],
      'default' => [
        'line-height' => '1',
      ],
  ];
    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['stagger'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Stagger', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'placeholder' => '0.08',
    ];
    $this->controls['duration'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'placeholder' => '0.7s',
    ];
    $this->controls['ease'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
          'none' => 'none',
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'custom' => 'custom'
        ],
        'inline' => true,
        'placeholder' => 'power3',
    ];
    $this->controls['customEase'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'ease', '=', 'custom' ],
    ];


    //Gradient
    $this->controls['titleGradient'] = [
      'group' => 'gradient',
      'tab' => 'content',
      'type' => 'gradient',
      'css' => [
        [
          'property' => 'background-image',
          'selector' => '.char',
        ],
      ],
      'default' => [
        'applyTo' => 'background',
        'gradientType' => 'linear',
        'colors' => [],
        'angle' => '0',
      ],
    ];

    //Padding from style tab applied to the root without link and to the link if exists
    $this->controls['_padding'] = [
      'tab'   => 'style',
      'group' => '_layout',
      'label' => esc_html__( 'Padding', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'padding',
          'selector' => '&:not(:has(> a)), > a',
        ]
      ],
      'default' => [
        'top'    => 0,
        'right'  => 0,
        'bottom' => 0,
        'left'   => 0,
      ],
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'bc_threed_swap_title', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_3d_swap_title.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';
    $stagger    = ! empty( $settings['stagger'] ) ? $settings['stagger'] : 0.08;
    $duration    = ! empty( $settings['duration'] ) ? $settings['duration'] : 0.7;
    $ease    = ! empty( $settings['ease'] ) ? $settings['ease'] : 'power3';
    if ($ease === 'custom') {
      $ease = ! empty( $settings['customEase'] ) ? $settings['customEase'] : 'power3';
    }

    $this->set_attribute( '_root', 'class', 'bc-3dswap-title' );
    $this->set_attribute( '_root', 'bc-3dswap-title-hide', '' );
    $this->set_attribute( '_root', 'data-stagger', $stagger );
    $this->set_attribute( '_root', 'data-duration', $duration );
    $this->set_attribute( '_root', 'data-ease', $ease );

    if ( ! empty( $settings['link'] ) ) {
			$this->set_link_attributes( '_link', $settings['link'] );
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <a class='bc-3dswap-title__anchor' {$this->render_attributes( '_link' )}>
          <span class='bc-3dswap-title__inner-wrapper'>
            <span class='bc-3dswap-title__title bc-3dswap-title__title--front'>$inner_title</span>
            <span class='bc-3dswap-title__title bc-3dswap-title__title--back'>$inner_title</span>
          </span>
        </a>
      </{$this->tag}>
      ";
		}else{
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <span class='bc-3dswap-title__inner-wrapper'>
          <span class='bc-3dswap-title__title bc-3dswap-title__title--front'>$inner_title</span>
          <span class='bc-3dswap-title__title bc-3dswap-title__title--back'>$inner_title</span>
        </span>
      </{$this->tag}>
      ";
    }

		echo $output;
  }
}
