<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class B_3DHover extends \Bricks\Element {
  public $category     = 'Next Bricks - Cores';
  public $name         = '3dhover';
  public $icon         = 'ti-layout-media-right-alt';
  public $scripts      = ['threedhover'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Parallax Hover', 'bricks' );
  }

  public function set_controls() {
    $this->controls['alwaysActive'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Always Active', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => false,
    ];
    $this->controls['offset'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Offset', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'small' => true,
      'placeholder' => 50,
    ];
    $this->controls['duration'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Duration', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'small' => true,
      'placeholder' => 300,
    ];

    /*Rotate*/
    $this->controls['rotateSeparator'] = [
			'label'      => esc_html__( 'Rotate', 'bricks' ),
			'type'       => 'separator',
		];
    $this->controls['rotate'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Enable rotate', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => true,
    ];
    $this->controls['rotatetouch'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Enable rotate touch', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => true,
    ];
    $this->controls['rotateXMax'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Max X', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'small' => true,
      'placeholder' => 15,
    ];
    $this->controls['rotateYMax'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Max Y', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'small' => true,
      'placeholder' => 15,
    ];
    $this->controls['rotateXInvert'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Invert X', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => false,
    ];
    $this->controls['rotateYInvert'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Invert Y', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => false,
    ];

    /*Stretch*/
    $this->controls['stretchSeparator'] = [
			'label'      => esc_html__( 'Stretch', 'bricks' ),
			'type'       => 'separator',
		];
    $this->controls['stretchX'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'X axis', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'small' => true,
      'placeholder' => 0,
    ];
    $this->controls['stretchY'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Y axis', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'small' => true,
      'placeholder' => 0,
    ];
    $this->controls['stretchZ'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Z axis', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'small' => true,
      'placeholder' => 0,
    ];

    /*Shadow*/
    $this->controls['shadowSeparator'] = [
			'label'      => esc_html__( 'Shadow', 'bricks' ),
			'type'       => 'separator',
		];
    $this->controls['shadow'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Enable shadow', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => true,
    ];
    $this->controls['shadowOffset'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Offset', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'small' => true,
      'placeholder' => 50,
    ];
    $this->controls['shadowScale'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Scale', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'small' => true,
      'placeholder' => 1,
    ];
    $this->controls['highlight'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Highlight', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => true,
    ];
  }

  /*Render sliders & children*/
public function get_nestable_item() {
  return [
      'name'     => '3dhoverchild',
      'settings' => [
        '_hidden' => [
            '_cssClasses' => 'bc-parallax-hover__wrapper',
        ],
    ],
    'children' => [
      [
        'name'     => 'marqueebutton',
      ],
      [
        'name'     => 'text-basic',
        'label'    => esc_html__( 'Paragraph', 'bricks' ),
        'settings' => [
            'text' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. In id ipsum velit. Pellentesque faucibus magna arcu, et laoreet ligula lobortis eu. Interdum et malesuada fames ac ante ipsum primis in faucibus', 'bricks' ),
            'tag'  => 'p',
            '_hidden' => [
                '_cssClasses' => 'bc-parallax-hover__heading',
            ],
        ],
      ],
    ],
  ];
}

public function get_nestable_children() {
  $children = [];

  for ( $i = 0; $i < 1; $i++ ) { /*Cantidad de item a generar*/
      $item = $this->get_nestable_item();

      // Replace {item_index} with $index
      $item       = json_encode( $item );
      $item       = str_replace( '{item_index}', $i + 1, $item );
      $item       = json_decode( $item, true );
      $children[] = $item;
  }

  return $children;
}

  public function enqueue_scripts() {
    wp_enqueue_style( 'atropos-css', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_atropos.min.css', array(), NEXTBRICKS_VERSION, false);
    wp_enqueue_script( 'atropos-js', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_atropos.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);

    wp_enqueue_script( '3dhover-js', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_3dhover.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    /*Default*/
    $offset = ! empty( $settings['offset'] ) ? $settings['offset'] : 50;
    $alwaysActive = ! empty( $settings['alwaysActive'] ) ? $settings['alwaysActive'] : false;
    $duration = ! empty( $settings['duration'] ) ? $settings['duration'] : 300;
    /*Rotate*/
    $rotate = ! empty( $settings['rotate'] ) ? $settings['rotate'] : false;
    $rotatetouch = ! empty( $settings['rotatetouch'] ) ? $settings['rotatetouch'] : false;
    $rotateXMax = ! empty( $settings['rotateXMax'] ) ? $settings['rotateXMax'] : 15;
    $rotateYMax = ! empty( $settings['rotateYMax'] ) ? $settings['rotateYMax'] : 15;
    $rotateXInvert = ! empty( $settings['rotateXInvert'] ) ? $settings['rotateXInvert'] : false;
    $rotateYInvert = ! empty( $settings['rotateYInvert'] ) ? $settings['rotateYInvert'] : false;
    /*Stretch*/
    $stretchX = ! empty( $settings['stretchX'] ) ? $settings['stretchX'] : 0;
    $stretchY = ! empty( $settings['stretchY'] ) ? $settings['stretchY'] : 0;
    $stretchZ = ! empty( $settings['stretchZ'] ) ? $settings['stretchZ'] : 0;
    /*Shadow*/
    $shadow = ! empty( $settings['shadow'] ) ? $settings['shadow'] : false;
    $shadowOffset = ! empty( $settings['shadowOffset'] ) ? $settings['shadowOffset'] : 50;
    $shadowScale = ! empty( $settings['shadowScale'] ) ? $settings['shadowScale'] : 1;
    $highlight = ! empty( $settings['highlight'] ) ? $settings['highlight'] : false;


    $this->set_attribute( '_root', 'class', "atropos-inner"); /*el root es atropos-inner que es el que tiene que recibir los estilos del tab "STYLE"*/
    $output = "<div class='atropos bc-parallax-hover'
    data-offset=\"$offset\"
    data-alwaysActive=\"$alwaysActive\"
    data-duration=\"$duration\"
    data-rotate=\"$rotate\"
    data-rotatetouch=\"$rotatetouch\"
    data-rotateXMax=\"$rotateXMax\"
    data-rotateYMax=\"$rotateYMax\"
    data-rotateXInvert=\"$rotateXInvert\"
    data-rotateYInvert=\"$rotateYInvert\"
    data-stretchX=\"$stretchX\"
    data-stretchY=\"$stretchY\"
    data-stretchZ=\"$stretchZ\"
    data-shadow=\"$shadow\"
    data-shadowOffset=\"$shadowOffset\"
    data-shadowScale=\"$shadowScale\"
    data-highlight=\"$highlight\">

      <div class='atropos-scale'>
        <div class='atropos-rotate'>
          <div {$this->render_attributes( '_root' )}>";
            $output .= \Bricks\Frontend::render_children( $this );
          $output .= "</div>
        </div>
      </div>

    </div>";

  echo $output;
  }
}