<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Bubble extends \Bricks\Element {
    public $name         = 'bubble';
    public $icon         = 'fa-solid fa-circle';
    public $scripts      = ['bubbles'];

    public function get_label() {
        return esc_html__( 'Bubble', 'bricks' );
    }

    public function set_controls() {
        $this->controls['top'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Top', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
              [
                  'property' => 'top',
                  'selector' => '',
              ],
            ],
        ];
        $this->controls['left'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Left', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
              [
                  'property' => 'left',
                  'selector' => '',
              ],
            ],
        ];
        $this->controls['Bubbledimensions'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Dimensions', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
              [
                  'property' => '--circle-size',
                  'selector' => '',
              ],
            ],
            'placeholder' => '80%',
        ];
        $this->controls['BubblebubbleBackground'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type'  => 'color',
            'inline' => true,
            'css'     => [
              [
                  'property' => '--inner-background',
                  'selector' => '',
              ],
            ],
        ];
        $this->controls['Bubbleblendmode'] = [
			'tab'     => 'content',
			'label'   => 'Mix blend mode',
			'type'    => 'select',
			'inline'  => true,
			'options' => Setup::$control_options['blendMode'],
			'css'     => [
				[
					'property' => '--blending',
                    'selector' => '',
				]
			],
            'placeholder' => 'hard-light',
		];
        

        $this->controls['Bubbleanimationseparator'] = [
            'label'      => esc_html__( 'Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['Bubbletype'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Type', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'vertical' => 'Vertical',
                'horizontal' => 'Horizontal',
                'incircle1' => 'Rotating--1',
                'incircle2' => 'Rotating--2',
                'incircle3' => 'Rotating--3',
            ],
            'inline' => true,
        ];
        $this->controls['Bubblespeed'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Speed', 'bricks' ),
            'type'     => 'number',
            'unit' => 's',
            'inline' => true,
			'css'     => [
				[
					'property' => '--speed',
                    'selector' => '',
				]
			],
            'placeholder' => '40',
        ];
    }
    
    public function render() {
        $settings = $this->settings;
        $type = ! empty( $settings['Bubbletype'] ) ? $settings['Bubbletype'] : '';

        $this->set_attribute( '_root', 'class', "bc-bubbles__bubble");

        $dataTypeAttribute = $type ? "data-type=\"$type\"" : '';

        $output = "<div {$this->render_attributes( '_root' )} $dataTypeAttribute>";
        $output .= "</div>";

        echo $output;
    }
}