<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Bubbles_Wrapper extends \Bricks\Element {
    public $name         = 'bubbles_wrapper';
    public $icon         = 'fa-brands fa-medium fa-rotate-90';
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Bubbles Wrapper', 'bricks' );
    }

    public function set_controls() {
        $this->controls['_children'] = [
          'type'          => 'repeater',
          'titleProperty' => 'label',
          'items'         => 'children',
        ];
    }

    public function render() {
        $settings = $this->settings;

        $this->set_attribute( '_root', 'class', "bc-bubbles__wrapper");

        $output = "
        <div {$this->render_attributes( '_root' )}>";
            $output .= \Bricks\Frontend::render_children( $this );
            $output .= "<div class='bc-bubbles__bubble bc-bubbles__bubble--cursor'></div>";
        $output .= "</div>";

        echo $output;
    }
}