<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Codepen extends \Bricks\Element {
  public $category     = 'Next Bricks - Cores';
  public $name         = 'bc_codepen';
  public $icon         = 'fa-brands fa-codepen';
  public $scripts      = ['bc_codepen'];

  public function get_label() {
    return esc_html__( 'Codepen', 'bricks' );
  }

  public function set_controls() {
    $this->controls['url'] = [
        'hasDynamicData' => true,
        'tab' => 'content',
        'label' => esc_html__( 'Codepen URL', 'bricks' ),
        'type' => 'text',
        'placeholder' => 'https://codepen.io/bartveneman/pen/xxBMWgO',
    ];
    $this->controls['defaulttab'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Default tab', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'html,result' => 'HTML and Result',
            'css,result' => 'CSS and Result',
            'js,result' => 'JS and Result',
            'html,css' => 'HTML and CSS',
            'html,js' => 'HTML and JS',
            'css,js' => 'CSS and JS',
            'result' => 'only Result',
            'html' => 'only HTML',
            'css' => 'only CSS',
            'js' => 'only JS',
        ],
        'inline'      => true,
        'placeholder' => 'HTML and Result',
    ];
    $this->controls['editable'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Editable', 'bricks' ),
        'type'     => 'checkbox',
    ];
    $this->controls['preview'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Preview', 'bricks' ),
        'type'     => 'checkbox',
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];

    $this->controls['note'] = [
        'tab' => 'content',
        'description' => sprintf(html_entity_decode(esc_html__( 'There are 3 built-in themes: default, light and dark. In addition, you can set a theme by its number. e.g: 31205', 'bricks' )))
    ];
    $this->controls['theme'] = [
        'hasDynamicData' => true,
        'tab' => 'content',
        'label' => esc_html__( 'Theme', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'default',
    ];
    $this->controls['zoom'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Default zoom', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            '0.25' => '0.25',
            '0.5' => '0.5',
            '1' => '1',
        ],
        'inline'      => true,
        'placeholder' => '0.5',
    ];
    $this->controls['height'] = [
        'hasDynamicData' => true,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '300',
    ];
    $this->controls['width'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type' => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'width',
            'selector' => '',
          ]
        ],
        'placeholder' => '100%',
        'default' => '100%',
    ];
  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'bc-codepen-script', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_codepen_script.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    wp_enqueue_script( 'bc-codepen', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_codepen.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $url = ! empty( $settings['url'] ) ? $settings['url'] : 'https://codepen.io/bartveneman/pen/xxBMWgO';
    $theme = ! empty( $settings['theme'] ) ? $settings['theme'] : 'default';
    $defaulttab = ! empty( $settings['defaulttab'] ) ? $settings['defaulttab'] : 'html,result';
    $editable = ! empty( $settings['editable'] ) ? $settings['editable'] : 0;
    if($editable == '1'){$editableaux = 'true';}else{$editableaux = 'false';}
    $preview = ! empty( $settings['preview'] ) ? $settings['preview'] : 0;
    if($preview == '1'){$previewaux = 'true';}else{$previewaux = 'none';}

    //Get username and hash from given URL
    $path = parse_url($url, PHP_URL_PATH);
    $parts = explode('/', $path);
    $lastValue = end($parts);
    $antepenultimateValue = isset($parts[count($parts) - 3]) ? $parts[count($parts) - 3] : null;
    $username = $antepenultimateValue;
    $slugHash = $lastValue;

    $height = ! empty( $settings['height'] ) ? $settings['height'] : '300';
    $zoom = ! empty( $settings['zoom'] ) ? $settings['zoom'] : '0.5';

    $is_builder = bricks_is_builder();

    $this->set_attribute( '_root', 'class', 'bc-codepen' );

    if ( ! $is_builder ) {
      $this->set_attribute( '_root', 'bc-codepen--to-hide', '' );
    }
    $this->set_attribute( '_inner', 'class', 'bc-codepen__pen' );

    $output = "<div {$this->render_attributes( '_root' )}>";
    $output .= "<div {$this->render_attributes( '_inner' )}
    data-default-tab=\"$defaulttab\"
    data-editable=\"$editableaux\"
    data-preview=\"$previewaux\"
    data-slug-hash=\"$slugHash\"
    data-user=\"$username\"
    data-theme-id=\"$theme\"
    data-height=\"$height\"
    data-zoom=\"$zoom\"></div>";
    $output .= "</div>";

	echo $output;
  }
}
