<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Nightmode extends \Bricks\Element {
  public $category     = 'Next Bricks - Cores';
  public $name         = 'nightmode';
  public $icon         = 'fa-solid fa-toggle-off';
  public $scripts      = ['nightmode'];

  public function get_label() {
    return esc_html__( 'Dark Mode', 'bricks' );
  }

  public function set_controls() {
    $this->controls['note'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'NOTE: <br>Color changes can only be visible on the front.', 'bricks' )))
    ];

    //Style
    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Toggle Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['type'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Type', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'classic' => 'classic',
            'inner-moon' => 'inner moon',
            'expand' => 'expand',
            'within' => 'within',
            'around' => 'around',
            'simple' => 'simple',
            'horizon' => 'horizon',
            'eclipse' => 'eclipse',
            'lightbulb' => 'lightbulb',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'classic',
    ];
    $this->controls['reversed'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Reverse icon', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => false,
  ];
    $this->controls['size'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Size', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'css' => [
            [
              'property' => 'font-size',
              'selector' => '.theme-toggle',
            ]
        ],
        'inline'      => true,
        'placeholder' => '32px',
      'default' => '32px',
    ];
    $this->controls['fill'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Light icon color', 'bricks' ),
        'type'        => 'color',
        'inline'      => true,
        'css' => [
            [
              'property' => 'color',
              'selector' => '.theme-toggle',
            ]
        ],
      'default' => [
        'hex' => '#000000',
      ],
    ];
    $this->controls['filltoggle'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Dark icon color', 'bricks' ),
        'type'        => 'color',
        'inline'      => true,
        'css' => [
            [
              'property' => 'color',
              'selector' => '.theme-toggle--toggled',
            ]
        ],
      'default' => [
        'hex' => '#000000',
      ],
    ];

    //Animation
    $this->controls['animationSeparator'] = [
      'label'      => esc_html__( 'Animation', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['duration'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Toggle switch duration', 'bricks' ),
      'type' => 'number',
      'unit' => 's',
      'css' => [
          [
            'property' => '--duration',
            'selector' => '.theme-toggle',
          ]
      ],
      'inline'      => true,
      'placeholder' => '1s',
  ];
  $this->controls['transitionduration'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Color changes duration', 'bricks' ),
      'type' => 'number',
      'unit' => 's',
      'inline'      => true,
      'placeholder' => '0.5s',
  ];

  //Color changes
    $this->controls['colorChangesSeparator'] = [
      'label'      => esc_html__( 'Color Changes', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['noteColors'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Light mode is set as default.<br>In order of preference, a theme switch is produced when the user toggles the icon, when the user has previously selected Light or Dark mode at your site or when the user has Light or Dark mode at the browser.', 'bricks' )))
    ];
    $this->controls['toggled'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Set Dark mode as default', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => false,
    ];
    $this->controls['nightmodecolors'] = [
        'tab'           => 'content',
        'type'          => 'repeater',
        'label'         => esc_html__( 'Colors', 'bricks' ),
        'placeholder'   => esc_html__( 'Color change', 'bricks' ),
        'titleProperty' => 'title',
        'fields'        => [
          'fromcolor'       => [
            'type'    => 'color',
            'label'   => esc_html__( 'From color', 'bricks' ),
            'inline'      => true,
          ],
          'tocolor'       => [
            'type'    => 'color',
            'label'   => esc_html__( 'To color', 'bricks' ),
            'inline'      => true,
          ],

        ],
    ];
    $this->controls['nightmodebackgrounds'] = [
        'tab'           => 'content',
        'type'          => 'repeater',
        'label'         => esc_html__( 'Backgrounds', 'bricks' ),
        'placeholder'   => esc_html__( 'Background change', 'bricks' ),
        'titleProperty' => 'title',
        'fields'        => [
          'frombackground'       => [
            'type'    => 'color',
            'label'   => esc_html__( 'From background', 'bricks' ),
            'inline'      => true,
          ],
          'tobackground'       => [
            'type'    => 'color',
            'label'   => esc_html__( 'To background', 'bricks' ),
            'inline'      => true,
          ],

        ],
    ];
    $this->controls['nightmodeborders'] = [
      'tab'           => 'content',
      'type'          => 'repeater',
      'label'         => esc_html__( 'Border colors', 'bricks' ),
      'placeholder'   => esc_html__( 'Border color change', 'bricks' ),
      'titleProperty' => 'title',
      'fields'        => [
        'fromborder'       => [
          'type'    => 'color',
          'label'   => esc_html__( 'From border color', 'bricks' ),
          'inline'      => true,
        ],
        'toborder'       => [
          'type'    => 'color',
          'label'   => esc_html__( 'To border color', 'bricks' ),
          'inline'      => true,
        ],
      ],
    ];
    $this->controls['nightmodestrokes'] = [
      'tab'           => 'content',
      'type'          => 'repeater',
      'label'         => esc_html__( 'Stroke colors', 'bricks' ),
      'placeholder'   => esc_html__( 'Stroke color change', 'bricks' ),
      'titleProperty' => 'title',
      'fields'        => [
        'fromstroke'       => [
          'type'    => 'color',
          'label'   => esc_html__( 'From stroke color', 'bricks' ),
          'inline'      => true,
        ],
        'tostroke'       => [
          'type'    => 'color',
          'label'   => esc_html__( 'To stroke color', 'bricks' ),
          'inline'      => true,
        ],
      ],
    ];
    $this->controls['nightmodefills'] = [
      'tab'           => 'content',
      'type'          => 'repeater',
      'label'         => esc_html__( 'Fill colors', 'bricks' ),
      'placeholder'   => esc_html__( 'Fill color change', 'bricks' ),
      'titleProperty' => 'title',
      'fields'        => [
        'fromfill'       => [
          'type'    => 'color',
          'label'   => esc_html__( 'From fill color', 'bricks' ),
          'inline'      => true,
        ],
        'tofill'       => [
          'type'    => 'color',
          'label'   => esc_html__( 'To fill color', 'bricks' ),
          'inline'      => true,
        ],
      ],
    ];
  }


  public function enqueue_scripts() {
    $settings = $this->settings;
    $type    = ! empty( $settings['type'] ) ? $settings['type'] : 'classic';

    if($type == 'classic'){
      wp_enqueue_style( 'classic-css', NEXTBRICKS_PLUGIN_URL . 'local_assets/darkmode/bc_classic.min.css', array(), NEXTBRICKS_VERSION, false);
    }
    if($type == 'around'){
      wp_enqueue_style( 'around-css', NEXTBRICKS_PLUGIN_URL . 'local_assets/darkmode/bc_around.min.css', array(), NEXTBRICKS_VERSION, false);
    }
    if($type == 'eclipse'){
      wp_enqueue_style( 'eclipse-css', NEXTBRICKS_PLUGIN_URL . 'local_assets/darkmode/bc_eclipse.min.css', array(), NEXTBRICKS_VERSION, false);
    }
    if($type == 'expand'){
      wp_enqueue_style( 'expand-css', NEXTBRICKS_PLUGIN_URL . 'local_assets/darkmode/bc_expand.min.css', array(), NEXTBRICKS_VERSION, false);
    }
    if($type == 'horizon'){
      wp_enqueue_style( 'horizon-css', NEXTBRICKS_PLUGIN_URL . 'local_assets/darkmode/bc_horizon.min.css', array(), NEXTBRICKS_VERSION, false);
    }
    if($type == 'innermoon'){
      wp_enqueue_style( 'innermoon-css', NEXTBRICKS_PLUGIN_URL . 'local_assets/darkmode/bc_innermoon.min.css', array(), NEXTBRICKS_VERSION, false);
    }
    if($type == 'lightbulb'){
      wp_enqueue_style( 'lightbulb-css', NEXTBRICKS_PLUGIN_URL . 'local_assets/darkmode/bc_lightbulb.min.css', array(), NEXTBRICKS_VERSION, false);
    }
    if($type == 'simple'){
      wp_enqueue_style( 'simple-css', NEXTBRICKS_PLUGIN_URL . 'local_assets/darkmode/bc_simple.min.css', array(), NEXTBRICKS_VERSION, false);
    }
    if($type == 'within'){
      wp_enqueue_style( 'within-css', NEXTBRICKS_PLUGIN_URL . 'local_assets/darkmode/bc_within.min.css', array(), NEXTBRICKS_VERSION, false);
    }
    
    wp_enqueue_script( 'darkmode', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_dark_mode.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $type    = ! empty( $settings['type'] ) ? $settings['type'] : 'classic';
    $transitionduration    = ! empty( $settings['transitionduration'] ) ? $settings['transitionduration'] : '0.5s';

    $toggled = ! empty( $settings['toggled'] ) ? $settings['toggled'] : false;
    $reversed = ! empty( $settings['reversed'] ) ? $settings['reversed'] : false;
    $nightmodecolors = ! empty( $settings['nightmodecolors'] ) ? $settings['nightmodecolors'] : false;
    $nightmodebackgrounds = ! empty( $settings['nightmodebackgrounds'] ) ? $settings['nightmodebackgrounds'] : false;
    $nightmodeborders = ! empty( $settings['nightmodeborders'] ) ? $settings['nightmodeborders'] : false;
    $nightmodeborders = ! empty( $settings['nightmodeborders'] ) ? $settings['nightmodeborders'] : false;
    $nightmodestrokes = ! empty( $settings['nightmodestrokes'] ) ? $settings['nightmodestrokes'] : false;
    $nightmodefills = ! empty( $settings['nightmodefills'] ) ? $settings['nightmodefills'] : false;

    $this->set_attribute( '_root', 'class', 'bc-dark-mode' );

    $themeToggleClasses = 'theme-toggle';
    if ($toggled) {
        $themeToggleClasses .= ' theme-toggle--toggled';
    }
    if ($reversed) {
        $themeToggleClasses .= ' theme-toggle--reversed';
    }

    $output = "<div {$this->render_attributes( '_root' )}
data-transitionduration=\"$transitionduration\">";

    switch ($type) {
        case 'classic':
            $output .= "
            <div class='$themeToggleClasses'>
            <svg
              xmlns='http://www.w3.org/2000/svg'
              aria-hidden='true'
              width='1em'
              height='1em'
              fill='currentColor'
              stroke-linecap='round'
              class='theme-toggle__classic'
              viewBox='0 0 32 32'
            >
              <clipPath id='theme-toggle__classic__cutout'>
                <path d='M0-5h30a1 1 0 0 0 9 13v24H0Z' />
              </clipPath>
              <g clip-path='url(#theme-toggle__classic__cutout)'>
                <circle cx='16' cy='16' r='9.34' />
                <g stroke='currentColor' stroke-width='1.5'>
                  <path d='M16 5.5v-4' />
                  <path d='M16 30.5v-4' />
                  <path d='M1.5 16h4' />
                  <path d='M26.5 16h4' />
                  <path d='m23.4 8.6 2.8-2.8' />
                  <path d='m5.7 26.3 2.9-2.9' />
                  <path d='m5.8 5.8 2.8 2.8' />
                  <path d='m23.4 23.4 2.9 2.9' />
                </g>
              </g>
            </svg>
            </div>
            ";
            break;

        case 'inner-moon':
            $output .= "
            <div class='$themeToggleClasses'>
            <svg
              xmlns='http://www.w3.org/2000/svg'
              aria-hidden='true'
              width='1em'
              height='1em'
              fill='currentColor'
              class='theme-toggle__inner-moon'
              viewBox='0 0 32 32'
            >
              <path d='M27.5 11.5v-7h-7L16 0l-4.5 4.5h-7v7L0 16l4.5 4.5v7h7L16 32l4.5-4.5h7v-7L32 16l-4.5-4.5zM16 25.4a9.39 9.39 0 1 1 0-18.8 9.39 9.39 0 1 1 0 18.8z' />
              <circle cx='16' cy='16' r='8.1' />
            </svg>
            </div>
            ";
            break;

        case 'expand':
            $output .= "
            <div class='$themeToggleClasses'>
            <svg
              xmlns='http://www.w3.org/2000/svg'
              aria-hidden='true'
              width='1em'
              height='1em'
              fill='currentColor'
              class='theme-toggle__expand'
              viewBox='0 0 32 32'
            >
              <clipPath id='theme-toggle__expand__cutout'>
                <path d='M0-11h25a1 1 0 0017 13v30H0Z' />
              </clipPath>
              <g clip-path='url(#theme-toggle__expand__cutout)'>
                <circle cx='16' cy='16' r='8.4' />
                <path d='M18.3 3.2c0 1.3-1 2.3-2.3 2.3s-2.3-1-2.3-2.3S14.7.9 16 .9s2.3 1 2.3 2.3zm-4.6 25.6c0-1.3 1-2.3 2.3-2.3s2.3 1 2.3 2.3-1 2.3-2.3 2.3-2.3-1-2.3-2.3zm15.1-10.5c-1.3 0-2.3-1-2.3-2.3s1-2.3 2.3-2.3 2.3 1 2.3 2.3-1 2.3-2.3 2.3zM3.2 13.7c1.3 0 2.3 1 2.3 2.3s-1 2.3-2.3 2.3S.9 17.3.9 16s1-2.3 2.3-2.3zm5.8-7C9 7.9 7.9 9 6.7 9S4.4 8 4.4 6.7s1-2.3 2.3-2.3S9 5.4 9 6.7zm16.3 21c-1.3 0-2.3-1-2.3-2.3s1-2.3 2.3-2.3 2.3 1 2.3 2.3-1 2.3-2.3 2.3zm2.4-21c0 1.3-1 2.3-2.3 2.3S23 7.9 23 6.7s1-2.3 2.3-2.3 2.4 1 2.4 2.3zM6.7 23C8 23 9 24 9 25.3s-1 2.3-2.3 2.3-2.3-1-2.3-2.3 1-2.3 2.3-2.3z' />
              </g>
            </svg>
            </div>
            ";
            break;

        case 'within':
            $output .= "
            <div class='$themeToggleClasses'>
            <svg
              xmlns='http://www.w3.org/2000/svg'
              aria-hidden='true'
              class='theme-toggle__within'
              height='1em'
              width='1em'
              viewBox='0 0 32 32'
              fill='currentColor'
            >
              <clipPath id='theme-toggle__within__clip'>
                <path d='M0 0h32v32h-32ZM6 16A1 1 0 0026 16 1 1 0 006 16' />
              </clipPath>
              <g clip-path='url(#theme-toggle__within__clip)'>
                <path d='M30.7 21.3 27.1 16l3.7-5.3c.4-.5.1-1.3-.6-1.4l-6.3-1.1-1.1-6.3c-.1-.6-.8-.9-1.4-.6L16 5l-5.4-3.7c-.5-.4-1.3-.1-1.4.6l-1 6.3-6.4 1.1c-.6.1-.9.9-.6 1.3L4.9 16l-3.7 5.3c-.4.5-.1 1.3.6 1.4l6.3 1.1 1.1 6.3c.1.6.8.9 1.4.6l5.3-3.7 5.3 3.7c.5.4 1.3.1 1.4-.6l1.1-6.3 6.3-1.1c.8-.1 1.1-.8.7-1.4zM16 25.1c-5.1 0-9.1-4.1-9.1-9.1 0-5.1 4.1-9.1 9.1-9.1s9.1 4.1 9.1 9.1c0 5.1-4 9.1-9.1 9.1z' />
              </g>
              <path
                class='theme-toggle__within__circle'
                d='M16 7.7c-4.6 0-8.2 3.7-8.2 8.2s3.6 8.4 8.2 8.4 8.2-3.7 8.2-8.2-3.6-8.4-8.2-8.4zm0 14.4c-3.4 0-6.1-2.9-6.1-6.2s2.7-6.1 6.1-6.1c3.4 0 6.1 2.9 6.1 6.2s-2.7 6.1-6.1 6.1z'
              />
              <path
                class='theme-toggle__within__inner'
                d='M16 9.5c-3.6 0-6.4 2.9-6.4 6.4s2.8 6.5 6.4 6.5 6.4-2.9 6.4-6.4-2.8-6.5-6.4-6.5z'
              />
            </svg>
            </div>
            ";
            break;

        case 'around':
            $output .= "
            <div class='$themeToggleClasses'>
            <svg
              xmlns='http://www.w3.org/2000/svg'
              aria-hidden='true'
              width='1em'
              height='1em'
              fill='currentColor'
              class='theme-toggle__around'
              viewBox='0 0 32 32'
            >
              <clipPath id='theme-toggle__around__cutout'>
                <path d='M0 0h42v30a1 1 0 00-16 13H0Z' />
              </clipPath>
              <g clip-path='url(#theme-toggle__around__cutout)'>
                <circle cx='16' cy='16' r='8.4' />
                <g>
                  <circle cx='16' cy='3.3' r='2.3' />
                  <circle cx='27' cy='9.7' r='2.3' />
                  <circle cx='27' cy='22.3' r='2.3' />
                  <circle cx='16' cy='28.7' r='2.3' />
                  <circle cx='5' cy='22.3' r='2.3' />
                  <circle cx='5' cy='9.7' r='2.3' />
                </g>
              </g>
            </svg>
            </div>
            ";
            break;

        case 'simple':
            $output .= "
            <div class='$themeToggleClasses'>
            <svg
              xmlns='http://www.w3.org/2000/svg'
              aria-hidden='true'
              width='1em'
              height='1em'
              class='theme-toggle__simple'
              fill='currentColor'
              viewBox='0 0 32 32'
            >
              <clipPath id='theme-toggle__simple__cutout'>
                <path d='M0-5h55v37h-55zm32 12a1 1 0 0025 0 1 1 0 00-25 0' />
              </clipPath>
              <g clip-path='url(#theme-toggle__simple__cutout)'>
                <circle cx='16' cy='16' r='15' />
              </g>
            </svg>
            </div>
            ";
            break;

        case 'horizon':
            $output .= "
            <div class='$themeToggleClasses'>
            <svg
              xmlns='http://www.w3.org/2000/svg'
              aria-hidden='true'
              width='1em'
              height='1em'
              fill='currentColor'
              class='theme-toggle__horizon'
              viewBox='0 0 32 32'
            >
              <clipPath id='theme-toggle__horizon__mask'>
                <path d='M0 0h32v29h-32z' />
              </clipPath>
              <path d='M30.7 29.9H1.3c-.7 0-1.3.5-1.3 1.1 0 .6.6 1 1.3 1h29.3c.7 0 1.3-.5 1.3-1.1.1-.5-.5-1-1.2-1z' />
              <g clip-path='url(#theme-toggle__horizon__mask)'>
                <path d='M16 8.8c-3.4 0-6.1 2.8-6.1 6.1s2.7 6.3 6.1 6.3 6.1-2.8 6.1-6.1-2.7-6.3-6.1-6.3zm13.3 11L26 15l3.3-4.8c.3-.5.1-1.1-.5-1.2l-5.7-1-1-5.7c-.1-.6-.8-.8-1.2-.5L16 5.1l-4.8-3.3c-.5-.4-1.2-.1-1.3.4L8.9 8 3.2 9c-.6.1-.8.8-.5 1.2L6 15l-3.3 4.8c-.3.5-.1 1.1.5 1.2l5.7 1 1 5.7c.1.6.8.8 1.2.5L16 25l4.8 3.3c.5.3 1.1.1 1.2-.5l1-5.7 5.7-1c.7-.1.9-.8.6-1.3zM16 22.5A7.6 7.6 0 0 1 8.3 15c0-4.2 3.5-7.5 7.7-7.5s7.7 3.4 7.7 7.5c0 4.2-3.4 7.5-7.7 7.5z' />
              </g>
            </svg>
            </div>
            ";
            break;

        case 'eclipse':
            $output .= "
            <div class='$themeToggleClasses'>
            <svg
              xmlns='http://www.w3.org/2000/svg'
              aria-hidden='true'
              width='1em'
              height='1em'
              class='theme-toggle__eclipse'
              fill='currentColor'
              viewBox='0 0 32 32'
            >
              <clipPath id='theme-toggle__eclipse__cutout'>
                <path d='M0 0h64v32h-64zm36 16a1 1 0 0024 1 1 1 0 00-24-1' />
              </clipPath>
              <g clip-path='url(#theme-toggle__eclipse__cutout)'>
                <circle cx='16' cy='16' r='16' />
              </g>
            </svg>
            </div>
            ";
            break;

        case 'lightbulb':
            $output .= "
            <div class='$themeToggleClasses'>
            <svg
              xmlns='http://www.w3.org/2000/svg'
              aria-hidden='true'
              width='1em'
              height='1em'
              class='theme-toggle__lightbulb'
              stroke-width='0.7'
              stroke='currentColor'
              fill='currentColor'
              stroke-linecap='round'
              viewBox='0 0 32 32'
            >
              <path
                stroke-width='0'
                d='M9.4 9.9c1.8-1.8 4.1-2.7 6.6-2.7 5.1 0 9.3 4.2 9.3 9.3 0 2.3-.8 4.4-2.3 6.1-.7.8-2 2.8-2.5 4.4 0 .2-.2.4-.5.4-.2 0-.4-.2-.4-.5v-.1c.5-1.8 2-3.9 2.7-4.8 1.4-1.5 2.1-3.5 2.1-5.6 0-4.7-3.7-8.5-8.4-8.5-2.3 0-4.4.9-5.9 2.5-1.6 1.6-2.5 3.7-2.5 6 0 2.1.7 4 2.1 5.6.8.9 2.2 2.9 2.7 4.9 0 .2-.1.5-.4.5h-.1c-.2 0-.4-.1-.4-.4-.5-1.7-1.8-3.7-2.5-4.5-1.5-1.7-2.3-3.9-2.3-6.1 0-2.3 1-4.7 2.7-6.5z'
              />
              <path d='M19.8 28.3h-7.6' />
              <path d='M19.8 29.5h-7.6' />
              <path d='M19.8 30.7h-7.6' />
              <path
                pathLength='1'
                class='theme-toggle__lightbulb__coil'
                fill='none'
                d='M14.6 27.1c0-3.4 0-6.8-.1-10.2-.2-1-1.1-1.7-2-1.7-1.2-.1-2.3 1-2.2 2.3.1 1 .9 1.9 2.1 2h7.2c1.1-.1 2-1 2.1-2 .1-1.2-1-2.3-2.2-2.3-.9 0-1.7.7-2 1.7 0 3.4 0 6.8-.1 10.2'
              />
              <g class='theme-toggle__lightbulb__rays'>
                <path pathLength='1' d='M16 6.4V1.3' />
                <path pathLength='1' d='M26.3 15.8h5.1' />
                <path pathLength='1' d='m22.6 9 3.7-3.6' />
                <path pathLength='1' d='M9.4 9 5.7 5.4' />
                <path pathLength='1' d='M5.7 15.8H.6' />
              </g>
            </svg>
            </div>
            ";
            break;

        default:
            $output .= "
            <div class='$themeToggleClasses'>
            <svg
              xmlns='http://www.w3.org/2000/svg'
              aria-hidden='true'
              width='1em'
              height='1em'
              fill='currentColor'
              stroke-linecap='round'
              class='theme-toggle__classic'
              viewBox='0 0 32 32'
            >
              <clipPath id='theme-toggle__classic__cutout'>
                <path d='M0-5h30a1 1 0 0 0 9 13v24H0Z' />
              </clipPath>
              <g clip-path='url(#theme-toggle__classic__cutout)'>
                <circle cx='16' cy='16' r='9.34' />
                <g stroke='currentColor' stroke-width='1.5'>
                  <path d='M16 5.5v-4' />
                  <path d='M16 30.5v-4' />
                  <path d='M1.5 16h4' />
                  <path d='M26.5 16h4' />
                  <path d='m23.4 8.6 2.8-2.8' />
                  <path d='m5.7 26.3 2.9-2.9' />
                  <path d='m5.8 5.8 2.8 2.8' />
                  <path d='m23.4 23.4 2.9 2.9' />
                </g>
              </g>
            </svg>
            </div>
            ";
            break;
    }

    $output .= '</div>';

	 echo $output;

    if ($nightmodecolors) {
        echo '<div class="bc-dark-mode__list--colors" data-fromcolors="';
        foreach ( $nightmodecolors as $nightmodecolor ) {
            if ( isset($nightmodecolor['fromcolor']) && is_array($nightmodecolor['fromcolor'])) {
                if (isset($nightmodecolor['fromcolor']['rgb'])) {
                  $fromcolor = $nightmodecolor['fromcolor']['rgb'];
                }else if(isset($nightmodecolor['fromcolor']['raw'])){
                  $fromcolor = $nightmodecolor['fromcolor']['raw'];
                }else if(isset($nightmodecolor['fromcolor']['hex'])){
                  $fromcolor = $nightmodecolor['fromcolor']['hex'];
                }
                echo $fromcolor . 'd4511782';
            }else{
                echo 'unset' . 'd4511782';
            }
        }
        echo '" data-tocolors="';
        foreach ( $nightmodecolors as $nightmodecolor ) {
            if ( isset($nightmodecolor['tocolor']) && is_array($nightmodecolor['tocolor'])) {
                if (isset($nightmodecolor['tocolor']['rgb'])) {
                  $tocolor = $nightmodecolor['tocolor']['rgb'];
                }else if(isset($nightmodecolor['tocolor']['raw'])){
                  $tocolor = $nightmodecolor['tocolor']['raw'];
                }else if(isset($nightmodecolor['tocolor']['hex'])){
                  $tocolor = $nightmodecolor['tocolor']['hex'];
                }
                echo $tocolor . 'd4511782';
            }else{
                echo 'unset' . 'd4511782';
            }
        }
        echo '"></div>';
    }
    if ($nightmodebackgrounds) {
        echo '<div class="bc-dark-mode__list--backgrounds" data-frombackgrounds="';
        foreach ( $nightmodebackgrounds as $nightmodebackground ) {
            if ( isset($nightmodebackground['frombackground']) && is_array($nightmodebackground['frombackground'])) {
                if (isset($nightmodebackground['frombackground']['rgb'])) {
                  $frombackground = $nightmodebackground['frombackground']['rgb'];
                }else if(isset($nightmodebackground['frombackground']['raw'])){
                  $frombackground = $nightmodebackground['frombackground']['raw'];
                }else if(isset($nightmodebackground['frombackground']['hex'])){
                  $frombackground = $nightmodebackground['frombackground']['hex'];
                }
                echo $frombackground . 'd4511782';
            }else{
                echo 'unset' . 'd4511782';
            }
        }
        echo '" data-tobackgrounds="';
        foreach ( $nightmodebackgrounds as $nightmodebackground ) {
            if ( isset($nightmodebackground['tobackground']) && is_array($nightmodebackground['tobackground'])) {
                if (isset($nightmodebackground['tobackground']['rgb'])) {
                  $tobackground = $nightmodebackground['tobackground']['rgb'];
                }else if(isset($nightmodebackground['tobackground']['raw'])){
                  $tobackground = $nightmodebackground['tobackground']['raw'];
                }else if(isset($nightmodebackground['tobackground']['hex'])){
                  $tobackground = $nightmodebackground['tobackground']['hex'];
                }
                echo $tobackground . 'd4511782';
            }else{
                echo 'unset' . 'd4511782';
            }
        }
        echo '"></div>';
    }
    if ($nightmodeborders) {
      echo '<div class="bc-dark-mode__list--borders" data-fromborders="';
      foreach ( $nightmodeborders as $nightmodeborder ) {
          if ( isset($nightmodeborder['fromborder']) && is_array($nightmodeborder['fromborder'])) {
              if (isset($nightmodeborder['fromborder']['rgb'])) {
                $fromborder = $nightmodeborder['fromborder']['rgb'];
              }else if(isset($nightmodeborder['fromborder']['raw'])){
                $fromborder = $nightmodeborder['fromborder']['raw'];
              }else if(isset($nightmodeborder['fromborder']['hex'])){
                $fromborder = $nightmodeborder['fromborder']['hex'];
              }
              echo $fromborder . 'd4511782';
          }else{
              echo 'unset' . 'd4511782';
          }
      }
      echo '" data-toborders="';
      foreach ( $nightmodeborders as $nightmodeborder ) {
          if ( isset($nightmodeborder['toborder']) && is_array($nightmodeborder['toborder'])) {
              if (isset($nightmodeborder['toborder']['rgb'])) {
                $toborder = $nightmodeborder['toborder']['rgb'];
              }else if(isset($nightmodeborder['toborder']['raw'])){
                $toborder = $nightmodeborder['toborder']['raw'];
              }else if(isset($nightmodeborder['toborder']['hex'])){
                $toborder = $nightmodeborder['toborder']['hex'];
              }
              echo $toborder . 'd4511782';
          }else{
              echo 'unset' . 'd4511782';
          }
      }
      echo '"></div>';
    }
    if ($nightmodestrokes) {
      echo '<div class="bc-dark-mode__list--strokes" data-fromstrokes="';
      foreach ( $nightmodestrokes as $nightmodestroke ) {
          if ( isset($nightmodestroke['fromstroke']) && is_array($nightmodestroke['fromstroke'])) {
              if (isset($nightmodestroke['fromstroke']['rgb'])) {
                $fromstroke = $nightmodestroke['fromstroke']['rgb'];
              }else if(isset($nightmodestroke['fromstroke']['raw'])){
                $fromstroke = $nightmodestroke['fromstroke']['raw'];
              }else if(isset($nightmodestroke['fromstroke']['hex'])){
                $fromstroke = $nightmodestroke['fromstroke']['hex'];
              }
              echo $fromstroke . 'd4511782';
          }else{
              echo 'unset' . 'd4511782';
          }
      }
      echo '" data-tostrokes="';
      foreach ( $nightmodestrokes as $nightmodestroke ) {
          if ( isset($nightmodestroke['tostroke']) && is_array($nightmodestroke['tostroke'])) {
              if (isset($nightmodestroke['tostroke']['rgb'])) {
                $tostroke = $nightmodestroke['tostroke']['rgb'];
              }else if(isset($nightmodestroke['tostroke']['raw'])){
                $tostroke = $nightmodestroke['tostroke']['raw'];
              }else if(isset($nightmodestroke['tostroke']['hex'])){
                $tostroke = $nightmodestroke['tostroke']['hex'];
              }
              echo $tostroke . 'd4511782';
          }else{
              echo 'unset' . 'd4511782';
          }
      }
      echo '"></div>';
    }
    if ($nightmodefills) {
      echo '<div class="bc-dark-mode__list--fills" data-fromfills="';
      foreach ( $nightmodefills as $nightmodefill ) {
          if ( isset($nightmodefill['fromfill']) && is_array($nightmodefill['fromfill'])) {
              if (isset($nightmodefill['fromfill']['rgb'])) {
                $fromfill = $nightmodefill['fromfill']['rgb'];
              }else if(isset($nightmodefill['fromfill']['raw'])){
                $fromfill = $nightmodefill['fromfill']['raw'];
              }else if(isset($nightmodefill['fromfill']['hex'])){
                $fromfill = $nightmodefill['fromfill']['hex'];
              }
              echo $fromfill . 'd4511782';
          }else{
              echo 'unset' . 'd4511782';
          }
      }
      echo '" data-tofills="';
      foreach ( $nightmodefills as $nightmodefill ) {
          if ( isset($nightmodefill['tofill']) && is_array($nightmodefill['tofill'])) {
              if (isset($nightmodefill['tofill']['rgb'])) {
                $tofill = $nightmodefill['tofill']['rgb'];
              }else if(isset($nightmodefill['tofill']['raw'])){
                $tofill = $nightmodefill['tofill']['raw'];
              }else if(isset($nightmodefill['tofill']['hex'])){
                $tofill = $nightmodefill['tofill']['hex'];
              }
              echo $tofill . 'd4511782';
          }else{
              echo 'unset' . 'd4511782';
          }
      }
      echo '"></div>';
    }
  }
}

