<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Expander extends Element {
  public $category     = 'Next Bricks - Cores';
  public $name         = 'expander';
  public $icon         = 'fa-solid fa-expand';
  public $tag      = 'h3';
  public $scripts      = ['bcexpander'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Expanders', 'bricks' );
  }

  public function set_controls() {
    $this->controls['schema'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Include FAQ Schema', 'bricks' ),
      'type' => 'checkbox',
  ];
    $this->controls['openatbuilder'] = [
      'hasDynamicData' => false,
      'tab'         => 'content',
      'label'       => esc_html__( 'Open all at Bricks', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'true' => 'true',
          'false' => 'false',
      ],
      'inline'      => true,
      'small'      => true,
      'placeholder' => 'true',
    ];
    $this->controls['_children'] = [
        'type'          => 'repeater',
        'titleProperty' => 'label',
        'items'         => 'children', 
    ];

    $this->controls['settingsSeparator'] = [
      'label'      => esc_html__( 'Settings', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['mode'] = [
        'hasDynamicData' => false,
        'tab'         => 'content',
        'label'       => esc_html__( 'Mode', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'click' => 'click',
            'hover' => 'hover',
        ],
        'inline'      => true,
        'small'      => true,
        'placeholder' => 'click',
    ];
    $this->controls['singleopen'] = [
        'hasDynamicData' => false,
        'tab'         => 'content',
        'label'       => esc_html__( 'Open one at a time', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'true' => 'true',
            'false' => 'false',
        ],
        'inline'      => true,
        'small'      => true,
        'placeholder' => 'true',
    ];
    $this->controls['openall'] = [
        'hasDynamicData' => false,
        'tab'         => 'content',
        'label'       => esc_html__( 'Open all by default', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'true' => 'true',
            'false' => 'false',
        ],
        'inline'      => true,
        'small'      => true,
        'placeholder' => 'false',
    ];
    $this->controls['openthis'] = [
      'hasDynamicData' => false,
      'tab'         => 'content',
      'label'       => esc_html__( 'Open this by default', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'Expander number',
    ];

    $this->controls['separatorAux'] = [
      'type'       => 'separator',
    ];
    $this->controls['note'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Customize Expanders root element styles at the Style tab, including its display settings.<br>Use the following styles controls to apply them at every Expander, Label and Content children.', 'bricks' )))
    ];
    
    /*Expander*/
    $this->controls['expanderSeparator'] = [
      'label'      => esc_html__( 'Expander Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['expanderwidth'] = [
        'inline' => true,
        'tab'     => 'content',
        'label'   => esc_html__( 'Width', 'bricks' ),
        'type'    => 'number',
        'units'    => true,
        'css'     => [
          [
            'property' => 'width',
            'selector' => '.bc-expander-container',
          ],
        ],
        'placeholder'    => '600px',
        'default' => '600px',
    ];
    $this->controls['expanderborder'] = [
        'inline' => true,
        'tab'     => 'content',
        'label'   => esc_html__( 'Border', 'bricks' ),
        'type'    => 'border',
        'css'     => [
          [
            'property' => 'border',
            'selector' => '.bc-expander-container',
          ],
        ],
    ];
    $this->controls['expanderbackground'] = [
        'inline' => true,
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'background',
        'css'     => [
          [
            'property' => 'background',
            'selector' => '.bc-expander-container',
          ],
        ],
    ];

    /*Label*/
    $this->controls['labelSeparator'] = [
      'label'      => esc_html__( 'Label Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['labeldirection'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Direction', 'bricks' ),
        'type'    => 'direction',
        'css'     => [
          [
            'property' => 'flex-direction',
            'selector' => '.bc-expander-question',
          ],
        ],
        'default' => 'row',
    ];
    $this->controls['labeljustify'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Justify content', 'bricks' ),
        'type'    => 'justify-content',
        'css'     => [
          [
            'property' => 'justify-content',
            'selector' => '.bc-expander-question',
          ],
        ],
        'default' => 'space-between',
    ];
    $this->controls['labelalign'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Align items', 'bricks' ),
        'type'    => 'align-items',
        'css'     => [
          [
            'property' => 'align-items',
            'selector' => '.bc-expander-question',
          ],
        ],
        'default' => 'center',
    ];
    $this->controls['labelgap'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Gap', 'bricks' ),
      'type'    => 'number',
      'units'    => true,
      'css'     => [
        [
          'property' => 'gap',
          'selector' => '.bc-expander-question',
        ],
      ],
      'placeholder' => ' ',
  ];
    $this->controls['labelpadding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
          [
            'property' => 'padding',
            'selector' => '.bc-expander-question',
          ],
        ],
        'default' => [
            'top' => '10px',
            'right' => '20px',
            'bottom' => '10px',
            'left' => '20px',
        ],
    ];
    $this->controls['labeltypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
          [
            'property' => 'typography',
            'selector' => '.bc-expander-question-heading',
          ],
        ],
    ];
    $this->controls['labelicontypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Icon Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
          [
            'property' => 'typography',
            'selector' => '.bc-expander-question .bc-expander-question-icon',
          ],
        ],
    ];
    $this->controls['labelrotation'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Icon Rotation', 'bricks' ),
        'type'    => 'number',
        'unit'    => 'deg',
        'css'     => [
          [
            'property' => '--rotate-degree',
            'selector' => '.bc-expander-question-icon',
          ],
        ],
        'placeholder'    => '180deg'
    ];
    $this->controls['labelicontransitionduration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Icon Transition Duration', 'bricks' ),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
          [
            'property' => '--icon-transition-duration',
            'selector' => '.bc-expander-question-icon',
          ],
        ],
        'placeholder'    => '0.2s'
    ];

    /*Content*/
    $this->controls['contentSeparator'] = [
      'label'      => esc_html__( 'Content Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['contentpadding'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Padding', 'bricks' ),
      'type'    => 'spacing',
      'css'     => [
        [
          'property' => 'padding',
          'selector' => '.bc-expander-answer',
        ],
      ],
      'default' => [
          'top' => '0',
          'right' => '20px',
          'bottom' => '15px',
          'left' => '20px',
      ],
  ];
    $this->controls['contenttypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
          [
            'property' => 'typography',
            'selector' => '.bc-expander-answer',
          ],
        ],
    ];
    $this->controls['contenttransitionduration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Transition Duration', 'bricks' ),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
          [
            'property' => 'transition',
            'selector' => '.bc-expander-answercont',
          ],
        ],
        'placeholder'    => '0.3s',
        'default' => '0.3s',
    ];
  }

  public function get_nestable_item() {
		return [
			'name'     => 'block',
			'label'    => esc_html__( 'Expander', 'bricks' ),
            'settings' => [
                '_hidden' => [
                '_cssClasses' => 'bc-expander-container',
                ],
            ],
			'children' => [
          [
          'name'     => 'block',
					'label'    => esc_html__( 'Label', 'bricks' ),
					'settings' => [
						'_hidden'  => [
							'_cssClasses' => 'bc-expander-question',
						],
					],
                    'children' => [
                        [
                            'name'     => 'heading',
                            'label'    => esc_html__( 'Label Heading', 'bricks' ),
                            'settings' => [
                                'text' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'bricks' ),
                                'tag'  => 'h3',
                                '_hidden' => [
                                    '_cssClasses' => 'bc-expander-question-heading',
                                ],
                            ],
                        ],
                        [
                            'name'     => 'icon',
                            'label'    => esc_html__( 'Label Icon', 'bricks' ),
                            'settings' => [
                                'text' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'bricks' ),
                                '_hidden' => [
                                    '_cssClasses' => 'bc-expander-question-icon',
                                ],
                                'icon'     => [
									'icon'    => 'ti-angle-down',
									'library' => 'themify',
								],
                            ],
                        ],
                    ],
                ],
				[
					'name'     => 'block',
					'label'    => esc_html__( 'Content', 'bricks' ),
					'settings' => [
						'_hidden'  => [
							'_cssClasses' => 'bc-expander-answercont',
						],
					],
                    'children' => [
                        [
                            'name'     => 'text-basic',
                            'label'    => esc_html__( 'Content', 'bricks' ),
                            'settings' => [
                                'text' => esc_html__( 'Phasellus vestibulum justo laoreet odio vehicula porttitor. Quisque nec volutpat mauris. Donec eu magna nec diam consequat auctor.
                                Cras mollis congue libero, non eleifend sapien faucibus eget. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas', 'bricks' ),
                                'tag'  => 'div',
                                '_hidden' => [
                                    '_cssClasses' => 'bc-expander-answer',
                                ],
                            ],
                        ],
                    ],
				],
			],
		];
}

public function get_nestable_children() {
    $item = $this->get_nestable_item();
    return [$item];
}


public function enqueue_scripts() {
  wp_enqueue_script( 'expander', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_expander.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
}

  public function render() {
    $settings = $this->settings;

    $schema = ! empty( $settings['schema'] ) ? $settings['schema'] : 'false';
    $openatbuilder = ! empty( $settings['openatbuilder'] ) ? $settings['openatbuilder'] : 'true';
    $mode = ! empty( $settings['mode'] ) ? $settings['mode'] : 'click';
    $singleopen = ! empty( $settings['singleopen'] ) ? $settings['singleopen'] : 'true';
    $openall = ! empty( $settings['openall'] ) ? $settings['openall'] : 'false';
    $openthis = ! empty( $settings['openthis'] ) ? $settings['openthis'] : '';
    $contenttransitionduration = ! empty( $settings['contenttransitionduration'] ) ? $settings['contenttransitionduration'] : '0.3';

    //Include FAQ Schema
    if ($schema == 'true') {
      $nestable_items = $this->get_nestable_item();

      // Expanders - itemscope="" itemtype="https://schema.org/FAQPage"
      $this->set_attribute( '_root', 'itemscope', "" );
      $this->set_attribute( '_root', 'itemtype', "https://schema.org/FAQPage" );

      if (isset($nestable_items['children'])) {
        foreach ($nestable_items['children'] as $index => $item) {
          // Individual Expander - itemscope="" itemprop="mainEntity" itemtype="https://schema.org/Question"
          add_filter('bricks/element/set_root_attributes', function($attributes, $element) {
            if (isset($attributes['class']) && is_array($attributes['class']) && in_array('bc-expander-container', $attributes['class'])) {
                $attributes['itemscope'] = '';
                $attributes['itemprop'] = 'mainEntity';
                $attributes['itemtype'] = 'https://schema.org/Question';
            }
            return $attributes;
          }, 10, 2);

          // Question Heading - itemprop="name"
          add_filter('bricks/element/set_root_attributes', function($attributes, $element) {
            if (isset($attributes['class']) && is_array($attributes['class']) && in_array('bc-expander-question-heading', $attributes['class'])) {
                $attributes['itemprop'] = 'name';
            }
            return $attributes;
          }, 10, 2);

          // Answer Container - itemscope="" itemprop="acceptedAnswer" itemtype="https://schema.org/Answer"
          add_filter('bricks/element/set_root_attributes', function($attributes, $element) {
            if (isset($attributes['class']) && is_array($attributes['class']) && in_array('bc-expander-answercont', $attributes['class'])) {
                $attributes['itemscope'] = '';
                $attributes['itemprop'] = 'acceptedAnswer';
                $attributes['itemtype'] = 'https://schema.org/Answer';
            }
            return $attributes;
          }, 10, 2);

          // Answer Text - itemprop="text"
          add_filter('bricks/element/set_root_attributes', function($attributes, $element) {
            if (isset($attributes['class']) && is_array($attributes['class']) && in_array('bc-expander-answer', $attributes['class'])) {
                $attributes['itemprop'] = 'text';
            }
            return $attributes;
          }, 10, 2);
        }
      }
    }


    
    $this->set_attribute( '_root', 'class', 'wrapper-bc-expander' );

    $output = "<div {$this->render_attributes( '_root' )}
data-openatbuilder=\"$openatbuilder\"
data-contenttransitionduration=\"$contenttransitionduration\"
data-mode=\"$mode\"
data-singleopen=\"$singleopen\"
data-openall=\"$openall\"
data-openthis=\"$openthis\">";
    $output .= Frontend::render_children( $this );
    $output .= '</div>';

	echo $output;
  }
}
