<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Infinite_Title extends \Bricks\Element {
    public $category     = 'Next Bricks - Cores';
    public $name         = 'infinite_title';
    public $icon         = 'ti-layout-width-default';
    public $scripts      = ['bc_infinite_title'];
    public $nestable     = true;

    public function get_label() {
    return esc_html__( 'Vertical Marquee', 'bricks' );
    }

    public function set_controls() {
        $this->controls['note0'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Drag & Drop elements inside the marquee.<br>If the animation is played at the builder you may need to reload canvas when setting or deleting elements.', 'bricks' )))
        ];
        $this->controls['note1'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Images must have an eager loading.', 'bricks' )))
        ];
        $this->controls['styleseparator'] = [
            'label'      => esc_html__( 'Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Height must be equal or lower than the height of all children combined.', 'bricks' )))
        ];
        $this->controls['width'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Width', 'bricks' ),
            'type'    => 'number',
            'units'    => true,
            'css'     => [
              [
                'property' => 'width',
                'selector' => '',
              ],
            ],
            'placeholder' => '100%',
            'rerender' => true,
        ];
        $this->controls['height'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Height', 'bricks' ),
            'type'    => 'number',
            'units'    => true,
            'css'     => [
              [
                'property' => 'height',
                'selector' => '',
              ],
            ],
            'placeholder' => 'auto',
            'rerender' => true,
        ];
        $this->controls['gap'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Gap between items', 'bricks' ),
            'type'    => 'number',
            'units'    => true,
            'css'     => [
              [
                'property' => '--gap',
                'selector' => '',
              ],
            ],
            'placeholder' => '10px',
            'rerender' => true,
        ];
        $this->controls['blurEdges'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Blur edges', 'bricks' ),
            'type' => 'checkbox',
            'default' => true,
        ];
        $this->controls['edgesHeight'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Blur height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css' => [
              [
                'property' => ' --height',
                'selector' => '',
              ]
            ],
            'placeholder' => '50%',
            'required' => [ 'blurEdges', '=', true],
        ];
        
        $this->controls['animationseparator'] = [
            'label'      => esc_html__( 'Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['disablebuilder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
            'type'     => 'checkbox',
            'default' => true,
        ];
        $this->controls['reverse'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Reverse', 'bricks' ),
            'type' => 'checkbox',
            'inline' => true,
            'small' => true,
            'default' => false,
        ];
        $this->controls['duration'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Speed', 'bricks' ),
            'type' => 'number',
            'unit' => 's',
            'inline' => true,
            'placeholder' => '3s',
        ];
        $this->controls['pauseonhover'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Pause on Hover', 'bricks' ),
            'type' => 'checkbox',
            'inline' => true,
            'small' => true,
            'default' => true,
        ];
        $this->controls['hoverspeed'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Hover Speed', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => '',
            'required' => [ 'pauseonhover', '=', false],
        ];
        $this->controls['easing'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'GSAP easing', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'none' => 'none',
                'power1' => 'power1',
                'power2' => 'power2',
                'power3' => 'power3',
                'power4' => 'power4',
                'back' => 'back',
                'bounce' => 'bounce',
                'circ' => 'circ',
                'elastic' => 'elastic',
                'expo' => 'expo',
                'sine' => 'sine',
            ],
            'inline' => true,
            'placeholder' => 'none',
        ];
    }

    /*Render children*/
    public function get_nestable_children() {
        return [
            [
                'name'     => 'heading',
                'label'    => esc_html__( 'Title', 'bricks' ),
                'settings' => [
                    'text' => esc_html__( 'A great caption #1', 'bricks' ),
                    'tag'  => 'h3',
                ],
            ],

            [
                'name'     => 'heading',
                'label'    => esc_html__( 'Title', 'bricks' ),
                'settings' => [
                    'text' => esc_html__( 'A great caption #2', 'bricks' ),
                    'tag'  => 'h3',
                ],
            ],

            [
                'name'     => 'heading',
                'label'    => esc_html__( 'Title', 'bricks' ),
                'settings' => [
                    'text' => esc_html__( 'A great caption #3', 'bricks' ),
                    'tag'  => 'h3',
                ],
            ],
        ];
      }

    public function enqueue_scripts() {
        wp_enqueue_script( 'bc_infinite_title', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_infinite_title.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
        $duration    = ! empty( $settings['duration'] ) ? $settings['duration'] : '3s';
        $easing    = ! empty( $settings['easing'] ) ? $settings['easing'] : 'none';

        $blurEdges = ! empty( $settings['blurEdges'] ) ? $settings['blurEdges'] : false;
        $reverse = ! empty( $settings['reverse'] ) ? $settings['reverse'] : false;
        $pauseonhover = ! empty( $settings['pauseonhover'] ) ? $settings['pauseonhover'] : false;
        $hoverspeed = ! empty( $settings['hoverspeed'] ) ? $settings['hoverspeed'] : '';

        $this->set_attribute( '_root', 'class', 'bc-infinite-title' );
        $this->set_attribute( '_root', 'data-disable-builder', $disablebuilder);
        $this->set_attribute( '_root', 'data-duration', $duration);
        $this->set_attribute( '_root', 'data-easing', $easing);

        $this->set_attribute( '_root', 'data-blur-edges', $blurEdges);
        $this->set_attribute( '_root', 'data-reverse', $reverse);
        $this->set_attribute( '_root', 'data-pauseonhover', $pauseonhover);
        $this->set_attribute( '_root', 'data-hoverspeed', $hoverspeed);

        $this->set_attribute( '_inner', 'class', 'bc-infinite-title__wrapper' );
        
        $output = "<div {$this->render_attributes( '_root' )}>";
        $output .= "<div {$this->render_attributes( '_inner' )}>";
        $output .= Frontend::render_children( $this );
        $output .= "</div>";
        $output .= "</div>";

        echo $output;
    }
}