<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Layerbutton extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'layerbutton';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';
  public $scripts      = ['layerbutton'];

  public function get_label() {
    return esc_html__( 'Layer Button', 'bricks' );
  }

  public function set_control_groups() {
    $this->control_groups['firstlayer'] = [
      'title' => esc_html__( 'First layer', 'bricks' ),
      'tab'   => 'content',
    ];
    $this->control_groups['secondlayer'] = [
      'title' => esc_html__( 'Second layer', 'bricks' ),
      'tab'   => 'content',
    ];
    $this->control_groups['thirdlayer'] = [
      'title' => esc_html__( 'Third layer', 'bricks' ),
      'tab'   => 'content',
    ];
    $this->control_groups['fourthlayer'] = [
      'title' => esc_html__( 'Fourth layer', 'bricks' ),
      'tab'   => 'content',
    ];
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    /*ORIGINAL LAYER*/
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Original layer', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['iconsSeparator'] = [
      'label'      => esc_html__( 'Icons', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['includeLeftIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Left Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['leftIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .bc-layer-button__left-icon',
        ],
      ],
      'required'   => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .bc-layer-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .bc-layer-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .bc-layer-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['includeRightIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Right Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['rightIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .bc-layer-button__right-icon',
        ],
      ],
      'required'   => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .bc-layer-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .bc-layer-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .bc-layer-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];

    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['whitespace'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'White space', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'wrap' => 'wrap',
          'nowrap' => 'nowrap',
      ],
      'inline'      => true,
      'css'     => [
          [
            'property' => 'white-space',
            'selector' => '',
          ],
        ],
      'placeholder'        => 'wrap',
  ];
  $this->controls['padding'] = [
    'tab'         => 'content',
    'label'       => esc_html__( 'Padding', 'bricks' ),
    'type'        => 'spacing',
    'css'     => [
        [
          'property' => 'padding',
          'selector' => '&{pseudo} .bc-layer-button__original-layer',
        ],
      ],
      'placeholder' => [
        'top' => 20,
        'right' => 40,
        'bottom' => 20,
        'left' => 40,
      ],
  ];
    $this->controls['typography'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Typography', 'bricks' ),
        'type'        => 'typography',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'typography',
              'selector' => '&{pseudo} .bc-layer-button__original-layer',
            ],
          ],
    ];
    $this->controls['buttonbackground'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Button background', 'bricks' ),
        'type'        => 'background',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'background',
              'selector' => '&{pseudo} .bc-layer-button__original-layer',
            ],
          ],
    ];
    $this->controls['buttonborder'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Button border', 'bricks' ),
        'type'        => 'border',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'border',
              'selector' => '&{pseudo} .bc-layer-button__original-layer',
            ],
          ],
    ];
    $this->controls['originallayerzindex'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'zIndex', 'bricks' ),
      'type' => 'number',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'z-index',
            'selector' => '&{pseudo} .bc-layer-button__original-layer',
          ],
        ],
  ];
  $this->controls['onHoverSeparator'] = [
    'label'      => esc_html__( 'On Hover', 'bricks' ),
    'type'       => 'separator',
  ];
  $this->controls['originallayertranslate3dpxto'] = [
    'tab'         => 'content',
    'label'       => esc_html__( '3D Translate to', 'bricks' ),
    'type'  => 'number',
    'units' => true,
    'inline'      => true,
    'css'     => [
        [
          'property' => '--translate3dpxto',
          'selector' => '&{pseudo} .bc-layer-button__original-layer',
        ],
      ],
    'placeholder'    => esc_html__( '0px', 'bricks' ),
  ];
    $this->controls['originallayerhovercolor'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Color', 'bricks' ),
      'type'        => 'color',
      'inline'      => true,
      'css'     => [
          [
            'property' => '--color',
            'selector' => '&{pseudo} .bc-layer-button__original-layer',
          ],
        ],
    ];
    $this->controls['originallayerhoverbackground'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Background', 'bricks' ),
      'type'        => 'color',
      'inline'      => true,
      'css'     => [
          [
            'property' => '--background',
            'selector' => '&{pseudo} .bc-layer-button__original-layer',
          ],
        ],
    ];
    $this->controls['originallayerzindexonhover'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'zIndex', 'bricks' ),
        'type' => 'number',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--z-index',
              'selector' => '&{pseudo} .bc-layer-button__original-layer',
            ],
          ],
        'placeholder' => '1',
    ];
    $this->controls['originallayertransitionduration'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Transition duration', 'bricks' ),
      'type' => 'number',
      'unit' => 's',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'transition-duration',
            'selector' => '&{pseudo} .bc-layer-button__original-layer',
          ],
        ],
      'placeholder'    => esc_html__( '0.3s', 'bricks' ),
    ];

    /*FIRST LAYER*/
    $this->controls['firstlayerremove'] = [
      'group'   => 'firstlayer',
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Remove layer', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => false,
  ];
  $this->controls['firstlayerinner_title'] = [
    'group'   => 'firstlayer',
    'tab'            => 'content',
    'type'           => 'text',
    'hasDynamicData' => 'text',
    'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
  ];
  $this->controls['firstlayerpadding'] = [
    'group'   => 'firstlayer',
    'tab'         => 'content',
    'label'       => esc_html__( 'Padding', 'bricks' ),
    'type'        => 'spacing',
    'css'     => [
        [
          'property' => 'padding',
          'selector' => '&{pseudo} .bc-layer-button__first-layer',
        ],
      ],
      'placeholder' => [
        'top' => 20,
        'right' => 40,
        'bottom' => 20,
        'left' => 40,
      ],
];
    $this->controls['firstlayertwidth'] = [
      'group'   => 'firstlayer',
      'tab'         => 'content',
      'label'       => esc_html__( 'Width', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline'      => true,
      'css'     => [
          [
            'property' => 'width',
            'selector' => '&{pseudo} .bc-layer-button__first-layer',
          ],
        ],
        'placeholder' => '100%',
    ];
    $this->controls['firstlayertheight'] = [
      'group'   => 'firstlayer',
      'tab'         => 'content',
      'label'       => esc_html__( 'Height', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline'      => true,
      'css'     => [
          [
            'property' => 'height',
            'selector' => '&{pseudo} .bc-layer-button__first-layer',
          ],
        ],
        'placeholder' => '100%',
    ];
  $this->controls['firstlayertypography'] = [
    'group'   => 'firstlayer',
    'tab'         => 'content',
    'label'       => esc_html__( 'Typography', 'bricks' ),
    'type'        => 'typography',
    'inline'      => true,
    'css'     => [
        [
          'property' => 'typography',
          'selector' => '&{pseudo} .bc-layer-button__first-layer',
        ],
      ],
];
    $this->controls['layerbackground'] = [
      'group'   => 'firstlayer',
        'tab'         => 'content',
        'label'       => esc_html__( 'Background', 'bricks' ),
        'type'        => 'background',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'background',
              'selector' => '&{pseudo} .bc-layer-button__first-layer',
            ],
          ],
    ];
    $this->controls['layerborder'] = [
      'group'   => 'firstlayer',
        'tab'         => 'content',
        'label'       => esc_html__( 'Border', 'bricks' ),
        'type'        => 'border',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'border',
              'selector' => '&{pseudo} .bc-layer-button__first-layer',
            ],
          ],
    ];
  $this->controls['firstlayerzindex'] = [
    'group'   => 'firstlayer',
      'tab'         => 'content',
      'label'       => esc_html__( 'zIndex', 'bricks' ),
      'type' => 'number',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'z-index',
            'selector' => '&{pseudo} .bc-layer-button__first-layer',
          ],
        ],
  ];
  $this->controls['translate3dpxfrom'] = [
    'group'   => 'firstlayer',
    'tab'         => 'content',
    'label'       => esc_html__( '3D Translate from', 'bricks' ),
    'type'  => 'number',
    'units' => true,
    'inline'      => true,
    'css'     => [
        [
          'property' => '--translate3dpxfrom',
          'selector' => '&{pseudo} .bc-layer-button__first-layer',
        ],
      ],
    'placeholder'    => esc_html__( '6px', 'bricks' ),
  ];
  $this->controls['onHover1Separator'] = [
    'label'      => esc_html__( 'On Hover', 'bricks' ),
    'type'       => 'separator',
    'group'   => 'firstlayer',
  ];
  $this->controls['translate3dpxto'] = [
    'group'   => 'firstlayer',
    'tab'         => 'content',
    'label'       => esc_html__( '3D Translate to', 'bricks' ),
    'type'  => 'number',
    'units' => true,
    'inline'      => true,
    'css'     => [
        [
          'property' => '--translate3dpxto',
          'selector' => '&{pseudo} .bc-layer-button__first-layer',
        ],
      ],
    'placeholder'    => esc_html__( '0', 'bricks' ),
  ];
    $this->controls['firstlayerhovercolor'] = [
      'group'   => 'firstlayer',
      'tab'         => 'content',
      'label'       => esc_html__( 'Color', 'bricks' ),
      'type'        => 'color',
      'inline'      => true,
      'css'     => [
          [
            'property' => '--color',
            'selector' => '&{pseudo} .bc-layer-button__first-layer',
          ],
        ],
    ];
    $this->controls['firstlayerhoverbackground'] = [
      'group'   => 'firstlayer',
      'tab'         => 'content',
      'label'       => esc_html__( 'Background', 'bricks' ),
      'type'        => 'color',
      'inline'      => true,
      'css'     => [
          [
            'property' => '--background',
            'selector' => '&{pseudo} .bc-layer-button__first-layer',
          ],
        ],
    ];
    $this->controls['firstlayerzindexonhover'] = [
      'group'   => 'firstlayer',
        'tab'         => 'content',
        'label'       => esc_html__( 'zIndex', 'bricks' ),
        'type' => 'number',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--z-index',
              'selector' => '&{pseudo} .bc-layer-button__first-layer',
            ],
          ],
        'placeholder' => '0',
    ];
    $this->controls['transitionduration'] = [
      'group'   => 'firstlayer',
      'tab'         => 'content',
      'label'       => esc_html__( 'Transition duration', 'bricks' ),
      'type' => 'number',
      'unit' => 's',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'transition-duration',
            'selector' => '&{pseudo} .bc-layer-button__first-layer',
          ],
        ],
      'placeholder'    => esc_html__( '0.3s', 'bricks' ),
    ];

    /*SECOND LAYER*/
    $this->controls['secondlayerremove'] = [
      'group'   => 'secondlayer',
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Remove layer', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => false,
  ];
  $this->controls['secondlayerinner_title'] = [
    'group'   => 'secondlayer',
    'tab'            => 'content',
    'type'           => 'text',
    'hasDynamicData' => 'text',
    'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
  ];
  $this->controls['secondlayerpadding'] = [
    'group'   => 'secondlayer',
    'tab'         => 'content',
    'label'       => esc_html__( 'Padding', 'bricks' ),
    'type'        => 'spacing',
    'css'     => [
        [
          'property' => 'padding',
          'selector' => '&{pseudo} .bc-layer-button__second-layer',
        ],
      ],
      'placeholder' => [
        'top' => 20,
        'right' => 40,
        'bottom' => 20,
        'left' => 40,
      ],
];
    $this->controls['secondlayertwidth'] = [
      'group'   => 'secondlayer',
      'tab'         => 'content',
      'label'       => esc_html__( 'Width', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline'      => true,
      'css'     => [
          [
            'property' => 'width',
            'selector' => '&{pseudo} .bc-layer-button__second-layer',
          ],
        ],
        'placeholder' => '100%',
    ];
    $this->controls['secondlayertheight'] = [
      'group'   => 'secondlayer',
      'tab'         => 'content',
      'label'       => esc_html__( 'Height', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline'      => true,
      'css'     => [
          [
            'property' => 'height',
            'selector' => '&{pseudo} .bc-layer-button__second-layer',
          ],
        ],
        'placeholder' => '100%',
    ];
  $this->controls['secondlayertypography'] = [
    'group'   => 'secondlayer',
    'tab'         => 'content',
    'label'       => esc_html__( 'Typography', 'bricks' ),
    'type'        => 'typography',
    'inline'      => true,
    'css'     => [
        [
          'property' => 'typography',
          'selector' => '&{pseudo} .bc-layer-button__second-layer',
        ],
      ],
];
    $this->controls['secondlayerbackground'] = [
      'group'   => 'secondlayer',
        'tab'         => 'content',
        'label'       => esc_html__( 'Background', 'bricks' ),
        'type'        => 'background',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'background',
              'selector' => '&{pseudo} .bc-layer-button__second-layer',
            ],
          ],
    ];
    $this->controls['secondlayerborder'] = [
      'group'   => 'secondlayer',
        'tab'         => 'content',
        'label'       => esc_html__( 'Border', 'bricks' ),
        'type'        => 'border',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'border',
              'selector' => '&{pseudo} .bc-layer-button__second-layer',
            ],
          ],
    ];
  $this->controls['secondlayerzindex'] = [
    'group'   => 'secondlayer',
      'tab'         => 'content',
      'label'       => esc_html__( 'zIndex', 'bricks' ),
      'type' => 'number',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'z-index',
            'selector' => '&{pseudo} .bc-layer-button__second-layer',
          ],
        ],
  ];
  $this->controls['secondlayertranslate3dpxfrom'] = [
    'group'   => 'secondlayer',
    'tab'         => 'content',
    'label'       => esc_html__( '3D Translate from', 'bricks' ),
    'type'  => 'number',
    'units' => true,
    'inline'      => true,
    'css'     => [
        [
          'property' => '--translate3dpxfrom',
          'selector' => '&{pseudo} .bc-layer-button__second-layer',
        ],
      ],
    'placeholder'    => esc_html__( '12px', 'bricks' ),
  ];
  $this->controls['onHover2Separator'] = [
    'label'      => esc_html__( 'On Hover', 'bricks' ),
    'type'       => 'separator',
    'group'   => 'secondlayer',
  ];
  $this->controls['secondlayertranslate3dpxto'] = [
    'group'   => 'secondlayer',
    'tab'         => 'content',
    'label'       => esc_html__( '3D Translate to', 'bricks' ),
    'type'  => 'number',
    'units' => true,
    'inline'      => true,
    'css'     => [
        [
          'property' => '--translate3dpxto',
          'selector' => '&{pseudo} .bc-layer-button__second-layer',
        ],
      ],
    'placeholder'    => esc_html__( '0', 'bricks' ),
  ];
    $this->controls['secondlayerhovercolor'] = [
      'group'   => 'secondlayer',
      'tab'         => 'content',
      'label'       => esc_html__( 'Color', 'bricks' ),
      'type'        => 'color',
      'inline'      => true,
      'css'     => [
          [
            'property' => '--color',
            'selector' => '&{pseudo} .bc-layer-button__second-layer',
          ],
        ],
    ];
    $this->controls['secondlayerhoverbackground'] = [
      'group'   => 'secondlayer',
      'tab'         => 'content',
      'label'       => esc_html__( 'Background', 'bricks' ),
      'type'        => 'color',
      'inline'      => true,
      'css'     => [
          [
            'property' => '--background',
            'selector' => '&{pseudo} .bc-layer-button__second-layer',
          ],
        ],
    ];
    $this->controls['secondlayerzindexonhover'] = [
      'group'   => 'secondlayer',
        'tab'         => 'content',
        'label'       => esc_html__( 'zIndex', 'bricks' ),
        'type' => 'number',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--z-index',
              'selector' => '&{pseudo} .bc-layer-button__second-layer',
            ],
          ],
        'placeholder' => '-1',
    ];
    $this->controls['secondlayertransitionduration'] = [
      'group'   => 'secondlayer',
      'tab'         => 'content',
      'label'       => esc_html__( 'Transition duration', 'bricks' ),
      'type' => 'number',
      'unit' => 's',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'transition-duration',
            'selector' => '&{pseudo} .bc-layer-button__second-layer',
          ],
        ],
      'placeholder'    => esc_html__( '0.3s', 'bricks' ),
    ];

    /*THIRD LAYER*/
    $this->controls['thirdlayerremove'] = [
      'group'   => 'thirdlayer',
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Remove layer', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => false,
  ];
  $this->controls['thirdlayerinner_title'] = [
    'group'   => 'thirdlayer',
    'tab'            => 'content',
    'type'           => 'text',
    'hasDynamicData' => 'text',
    'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
  ];
  $this->controls['thirdlayerpadding'] = [
    'group'   => 'thirdlayer',
    'tab'         => 'content',
    'label'       => esc_html__( 'Padding', 'bricks' ),
    'type'        => 'spacing',
    'css'     => [
        [
          'property' => 'padding',
          'selector' => '&{pseudo} .bc-layer-button__third-layer',
        ],
      ],
      'placeholder' => [
        'top' => 20,
        'right' => 40,
        'bottom' => 20,
        'left' => 40,
      ],
];
    $this->controls['thirdlayertwidth'] = [
      'group'   => 'thirdlayer',
      'tab'         => 'content',
      'label'       => esc_html__( 'Width', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline'      => true,
      'css'     => [
          [
            'property' => 'width',
            'selector' => '&{pseudo} .bc-layer-button__third-layer',
          ],
        ],
        'placeholder' => '100%',
    ];
    $this->controls['thirdlayertheight'] = [
      'group'   => 'thirdlayer',
      'tab'         => 'content',
      'label'       => esc_html__( 'Height', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline'      => true,
      'css'     => [
          [
            'property' => 'height',
            'selector' => '&{pseudo} .bc-layer-button__third-layer',
          ],
        ],
        'placeholder' => '100%',
    ];
  $this->controls['thirdlayertypography'] = [
    'group'   => 'thirdlayer',
    'tab'         => 'content',
    'label'       => esc_html__( 'Typography', 'bricks' ),
    'type'        => 'typography',
    'inline'      => true,
    'css'     => [
        [
          'property' => 'typography',
          'selector' => '&{pseudo} .bc-layer-button__third-layer',
        ],
      ],
];
    $this->controls['thirdlayerbackground'] = [
      'group'   => 'thirdlayer',
        'tab'         => 'content',
        'label'       => esc_html__( 'Background', 'bricks' ),
        'type'        => 'background',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'background',
              'selector' => '&{pseudo} .bc-layer-button__third-layer',
            ],
          ],
    ];
    $this->controls['thirdlayerborder'] = [
      'group'   => 'thirdlayer',
        'tab'         => 'content',
        'label'       => esc_html__( 'Border', 'bricks' ),
        'type'        => 'border',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'border',
              'selector' => '&{pseudo} .bc-layer-button__third-layer',
            ],
          ],
    ];
  $this->controls['thirdlayerzindex'] = [
    'group'   => 'thirdlayer',
      'tab'         => 'content',
      'label'       => esc_html__( 'Layer zIndex', 'bricks' ),
      'type' => 'number',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'z-index',
            'selector' => '&{pseudo} .bc-layer-button__third-layer',
          ],
        ],
  ];
  $this->controls['thirdlayertranslate3dpxfrom'] = [
    'group'   => 'thirdlayer',
    'tab'         => 'content',
    'label'       => esc_html__( '3D Translate from', 'bricks' ),
    'type'  => 'number',
    'units' => true,
    'inline'      => true,
    'css'     => [
        [
          'property' => '--translate3dpxfrom',
          'selector' => '&{pseudo} .bc-layer-button__third-layer',
        ],
      ],
    'placeholder'    => esc_html__( '18px', 'bricks' ),
  ];
  $this->controls['onHover3Separator'] = [
    'label'      => esc_html__( 'On Hover', 'bricks' ),
    'type'       => 'separator',
    'group'   => 'thirdlayer',
  ];
  $this->controls['thirdlayertranslate3dpxto'] = [
    'group'   => 'thirdlayer',
    'tab'         => 'content',
    'label'       => esc_html__( '3D Translate to', 'bricks' ),
    'type'  => 'number',
    'units' => true,
    'inline'      => true,
    'css'     => [
        [
          'property' => '--translate3dpxto',
          'selector' => '&{pseudo} .bc-layer-button__third-layer',
        ],
      ],
    'placeholder'    => esc_html__( '0', 'bricks' ),
  ];
    $this->controls['thirdlayerhovercolor'] = [
      'group'   => 'thirdlayer',
      'tab'         => 'content',
      'label'       => esc_html__( 'Color', 'bricks' ),
      'type'        => 'color',
      'inline'      => true,
      'css'     => [
          [
            'property' => '--color',
            'selector' => '&{pseudo} .bc-layer-button__third-layer',
          ],
        ],
    ];
    $this->controls['thirdlayerhoverbackground'] = [
      'group'   => 'thirdlayer',
      'tab'         => 'content',
      'label'       => esc_html__( 'Background', 'bricks' ),
      'type'        => 'color',
      'inline'      => true,
      'css'     => [
          [
            'property' => '--background',
            'selector' => '&{pseudo} .bc-layer-button__third-layer',
          ],
        ],
    ];
    $this->controls['thirdlayerzindexonhover'] = [
      'group'   => 'thirdlayer',
        'tab'         => 'content',
        'label'       => esc_html__( 'zIndex', 'bricks' ),
        'type' => 'number',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--z-index',
              'selector' => '&{pseudo} .bc-layer-button__third-layer',
            ],
          ],
        'placeholder' => '-2',
    ];
    $this->controls['thirdlayertransitionduration'] = [
      'group'   => 'thirdlayer',
      'tab'         => 'content',
      'label'       => esc_html__( 'Transition duration', 'bricks' ),
      'type' => 'number',
      'unit' => 's',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'transition-duration',
            'selector' => '&{pseudo} .bc-layer-button__third-layer',
          ],
        ],
      'placeholder'    => esc_html__( '0.3s', 'bricks' ),
    ];

        /*THIRD LAYER*/
        $this->controls['fourthlayerremove'] = [
          'group'   => 'fourthlayer',
          'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'Remove layer', 'bricks' ),
          'type' => 'checkbox',
          'inline' => true,
          'small' => true,
          'default' => false,
      ];
      $this->controls['fourthlayerinner_title'] = [
        'group'   => 'fourthlayer',
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
      ];
      $this->controls['fourthlayerpadding'] = [
        'group'   => 'fourthlayer',
        'tab'         => 'content',
        'label'       => esc_html__( 'Padding', 'bricks' ),
        'type'        => 'spacing',
        'css'     => [
            [
              'property' => 'padding',
              'selector' => '&{pseudo} .bc-layer-button__fourth-layer',
            ],
          ],
          'placeholder' => [
            'top' => 20,
            'right' => 40,
            'bottom' => 20,
            'left' => 40,
          ],
    ];
        $this->controls['fourthlayertwidth'] = [
          'group'   => 'fourthlayer',
          'tab'         => 'content',
          'label'       => esc_html__( 'Width', 'bricks' ),
          'type'  => 'number',
          'units' => true,
          'inline'      => true,
          'css'     => [
              [
                'property' => 'width',
                'selector' => '&{pseudo} .bc-layer-button__fourth-layer',
              ],
            ],
            'placeholder' => '100%',
        ];
        $this->controls['fourthlayertheight'] = [
          'group'   => 'fourthlayer',
          'tab'         => 'content',
          'label'       => esc_html__( 'Height', 'bricks' ),
          'type'  => 'number',
          'units' => true,
          'inline'      => true,
          'css'     => [
              [
                'property' => 'height',
                'selector' => '&{pseudo} .bc-layer-button__fourth-layer',
              ],
            ],
            'placeholder' => '100%',
        ];
      $this->controls['fourthlayertypography'] = [
        'group'   => 'fourthlayer',
        'tab'         => 'content',
        'label'       => esc_html__( 'Typography', 'bricks' ),
        'type'        => 'typography',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'typography',
              'selector' => '&{pseudo} .bc-layer-button__fourth-layer',
            ],
          ],
    ];
        $this->controls['fourthlayerbackground'] = [
          'group'   => 'fourthlayer',
            'tab'         => 'content',
            'label'       => esc_html__( 'Background', 'bricks' ),
            'type'        => 'background',
            'inline'      => true,
            'css'     => [
                [
                  'property' => 'background',
                  'selector' => '&{pseudo} .bc-layer-button__fourth-layer',
                ],
              ],
        ];
        $this->controls['fourthlayerborder'] = [
          'group'   => 'fourthlayer',
            'tab'         => 'content',
            'label'       => esc_html__( 'Border', 'bricks' ),
            'type'        => 'border',
            'inline'      => true,
            'css'     => [
                [
                  'property' => 'border',
                  'selector' => '&{pseudo} .bc-layer-button__fourth-layer',
                ],
              ],
        ];
      $this->controls['fourthlayerzindex'] = [
        'group'   => 'fourthlayer',
          'tab'         => 'content',
          'label'       => esc_html__( 'zIndex', 'bricks' ),
          'type' => 'number',
          'inline'      => true,
          'css'     => [
              [
                'property' => 'z-index',
                'selector' => '&{pseudo} .bc-layer-button__fourth-layer',
              ],
            ],
      ];
      $this->controls['fourthlayertranslate3dpxfrom'] = [
        'group'   => 'fourthlayer',
        'tab'         => 'content',
        'label'       => esc_html__( '3D Translate from', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline'      => true,
        'css'     => [
            [
              'property' => '--translate3dpxfrom',
              'selector' => '&{pseudo} .bc-layer-button__fourth-layer',
            ],
          ],
        'placeholder'    => esc_html__( '24px', 'bricks' ),
      ];
      $this->controls['onHover4Separator'] = [
        'label'      => esc_html__( 'On Hover', 'bricks' ),
        'type'       => 'separator',
        'group'   => 'fourthlayer',
      ];
      $this->controls['fourthlayertranslate3dpxto'] = [
        'group'   => 'fourthlayer',
        'tab'         => 'content',
        'label'       => esc_html__( '3D Translate to', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline'      => true,
        'css'     => [
            [
              'property' => '--translate3dpxto',
              'selector' => '&{pseudo} .bc-layer-button__fourth-layer',
            ],
          ],
        'placeholder'    => esc_html__( '0', 'bricks' ),
      ];
        $this->controls['fourthlayerhovercolor'] = [
          'group'   => 'fourthlayer',
          'tab'         => 'content',
          'label'       => esc_html__( 'Color', 'bricks' ),
          'type'        => 'color',
          'inline'      => true,
          'css'     => [
              [
                'property' => '--color',
                'selector' => '&{pseudo} .bc-layer-button__fourth-layer',
              ],
            ],
        ];
        $this->controls['fourthlayerhoverbackground'] = [
          'group'   => 'fourthlayer',
          'tab'         => 'content',
          'label'       => esc_html__( 'Background', 'bricks' ),
          'type'        => 'color',
          'inline'      => true,
          'css'     => [
              [
                'property' => '--background',
                'selector' => '&{pseudo} .bc-layer-button__fourth-layer',
              ],
            ],
        ];
        $this->controls['fourthlayerzindexonhover'] = [
          'group'   => 'fourthlayer',
            'tab'         => 'content',
            'label'       => esc_html__( 'zIndex', 'bricks' ),
            'type' => 'number',
            'inline'      => true,
            'css'     => [
                [
                  'property' => '--z-index',
                  'selector' => '&{pseudo} .bc-layer-button__fourth-layer',
                ],
              ],
            'placeholder' => '-3',
        ];
        $this->controls['fourthlayertransitionduration'] = [
          'group'   => 'fourthlayer',
          'tab'         => 'content',
          'label'       => esc_html__( 'Transition duration', 'bricks' ),
          'type' => 'number',
          'unit' => 's',
          'inline'      => true,
          'css'     => [
              [
                'property' => 'transition-duration',
                'selector' => '&{pseudo} .bc-layer-button__fourth-layer',
              ],
            ],
          'placeholder'    => esc_html__( '0.3s', 'bricks' ),
        ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'layerbutton', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_layer_button.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';
    $firstlayerinner_title    = ! empty( $settings['firstlayerinner_title'] ) ? $settings['firstlayerinner_title'] : '';
    $secondlayerinner_title    = ! empty( $settings['secondlayerinner_title'] ) ? $settings['secondlayerinner_title'] : '';
    $thirdlayerinner_title    = ! empty( $settings['thirdlayerinner_title'] ) ? $settings['thirdlayerinner_title'] : '';
    $fourthlayerinner_title    = ! empty( $settings['fourthlayerinner_title'] ) ? $settings['fourthlayerinner_title'] : '';
    $firstlayerremove = ! empty( $settings['firstlayerremove'] ) ? $settings['firstlayerremove'] : false;
    $secondlayerremove = ! empty( $settings['secondlayerremove'] ) ? $settings['secondlayerremove'] : false;
    $thirdlayerremove = ! empty( $settings['thirdlayerremove'] ) ? $settings['thirdlayerremove'] : false;
    $fourthlayerremove = ! empty( $settings['fourthlayerremove'] ) ? $settings['fourthlayerremove'] : false;

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $includeLeftIcon = ! empty( $settings['includeLeftIcon'] ) ? $settings['includeLeftIcon'] : 0;
    $includeRightIcon = ! empty( $settings['includeRightIcon'] ) ? $settings['includeRightIcon'] : 0;
    if ( $includeLeftIcon !== 0 ) {
      $leftIcon = self::render_icon( $settings['leftIcon'], [ 'bc-layer-button__left-icon' ] );
    }else{
      $leftIcon = '';
    }
    if ( $includeRightIcon !== 0 ) {
      $rightIcon = self::render_icon( $settings['rightIcon'], [ 'bc-layer-button__right-icon' ] );
    }else{
      $rightIcon = '';
    }

    $this->set_attribute( '_root', 'class', 'bc-layer-button' );

    $output = "<$root_tag {$this->render_attributes('_root')}>
    <div class='bc-layer-button__original-layer'>$leftIcon$inner_title$rightIcon</div>";

    if (!$firstlayerremove) {
        $output .= "<span class='bc-layer-button__first-layer'>$firstlayerinner_title</span>";
    }
    if (!$secondlayerremove) {
      $output .= "<span class='bc-layer-button__second-layer'>$secondlayerinner_title</span>";
    }
    if (!$thirdlayerremove) {
      $output .= "<span class='bc-layer-button__third-layer'>$thirdlayerinner_title</span>";
    }
    if (!$fourthlayerremove) {
      $output .= "<span class='bc-layer-button__fourth-layer'>$fourthlayerinner_title</span>";
    }

    $output .= "</$root_tag>";

	echo $output;
  }
}



