<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Maskbutton extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'maskbutton';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';
  public $scripts      = ['maskbutton'];

  public function get_label() {
    return esc_html__( 'Mask Button', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Mask Button', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['iconsSeparator'] = [
      'label'      => esc_html__( 'Icons', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['includeLeftIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Left Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['leftIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .bc-mask-button__left-icon',
        ],
      ],
      'required'   => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .bc-mask-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .bc-mask-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .bc-mask-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['includeRightIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Right Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['rightIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .bc-mask-button__right-icon',
        ],
      ],
      'required'   => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .bc-mask-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .bc-mask-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .bc-mask-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];

    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['whitespace'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'White space', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'wrap' => 'wrap',
            'nowrap' => 'nowrap',
        ],
        'inline'      => true,
        'css'     => [
            [
              'property' => 'white-space',
              'selector' => '',
            ],
          ],
        'placeholder' => 'wrap',
    ];
    $this->controls['padding'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Padding', 'bricks' ),
        'type'        => 'spacing',
        'css'     => [
            [
              'property' => 'padding',
              'selector' => '',
            ],
          ],
          'placeholder' => [
            'top' => 15,
            'right' => 30,
            'bottom' => 15,
            'left' => 30,
          ],
        'default' => [
            'top' => '15px',
            'right' => '30px',
            'bottom' => '15px',
            'left' => '30px',
        ],
    ];
    $this->controls['background'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Background', 'bricks' ),
        'type'        => 'background',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--bg',
              'selector' => '',
            ],
          ],
        'default' => [
            'color' => [
                'hex' => '#000000',
            ],
        ],
    ];
    $this->controls['note'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Mix blend mode is applied to the text. It is required to achieve an appropriate Mask effect.', 'bricks' )))
    ];
    $this->controls['blendmode'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Mix blend mode', 'bricks' ),
      'type'        => 'select',
      'options'     => [
        'difference' => 'difference',
        'exclusion' => 'exclusion',
        'normal' => 'normal',
        'screen' => 'screen',
        'lighten' => 'lighten',
        'hard-light' => 'hard-light',
        'luminosity' => 'luminosity',
      ],
      'inline'      => true,
      'css'     => [
          [
            'property' => 'mix-blend-mode',
            'selector' => '&{pseudo} .bc-mask-button__title',
          ],
        ],
      'placeholder' => 'difference',
  ];
    $this->controls['color'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Color', 'bricks' ),
        'type'        => 'color',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--fg',
              'selector' => '',
            ],
        ],
        'default' => [
            'hex' => '#e6e6e6',
        ],
    ];
    $this->controls['typography'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Typography', 'bricks' ),
        'type'        => 'typography',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'typography',
              'selector' => '',
            ],
        ],
        'exclude' => [
            'color',
        ],
    ];
    $this->controls['border'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Border', 'bricks' ),
        'type'        => 'border',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'border',
              'selector' => '',
            ],
        ],
        'exclude' => [
            'radius',
        ],
    ];
    $this->controls['borderRadius'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Border radius', 'bricks' ),
        'type'        => 'border',
        'css'     => [
            [
              'property' => 'border-radius',
              'selector' => '&{pseudo}',
            ],
                        [
              'property' => 'border-radius',
              'selector' => '&{pseudo} .bc-mask-button__back',
            ],
        ],
        'exclude' => [
          'width',
          'style',
          'color',
        ],
        'default' => [
          'radius' => [
            'top' => 0,
            'right' => 0,
            'bottom' => 0,
            'left' => 0,
          ],
        ],
    ];

    $this->controls['maskSeparator'] = [
      'label'      => esc_html__( 'Mask', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['widthMask'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Width', 'bricks' ),
        'type'        => 'number',
        'units'      => true,
        'inline'      => true,
        'css'     => [
            [
              'property' => 'width',
              'selector' => '&{pseudo} .bc-mask-button__back > span',
            ],
        ],
        'placeholder' => '50%',
    ];
    $this->controls['borderRadiusMask'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Border radius', 'bricks' ),
        'type'        => 'border',
        'css'     => [
            [
              'property' => '--border-radius2',
              'selector' => '&{pseudo} .bc-mask-button__back > span',
            ],
        ],
        'exclude' => [
          'width',
          'style',
          'color',
        ],
    ];
    $this->controls['backgroundmask'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Background', 'bricks' ),
      'type'        => 'background',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'background',
            'selector' => '&{pseudo} .bc-mask-button__back > span',
          ],
        ],
    ];
    $this->controls['transitiondurationMask'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Transition duration', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'unit'        => 's',
        'css'     => [
            [
              'property' => '--transition-duration',
              'selector' => '',
            ],
        ],
        'placeholder' => '0.5s',
        'default' => '0.5s',
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'maskbutton', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_mask_button.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $includeLeftIcon = ! empty( $settings['includeLeftIcon'] ) ? $settings['includeLeftIcon'] : 0;
    $includeRightIcon = ! empty( $settings['includeRightIcon'] ) ? $settings['includeRightIcon'] : 0;
    if ( $includeLeftIcon !== 0 ) {
      $leftIcon = self::render_icon( $settings['leftIcon'], [ 'bc-mask-button__left-icon' ] );
    }else{
      $leftIcon = '';
    }
    if ( $includeRightIcon !== 0 ) {
      $rightIcon = self::render_icon( $settings['rightIcon'], [ 'bc-mask-button__right-icon' ] );
    }else{
      $rightIcon = '';
    }

    $this->set_attribute( '_root', 'class', 'bc-mask-button' );

    $output = "
    <$root_tag {$this->render_attributes( '_root' )}>
        <span class='bc-mask-button__back'>
            <span></span>
        </span>
        <span class='bc-mask-button__title'>$leftIcon$inner_title$rightIcon</span>
    </$root_tag>
    ";

	echo $output;
  }
}
