<?php
namespace Bricks;

if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Observer extends \Bricks\Element {
    public $category     = 'Next Bricks - Cores';
    public $name         = 'observer';
    public $icon         = 'fa-solid fa-border-top-left';
    public $scripts      = ['observer'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Observer', 'bricks' );
    }

    public function set_controls() {
        // Display
		$this->controls['_display'] = [
			'label'     => esc_html__( 'Display', 'bricks' ),
			'type'      => 'select',
			'options'   => [
				'flex'         => 'flex',
				'grid'         => 'grid',
				'block'        => 'block',
				'inline-block' => 'inline-block',
				'inline'       => 'inline',
				'none'         => 'none',
			],
			'inline'    => true,
			'lowercase' => true,
			'css'       => [
				[
					'property' => 'display',
					'selector' => '',
				],
				/**
				 * Use 'required' property to add CSS rule if display is set to 'grid'
				 *
				 * @prev 1.7.2: Used .brx-grid class on nestable to set align-items to initial.
				 *
				 * @since 1.7.2
				 */
				[
					'selector' => '',
					'property' => 'align-items',
					'value'    => 'initial',
					'required' => 'grid',
				],
			],
		];

		// Display: grid

		$this->controls['_gridGap'] = [
			'label'       => esc_html__( 'Gap', 'bricks' ),
			'type'        => 'number',
			'units'       => true,
			'css'         => [
				[
					'property' => 'grid-gap', // '{column-gap} {row-gap}' e.g. '20px 40px'
					'selector' => '',
				],
			],
			'placeholder' => '',
			'required'    => [ '_display', '=', 'grid' ],
		];

		$this->controls['_gridTemplateColumns'] = [
			'label'          => esc_html__( 'Grid template columns', 'bricks' ),
			'type'           => 'text',
			'tooltip'        => [
				'content'  => 'grid-tempate-columns',
				'position' => 'top-left',
			],
			'hasDynamicData' => false,
			'css'            => [
				[
					'property' => 'grid-template-columns',
					'selector' => '',
				],
			],
			'placeholder'    => '',
			'required'       => [ '_display', '=', 'grid' ],
		];

		$this->controls['_gridTemplateRows'] = [
			'label'          => esc_html__( 'Grid template rows', 'bricks' ),
			'type'           => 'text',
			'tooltip'        => [
				'content'  => 'grid-tempate-rows',
				'position' => 'top-left',
			],
			'hasDynamicData' => false,
			'css'            => [
				[
					'property' => 'grid-template-rows',
					'selector' => '',
				],
			],
			'placeholder'    => '',
			'required'       => [ '_display', '=', 'grid' ],
		];

		$this->controls['_gridAutoColumns'] = [
			'label'          => esc_html__( 'Grid auto columns', 'bricks' ),
			'type'           => 'text',
			'tooltip'        => [
				'content'  => 'grid-auto-columns',
				'position' => 'top-left',
			],
			'hasDynamicData' => false,
			'css'            => [
				[
					'property' => 'grid-auto-columns',
					'selector' => '',
				],
			],
			'required'       => [ '_display', '=', 'grid' ],
		];

		$this->controls['_gridAutoRows'] = [
			'label'          => esc_html__( 'Grid auto rows', 'bricks' ),
			'type'           => 'text',
			'tooltip'        => [
				'content'  => 'grid-auto-rows',
				'position' => 'top-left',
			],
			'hasDynamicData' => false,
			'css'            => [
				[
					'property' => 'grid-auto-rows',
					'selector' => '',
				],
			],
			'required'       => [ '_display', '=', 'grid' ],
		];

		$this->controls['_gridAutoFlow'] = [
			'label'    => esc_html__( 'Grid auto flow', 'bricks' ),
			'type'     => 'select',
			'options'  => [
				'row'    => 'row',
				'column' => 'column',
				'dense'  => 'dense',
			],
			'tooltip'  => [
				'content'  => 'grid-auto-flow',
				'position' => 'top-left',
			],
			'css'      => [
				[
					'property' => 'grid-auto-flow',
					'selector' => '',
				],
			],
			'required' => [ '_display', '=', 'grid' ],
		];

		$this->controls['_justifyItemsGrid'] = [
			'label'     => esc_html__( 'Justify items', 'bricks' ),
			'tooltip'   => [
				'content'  => 'justify-items',
				'position' => 'top-left',
			],
			'type'      => 'justify-content',
			'direction' => 'row',
			'css'       => [
				[
					'property' => 'justify-items',
				],
			],
			'required'  => [ '_display', '=', 'grid' ],
		];

		$this->controls['_alignItemsGrid'] = [
			'label'     => esc_html__( 'Align items', 'bricks' ),
			'tooltip'   => [
				'content'  => 'align-items',
				'position' => 'top-left',
			],
			'type'      => 'align-items',
			'direction' => 'row',
			'css'       => [
				[
					'property' => 'align-items',
				],
			],
			'required'  => [ '_display', '=', 'grid' ],
		];

		$this->controls['_justifyContentGrid'] = [
			'label'     => esc_html__( 'Justify content', 'bricks' ),
			'tooltip'   => [
				'content'  => 'justify-content',
				'position' => 'top-left',
			],
			'type'      => 'justify-content',
			'direction' => 'row',
			'css'       => [
				[
					'property' => 'justify-content',
				],
			],
			'required'  => [ '_display', '=', 'grid' ],
		];

		$this->controls['_alignContentGrid'] = [
			'label'     => esc_html__( 'Align content', 'bricks' ),
			'tooltip'   => [
				'content'  => 'align-content',
				'position' => 'top-left',
			],
			'type'      => 'align-items',
			'direction' => 'row',
			'css'       => [
				[
					'property' => 'align-content',
				],
			],
			'required'  => [ '_display', '=', 'grid' ],
		];

		// Display: flex

		// Flex controls
		$this->controls['_flexWrap'] = [
			'label'    => esc_html__( 'Flex wrap', 'bricks' ),
			'tooltip'  => [
				'content'  => 'flex-wrap',
				'position' => 'top-left',
			],
			'type'     => 'select',
			'options'  => [
				'nowrap'       => esc_html__( 'No wrap', 'bricks' ),
				'wrap'         => esc_html__( 'Wrap', 'bricks' ),
				'wrap-reverse' => esc_html__( 'Wrap reverse', 'bricks' ),
			],
			'inline'   => true,
			'css'      => [
				[
					'property' => 'flex-wrap',
				],
			],
			'required' => [ '_display', '=', 'flex' ],
		];

		$this->controls['_direction'] = [
			'label'    => esc_html__( 'Direction', 'bricks' ),
			'tooltip'  => [
				'content'  => 'flex-direction',
				'position' => 'top-left',
			],
			'type'     => 'direction',
			'css'      => [
				[
					'property' => 'flex-direction',
				],
			],
			'inline'   => true,
			'rerender' => true,
			'required' => [ '_display', '=', 'flex' ],
		];

		$this->controls['_alignSelf'] = [
			'label'    => esc_html__( 'Align self', 'bricks' ),
			'tooltip'  => [
				'content'  => 'align-self',
				'position' => 'top-left',
			],
			'type'     => 'align-items',
			'css'      => [
				[
					'property'  => 'align-self',
					'important' => true,
				],
				[
					'selector' => '',
					'property' => 'width',
					'value'    => '100%',
					'required' => 'stretch', // NOTE: Undocumented (@since 1.4)
				],
			],
			'required' => [ '_display', '=', 'flex' ],
		];

		$this->controls['_justifyContent'] = [
			'label'    => esc_html__( 'Align main axis', 'bricks' ),
			'tooltip'  => [
				'content'  => 'justify-content',
				'position' => 'top-left',
			],
			'type'     => 'justify-content',
			'css'      => [
				[
					'property' => 'justify-content',
				],
			],
			'required' => [ '_display', '=', 'flex' ],
		];

		$this->controls['_alignItems'] = [
			'label'    => esc_html__( 'Align cross axis', 'bricks' ),
			'tooltip'  => [
				'content'  => 'align-items',
				'position' => 'top-left',
			],
			'type'     => 'align-items',
			'css'      => [
				[
					'property' => 'align-items',
				],
			],
			'required' => [ '_display', '=', 'flex' ],
		];

		$this->controls['_columnGap'] = [
			'label'    => esc_html__( 'Column gap', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'column-gap',
				],
			],
			'required' => [ '_display', '=', 'flex' ],
		];

		$this->controls['_rowGap'] = [
			'label'    => esc_html__( 'Row gap', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'row-gap',
				],
			],
			'required' => [ '_display', '=', 'flex' ],
		];

		// @since 1.3.5
		$this->controls['_flexGrow'] = [
			'label'       => esc_html__( 'Flex grow', 'bricks' ),
			'type'        => 'number',
			'min'         => 0,
			'tooltip'     => [
				'content'  => 'flex-grow',
				'position' => 'top-left',
			],
			'css'         => [
				[
					'property' => 'flex-grow',
				],
			],
			'placeholder' => 0,
			'required'    => [ '_display', '=', 'flex' ],
		];

		$this->controls['_flexShrink'] = [
			'label'       => esc_html__( 'Flex shrink', 'bricks' ),
			'type'        => 'number',
			'min'         => 0,
			'tooltip'     => [
				'content'  => 'flex-shrink',
				'position' => 'top-left',
			],
			'css'         => [
				[
					'property' => 'flex-shrink',
				],
			],
			'placeholder' => 1,
			'required'    => [ '_display', '=', 'flex' ],
		];

		$this->controls['_flexBasis'] = [
			'label'          => esc_html__( 'Flex basis', 'bricks' ),
			'type'           => 'text',
			'tooltip'        => [
				'content'  => 'flex-basis',
				'position' => 'top-left',
			],
			'css'            => [
				[
					'property' => 'flex-basis',
				],
			],
			'inline'         => true,
			'small'          => true,
			'placeholder'    => 'auto',
			'hasDynamicData' => false,
			'required'       => [ '_display', '=', 'flex' ],
		];

		// TAB: STYLE

		// Inner container (direct children)
		$this->controls['_innerContainerSeparator'] = [
			'type'  => 'separator',
			'label' => esc_html__( 'Inner container', 'bricks' ) . ' / div',
			'tab'   => 'style',
			'group' => '_layout',
		];

		$this->controls['_innerContainerMargin'] = [
			'tab'   => 'style',
			'group' => '_layout',
			'label' => esc_html__( 'Margin', 'bricks' ),
			'type'  => 'spacing',
			'css'   => [
				[
					'property' => 'margin',
					'selector' => '> .brxe-container',
				],
				[
					'property' => 'margin',
					'selector' => '> .brxe-block',
				],
				[
					'property' => 'margin',
					'selector' => '> .brxe-div',
				],
			],
		];

		$this->controls['_innerContainerPadding'] = [
			'tab'   => 'style',
			'group' => '_layout',
			'label' => esc_html__( 'Padding', 'bricks' ),
			'type'  => 'spacing',
			'css'   => [
				[
					'property' => 'padding',
					'selector' => '> .brxe-container',
				],
				[
					'property' => 'padding',
					'selector' => '> .brxe-block',
				],
				[
					'property' => 'padding',
					'selector' => '> .brxe-div',
				],
			],
      'default' => [
        'top' => '200px',
        'right' => '200px',
        'bottom' => '200px',
        'left' => '200px',
      ],
    ];



        /*Element settings*/
        $this->controls['separator'] = [
            'type'       => 'separator',
        ];
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Place the content you want at the Observer and set the element to observe on mousemove. Observe is body by default.', 'bricks' )))
        ];

        $this->controls['observe'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Observe', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
			'placeholder'    => '.className',
        ];
        $this->controls['constrain'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Constrain', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'placeholder'        => '1000',
        ];
        $this->controls['perspective'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Perspective', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'placeholder'        => '100',
        ];
    }

    /*Render children*/
    public function get_nestable_children() {
        return [
          [
            'name'     => 'heading',
            'label'    => esc_html__( 'Heading', 'bricks' ),
            'settings' => [
                'text' => esc_html__( 'Wonderful Heading', 'bricks' ),
                'tag'  => 'h3',
                '_hidden'  => [
                    '_cssClasses' => 'bc-observer__eg-heading',
                ],
            ],
          ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'bc-observer-js', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_observer.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $observe = ! empty( $settings['observe'] ) ? $settings['observe'] : '';
        $constrain = ! empty( $settings['constrain'] ) ? $settings['constrain'] : '1000';
        $perspective = ! empty( $settings['perspective'] ) ? $settings['perspective'] : '100';

        $this->set_attribute( '_root', 'class', "bc-observer");
        $this->set_attribute( '_root', 'data-observe', $observe );
        $this->set_attribute( '_root', 'data-constrain', $constrain );
        $this->set_attribute( '_root', 'data-perspective', $perspective );

        $output = "
        <div {$this->render_attributes( '_root' )}>";
          $output .= \Bricks\Frontend::render_children( $this );
        $output .= "</div>";

        echo $output;
    }
}