<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Overlay_Menu extends \Bricks\Element {
  public $category     = 'Next Bricks - Menus';
  public $name         = 'overlaymenu';
  public $icon         = 'ti-menu-alt';
  public $scripts      = ['overlaymenu'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Wrap Menu', 'bricks' );
  }

  public function set_controls() {
    $this->controls['note'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'NOTE: all your body content must be placed inside Body Root element.', 'bricks' )))
    ];    

    $this->controls['overlaySeparator'] = [
      'label'      => esc_html__( 'Wrap', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['scale'] = [
      'label'       => esc_html__( 'Scale', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => '0.925',
    ];
    $this->controls['top'] = [
      'label'       => esc_html__( 'Top Distance', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => '70vh',
    ];

    $this->controls['animationSeparator'] = [
      'label'      => esc_html__( 'Animation', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['duration'] = [
      'label'       => esc_html__( 'Duration', 'bricks' ),
      'type'        => 'number',
      'unit'      => 's',
      'inline'      => true,
      'placeholder' => '1s',
    ];
    $this->controls['easing'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
          'none' => 'none',
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'custom' => 'custom'
        ],
        'inline' => true,
      'placeholder' => 'power4',
    ];
    $this->controls['customEasing'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'easing', '=', 'custom' ],
    ];

    
    $this->controls['separator'] = [
      'description' => sprintf(html_entity_decode(esc_html__( '<br>All elements with this class will toggle the menu alongside all the Burgers inside the menu.', 'bricks' ))),
      'type'       => 'separator',
    ];
    $this->controls['customtoggle'] = [
      'label'       => esc_html__( 'Custom Toggle', 'bricks' ),
      'type'        => 'text',
      'placeholder' => '.bc-core-burguer',
    ];
    $this->controls['lockBodyScrollingSeparator'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'If true, Custom Toggle will lock body scrolling on click.', 'bricks' )))
  ];
    $this->controls['lockBodyScrolling'] = [
      'label' => esc_html__( 'Lock body scrolling', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => false,
  ];

    $this->controls['accessibilitySeparator'] = [
      'label'      => esc_html__( 'Accessibility', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['closeOnEsc'] = [
      'label' => esc_html__( 'Close when pressing ESC key', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => true,
    ];  
  }
  
/*Render children*/
public function get_nestable_children() {
return [
    [
        'name'     => 'coreburguer',
        'label'    => esc_html__( 'Burger', 'bricks' ),
        'settings' => [
          '_hidden' => [
              '_cssClasses' => 'bc-core-burguer--overlay-menu',
          ],
        ],
    ],

    [
        'name'     => 'block',
        'label'    => esc_html__( 'Overlay Content', 'bricks' ),
        'settings' => [
          '_hidden'  => [
              '_cssClasses' => 'bc-overlay-menu__items-wrapper',
          ],
        ],
        'children' => [
        [
            'name'     => 'swap-hover',
        ],
        [
            'name'     => 'swap-hover',
        ],
        [
            'name'     => 'swap-hover',
        ],
        ],
    ],

    [
      'name'     => 'block',
      'label'    => esc_html__( 'Body Root', 'bricks' ),
      'settings' => [
        '_hidden' => [
            '_cssClasses' => 'bc-overlay-menu__content',
        ],
      ],
      'children' => [
        [
          'name'     => 'swap-hover',
      ],
      ],
    ],
];
}

  public function enqueue_scripts() {
    wp_enqueue_script( 'overlay-menu-js', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_overlay_menu.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $duration = ! empty( $settings['duration'] ) ? $settings['duration'] : 1;
    $top = ! empty( $settings['top'] ) ? $settings['top'] : '70vh';
    $scale = ! empty( $settings['scale'] ) ? $settings['scale'] : 0.925;
    $easing = ! empty( $settings['easing'] ) ? $settings['easing'] : 'power4.out';
    if ($easing === 'custom') {
      $easing = ! empty( $settings['customEasing'] ) ? $settings['customEasing'] : 'power4.out';
    }
    $customtoggle = ! empty( $settings['customtoggle'] ) ? $settings['customtoggle'] : '';
    $lockBodyScrolling = ! empty( $settings['lockBodyScrolling'] ) ? $settings['lockBodyScrolling'] : 0;
    $closeOnEsc = ! empty( $settings['closeOnEsc'] ) ? $settings['closeOnEsc'] : 0;

    $this->set_attribute( '_root', 'class', 'bc-core-menu' );
    $this->set_attribute( '_root', 'class', 'bc-overlay-menu' );
    $this->set_attribute( '_root', 'data-duration', $duration );
    $this->set_attribute( '_root', 'data-top', $top );
    $this->set_attribute( '_root', 'data-scale', $scale );
    $this->set_attribute( '_root', 'data-easing', $easing );
    $this->set_attribute( '_root', 'data-customtoggle', $customtoggle );
    $this->set_attribute( '_root', 'data-customtoggle-lock-body-scrolling', $lockBodyScrolling );
    $this->set_attribute( '_root', 'data-close-on-esc', $closeOnEsc);

    $output = "<div {$this->render_attributes( '_root' )}>";
    $output .= Frontend::render_children( $this ); //Menu items
    $output .= '</div>';

    echo $output;
  }
}