<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Ripplebutton extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'ripplebutton';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';
  public $scripts      = ['ripplebutton'];

  public function get_label() {
    return esc_html__( 'Ripple Button', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Ripple Button', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Link to', 'bricks' ),
      'type'  => 'link',
  ];
  $this->controls['styleSeparator'] = [
    'label'      => esc_html__( 'Style', 'bricks' ),
    'type'       => 'separator',
  ];
  $this->controls['padding'] = [
    'tab'         => 'content',
    'label'       => esc_html__( 'Padding', 'bricks' ),
    'type'        => 'spacing',
    'css'     => [
        [
          'property' => 'padding',
          'selector' => '',
        ],
      ],
      'placeholder' => [
        'top' => 15,
        'right' => 50,
        'bottom' => 15,
        'left' => 50,
      ],
    'default' => [
        'top' => '15px',
        'right' => '50px',
        'bottom' => '15px',
        'left' => '50px',
    ],
];
    $this->controls['typography'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Typography', 'bricks' ),
        'type'        => 'typography',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'typography',
              'selector' => '',
            ],
          ],
    ];
    $this->controls['border'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Border', 'bricks' ),
        'type'        => 'border',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'border',
              'selector' => '',
            ],
          ],
    ];
    $this->controls['background'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Background', 'bricks' ),
        'type'        => 'background',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'background',
              'selector' => '',
            ],
          ],
        'default' => [
            'color' => [
                'hex' => '#ffffff',
            ],
        ],
    ];

    $this->controls['maskstyleSeparator'] = [
      'label'      => esc_html__( 'Mask style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['masktypography'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Mask color', 'bricks' ),
      'type'        => 'color',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'color',
            'selector' => '&{pseudo} .bc-ripple-button__pseudo::after',
          ],
        ],
      'default' => [
          'hex' => '#ffffff',
      ],
  ];
  $this->controls['maskbackground'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Mask background', 'bricks' ),
      'type'        => 'background',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'background',
            'selector' => '&{pseudo} .bc-ripple-button__hover-fill',
          ],
        ],
      'default' => [
          'color' => [
              'hex' => '#000000',
          ],
      ],
  ];

    /*MASK*/
    $this->controls['animationSeparator'] = [
      'label'      => esc_html__( 'Animation', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['side'] = [
      'hasDynamicData' => false,
      'tab'         => 'content',
      'label'       => esc_html__( 'Side', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'From top' => 'From top',
          'From bottom' => 'From bottom',
          'From left' => 'From left',
          'From right' => 'From right',
      ],
      'clearable'   => false,
      'inline'      => true,
      'small'      => true,
      'placeholder' => 'From top',
  ];
  $this->controls['amplitude'] = [
    'hasDynamicData' => false,
      'tab'         => 'content',
      'label'       => esc_html__( 'Amplitude', 'bricks' ),
      'type' => 'number',
      'unit' => '%',
      'css'     => [
          [
            'property' => '--amplitude',
            'selector' => '',
          ],
        ],
        'placeholder'    => esc_html__( '0%', 'bricks' ),
    'default' => '0%',
];
    $this->controls['textskew'] = [
      'hasDynamicData' => false,
        'tab'         => 'content',
        'label'       => esc_html__( 'Text skew', 'bricks' ),
        'type' => 'number',
        'unit' => 'deg',
        'inline'      => true,
        'small'      => true,
        'css'     => [
            [
              'property' => '--skew-text',
              'selector' => '',
            ],
          ],
          'placeholder'    => esc_html__( '10', 'bricks' ),
      'default' => '10deg',
  ];
    $this->controls['intransitionduration'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'In transition duration', 'bricks' ),
      'type' => 'number',
      'unit' => 's',
      'inline'      => true,
      'small'      => true,
      'css'     => [
          [
            'property' => '--transition-duration-in',
            'selector' => '',
          ],
      ],
      'placeholder'    => esc_html__( '0.8s', 'bricks' ),
      'default' => '0.8s',
  ];
    $this->controls['transitionduration'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Out transition duration', 'bricks' ),
      'type' => 'number',
      'unit' => 's',
      'inline'      => true,
      'small'      => true,
      'css'     => [
          [
            'property' => '--transition-duration',
            'selector' => '',
          ],
      ],
      'placeholder'    => esc_html__( '0.8s', 'bricks' ),
      'default' => '0.8s',
  ];
    $this->controls['transitionease'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'CSS Easing', 'bricks' ),
      'type' => 'text',
      'inline'      => true,
      'css'     => [
          [
            'property' => '--transition-ease',
            'selector' => '',
          ],
        ],
        'placeholder'    => esc_html__( 'cubic-bezier(0.22, 1, 0.36, 1)', 'bricks' ),
      'default' => 'cubic-bezier(0.22, 1, 0.36, 1)',
  ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'ripplebutton', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_ripple_button.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $inner_title = ! empty( $settings['inner_title'] ) ? esc_html( $settings['inner_title'] ) : 'Next Bricks';
    $side    = ! empty( $settings['side'] ) ? $settings['side'] : 'From top';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $additionalClasses = '';
    if ($side === 'From bottom') {
        $additionalClasses = 'bc-ripple-button--from-bottom';
    } elseif ($side === 'From left') {
        $additionalClasses = 'bc-ripple-button--from-left';
    } elseif ($side === 'From right') {
        $additionalClasses = 'bc-ripple-button--from-right';
    }
    
    $this->set_attribute( '_root', 'class', "bc-ripple-button" );
    $output = "
    <$root_tag {$this->render_attributes( '_root' )} data-type='$additionalClasses'>
      <span class='bc-ripple-button__hover-fill'></span>
      <span class='bc-ripple-button__pseudo' data-content='$inner_title'>
        <span class='bc-ripple-button__text'>
        $inner_title
        </span>
      </span>
    </$root_tag>
    ";

	echo $output;
  }
}



