<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Scrollbar extends \Bricks\Element {
  public $category     = 'Next Bricks - Cores';
  public $name         = 'Scrollbar';
  public $icon         = 'fas fa-grip-lines-vertical';
  public $css_selector = '';

  public function get_label() {
    return esc_html__( 'Scrollbar', 'bricks' );
  }

  public function set_controls() {
    $this->controls['note'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'NOTE: <br>Scrollbar can only be visible on the front.', 'bricks' )))
    ];
    $this->controls['target'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Target', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'body',
    ];

    $this->controls['settingsSeparator'] = [
      'label'      => esc_html__( 'Settings', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['overflowy'] = [
      'tab' => 'content',
      'label' => esc_html__( 'OverflowY', 'bricks' ),
      'type' => 'select',
      'options'     => [
        'scroll' => 'scroll',
        'hidden' => 'hidden',
    ],
      'inline' => true,
      'placeholder' => 'scroll',
    ];
    $this->controls['overflowx'] = [
      'tab' => 'content',
      'label' => esc_html__( 'OverflowX', 'bricks' ),
      'type' => 'select',
      'options'     => [
        'scroll' => 'scroll',
        'hidden' => 'hidden',
    ],
      'inline' => true,
      'placeholder' => 'hidden',
    ];
    $this->controls['visibility'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Visibility', 'bricks' ),
      'type' => 'select',
      'options'     => [
        'auto' => 'auto',
        'hidden' => 'hidden',
    ],
      'inline' => true,
      'placeholder' => 'auto',
    ];
    $this->controls['autohide'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Autohide', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'never' => 'never',
          'scroll' => 'scroll',
          'leave' => 'leave',
          'move' => 'move',
      ],
      'inline'      => true,
      'placeholder' => 'never',
    ];
    $this->controls['autohidedelay'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Autohide Delay', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => '500',
    ];





    $this->controls['thumbSeparator'] = [
      'label'      => esc_html__( 'Thumb', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['thumbcolor'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type' => 'color',
      'inline' => true,
      'css'     => [
        [
          'property' => '--thumb-color',
          'selector' => '.bc-data-scrollbar',
        ],
      ],
      'default' => [
          'hex' => '#000000',
          'alpha' => 0.44,
      ],
  ];
    $this->controls['thumbcolorhover'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Hover color', 'bricks' ),
      'type' => 'color',
      'inline' => true,
      'css'     => [
        [
          'property' => '--thumb-hovercolor',
          'selector' => '.bc-data-scrollbar',
        ],
      ],
      'default' => [
          'hex' => '#000000',
          'alpha' => 0.55,
      ],
  ];
    $this->controls['thumbcoloractive'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Active color', 'bricks' ),
      'type' => 'color',
      'inline' => true,
      'css'     => [
        [
          'property' => '--thumb-activecolor',
          'selector' => '.bc-data-scrollbar',
        ],
      ],
      'default' => [
          'hex' => '#000000',
          'alpha' => 0.66,
      ],
  ];
    $this->controls['thumbborderradius'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Border-radius', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline' => true,
      'placeholder' => '10px',
    ];


    $this->controls['trackSeparator'] = [
      'label'      => esc_html__( 'Track', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['tracksize'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline' => true,
      'placeholder' => '6px',
    ];
    $this->controls['trackmarginright'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Horizontal padding', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline' => true,
      'placeholder' => '2px',
    ];
    $this->controls['trackmargintopbottom'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Vertical padding', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline' => true,
      'placeholder' => '2px',
    ];
    $this->controls['trackcolor'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type' => 'color',
      'inline' => true,
      'css'     => [
        [
          'property' => '--track-color',
          'selector' => '.bc-data-scrollbar',
        ],
      ],
      'default' => [
          'hex' => '#000000',
          'alpha' => 0.0,
      ],
  ];
    $this->controls['trackcolorhover'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Hover color', 'bricks' ),
      'type' => 'color',
      'inline' => true,
      'css'     => [
        [
          'property' => '--track-hovercolor',
          'selector' => '.bc-data-scrollbar',
        ],
      ],
      'default' => [
          'hex' => '#000000',
          'alpha' => 0.0,
      ],
  ];
    $this->controls['trackcoloractive'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Active color', 'bricks' ),
      'type' => 'color',
      'inline' => true,
      'css'     => [
        [
          'property' => '--track-activecolor',
          'selector' => '.bc-data-scrollbar',
        ],
      ],
      'default' => [
          'hex' => '#000000',
          'alpha' => 0.0,
      ],
  ];
    $this->controls['trackborderradius'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Border-radius', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline' => true,
      'placeholder' => '10px',
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'scrollbar', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_scrollbar.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);

    wp_enqueue_style( 'scrollbars-css', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_overlayscrollbars.min.css', array(), NEXTBRICKS_VERSION, false);

    wp_enqueue_script( 'scrollbars-js', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_overlayscrollbars.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;

    $target = ! empty( $settings['target'] ) ? $settings['target'] : 'body';
    $tracksize = ! empty( $settings['tracksize'] ) ? $settings['tracksize'] : '6px';
    $thumbborderradius = ! empty( $settings['thumbborderradius'] ) ? $settings['thumbborderradius'] : '10px';
    $trackmarginright = ! empty( $settings['trackmarginright'] ) ? $settings['trackmarginright'] : '2px';
    $trackmargintopbottom = ! empty( $settings['trackmargintopbottom'] ) ? $settings['trackmargintopbottom'] : '2px';
    $trackborderradius = ! empty( $settings['trackborderradius'] ) ? $settings['trackborderradius'] : '10px';
    $overflowy = ! empty( $settings['overflowy'] ) ? $settings['overflowy'] : 'scroll';
    $overflowx = ! empty( $settings['overflowx'] ) ? $settings['overflowx'] : 'hidden';
    $visibility = ! empty( $settings['visibility'] ) ? $settings['visibility'] : 'auto';
    $autohide = ! empty( $settings['autohide'] ) ? $settings['autohide'] : 'never';
    $autohidedelay = ! empty( $settings['autohidedelay'] ) ? $settings['autohidedelay'] : '500';


    $this->set_attribute( 'inner', 'class', 'bc-data-scrollbar' );
    $this->set_attribute( 'inner', 'data-target', "$target");
    $this->set_attribute( 'inner', 'data-tracksize', "$tracksize");
    $this->set_attribute( 'inner', 'data-thumbborderradius', "$thumbborderradius");
    $this->set_attribute( 'inner', 'data-trackmarginright', "$trackmarginright");
    $this->set_attribute( 'inner', 'data-trackmargintopbottom', "$trackmargintopbottom");
    $this->set_attribute( 'inner', 'data-trackborderradius', "$trackborderradius");
    $this->set_attribute( 'inner', 'data-overflowy', $overflowy);
    $this->set_attribute( 'inner', 'data-overflowx', $overflowx);
    $this->set_attribute( 'inner', 'data-visibility', $visibility);
    $this->set_attribute( 'inner', 'data-autohide', $autohide);
    $this->set_attribute( 'inner', 'data-autohidedelay', $autohidedelay);


    $output = "<div {$this->render_attributes( '_root' )} >";
    $output .=
    "<div {$this->render_attributes( 'inner' )}>

    </div>";
    $output .= '</div>';


		echo $output;
  }
}

