<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Split_Button extends \Bricks\Element {
    public $category     = 'Next Bricks - Buttons';
    public $name         = 'split_button';
    public $icon         = 'fa-solid fa-square-minus';
    public $tag      = 'button';
    public $scripts      = ['bc_split_button'];
    public $nestable     = true;

    public function get_label() {
    return esc_html__( 'Split Button', 'bricks' );
    }

    public function set_controls() {
      $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'div' => 'div',
            'span' => 'span',
            'button' => 'button',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'button',
        'default'     => 'button',
    ];
    $this->controls['customTag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Custom tag', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'placeholder' => 'button',
        'required'    => [ 'tag', '=', 'custom' ],
    ];
        $this->controls['_children'] = [
            'type'          => 'repeater',
            'titleProperty' => 'label',
            'items'         => 'children',
        ];
        $this->controls['settingsSeparator'] = [
            'label'      => esc_html__( 'Settings', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['displaybuilder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Display at the builder', 'bricks' ),
            'type'     => 'checkbox',
            'default' => false,
        ];
        $this->controls['inner_title'] = [
            'tab'            => 'content',
            'type'           => 'text',
            'hasDynamicData' => 'text',
            'label'      => esc_html__( 'Title', 'bricks' ),
            'default'        => esc_html__( 'Reach us!', 'bricks' ),
            'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
        ];

        $this->controls['styleSeparator'] = [
            'label'      => esc_html__( 'Split Button Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['padding'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Padding', 'bricks' ),
            'type'    => 'spacing',
            'css'     => [
              [
                'property' => 'padding',
                'selector' => '&{pseudo} .bc-split-button__btn',
              ],
            ],
        ];
        $this->controls['typography'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Typography', 'bricks' ),
            'type'    => 'typography',
            'css'     => [
              [
                'property' => 'typography',
                'selector' => '&{pseudo} .bc-split-button__btn',
              ],
            ],
        ];
        $this->controls['background'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Background', 'bricks' ),
            'type'    => 'background',
            'css'     => [
              [
                'property' => 'background',
                'selector' => '&{pseudo} .bc-split-button__morph-bg',
              ],
            ],
        ];
        $this->controls['border'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Border', 'bricks' ),
            'type'    => 'border',
            'css'     => [
              [
                'property' => 'border',
                'selector' => '&{pseudo} .bc-split-button__morph-bg',
              ],
              [
                'property' => 'border',
                'selector' => '&{pseudo} .bc-split-button__btn',
              ],
            ],
        ];
        $this->controls['boxShadow'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Box Shadow', 'bricks' ),
            'type'    => 'box-shadow',
            'css'     => [
              [
                'property' => 'box-shadow',
                'selector' => '&{pseudo} .bc-split-button__morph-bg',
              ],
            ],
        ];
        $this->controls['gap'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Gap between', 'bricks' ),
            'type'    => 'number',
            'units'    => true,
            'css'     => [
              [
                'property' => 'gap',
                'selector' => '&{pseudo} .bc-split-button__btn',
              ],
            ],
        ];
        $this->controls['arrowDimensions'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Arrow dimensions', 'bricks' ),
            'type'    => 'number',
            'units'    => true,
            'css'     => [
              [
                'property' => '--dimensions',
                'selector' => '&{pseudo} .bc-split-button__btn-icon',
              ],
            ],
            'placeholder' => '12px',
        ];

        $this->controls['splittedsSeparator'] = [
            'label'      => esc_html__( 'Splitted Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['marginSplitted'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Margin', 'bricks' ),
            'type'    => 'spacing',
            'css'     => [
              [
                'property' => 'margin',
                'selector' => '&{pseudo} .bc-split-button__list-item',
              ],
            ],
        ];
        $this->controls['paddingSplitted'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Padding', 'bricks' ),
            'type'    => 'spacing',
            'css'     => [
              [
                'property' => 'padding',
                'selector' => '&{pseudo} .bc-split-button__list-item',
              ],
            ],
        ];
        $this->controls['typographySplitted'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Typography', 'bricks' ),
            'type'    => 'typography',
            'css'     => [
              [
                'property' => 'typography',
                'selector' => '&{pseudo} .bc-split-button__list-item',
              ],
            ],
        ];
        $this->controls['borderSplitted'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Border', 'bricks' ),
            'type'    => 'border',
            'css'     => [
              [
                'property' => 'border',
                'selector' => '&{pseudo} .bc-split-button__list-item',
              ],
            ],
        ];
        $this->controls['backgroundHoverSplitted'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Background on Hover', 'bricks' ),
            'type'    => 'color',
            'css'     => [
              [
                'property' => '--hover-background',
                'selector' => '',
              ],
            ],
        ];

        $this->controls['animationSeparator'] = [
            'label'      => esc_html__( 'Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['translatey'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Translate items on click', 'bricks' ),
            'type'    => 'number',
            'units'    => true,
            'css'     => [
              [
                'property' => '--translate-y',
                'selector' => '&{pseudo} .bc-split-button__btn',
              ],
            ],
            'placeholder' => '2px',
        ];
        $this->controls['duration'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Duration', 'bricks' ),
            'type'    => 'number',
            'unit'    => 's',
            'css'     => [
              [
                'property' => '--transition-duration',
                'selector' => '',
              ],
            ],
            'placeholder' => '0.3s',
        ];
        $this->controls['easing'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Easing', 'bricks' ),
            'type'    => 'text',
            'css'     => [
              [
                'property' => '--transition-easing',
                'selector' => '',
              ],
            ],
            'placeholder' => 'ease',
            'inline'    => true,
        ];
    }

    /*Render children*/
    public function get_nestable_children() {
        return [
            [
                'name'     => 'heading',
                'label'    => esc_html__( 'Splitted', 'bricks' ),
                'settings' => [
                    'text' => esc_html__( 'great@domain.com', 'bricks' ),
                    'tag'  => 'span',
                    '_hidden'  => [
                        '_cssClasses' => 'bc-split-button__list-item js-bc-split-button__item',
                    ],
                ],
            ],

            [
                'name'     => 'heading',
                'label'    => esc_html__( 'Splitted', 'bricks' ),
                'settings' => [
                    'text' => esc_html__( '+0 123 456 789', 'bricks' ),
                    'tag'  => 'span',
                    '_hidden'  => [
                        '_cssClasses' => 'bc-split-button__list-item js-bc-split-button__item',
                    ],
                ],
            ],
        ];
      }

    public function enqueue_scripts() {
        wp_enqueue_script( 'bc_split_button', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_split_button.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Reach us!';
        $displaybuilder    = ! empty( $settings['displaybuilder'] ) ? $settings['displaybuilder'] : 0;

        $this->set_attribute( '_root', 'class', 'bc-split-button');

        $output = "<div {$this->render_attributes( '_root' )}
            data-display-builder='{$displaybuilder}'>";
            $output .= "<{$this->tag} class='bc-split-button__btn' aria-controls='bc-split-button-list'>";
                $output .= "<span>$inner_title</span>";
                $output .= "<svg class='bc-split-button__btn-icon cd-icon' viewBox='0 0 12 12'> <!--arrow icon-->
                                <g fill='currentColor'>
                                    <path fill='none' stroke='currentColor' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M11 4l-5 5-5-5'></path>
                                </g>
                            </svg>";
            $output .= "</{$this->tag}>";
            $output .= "<div class='bc-split-button__list-wrapper' id='bc-split-button-list'>";
                $output .= "<div class='bc-split-button__list'>";
                    $output .= Frontend::render_children( $this );
                $output .= "</div>";
            $output .= "</div>";

            $output .= "<span class='bc-split-button__morph-bg' aria-hidden='true'></span>";
        $output .= "</div>";

        echo $output;
    }
}