<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Stripe_megaMenu extends Element {
  public $category     = 'Next Bricks - Menus';
  public $name         = 'stripemegamenu';
  public $icon         = 'ti-layout-media-right';
  public $tag      = 'div';
  public $scripts      = ['stripemegamenu'];
  public $nestable     = true;

public function get_label() {
    return esc_html__( 'Stripe megaMenu', 'bricks' );
}

public function set_controls() {
    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'div' => 'div',
            'section' => 'section',
            'nav' => 'nav',
            'aside' => 'aside',
            'header' => 'header',
            'footer' => 'footer',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'div',
        'default'     => 'div',
    ];
    $this->controls['customTag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Custom tag', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'placeholder' => 'div',
        'required'    => [ 'tag', '=', 'custom' ],
    ];
    $this->controls['noteaux'] = [
        'tab' => 'content',
        'description' => sprintf(html_entity_decode(esc_html__( "Each dropdown is assigned to each nav item in order. First dropdown is for first Nav Item, second dropdown is for second Nav Item and so on.<br>By giving the following class to a Nav Item it will be skipped from the workflow.", 'bricks' )))
    ];
    $this->controls['skipclass'] = [
        'label' => esc_html__( 'Skip class', 'bricks' ),
        'type' => 'text',
        'placeholder' => 'className',
    ];
    $this->controls['noteaux23'] = [
        'tab' => 'content',
        'description' => sprintf(html_entity_decode(esc_html__( "If you want to include a custom element as a Nav Item set to it the following class: bc-stripe__has-dropdown", 'bricks' )))
    ];
    $this->controls['arrowSeparator'] = [
        'label'      => esc_html__( 'Arrow', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['enablearrow'] = [
        'label' => esc_html__( 'Enable', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'small' => true,
        'default' => true,
    ];
    $this->controls['arrowcolor'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Color', 'bricks' ),
        'type'        => 'color',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--arrow-color',
              'selector' => '',
            ],
        ],
        'required' => [ 'enablearrow', '=', true],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];
    $this->controls['arrowsize'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Size', 'bricks' ),
        'type'        => 'number',
        'units'        => true,
        'inline'      => true,
        'css'     => [
            [
              'property' => '--arrow-size',
              'selector' => '',
            ],
        ],
        'placeholder' => '8px',
        'required' => [ 'enablearrow', '=', true],
        'default' => '8px',
    ];

    $this->controls['dropdownSeparator'] = [
        'label'      => esc_html__( 'Dropdown', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['noteaux2'] = [
        'tab' => 'content',
        'description' => sprintf(html_entity_decode(esc_html__( 'Each Dropdown element has a "Display at the builder" option at its content settings for a comfortable building.', 'bricks' )))
    ];
    $this->controls['dropdownpadding'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Padding', 'bricks' ),
        'type'        => 'spacing',
        'css'     => [
            [
              'property' => 'padding',
              'selector' => '.bc-stripe__dropdown-list .bc-stripe__content',
            ],
        ],
      'default' => [
        'top' => '25px',
        'right' => '25px',
        'bottom' => '25px',
        'left' => '25px',
      ],
    ];
    $this->controls['dropdownbackground'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Background', 'bricks' ),
        'type'        => 'background',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'background',
              'selector' => '.bc-stripe__dropdown-list',
            ],
        ],
        'default' => [
            'color' => [
                'hex' => '#ffffff',
            ],
        ],
    ];
    $this->controls['dropdownborder'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Border', 'bricks' ),
        'type'        => 'border',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'border',
              'selector' => '.bc-stripe__dropdown-list',
            ],
        ],
    ];
    $this->controls['dropdownboxshadow'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Box shadow', 'bricks' ),
        'type'        => 'box-shadow',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'box-shadow',
              'selector' => '.bc-stripe__dropdown-list',
            ],
        ],
        'default' => [
            'values' => [
                'offsetX' => '0',
                'offsetY' => '0',
                'blur' => '0',
                'spread' => '0',
            ],
            'color' => [
                'hex' => '#000000',
                'alpha' => 0,
            ],
        ],
    ];
    $this->controls['topdistance'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Top distance', 'bricks' ),
        'type'        => 'number',
        'units'        => true,
        'inline'      => true,
        'css'     => [
            [
              'property' => '--top-distance',
              'selector' => '',
            ],
        ],
        'placeholder' => '60px',
        'default' => '60px',
    ];
    $this->controls['fromtranslation'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'From translation', 'bricks' ),
        'type'        => 'number',
        'units'        => true,
        'inline'      => true,
        'css'     => [
            [
              'property' => '--from-distance',
              'selector' => '',
            ],
        ],
        'placeholder' => '20px',
        'default' => '20px',
    ];
    $this->controls['fromduration'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'From duration', 'bricks' ),
        'type'        => 'number',
        'unit'        => 's',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--from-duration',
              'selector' => '',
            ],
        ],
        'placeholder' => '0.3s',
        'default' => '0.3s',
    ];
    $this->controls['stripeSeparator'] = [
        'label'      => esc_html__( 'Stripe', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['stripedistance'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Stripe path', 'bricks' ),
        'type'        => 'number',
        'units'        => true,
        'inline'      => true,
        'css'     => [
            [
              'property' => '--stripe-distance',
              'selector' => '',
            ],
        ],
        'placeholder' => '100px',
        'default' => '100px',
    ];
    $this->controls['stripeduration'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Stripe duration', 'bricks' ),
        'type'        => 'number',
        'unit'        => 's',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--stripe-duration',
              'selector' => '',
            ],
        ],
        'placeholder' => '0.3s',
        'default' => '0.3s',
    ];
    $this->controls['opacityduration'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Opacity duration', 'bricks' ),
        'type'        => 'number',
        'unit'        => 's',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--opacity-duration',
              'selector' => '',
            ],
        ],
        'placeholder' => '0.3s',
        'default' => '0.3s',
    ];
    
    //Responsive
    $this->controls['responsiveSeparator'] = [
        'label'      => esc_html__( 'Responsive', 'bricks' ),
        'type'       => 'separator',
    ];

    $this->controls['enablemobilemenu'] = [
      'label' => esc_html__( 'Enable Mobile Menu', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => false,
    ];

    $this->controls['displaybuilderresponsive'] = [
        'label' => esc_html__( 'Display at the builder', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'small' => true,
        'required' => [ 'enablemobilemenu', '=', true],
    ];

    $this->controls['note'] = [
        'description' => sprintf(html_entity_decode(esc_html__( 'Select a breakpoint to determine at which pixel to display Core Burger and Menu.', 'bricks' ))),
        'required' => [ 'enablemobilemenu', '=', true],
    ];

    //Breakpoints control
    $breakpoints        = Breakpoints::$breakpoints;
    $breakpoint_options = [];

    foreach ( $breakpoints as $index => $breakpoint ) {
        $breakpoint_options[ $breakpoint['key'] ] = $breakpoint['label'];
    }

    $this->controls['mobileMenu'] = [
        'type'        => 'select',
        'options'     => $breakpoint_options,
        'rerender'    => true,
        'placeholder' => esc_html__( 'Mobile landscape', 'bricks' ),
        'required' => [ 'enablemobilemenu', '=', true],
    ];
}

public function get_nestable_children() {
    return [
        [
            'name'     => 'coreburguer',
            'settings' => [
                '_hidden'  => [
                    '_cssClasses' => 'bc-stripe__coreburguer',
                ],
              ],
        ],

        [
            'name'     => 'block',
            'label'    => esc_html__( 'Nav', 'bricks' ),
            'settings' => [
              '_hidden'  => [
                  '_cssClasses' => 'bc-stripe__main-nav',
              ],
            ],
            'children' => [
            [
                'name'     => 'heading',
                'label'    => esc_html__( 'Nav Item', 'bricks' ),
                'settings' => [
                    'text' => esc_html__( 'About', 'bricks' ),
                    'tag'  => 'span',
                    '_hidden'  => [
                        '_cssClasses' => 'bc-stripe__has-dropdown',
                    ],
                    '_attributes' => [
                        [
                        'name' => 'tabindex',
                        'value' => '0',
                        ],
                    ]
                ],
            ],
            [
                'name'     => 'heading',
                'label'    => esc_html__( 'Nav Item', 'bricks' ),
                'settings' => [
                    'text' => esc_html__( 'Stories', 'bricks' ),
                    'tag'  => 'span',
                    '_hidden'  => [
                        '_cssClasses' => 'bc-stripe__has-dropdown',
                    ],
                    '_attributes' => [
                        [
                        'name' => 'tabindex',
                        'value' => '0',
                        ],
                    ]
                ],
            ],
            [
                'name'     => 'heading',
                'label'    => esc_html__( 'Nav Item', 'bricks' ),
                'settings' => [
                    'text' => esc_html__( 'Contact', 'bricks' ),
                    'tag'  => 'span',
                    '_hidden'  => [
                        '_cssClasses' => 'bc-stripe__has-dropdown',
                    ],
                    '_attributes' => [
                        [
                        'name' => 'tabindex',
                        'value' => '0',
                        ],
                    ]
                ],
            ],
            ],
        ],
    
        [
            'name' => 'stripemmdropdownlist',
            'children' => [
                [
                    'name'     => 'stripemmdropdownitem',
                    'label'    => esc_html__( 'Dropdown', 'bricks' ),
                    'children' => [
                        [
                            'name'     => 'heading',
                            'label'    => esc_html__( 'Mobile Nav Item', 'bricks' ),
                            'settings' => [
                                'text' => esc_html__( 'About', 'bricks' ),
                                'tag'  => 'span',
                                '_hidden'  => [
                                    '_cssClasses' => 'bc-stripe__label',
                                ],
                            ],
                        ],
                        [
                            'name'     => 'text-basic',
                            'label'    => esc_html__( 'Basic Text', 'bricks' ),
                            'settings' => [
                                'text' => esc_html__( 'Place the content you want at the Dropdown without deleting its Mobile Nav Item', 'bricks' ),
                                'tag'  => 'p',
                                '_hidden'  => [
                                    '_cssClasses' => 'bc-stripe__paragraph-test',
                                ],
                            ],
                        ],
                    ],
                ],
                [
                    'name'     => 'stripemmdropdownitem',
                    'label'    => esc_html__( 'Dropdown', 'bricks' ),
                    'children' => [
                        [
                            'name'     => 'heading',
                            'label'    => esc_html__( 'Mobile Nav Item', 'bricks' ),
                            'settings' => [
                                'text' => esc_html__( 'Stories', 'bricks' ),
                                'tag'  => 'span',
                                '_hidden'  => [
                                    '_cssClasses' => 'bc-stripe__label',
                                ],
                            ],
                        ],
                        [
                            'name'     => 'text-basic',
                            'label'    => esc_html__( 'Basic Text', 'bricks' ),
                            'settings' => [
                                'text' => esc_html__( 'Place the content you want at the Dropdown without deleting its Mobile Nav Item', 'bricks' ),
                                'tag'  => 'p',
                                '_hidden'  => [
                                    '_cssClasses' => 'bc-stripe__paragraph-test bc-stripe__paragraph-test--v2',
                                ],
                            ],
                        ],
                    ],
                ],
                [
                    'name'     => 'stripemmdropdownitem',
                    'label'    => esc_html__( 'Dropdown', 'bricks' ),
                    'children' => [
                        [
                            'name'     => 'heading',
                            'label'    => esc_html__( 'Mobile Nav Item', 'bricks' ),
                            'settings' => [
                                'text' => esc_html__( 'Contact', 'bricks' ),
                                'tag'  => 'span',
                                '_hidden'  => [
                                    '_cssClasses' => 'bc-stripe__label',
                                ],
                            ],
                        ],
                        [
                            'name'     => 'text-basic',
                            'label'    => esc_html__( 'Basic Text', 'bricks' ),
                            'settings' => [
                                'text' => esc_html__( 'Place the content you want at the Dropdown without deleting its Mobile Nav Item.', 'bricks' ),
                                'tag'  => 'p',
                                '_hidden'  => [
                                    '_cssClasses' => 'bc-stripe__paragraph-test',
                                ],
                            ],
                        ],
                    ],
                ],
            ],
        ],
    ];
}

public function enqueue_scripts() {
    wp_enqueue_script( 'stripe-megamenu', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_stripe_megamenu.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);

    wp_enqueue_script( 'jquery-core' );
}

public function render() {
    $settings = $this->settings;
    $enablearrow = ! empty( $settings['enablearrow'] ) ? $settings['enablearrow'] : false;
    $enablemobilemenu = ! empty( $settings['enablemobilemenu'] ) ? $settings['enablemobilemenu'] : false;
    $displaybuilderresponsive = ! empty( $settings['displaybuilderresponsive'] ) ? $settings['displaybuilderresponsive'] : false;
    $show_nav_button_at = ! empty( $settings['mobileMenu'] ) ? $settings['mobileMenu'] : 'mobile_landscape';
    $breakpoint = Breakpoints::get_breakpoint_by( 'key', $show_nav_button_at );
    $breakpoint_width    = ! empty( $breakpoint['width'] ) ? intval( $breakpoint['width'] ) : 0;
    $skipclass = ! empty( $settings['skipclass'] ) ? $settings['skipclass'] : '';

    $this->set_attribute( '_root', 'class', 'bc-stripe' );

    $output = "
    <{$this->tag} {$this->render_attributes( '_root' )}
        data-enablemobilemenu='{$enablemobilemenu}'
        data-displaybuilderresponsive='{$displaybuilderresponsive}'
        data-breakpoint='{$breakpoint_width}'
        data-skipclass='{$skipclass}'" . ($enablearrow ? " data-arrow='arrow-enable'" : "") . ">
    <a href='#0' class='bc-stripe__nav-trigger'>Open Nav<span aria-hidden='true'></span></a>";
    $output .= Frontend::render_children( $this );
    $output .= "</{$this->tag}>";

    $nav_menu_inline_css = '';
    if($enablemobilemenu){
        $nav_menu_inline_css .= "@media (max-width: {$breakpoint_width}px) {";
        $nav_menu_inline_css .= "
        .bc-stripe__dropdown-list, 
        .bc-stripe__dropdown, 
        .bc-stripe__morph-dropdown-wrapper{ 
          all: unset;
        }
        .bc-stripe::before{
          content: 'mobile';
          display: none;
        }
        .bc-stripe__main-nav{
          display: none;
        }
        .bc-stripe__content .bc-stripe__dropdown::after{
          clear: both;
          content: '';
        }
        [data-open='bc-stripe--opened'] .bc-stripe__morph-dropdown-wrapper{
          display: block;
        }
        .bc-stripe__morph-dropdown-wrapper{
          display: none;
          position: absolute;
    
          top: 0;
          left: 0;
          width: 100%;
        }
        .bc-stripe__label{
          display: block;
        }
        .bc-stripe__coreburguer{
          display: flex;
  
          position: absolute;
          z-index: 10;
          top: 10px;
          right: 10px;
        }
        ";
        $nav_menu_inline_css .= '}';
    
        $output .= "<style>$nav_menu_inline_css</style>";
    }

    echo $output;
}
}
