<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Typed extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'bc-typed';
  public $icon         = 'ion-md-code-working';
  public $tag      = 'h3';
  public $scripts      = ['bc_typed'];

  public function get_label() {
    return esc_html__( 'Typed', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'h1' => 'h1',
          'h2' => 'h2',
          'h3' => 'h3',
          'h4' => 'h4',
          'h5' => 'h5',
          'h6' => 'h6',
          'p' => 'p',
          'span' => 'span',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'h3',
      'default'     => 'h3',
    ];
    $this->controls['customTag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Custom tag', 'bricks' ),
			'type'        => 'text',
			'inline'      => true,
			'placeholder' => 'h3',
			'required'    => [ 'tag', '=', 'custom' ],
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];
    $this->controls['typedSeparator'] = [
        'label'      => esc_html__( 'Typed', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['typedtitles'] = [
        'tab'           => 'content',
        'type'          => 'repeater',
        'label'         => esc_html__( 'Typed Titles', 'bricks' ),
        'titleProperty' => 'title',
        'default'       => [
            [ 'title' => 'First sentence' ],
            [ 'title' => 'Second sentence' ],
            [ 'title' => 'Third sentence' ],
        ],
        'placeholder'   => esc_html__( 'Typed Title', 'bricks' ),
        'fields'        => [
            'title' => [
                'label' => esc_html__( 'Title', 'bricks' ),
                'type'  => 'textarea',
            ],
        ],
        'reloadScripts' => true,
    ];
    $this->controls['titleTypography'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Typography', 'bricks' ),
      'type'    => 'typography',
        'css'     => [
        [
          'property' => 'typography',
          'selector' => '',
        ],
      ],
    ];

    $this->controls['prefixsufixSeparator'] = [
      'label'      => esc_html__( 'Prefix & Sufix', 'bricks' ),
      'type'       => 'separator',
  ];
    $this->controls['prefix'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Prefix', 'bricks' ),
      'type' => 'text',
      'inline'      => true,
      'hasDynamicData' => true,
      'placeholder' => '',
    ];
    $this->controls['prefixTypography'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Prefix typography', 'bricks' ),
      'type'    => 'typography',
        'css'     => [
        [
          'property' => 'typography',
          'selector' => '.bc-typed__prefix',
        ],
      ],
    ];
    $this->controls['sufix'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Sufix', 'bricks' ),
      'type' => 'text',
      'inline'      => true,
      'hasDynamicData' => true,
      'placeholder' => '',
    ];
    $this->controls['sufixTypography'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Sufix typography', 'bricks' ),
      'type'    => 'typography',
        'css'     => [
        [
          'property' => 'typography',
          'selector' => '.bc-typed__sufix',
        ],
      ],
    ];

    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];

    $this->controls['disablebuilder'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
        'type'     => 'checkbox',
        'default' => true,
    ];
    $this->controls['initOnScroll'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Fire on scroll', 'bricks' ),
        'type'     => 'checkbox',
        'default' => true,
    ];
    $this->controls['typeSpeed'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Type speed', 'bricks' ),
        'type'     => 'text',
        'inline' => true,
        'small' => true,
        'placeholder' => '20',
    ];
    $this->controls['backSpeed'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Back speed', 'bricks' ),
        'type'     => 'text',
        'inline' => true,
        'small' => true,
        'placeholder' => '20',
    ];
    $this->controls['startDelay'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Start delay', 'bricks' ),
        'type'     => 'text',
        'inline' => true,
        'small' => true,
        'placeholder' => '0',
    ];
    $this->controls['backDelay'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Back delay', 'bricks' ),
        'type'     => 'text',
        'inline' => true,
        'small' => true,
        'placeholder' => '700',
    ];
    $this->controls['shuffle'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Shuffle', 'bricks' ),
        'type'     => 'checkbox',
    ];

    //loop
    $this->controls['loop'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Loop', 'bricks' ),
        'type'     => 'checkbox',
        'default' => true,
    ];
    $this->controls['loopCount'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Loop count', 'bricks' ),
        'type'     => 'text',
        'placeholder' => 'Infinity',
        'inline' => true,
        'required' => [ 'loop', '=', true],
    ];

    //show cursor
    $this->controls['showCursor'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Show cursor', 'bricks' ),
        'type'     => 'checkbox',
        'default' => true,
    ];
    $this->controls['cursorChar'] = [
        'hasDynamicData' => true,
        'tab' => 'content',
        'label'    => esc_html__( 'Cursor character', 'bricks' ),
        'type'     => 'text',
        'placeholder' => '|',
        'inline' => true,
        'required' => [ 'showCursor', '=', true],
    ];
    $this->controls['cursorCharStyle'] = [
      'tab' => 'content',
      'label'    => esc_html__( 'Character typography', 'bricks' ),
      'type'     => 'typography',
      'css'     => [
        [
          'property' => 'typography',
          'selector' => '.typed-cursor',
        ],
      ],
      'required' => [ 'showCursor', '=', true],
    ];

    //fade
    $this->controls['fade'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Fade', 'bricks' ),
        'type'     => 'checkbox',
        'reloadScripts' => true,
    ];
    $this->controls['fadeDelay'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Fade Delay', 'bricks' ),
        'type'     => 'text',
        'placeholder' => '500',
        'inline' => true,
        'required' => [ 'fade', '=', true],
    ];

    //Padding from style tab applied to the root without link and to the link if exists
    $this->controls['_padding'] = [
      'tab'   => 'style',
      'group' => '_layout',
      'label' => esc_html__( 'Padding', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'padding',
          'selector' => '&:not(:has(> a)), > a',
        ]
      ],
    ];
  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'bc-typed', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_typed.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);

    wp_enqueue_script( 'bc-typedjs', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_typedjs.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
    $initOnScroll    = ! empty( $settings['initOnScroll'] ) ? $settings['initOnScroll'] : 0;

    $typeSpeed    = ! empty( $settings['typeSpeed'] ) ? $settings['typeSpeed'] : 20;
    $backSpeed    = ! empty( $settings['backSpeed'] ) ? $settings['backSpeed'] : 20;
    $startDelay    = ! empty( $settings['startDelay'] ) ? $settings['startDelay'] : 0;
    $backDelay    = ! empty( $settings['backDelay'] ) ? $settings['backDelay'] : 700;
    $shuffle    = ! empty( $settings['shuffle'] ) ? $settings['shuffle'] : 0;
    $loop    = ! empty( $settings['loop'] ) ? $settings['loop'] : 0;
    $loopCount    = ! empty( $settings['loopCount'] ) ? $settings['loopCount'] : 'Infinity';
    $showCursor    = ! empty( $settings['showCursor'] ) ? $settings['showCursor'] : 0;
    $cursorChar    = ! empty( $settings['cursorChar'] ) ? $settings['cursorChar'] : '|';
    $fade    = ! empty( $settings['fade'] ) ? $settings['fade'] : 0;
    $fadeDelay    = ! empty( $settings['fadeDelay'] ) ? $settings['fadeDelay'] : 500;

    $prefix    = ! empty( $settings['prefix'] ) ? $settings['prefix'] : '';
    $sufix    = ! empty( $settings['sufix'] ) ? $settings['sufix'] : '';

    $typedtitles = ! empty( $settings['typedtitles'] ) ? $settings['typedtitles'] : '';
    if ($typedtitles) {
        $typedtitles_array = '';
        foreach ( $typedtitles as $typedtitle ) {
            if ( isset($typedtitle['title']) ) {
                if (isset($typedtitle['title'])) {
                  $typedtitle_array = $typedtitle['title'];
                }
                $typedtitles_array .= $typedtitle_array . 'bc11';
            }else{
                $typedtitles_array .= 'Sentence' . 'bc11';
            }
        }
        $typedtitles_array .= '';
    }else{
        $typedtitles_array = 'unset';
    }
    $this->set_attribute( '_root', 'class', 'bc-typed' );
    $this->set_attribute( '_root_class', 'class', 'bc-typed__wrapper' );
    $this->set_attribute( '_inner', 'class', 'bc-typed__typed' );

    if ( ! empty( $settings['link'] ) ) {
			$this->set_link_attributes( '_link', $settings['link'] );
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}
      data-typed-titles='{$typedtitles_array}'
      data-disable-builder='{$disablebuilder}'
      data-init-on-scroll='{$initOnScroll}'
      data-typeSpeed='{$typeSpeed}'
      data-backSpeed='{$backSpeed}'
      data-startDelay='{$startDelay}'
      data-backDelay='{$backDelay}'
      data-shuffle='{$shuffle}'
      data-loop='{$loop}'
      data-loopCount='{$loopCount}'
      data-showCursor='{$showCursor}'
      data-cursorChar='{$cursorChar}'
      data-fade='{$fade}'
      data-fadeDelay='{$fadeDelay}'>
        <a class='bc-typed__anchor' {$this->render_attributes( '_link' )}>
          <span {$this->render_attributes( '_root_class' )}>";
          if($prefix != ''){$output .= "<span class='bc-typed__prefix'>$prefix</span>";}
          $output .= "<span {$this->render_attributes( '_inner' )}></span>";
          if($sufix != ''){$output .= "<span class='bc-typed__sufix'>$sufix</span>";}
          $output .= "</span> 
        </a>
      </{$this->tag}>
      ";
		}else{
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}
      data-typed-titles='{$typedtitles_array}'
      data-disable-builder='{$disablebuilder}'
      data-init-on-scroll='{$initOnScroll}'
      data-typeSpeed='{$typeSpeed}'
      data-backSpeed='{$backSpeed}'
      data-startDelay='{$startDelay}'
      data-backDelay='{$backDelay}'
      data-shuffle='{$shuffle}'
      data-loop='{$loop}'
      data-loopCount='{$loopCount}'
      data-showCursor='{$showCursor}'
      data-cursorChar='{$cursorChar}'
      data-fade='{$fade}'
      data-fadeDelay='{$fadeDelay}'>
        <span {$this->render_attributes( '_root_class' )}>";
        if($prefix != ''){$output .= "<span class='bc-typed__prefix'>$prefix</span>";}
        $output .= "<span {$this->render_attributes( '_inner' )}></span>";
        if($sufix != ''){$output .= "<span class='bc-typed__sufix'>$sufix</span>";}
        $output .= "</span> 
      </{$this->tag}>
      ";
    }

    echo $output;
  }
}

