function next_parallax_slider(){const constants={isDevice:"ontouchstart" in window};const instances={scrolls:[],sliders:[]};const lerp=(a,b,n)=>(1-n)*a+n*b;const clamp=(val,min,max)=>Math.max(Math.min(val,max),min);constants.isDevice&&document.body.classList.add("is-device");class Scroll{constructor(element,scrollEase,dragSpeed,scrollMultiplier){this.dom={container:element.querySelector("[data-parallax-slider-scroll]")};this.options={ease:parseFloat(scrollEase)||0.1,dragSpeed:parseFloat(dragSpeed)||1.5,scrollMultiplier:parseFloat(scrollMultiplier)||1};this.state={bounds:{},current:0,last:0,dragStart:0,dragEnd:0,dragging:!1};this.init()}
smooth=()=>{this.state.last=lerp(this.state.last,this.state.current,this.options.ease);this.dom.container.style.transform=`translate3d(${this.state.last}px, 0, 0)`};calc=(delta)=>{this.state.current=this.state.current+delta;this.state.current=clamp(this.state.current,(this.state.bounds.width-window.innerWidth)*-1,0)};handleWheel=(e)=>{e.preventDefault();const direction=this.dom.container.closest('[data-scroll-direction]').dataset.scrollDirection==='downward'?-1:1;this.calc(e.deltaY*this.options.scrollMultiplier*direction)};handleTouchStart=(e)=>{this.state.dragging=!0;this.state.dragStart=e.touches[0].clientX;this.state.dragEnd=this.state.current;document.body.classList.add("is-dragging")};handleTouchMove=(e)=>{if(!this.state.dragging)return;const x=e.touches[0].clientX;const delta=(this.state.dragStart-x)*this.options.dragSpeed;this.state.current=this.state.dragEnd-delta;this.state.current=clamp(this.state.current,(this.state.bounds.width-window.innerWidth)*-1,0);if(Math.abs(delta)>5){e.preventDefault()}};handleTouchEnd=()=>{this.state.dragging=!1;this.state.dragEnd=this.state.current;document.body.classList.remove("is-dragging")};handleMousedown=(e)=>{this.state.dragging=!0;this.state.dragStart=e.clientX;this.state.dragEnd=this.state.current;document.body.classList.add("is-dragging")};handleMousemove=(e)=>{if(!this.state.dragging)return;const delta=(this.state.dragStart-e.clientX)*this.options.dragSpeed;this.state.current=this.state.dragEnd-delta;this.state.current=clamp(this.state.current,(this.state.bounds.width-window.innerWidth)*-1,0)};handleMouseup=()=>{this.state.dragging=!1;this.state.dragEnd=this.state.current;document.body.classList.remove("is-dragging")};handleMouseleave=()=>{this.state.dragging=!1;this.state.dragEnd=this.state.current;document.body.classList.remove("is-dragging")};handleResize=()=>{this.state.bounds=this.dom.container.getBoundingClientRect()};enable(){gsap.ticker.add(this.smooth);this.dom.container.addEventListener("touchstart",this.handleTouchStart,{passive:!0});this.dom.container.addEventListener("touchmove",this.handleTouchMove,{passive:!1});this.dom.container.addEventListener("touchend",this.handleTouchEnd);if(!constants.isDevice){this.dom.container.addEventListener("wheel",this.handleWheel,{passive:!1});this.dom.container.addEventListener("mousedown",this.handleMousedown);this.dom.container.addEventListener("mousemove",this.handleMousemove);this.dom.container.addEventListener("mouseup",this.handleMouseup);this.dom.container.addEventListener("mouseleave",this.handleMouseleave)}}
disable(){gsap.ticker.remove(this.smooth);this.dom.container.removeEventListener("touchstart",this.handleTouchStart);this.dom.container.removeEventListener("touchmove",this.handleTouchMove);this.dom.container.removeEventListener("touchend",this.handleTouchEnd);if(!constants.isDevice){this.dom.container.removeEventListener("wheel",this.handleWheel);this.dom.container.removeEventListener("mousedown",this.handleMousedown);this.dom.container.removeEventListener("mousemove",this.handleMousemove);this.dom.container.removeEventListener("mouseup",this.handleMouseup);this.dom.container.removeEventListener("mouseleave",this.handleMouseleave)}}
addListeners(){window.addEventListener("resize",this.handleResize,{passive:!0})}
removeListeners(){window.removeEventListener("resize",this.handleResize)}
init(){this.handleResize();this.enable();this.addListeners()}
destroy(){this.disable();this.removeListeners()}}
class Slider{constructor(element,scrollInstance,parallaxScale){this.dom={};this.dom.container=element.querySelector(".next-parallax-slider__container");this.dom.items=element.querySelectorAll(".next-parallax-slider__item");this.dom.images=element.querySelectorAll(".next-parallax-slider__item-img-wrap");this.dom.progressWrap=element.querySelector(".next-parallax-slider__progress-line-wrap");this.dom.progress=element.querySelector(".next-parallax-slider__progress-line");this.parallaxScale=parseFloat(parallaxScale)||1.1;this.scrollInstance=scrollInstance;this.state={open:!0,scrollEnabled:!0,progress:0}}
setCache(){this.items=[];[...this.dom.items].forEach((el)=>{const bounds=el.getBoundingClientRect();this.items.push({img:el.querySelector(".next-parallax-slider__item-img"),bounds,x:0})})}
render=()=>{const scrollLast=Math.abs(this.scrollInstance.state.last);this.items.forEach((item)=>{const{bounds}=item;const inView=scrollLast+window.innerWidth>=bounds.left&&scrollLast<bounds.right;if(inView){const min=bounds.left-window.innerWidth;const max=bounds.right;const percentage=((scrollLast-min)*100)/(max-min);const newMin=-(window.innerWidth/12)*3;const newMax=0;item.x=((percentage-0)/(100-0))*(newMax-newMin)+newMin;if(item.img){item.img.style.transform=`translate3d(${item.x}px, 0, 0) scale(${this.parallaxScale})`}}});if(this.state.scrollEnabled&&this.dom.progress){const min=0;const max=-this.scrollInstance.state.bounds.width+window.innerWidth;this.state.progress=((this.scrollInstance.state.last-min)*100)/(max-min)/100;this.dom.progress.style.transform=`scaleX(${this.state.progress})`}};handleResize=()=>{this.setCache()};addListeners(){window.addEventListener("resize",this.handleResize)}
init(){gsap.ticker.add(this.render);this.setCache();this.addListeners()}}
document.querySelectorAll(".next-parallax-slider").forEach((parallaxSlider)=>{var isBricks=window.location.href.includes("brickspreview");if(isBricks){var observer=new MutationObserver(function(mutations){mutations.forEach(function(mutation){if(mutation.type==="childList"){mutation.addedNodes.forEach(function(node){if(node.nodeType===Node.ELEMENT_NODE&&node.classList.contains("next-parallax-slider__item")){initiate(parallaxSlider)}});mutation.removedNodes.forEach(function(node){if(node.nodeType===Node.ELEMENT_NODE&&node.classList.contains("next-parallax-slider__item")){initiate(parallaxSlider)}})}})});observer.observe(parallaxSlider,{childList:!0,subtree:!0})}else{initiate(parallaxSlider)}
parallaxSlider.removeAttribute("data-flickering")});function initiate(parallaxSlider){setInitialSlides(parallaxSlider);var scrollEase=parallaxSlider.getAttribute("data-scroll-ease");var dragSpeed=parallaxSlider.getAttribute("data-drag-speed");var scrollMultiplier=parallaxSlider.getAttribute("data-scroll-multiplier");const scroll=new Scroll(parallaxSlider,scrollEase,dragSpeed,scrollMultiplier);instances.scrolls.push(scroll);var parallaxScale=parallaxSlider.getAttribute("data-parallax-scale");const slider=new Slider(parallaxSlider,scroll,parallaxScale);slider.init();instances.sliders.push(slider)}
function setInitialSlides(parallaxSlider){var items=parallaxSlider.querySelectorAll(".next-parallax-slider__item");var totalSlides=items.length;var sliderElement=parallaxSlider.querySelector(".next-parallax-slider__slider");sliderElement.style.setProperty("--slidesTotal",totalSlides)}}
document.addEventListener("DOMContentLoaded",function(t){bricksIsFrontend&&next_parallax_slider()})