function next_tiles_v2(){class Tilesv2{constructor(container){const parentElement=container.closest('.next-tiles-v2');this.container=container;this.pixelSize=parseFloat(parentElement.dataset.pixelSize);this.delay=parseFloat(parentElement.dataset.delay)*1000;this.dimensions={width:0,height:0};this.pixels=new Map();this.init();this.bindEvents()}
init(){this.updateDimensions();this.createGrid()}
updateDimensions(){const rect=this.container.getBoundingClientRect();this.dimensions={width:rect.width,height:rect.height}}
createGrid(){this.container.innerHTML='';const columns=Math.ceil(this.dimensions.width/this.pixelSize);const rows=Math.ceil(this.dimensions.height/this.pixelSize);for(let y=0;y<rows;y++){const row=document.createElement('div');row.className='next-tiles-v2__row';for(let x=0;x<columns;x++){const pixel=document.createElement('div');pixel.className='next-tiles-v2__dot';pixel.style.width=`${this.pixelSize}px`;pixel.style.height=`${this.pixelSize}px`;const key=`${x}-${y}`;this.pixels.set(key,pixel);row.appendChild(pixel)}
this.container.appendChild(row)}}
animatePixel(pixel){pixel.style.opacity=1;setTimeout(()=>{pixel.style.opacity=0},this.delay)}
handleMouseMove(e){const rect=this.container.getBoundingClientRect();const x=Math.floor((e.clientX-rect.left)/this.pixelSize);const y=Math.floor((e.clientY-rect.top)/this.pixelSize);const key=`${x}-${y}`;const pixel=this.pixels.get(key);if(pixel){this.animatePixel(pixel)}}
bindEvents(){const parentElement=this.container.closest('.next-tiles-v2');parentElement.addEventListener('mousemove',this.handleMouseMove.bind(this));window.addEventListener('resize',()=>{this.updateDimensions();this.createGrid()})}}
document.querySelectorAll('.next-tiles-v2__trail').forEach(trail=>{new Tilesv2(trail)})}
document.addEventListener("DOMContentLoaded",function(t){bricksIsFrontend&&next_tiles_v2()})