<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Arrow_Button_v4 extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'next-arrow-button-v4';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';

  public function get_label() {
    return esc_html__( 'Arrow Button v4', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Arrow Button v4', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Label Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['padding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '&{pseudo} .nb-arrow-button-v4__text',
            ],
        ],
        'default' => [
            'top'    => 8,
            'right'  => 16, 
            'bottom' => 8,
            'left'   => 16,
        ],
    ];
    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '&{pseudo} .nb-arrow-button-v4__text span',
            ],
        ],
        'default' => [
            'font-size' => '15px',
            'font-weight' => '600',
            'line-height' => 'normal',
            'color' => [
                'hex' => '#000000',
              ]
        ],
    ];
    $this->controls['background'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&{pseudo} .nb-arrow-button-v4__text',
            ],
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];
    $this->controls['border'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Border', 'bricks'),
        'type'    => 'border',
        'css'     => [
          [
            'property' => 'border',
            'selector' => '&{pseudo} .nb-arrow-button-v4__text',
          ],
        ],
        'default' => [
            'radius' => [
                'top' => 100,
                'right' => 100,
                'bottom' => 100,
                'left' => 100,
            ],
        ]
    ];

    $this->controls['iconStyleSeparator'] = [
        'label'      => esc_html__( 'Arrow Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['iconType'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Icon', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'type1' => 'Arrow 1',
            'type2' => 'Arrow 2',
            'type3' => 'Angle',
            'type4' => 'Angles',
            'type5' => 'Fancy',
        ],
        'inline' => true,
        'placeholder' => 'Arrow 2',
        'default' => 'type2',
    ];
    $this->controls['iconDimensions'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Dimensions', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => '--icon-dimensions',
                'selector' => '',
            ],
        ],
        'default' => '33px',
    ];
    $this->controls['iconPadding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '&{pseudo} .nb-arrow-button-v4__icon',
            ],
        ],
        'default' => [
            'top'    => 10,
            'right'  => 10, 
            'bottom' => 10,
            'left'   => 10,
        ],
    ];
    $this->controls['iconBackground'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&{pseudo} .nb-arrow-button-v4__icon',
            ],
        ],
        'default' => [
            'rgb' => 'rgb(65, 153, 241)',
        ],
    ];
    $this->controls['iconFill'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Fill', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--stroke',
                'selector' => '&{pseudo} .nb-arrow-button-v4__icon',
            ],
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];
    $this->controls['iconBorder'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Border', 'bricks'),
        'type'    => 'border',
        'css'     => [
          [
            'property' => 'border',
            'selector' => '&{pseudo} .nb-arrow-button-v4__icon',
          ],
        ],
        'default' => [
            'radius' => [
                'top' => 100,
                'right' => 100,
                'bottom' => 100,
                'left' => 100,
            ],
        ]
    ];

    $this->controls['duplicatedIconStyleSeparator'] = [
        'label'      => esc_html__( 'Duplicated Arrow Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['duplicatedIconType'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Icon', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'type1' => 'Arrow 1',
            'type2' => 'Arrow 2',
            'type3' => 'Angle',
            'type4' => 'Angles',
            'type5' => 'Fancy',
        ],
        'inline' => true,
        'placeholder' => 'Arrow 2',
        'default' => 'type2',
    ];
    $this->controls['duplicatedIconPadding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '&{pseudo} .nb-arrow-button-v4__icon--duplicate',
            ],
        ],
        'default' => [
            'top'    => 10,
            'right'  => 10, 
            'bottom' => 10,
            'left'   => 10,
        ],
    ];
    $this->controls['duplicatedIconBackground'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&{pseudo} .nb-arrow-button-v4__icon--duplicate',
            ],
        ],
        'default' => [
            'rgb' => 'rgb(65, 153, 241)',
        ],
    ];
    $this->controls['duplicatedIconFill'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Fill', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'fill',
                'selector' => '&{pseudo} .nb-arrow-button-v4__icon--duplicate',
            ],
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];
    $this->controls['duplicatedIconBorder'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Border', 'bricks'),
        'type'    => 'border',
        'css'     => [
          [
            'property' => 'border',
            'selector' => '&{pseudo} .nb-arrow-button-v4__icon--duplicate',
          ],
        ],
        'default' => [
            'radius' => [
                'top' => 100,
                'right' => 100,
                'bottom' => 100,
                'left' => 100,
            ],
        ]
    ];

    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['transitionDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Duration', 'bricks' ),
        'type'    => 'number',
        'unit'   => 's',
        'default' => '0.5s',
        'css'     => [
            [
                'property' => '--transition-duration',
                'selector' => '',
            ],
        ],
    ];
    $this->controls['transitionEasing'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'CSS Easing', 'bricks' ),
        'type'    => 'text',
        'inline'  => true,
        'default' => 'cubic-bezier(0.76, 0, 0.24, 1)',
        'css'     => [
            [
                'property' => '--transition-easing',
                'selector' => '',
            ],
        ],
    ];
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Arrow Button v4';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    /*Icon*/
    $iconType = ! empty( $settings['iconType'] ) ? $settings['iconType'] : 'type2';
    if($iconType == 'type1'){
        $icon = 
        "<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 25 25'>
        <path d='m17.5 5.999-.707.707 5.293 5.293H1v1h21.086l-5.294 5.295.707.707L24 12.499l-6.5-6.5z'/>
        </svg>";
    }
    if($iconType == 'type2'){
        $icon = 
        "<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24'>
        <path d='M11.293 4.707 17.586 11H4v2h13.586l-6.293 6.293 1.414 1.414L21.414 12l-8.707-8.707-1.414 1.414z'/>
        </svg>";
    }
    if($iconType == 'type3'){
        $icon = 
        "<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 320 512'>
        <path d='M310.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L242.7 256 73.4 86.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l192 192z'/>
        </svg>";
    }
    if($iconType == 'type4'){
        $icon = 
        "<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 512 512'>
        <path d='M470.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 256 265.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160zm-352 160l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L210.7 256 73.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0z'/>
        </svg>";
    }
    if($iconType == 'type5'){
        $icon = 
        "<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20' style='fill: none !important'>
            <path d='M0.985771 9.98158L19.9713 9.98162' stroke-miterlimit='10'/>
            <path d='M19.6589 9.97797C15.1624 9.978 11.5176 6.33315 11.5176 1.83661' stroke-miterlimit='10'/>
            <path d='M11.5174 18.1213C11.5175 13.6248 15.1623 9.97997 19.6588 9.97995' stroke-miterlimit='10'/>
        </svg>";
    }

    /*Duplicated Icon*/
    $duplicatedIconType = ! empty( $settings['duplicatedIconType'] ) ? $settings['duplicatedIconType'] : 'type2';
    if($duplicatedIconType == 'type1'){
        $duplicatedIcon = 
        "<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 25 25'>
        <path d='m17.5 5.999-.707.707 5.293 5.293H1v1h21.086l-5.294 5.295.707.707L24 12.499l-6.5-6.5z'/>
        </svg>";
    }
    if($duplicatedIconType == 'type2'){
        $duplicatedIcon = 
        "<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24'>
        <path d='M11.293 4.707 17.586 11H4v2h13.586l-6.293 6.293 1.414 1.414L21.414 12l-8.707-8.707-1.414 1.414z'/>
        </svg>";
    }
    if($duplicatedIconType == 'type3'){
        $duplicatedIcon = 
        "<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 320 512'>
        <path d='M310.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L242.7 256 73.4 86.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l192 192z'/>
        </svg>";
    }
    if($duplicatedIconType == 'type4'){
        $duplicatedIcon = 
        "<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 512 512'>
        <path d='M470.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 256 265.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160zm-352 160l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L210.7 256 73.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0z'/>
        </svg>";
    }
    if($duplicatedIconType == 'type5'){
        $duplicatedIcon = 
        "<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20' style='fill: none !important'>
            <path d='M0.985771 9.98158L19.9713 9.98162' stroke-miterlimit='10'/>
            <path d='M19.6589 9.97797C15.1624 9.978 11.5176 6.33315 11.5176 1.83661' stroke-miterlimit='10'/>
            <path d='M11.5174 18.1213C11.5175 13.6248 15.1623 9.97997 19.6588 9.97995' stroke-miterlimit='10'/>
        </svg>";
    }

    $this->set_attribute( '_root', 'class', 'nb-arrow-button-v4' );
    $output = "
    <$root_tag  {$this->render_attributes( '_root' )}>
        <div class='nb-arrow-button-v4__icon nb-arrow-button-v4__icon--duplicate'>
            $duplicatedIcon
        </div>
        <div class='nb-arrow-button-v4__text'>
            <span>$inner_title</span>
        </div>
        <div class='nb-arrow-button-v4__icon'>
            $icon
        </div>
    </$root_tag>
    ";

	echo $output;
  }
}