<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Arrow_Button_v6 extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'next-arrow-button-v6';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';

  public function get_label() {
    return esc_html__( 'Arrow Button v6', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'label'       => esc_html__( 'Title', 'bricks' ),
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Arrow Button v6', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['swap_title'] = [
        'label'       => esc_html__( 'Swap Title', 'bricks' ),
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Arrow Button v6', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Label Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['padding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '&{pseudo} .nb-arrow-button-v6__inner',
            ],
        ],
        'default' => [
            'top'    => 10,
            'right'  => 15, 
            'bottom' => 10,
            'left'   => 15,
        ],
    ];
    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'color' => [
                'hex' => '#ffffff',
              ]
        ],
    ];
    $this->controls['background'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&{pseudo} .nb-arrow-button-v6__bg',
            ],
        ],
        'default' => [
            'hex' => '#000000',
        ],
    ];
    $this->controls['border'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Border', 'bricks'),
        'type'    => 'border',
        'css'     => [
          [
            'property' => 'border',
            'selector' => '&{pseudo} .nb-arrow-button-v6__bg',
          ],
        ],
        'default' => [
            'radius' => [
                'top' => 8,
                'right' => 8,
                'bottom' => 8,
                'left' => 8,
            ],
        ]
    ];

    $this->controls['iconStyleSeparator'] = [
        'label'      => esc_html__( 'Arrow Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['iconDimensions'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Dimensions', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => '--dimensions',
                'selector' => '&{pseudo} .nb-arrow-button-v6__icon',
            ],
        ],
        'default' => '20px',
    ];
    $this->controls['iconWeight'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Weight', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'width',
                'selector' => '&{pseudo} .nb-arrow-button-v6__icon-mid',
            ],
        ],
        'default' => '10%',
    ];
    $this->controls['iconColor'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'color',
                'selector' => '&{pseudo} .nb-arrow-button-v6__icon',
            ],
        ],
        'default' => [
            'hex' => '#000000',
        ],
    ];

    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Text Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['textDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Duration', 'bricks' ),
        'type'    => 'number',
        'unit'   => 's',
        'css'     => [
            [
                'property' => '--text-duration',
                'selector' => '',
            ],
        ],
        'default' => '0.45s',
    ];

    $this->controls['arrowTranslateSeparator'] = [
        'label'      => esc_html__( 'Arrow Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['arrowTranslateFrom'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Translate From', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => '--translate-from',
                'selector' => '&{pseudo} .nb-arrow-button-v6__icon',
            ],
        ],
        'default' => '3em',
    ];
    
    $this->controls['arrowTranslateDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Translate Duration', 'bricks' ),
        'type'    => 'number',
        'unit'   => 's',
        'css'     => [
            [
                'property' => '--arrow-translate-duration',
                'selector' => '&{pseudo} .nb-arrow-button-v6__icon',
            ],
        ],
        'default' => '0.85s',
    ];
    $this->controls['arrowAnimationDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Animation Duration', 'bricks' ),
        'type'    => 'number',
        'unit'   => 's',
        'css'     => [
            [
                'property' => '--arrow-animation-duration',
                'selector' => '&{pseudo} .nb-arrow-button-v6__icon',
            ],
        ],
        'default' => '0.8s',
    ];
    $this->controls['animationEase'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'CSS Easing', 'bricks' ),
        'type'    => 'text',
        'inline'  => true,
        'css'     => [
            [
                'property' => '--animation-ease',
                'selector' => '&{pseudo} .nb-arrow-button-v6__icon',
            ],
        ],
        'default' => 'cubic-bezier(.65, .06, .33, .89)',
    ];
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Arrow Button v6';
    $swap_title    = ! empty( $settings['swap_title'] ) ? $settings['swap_title'] : 'Arrow Button v6';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $this->set_attribute( '_root', 'class', 'nb-arrow-button-v6' );
    $output = "
    <$root_tag  {$this->render_attributes( '_root' )}>
        <span class='nb-arrow-button-v6__bg'></span>
        <span data-text='$swap_title' class='nb-arrow-button-v6__inner'>
            <span class='nb-arrow-button-v6__text'>$inner_title</span>
        </span>
        <span class='nb-arrow-button-v6__icon'>
            <span class='nb-arrow-button-v6__icon-start'>
                <svg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 8 16' class='nb-arrow-button-v6__icon-svg'>
                    <path fill='currentColor' d='M1.113 9.327a2.065 2.065 0 0 1 0-2.654L6.4.37C6.596.135 6.886 0 7.191 0h.55v16h-.55c-.305 0-.595-.135-.79-.369L1.112 9.327Z'></path>
                </svg>
            </span>
            <span class='nb-arrow-button-v6__icon-mid'></span>
            <span class='nb-arrow-button-v6__icon-end'>
                <svg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 6 16' class='nb-arrow-button-v6__icon-svg'>
                    <path fill='currentColor' fill-rule='evenodd' d='M5.288 1.696A1.032 1.032 0 0 0 4.497 0H1.032C.462 0 0 .462 0 1.032v13.936C0 15.538.462 16 1.032 16h3.465c.876 0 1.354-1.024.79-1.696L1.114 9.327a2.065 2.065 0 0 1 0-2.654l4.175-4.977Z' clip-rule='evenodd'></path>
                    <path fill='currentColor' d='M0 0h1.548v1.548H0zM0 14.452h1.548V16H0z'></path>
                </svg>
            </span>
        </span>
    </$root_tag>
    ";

	echo $output;
  }
}