<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Audio_Player extends \Bricks\Element {
  public $category     = 'Next Bricks - Cores';
  public $name         = 'next_audio_player';
  public $icon         = 'fas fa-wave-square';
  public $tag      = 'div';
  public $scripts      = ['next_audio_player'];

  public function get_label() {
    return esc_html__( 'Audio Player', 'bricks' );
  }

  public function set_controls() {
    $this->controls['audioSeparator'] = [
        'label'      => esc_html__( 'Audio', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['source'] = [
        'tab' => 'content',
        'label' => esc_html__('Source', 'bricks'),
        'type' => 'text',
        'default' => 'https://nextbricks.io/wp-content/uploads/2025/04/Cartoon-Daniel-Levi-Jeja-On-On-feat.-Daniel-Levi-NCS-Release.mp3',
    ];

    $this->controls['progressAnimationSeparator'] = [
        'label'      => esc_html__( 'Progress Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['duration'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '0.4s',
    ];

    $this->controls['ease'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
            'none' => 'none',
            'power1' => 'power1',
            'power2' => 'power2',
            'power3' => 'power3',
            'power4' => 'power4',
            'back' => 'back',
            'bounce' => 'bounce',
            'circ' => 'circ',
            'elastic' => 'elastic',
            'expo' => 'expo',
            'sine' => 'sine',
            'steps' => 'steps'
        ],
        'inline' => true,
        'default' => 'expo',
    ];

    /*css*/
    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Wrapper', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['padding'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Padding', 'bricks' ),
        'type' => 'spacing',
        'css' => [
            [
                'property' => 'padding',
                'selector' => '',
            ]
        ],
        'default' => [
            'top' => '8',
            'right' => '8',
            'bottom' => '8',
            'left' => '8',
        ],
    ];
    $this->controls['width'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'width',
            'selector' => '',
          ]
        ],
        'default' => '100%',
    ];
    $this->controls['maxWidth'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Max Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'width',
            'selector' => '',
          ]
        ],
        'default' => '250px',
    ];
    $this->controls['height'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'height',
            'selector' => '',
          ]
        ],
        'default' => 'auto',
    ];
    $this->controls['background'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Background', 'bricks' ),
        'type' => 'background',
        'inline' => true,
        'css' => [
            [
                'property' => 'background',
                'selector' => '',
            ]
        ],
        'default' => [
            'color' => [
                'hex' => '#272727',
            ],
        ],
    ];
    $this->controls['border'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Border', 'bricks' ),
        'type' => 'border',
        'inline' => true,
        'css' => [
            [
                'property' => 'border',
                'selector' => '',
            ]
        ],
        'default' => [
            'radius' => [
                'top' => '15',
                'right' => '15',
                'bottom' => '15',
                'left' => '15',
            ],
        ],
    ];

    $this->controls['topWrapperStyleSeparator'] = [
        'label'      => esc_html__( 'Top Wrapper', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['topWrapperGap'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Gap', 'bricks' ),
        'type' => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
            [
                'property' => 'gap',
                'selector' => '.nb-audio-player__top',
            ]
        ],
        'default' => '8px',
    ];

    $this->controls['thumbnailSeparator'] = [
        'label'      => esc_html__( 'Thumbnail', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['image'] = [
        'hasDynamicData' => true,
        'tab' => 'content',
        'label' => esc_html__( 'Image', 'bricks' ),
        'type' => 'image',
        'default' => [
          'url' => 'https://i.scdn.co/image/ab67616d00001e0291293cbe0afa8ca67f8ab9f4',
        ],
    ];
    $this->controls['thumbnailWidth'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type' => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
            [
                'property' => 'width',
                'selector' => '.nb-audio-player__thumbnail',
            ]
        ],
        'default' => '50px',
    ];
    $this->controls['thumbnailHeight'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type' => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
            [
                'property' => 'height',
                'selector' => '.nb-audio-player__thumbnail',
            ]
        ],
        'default' => '50px',
    ];
    $this->controls['thumbnailBorder'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Border', 'bricks' ),
        'type' => 'border',
        'inline' => true,
        'css' => [
            [
                'property' => 'border',
                'selector' => '.nb-audio-player__thumbnail',
            ]
        ],
        'default' => [
            'radius' => [
                'top' => '10',
                'right' => '10',
                'bottom' => '10',
                'left' => '10',
            ],
        ],
    ];

    $this->controls['textsSeparator'] = [
        'label'      => esc_html__( 'Texts', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['textsGap'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Gap', 'bricks' ),
        'type' => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
            [
                'property' => 'gap',
                'selector' => '.nb-audio-player__top-texts',
            ]
        ],
        'default' => '2px',
    ];
    $this->controls['nameText'] = [
        'hasDynamicData' => true,
        'tab' => 'content',
        'label' => esc_html__( 'Audio Title', 'bricks' ),
        'type' => 'text',
        'placeholder' => esc_html__( 'Enter audio title', 'bricks' ),
        'default' => esc_html__( 'On & On', 'bricks' ),
    ];
    $this->controls['nameTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '.nb-audio-player__name',
            ],
        ],
        'default' => [
            'font-size' => '14px',
            'font-weight' => '600',
            'line-height' => 'normal',
            'color' => [
                'hex' => '#a0a0a0',
            ],
        ],
    ];
    $this->controls['artistText'] = [
        'hasDynamicData' => true,
        'tab' => 'content',
        'label' => esc_html__( 'Artist Name', 'bricks' ),
        'type' => 'text',
        'placeholder' => esc_html__( 'Enter artist name', 'bricks' ),
        'default' => esc_html__( 'NCS', 'bricks' ),
    ];
    $this->controls['artistTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '.nb-audio-player__artist',
            ],
        ],
        'default' => [
            'font-size' => '12px',
            'font-weight' => '600',
            'line-height' => 'normal',
            'color' => [
                'hex' => '#656565',
            ],
        ],
    ];

    $this->controls['playPauseStyleSeparator'] = [
        'label'      => esc_html__( 'Play/Pause Button', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['playPauseWidth'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type' => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
            [
                'property' => 'width',
                'selector' => '.nb-audio-player__play, .nb-audio-player__pause',
            ]
        ],
        'default' => '30px',
    ];
    
    $this->controls['playPauseHeight'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type' => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
            [
                'property' => 'height',
                'selector' => '.nb-audio-player__play, .nb-audio-player__pause',
            ]
        ],
        'default' => '30px',
    ];
    
    $this->controls['playPauseMarginRight'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Margin', 'bricks' ),
        'type' => 'spacing',
        'css' => [
            [
                'property' => 'margin',
                'selector' => '.nb-audio-player__play, .nb-audio-player__pause',
            ]
        ],
        'default' => [
            'right' => '8',
        ],
    ];
    
    $this->controls['playPausePadding'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Padding', 'bricks' ),
        'type' => 'spacing',
        'css' => [
            [
                'property' => 'padding',
                'selector' => '.nb-audio-player__play, .nb-audio-player__pause',
            ]
        ],
        'default' => [
            'top' => '8',
            'right' => '8',
            'bottom' => '8',
            'left' => '8',
        ],
    ];
    $this->controls['playPauseBorder'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Border', 'bricks' ),
        'type' => 'border',
        'inline' => true,
        'css' => [
            [
                'property' => 'border',
                'selector' => '.nb-audio-player__play, .nb-audio-player__pause',
            ]
        ],
        'default' => [
            'radius' => [
                'top' => '8',
                'right' => '8',
                'bottom' => '8',
                'left' => '8',
            ],
        ],
    ];
    $this->controls['playColor'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Play Background', 'bricks' ),
        'type' => 'color',
        'inline' => true,
        'css' => [
            [
                'property' => 'background',
                'selector' => '.nb-audio-player__play',
            ]
        ],
        'default' => [
            'hex' => '#3a8ce3',
        ],
    ];
    $this->controls['playFill'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Play Fill', 'bricks' ),
        'type' => 'color',
        'inline' => true,
        'css' => [
            [
                'property' => 'fill',
                'selector' => '.nb-audio-player__play svg',
            ]
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];
    $this->controls['pauseColor'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Pause Background', 'bricks' ),
        'type' => 'color',
        'inline' => true,
        'css' => [
            [
                'property' => 'background',
                'selector' => '.nb-audio-player__pause',
            ]
        ],
        'default' => [
            'hex' => '#3a8ce3',
        ],
    ];
    $this->controls['pauseFill'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Pause Fill', 'bricks' ),
        'type' => 'color',
        'inline' => true,
        'css' => [
            [
                'property' => 'fill',
                'selector' => '.nb-audio-player__pause svg',
            ]
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];

    $this->controls['durationProgressSeparator'] = [
        'label'      => esc_html__( 'Duration & Progress Container', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['progressPadding'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Padding', 'bricks' ),
        'type' => 'spacing',
        'css' => [
            [
                'property' => 'padding',
                'selector' => '.nb-audio-player__bottom',
            ]
        ],
        'default' => [
            'top' => '12',
            'right' => '2',
            'bottom' => '2',
            'left' => '2',
        ],
    ];

    $this->controls['progressSeparator'] = [
        'label'      => esc_html__( 'Progress', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['progressMargin'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Margin', 'bricks' ),
        'type' => 'spacing',
        'css' => [
            [
                'property' => 'margin',
                'selector' => '.nb-audio-player__progress-container',
            ]
        ],
        'default' => [
            'top' => '0',
            'right' => '8',
            'bottom' => '0',
            'left' => '8',
        ],
    ];
    $this->controls['progressHeight'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type' => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
            [
                'property' => 'height',
                'selector' => '.nb-audio-player__progress',
            ]
        ],
        'default' => '4px',
    ];
    $this->controls['progressFill'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Fill Color', 'bricks' ),
        'type' => 'color',
        'inline' => true,
        'css' => [
            [
                'property' => 'background',
                'selector' => '.nb-audio-player__progress',
            ]
        ],
        'default' => [
            'hex' => '#3a8ce3',
        ],
    ];
    $this->controls['progressBackground'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Path Color', 'bricks' ),
        'type' => 'color',
        'inline' => true,
        'css' => [
            [
                'property' => 'background',
                'selector' => '.nb-audio-player__progress-container',
            ]
        ],
        'default' => [
            'hex' => '#555',
        ],
    ];
    $this->controls['progressBorder'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Border', 'bricks' ),
        'type' => 'border',
        'css' => [
            [
                'property' => 'border',
                'selector' => '.nb-audio-player__progress-container, .nb-audio-player__progress',
            ]
        ],
        'default' => [
            'radius' => [
                'top' => '2',
                'right' => '2',
                'bottom' => '2',
                'left' => '2',
            ],
        ],
    ];

    $this->controls['timerSeparator'] = [
        'label'      => esc_html__( 'Timer & Duration', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['timerTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Timer Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '.nb-audio-player__timer',
            ],
        ],
        'default' => [
            'font-size' => '12px',
            'line-height' => 'normal',
            'color' => [
                'hex' => '#a0a0a0',
            ],
        ],
    ];
    $this->controls['durationTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Duration Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '.nb-audio-player__duration',
            ],
        ],
        'default' => [
            'font-size' => '12px',
            'line-height' => 'normal',
            'color' => [
                'hex' => '#a0a0a0',
            ],
        ],
    ];
  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'next_howler', NEXTBRICKS_PLUGIN_URL . 'local_assets/next_howler.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    wp_enqueue_script( 'next_audio_player', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_audio_player.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $audioName = !empty($settings['nameText']) ? $settings['nameText'] : 'On & On';
    $audioArtist = !empty($settings['artistText']) ? $settings['artistText'] : 'NCS';
    $duration = !empty($settings['duration']) ? $settings['duration'] : '0.4';
    $ease = !empty($settings['ease']) ? $settings['ease'] : 'expo';
    $source = !empty($settings['source']) ? $settings['source'] : 'https://nextbricks.io/wp-content/uploads/2025/04/Cartoon-Daniel-Levi-Jeja-On-On-feat.-Daniel-Levi-NCS-Release.mp3';
    
    $this->set_attribute( '_root', 'class', "nb-audio-player");
    $this->set_attribute('_root', 'data-duration', $duration);
    $this->set_attribute('_root', 'data-ease', $ease);
    $this->set_attribute('_root', 'data-source', $source);

    //Render dynamic data
    if (isset($settings['image']['useDynamicData'])){
        $last_image = $this->render_dynamic_data_tag($settings['image']['useDynamicData'], 'image');
        $last_image = wp_get_attachment_url($last_image[0]);
    
        $attachment_id = attachment_url_to_postid($last_image);
        $image_metadata = wp_get_attachment_metadata($attachment_id);
        
        $width = isset($image_metadata['width']) ? $image_metadata['width'] : 0;
        $height = isset($image_metadata['height']) ? $image_metadata['height'] : 0;
    }
    //Render normal image
    else if (isset($settings['image'])) {
        $last_image = $settings['image']['url'];
    
        $image_dimensions = @getimagesize($last_image);
        if ($image_dimensions !== false) {
            $width = $image_dimensions[0];
            $height = $image_dimensions[1];
        } else {
            $width = 0;
            $height = 0;
        }
    }
    //Render default
    else{
        $last_image = 'https://i.scdn.co/image/ab67616d00001e0291293cbe0afa8ca67f8ab9f4';
    
        $image_dimensions = @getimagesize($last_image);
        if ($image_dimensions !== false) {
            $width = $image_dimensions[0];
            $height = $image_dimensions[1];
        } else {
            $width = 0;
            $height = 0;
        }
    }

    $output = "<div {$this->render_attributes( '_root' )}>";
    $output .= "
        <div class='nb-audio-player__top'>
            <img class='nb-audio-player__thumbnail' src='$last_image' alt='Thumbnail' />

            <div class='nb-audio-player__top-right'>
                <div class='nb-audio-player__top-texts'>
                    <div class='nb-audio-player__name'>$audioName</div>
                    <div class='nb-audio-player__artist'>$audioArtist</div>
                </div>

                <div class='nb-audio-player__play' tabindex='0'>
                    <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' width='20' height='20' fill='none'>
                        <path d='M13.9405 6.337C15.5735 7.26468 16.8567 7.99369 17.7709 8.66148C18.6913 9.33386 19.3721 10.0366 19.6159 10.9632C19.7947 11.6426 19.7947 12.3574 19.6159 13.0368C19.3721 13.9634 18.6913 14.6661 17.7709 15.3385C16.8567 16.0063 15.5735 16.7353 13.9406 17.663L13.9406 17.663C12.3632 18.5591 11.033 19.3148 10.0232 19.7444C9.0053 20.1773 8.07729 20.3968 7.17536 20.1412C6.51252 19.9533 5.90941 19.5968 5.42356 19.1066C4.76419 18.4414 4.49951 17.5219 4.37429 16.4154C4.24998 15.3169 4.24999 13.879 4.25 12.0501V12.0501V11.9499V11.9499C4.24999 10.121 4.24998 8.68309 4.37429 7.58464C4.49951 6.4781 4.76419 5.55861 5.42356 4.89335C5.90941 4.40317 6.51252 4.04666 7.17536 3.85883C8.07729 3.60325 9.0053 3.82269 10.0232 4.25565C11.033 4.68516 12.3632 5.44084 13.9405 6.337Z'/>
                    </svg>
                </div>
                <div class='nb-audio-player__pause' tabindex='0'>
                    <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' width='20' height='20' fill='none'>
                        <path d='M16.9506 3.25L17 3.25L17.0494 3.25H17.0494C17.7143 3.24996 18.2871 3.24993 18.7458 3.31161C19.2375 3.37771 19.7087 3.52677 20.091 3.90901C20.4732 4.29126 20.6223 4.76252 20.6884 5.25416C20.7501 5.71291 20.7501 6.28577 20.7501 6.95064V17.0494C20.7501 17.7142 20.7502 18.2871 20.6885 18.7458C20.6224 19.2375 20.4733 19.7087 20.0911 20.091C19.7088 20.4732 19.2376 20.6223 18.7459 20.6884C18.2872 20.7501 17.7143 20.75 17.0495 20.75H16.9507C16.2859 20.75 15.713 20.7501 15.2543 20.6884C14.7626 20.6223 14.2914 20.4732 13.9091 20.091C13.5269 19.7087 13.3778 19.2375 13.3117 18.7458C13.2501 18.2871 13.2501 17.7143 13.2501 17.0494V17.0494V6.95063V6.95058C13.2501 6.28574 13.2501 5.71289 13.3117 5.25416C13.3778 4.76252 13.5269 4.29126 13.9091 3.90901C14.2914 3.52677 14.7626 3.37771 15.2543 3.31161C15.713 3.24993 16.2859 3.24996 16.9507 3.25H16.9507Z'/>
                        <path d='M6.95072 3.25L7.00009 3.25L7.04947 3.25H7.04952C7.71436 3.24996 8.28721 3.24993 8.74594 3.31161C9.23758 3.37771 9.70884 3.52677 10.0911 3.90901C10.4733 4.29126 10.6224 4.76252 10.6885 5.25416C10.7502 5.71291 10.7501 6.28577 10.7501 6.95064V17.0494C10.7501 17.7142 10.7502 18.2871 10.6885 18.7458C10.6224 19.2375 10.4733 19.7087 10.0911 20.091C9.70884 20.4732 9.23758 20.6223 8.74594 20.6884C8.28719 20.7501 7.71433 20.75 7.04946 20.75H6.95073C6.28586 20.75 5.713 20.7501 5.25425 20.6884C4.76261 20.6223 4.29135 20.4732 3.9091 20.091C3.52686 19.7087 3.3778 19.2375 3.3117 18.7458C3.25003 18.2871 3.25006 17.7143 3.25009 17.0494V17.0494V6.95063V6.95058C3.25006 6.28574 3.25003 5.71289 3.3117 5.25416C3.3778 4.76252 3.52686 4.29126 3.9091 3.90901C4.29135 3.52677 4.76261 3.37771 5.25425 3.31161C5.71298 3.24993 6.28583 3.24996 6.95067 3.25H6.95072Z'/>
                    </svg>
                </div>
            </div>
        </div>

        <div class='nb-audio-player__bottom'>
            <div class='nb-audio-player__timer'>0:00</div>
            <div class='nb-audio-player__progress-container'>
                <div class='nb-audio-player__progress'></div>
            </div>
            <div class='nb-audio-player__duration'>0:00</div>
        </div>
    ";
    $output .= "</div>";

	echo $output;
  }
}