<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class NB_Circular_Menu extends \Bricks\Element {
    public $category     = 'Next Bricks - Menus';
    public $name         = 'next-circular-menu';
    public $icon         = 'ti-menu-alt';
    public $scripts      = ['next_circular_menu'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Circular Menu', 'bricks' );
    }

    public function set_controls() {
        $this->controls['openbuilder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Open at the builder', 'bricks' ),
            'type'     => 'checkbox',
        ];
    
        $this->controls['separator'] = [
            'description' => sprintf(html_entity_decode(esc_html__( '<br>All elements with this class will toggle the menu alongside all the Burgers inside the menu.', 'bricks' ))),
            'type'       => 'separator',
        ];
        $this->controls['customtoggle'] = [
            'label'       => esc_html__( 'Custom Toggle', 'bricks' ),
            'type'        => 'text',
            'placeholder' => '.bc-core-burger',
        ];
        $this->controls['lockBodyScrollingSeparator'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'If true, Custom Toggle will lock body scrolling on click.', 'bricks' )))
        ];
        $this->controls['lockBodyScrolling'] = [
            'label' => esc_html__( 'Lock body scrolling', 'bricks' ),
            'type' => 'checkbox',
            'inline' => true,
            'small' => true,
            'default' => false,
        ];

        $this->controls['animationSeparator'] = [
            'label'      => esc_html__( 'Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['fromTop'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'From Top', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
              [
                  'property' => '--from-top',
                  'selector' => '.nb-circular-menu__content',
              ],
            ],
            'placeholder' => '24px',
            'default' => '24px',
        ];
        $this->controls['fromLeft'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'From Left', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
              [
                  'property' => '--from-left',
                  'selector' => '.nb-circular-menu__content',
              ],
            ],
            'placeholder' => '24px',
            'default' => '24px',
        ];
        $this->controls['duration'] = [
            'label'       => esc_html__( 'Duration', 'bricks' ),
            'type'        => 'number',
            'unit'      => 's',
            'inline'      => true,
            'placeholder' => '0.4s',
        ];
        $this->controls['easing'] = [
          'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'GSAP easing', 'bricks' ),
            'type' => 'select',
            'options'     => [
              'none' => 'none',
              'power1' => 'power1',
              'power2' => 'power2',
              'power3' => 'power3',
              'power4' => 'power4',
              'back' => 'back',
              'bounce' => 'bounce',
              'circ' => 'circ',
              'elastic' => 'elastic',
              'expo' => 'expo',
              'sine' => 'sine',
              'steps' => 'steps',
              'custom' => 'custom'
            ],
            'inline' => true,
            'placeholder' => 'none',
        ];
        $this->controls['customEasing'] = [
          'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'Custom easing', 'bricks' ),
          'type' => 'text',
          'inline' => true,
          'placeholder' => 'back.out(1.7)',
          'default' => 'back.out(1.7)',
          'required' => [ 'easing', '=', 'custom' ],
        ];


        $this->controls['contentseparator'] = [
            'label'       => esc_html__( 'Content Style', 'bricks' ),
            'description' => sprintf(html_entity_decode(esc_html__( 'Edit Content styles at its element or directly from here.', 'bricks' ))),
            'type'       => 'separator',
        ];
        $this->controls['width'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
              [
                  'property' => 'width',
                  'selector' => '.nb-circular-menu__content',
              ],
            ],
            'placeholder' => '100svw',
            'default' => '100svw',
        ];
        $this->controls['height'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
              [
                  'property' => 'height',
                  'selector' => '.nb-circular-menu__content',
              ],
            ],
            'placeholder' => '100svh',
            'default' => '100svh',
        ];
        $this->controls['background'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type'  => 'background',
            'units' => true,
            'css'     => [
              [
                  'property' => 'background',
                  'selector' => '.nb-circular-menu__content',
              ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#c4c4c4',
                ],
            ],
        ];

        $this->controls['accessibilitySeparator'] = [
            'label'      => esc_html__( 'Accessibility', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['closeOnEsc'] = [
            'label' => esc_html__( 'Close when pressing ESC key', 'bricks' ),
            'type' => 'checkbox',
            'inline' => true,
            'small' => true,
            'default' => true,
        ];
    }

    /*Render children*/
    public function get_nestable_children() {
        return [
            [
            'name'     => 'coreburguer',
            'label'    => esc_html__( 'Burger', 'bricks' ),
            'settings' => [
                '_hidden' => [
                    '_cssClasses' => 'bc-core-burguer--circular-menu',
                ],
            ],
            ],
        
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Content', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'nb-circular-menu__content',
                    ],
                ],
            ]
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'nb-circular-menu', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_circular_menu.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $openbuilder = ! empty( $settings['openbuilder'] ) ? $settings['openbuilder'] : 0;
        $duration = ! empty( $settings['duration'] ) ? $settings['duration'] : '0.4s';
        $easing = ! empty( $settings['easing'] ) ? $settings['easing'] : 'none';
        if ($easing === 'custom') {
      $easing = ! empty( $settings['customEasing'] ) ? $settings['customEasing'] : 'none';
    }
        $customtoggle = ! empty( $settings['customtoggle'] ) ? $settings['customtoggle'] : '';
        $lockBodyScrolling = ! empty( $settings['lockBodyScrolling'] ) ? $settings['lockBodyScrolling'] : 0;
        $closeOnEsc = ! empty( $settings['closeOnEsc'] ) ? $settings['closeOnEsc'] : 0;

        $this->set_attribute( '_root', 'class', 'bc-core-menu' );
        $this->set_attribute( '_root', 'class', "nb-circular-menu");
        $this->set_attribute( '_root', 'data-duration', $duration );
        $this->set_attribute( '_root', 'data-easing', $easing );
        $this->set_attribute( '_root', 'data-customtoggle', $customtoggle );
        $this->set_attribute( '_root', 'data-customtoggle-lock-body-scrolling', $lockBodyScrolling );
        $this->set_attribute( '_root', 'data-open-builder', $openbuilder);
        $this->set_attribute( '_root', 'data-close-on-esc', $closeOnEsc);

        $output = "<div {$this->render_attributes( '_root' )}>";
        $output .= Frontend::render_children( $this );
        $output .= "</div>";

        echo $output;
    }
}