<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Dropdown extends \Bricks\Element {
  public $name         = 'nextdropdown';
  public $icon         = 'ion-ios-arrow-dropdown-circle';
  public $tag      = 'div';
  public $scripts      = ['next_dropdown'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Dropdown element', 'bricks' );
  }

  public function set_controls() {
    $this->controls['openbuilder'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Open at the builder', 'bricks' ),
      'type'     => 'checkbox',
    ];
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'section' => 'section',
          'nav' => 'nav',
          'aside' => 'aside',
          'header' => 'header',
          'footer' => 'footer',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];

    $this->controls['toggle'] = [
      'label'       => esc_html__( 'Toggle selector', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'classname',
    ];
    $this->controls['trigger'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Event', 'bricks' ),
      'type'        => 'select',
      'options'     => [
        'click' => 'click',
        'hover' => 'hover',
      ],
      'inline'      => true,
      'placeholder' => 'hover',
    ];

    //Accesibility
    $this->controls['accesibilitySeparator'] = [
      'label'       => esc_html__( 'Accesibility', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['opendefault'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Opened by default', 'bricks' ),
      'type'     => 'checkbox',
      'required' => [ 'trigger', '=', 'click'],
    ];
    $this->controls['closeclick'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Close when clicking outside', 'bricks' ),
      'type'     => 'checkbox',
      'required' => [ 'trigger', '=', 'click'],
    ];
    $this->controls['closeesc'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Close when pressing ESC', 'bricks' ),
      'type'     => 'checkbox',
    ];

    //Style
    $this->controls['styleSeparator'] = [
      'label'       => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['padding'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Padding', 'bricks' ),
      'type'  => 'spacing',
      'css'     => [
        [
            'property' => 'padding',
            'selector' => '',
        ],
      ],
    ];
    $this->controls['margin'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'     => [
        [
            'property' => 'margin',
            'selector' => '',
        ],
      ],
    ];
    $this->controls['background'] = [
      'hasDynamicData' => false,
      'inline'      => true,
      'tab' => 'content',
      'label' => esc_html__( 'Background', 'bricks' ),
      'type'  => 'background',
      'css'     => [
        [
            'property' => 'background',
            'selector' => '',
        ],
      ],
    ];
    $this->controls['border'] = [
      'hasDynamicData' => false,
      'inline'      => true,
      'tab' => 'content',
      'label' => esc_html__( 'Border', 'bricks' ),
      'type'  => 'border',
      'css'     => [
        [
            'property' => 'border',
            'selector' => '',
        ],
      ],
    ];
    $this->controls['boxShadow'] = [
      'hasDynamicData' => false,
      'inline'      => true,
      'tab' => 'content',
      'label' => esc_html__( 'Box shadow', 'bricks' ),
      'type'  => 'box-shadow',
      'css'     => [
        [
            'property' => 'box-shadow',
            'selector' => '',
        ],
      ],
    ];

    //Positioning
    $this->controls['positioningSeparator'] = [
      'label'       => esc_html__( 'Positioning', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['positioning'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Position', 'bricks' ),
      'type'        => 'select',
      'options'     => [
        'absolute' => 'absolute',
        'relative' => 'relative',
        'sticky' => 'sticky',
        'fixed' => 'fixed',
      ],
      'css'     => [
        [
            'property' => 'position',
            'selector' => '',
        ],
      ],
      'inline'      => true,
      'placeholder' => 'absolute',
    ];
    $this->controls['positioningResponsive'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Toggled Position', 'bricks' ),
      'type'        => 'select',
      'options'     => [
        'absolute' => 'absolute',
        'relative' => 'relative',
        'sticky' => 'sticky',
        'fixed' => 'fixed',
      ],
      'css'     => [
        [
            'property' => 'position',
            'selector' => '&[data-toggled]',
        ],
      ],
      'inline'      => true,
      'placeholder' => 'absolute',
    ];
    $this->controls['top'] = [
      'hasDynamicData' => false,
      'inline'      => true,
      'tab' => 'content',
      'label' => esc_html__( 'Top', 'bricks' ),
      'type'  => 'number',
      'units'      => true,
      'css'     => [
        [
            'property' => 'top',
            'selector' => '',
        ],
      ],
    ];
    $this->controls['bottom'] = [
      'hasDynamicData' => false,
      'inline'      => true,
      'tab' => 'content',
      'label' => esc_html__( 'Bottom', 'bricks' ),
      'type'  => 'number',
      'units'      => true,
      'css'     => [
        [
            'property' => 'bottom',
            'selector' => '',
        ],
      ],
    ];
    $this->controls['left'] = [
      'hasDynamicData' => false,
      'inline'      => true,
      'tab' => 'content',
      'label' => esc_html__( 'Left', 'bricks' ),
      'type'  => 'number',
      'units'      => true,
      'css'     => [
        [
            'property' => 'left',
            'selector' => '',
        ],
      ],
    ];
    $this->controls['right'] = [
      'hasDynamicData' => false,
      'inline'      => true,
      'tab' => 'content',
      'label' => esc_html__( 'Right', 'bricks' ),
      'type'  => 'number',
      'units'      => true,
      'css'     => [
        [
            'property' => 'right',
            'selector' => '',
        ],
      ],
    ];
    $this->controls['zIndex'] = [
      'hasDynamicData' => false,
      'inline'      => true,
      'tab' => 'content',
      'label' => esc_html__( 'zIndex', 'bricks' ),
      'type'  => 'text',
      'css'     => [
        [
            'property' => 'z-index',
            'selector' => '',
        ],
      ],
    ];

    //Mask
    $this->controls['maskSeparator'] = [
      'label'       => esc_html__( 'Mask', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['noteMask'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( "Mask is for having an additional spacing around the dropdown that will be taked
      into account to not close the dropdown. Think of it like an outer padding.<br> It is specially useful for the hover event, where hovering at this extra space won't close the dropdown.", 'bricks' )))
    ];
    $this->controls['mask'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Mask', 'bricks' ),
      'type'        => 'spacing',
      'css'     => [
        [
            'property' => '--mask',
            'selector' => '&:before',
        ],
      ],
    ];

    //Fade Animation
    $this->controls['fadeAnimationSeparator'] = [
      'label'       => esc_html__( 'Fade Animation', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['fadeDuration'] = [
      'hasDynamicData' => false,
      'inline'      => true,
      'tab' => 'content',
      'label' => esc_html__( 'Duration', 'bricks' ),
      'type'  => 'number',
      'unit' => 's',
      'css'     => [
        [
            'property' => '--opacity-duration',
            'selector' => '',
        ],
      ],
      'placeholder' => '0.2s',
    ];
    $this->controls['fadeDelay'] = [
      'hasDynamicData' => false,
      'inline'      => true,
      'tab' => 'content',
      'label' => esc_html__( 'Delay', 'bricks' ),
      'type'  => 'number',
      'unit' => 's',
      'css'     => [
        [
            'property' => '--opacity-delay',
            'selector' => '',
        ],
      ],
      'placeholder' => '0s',
    ];
    $this->controls['fadeEasing'] = [
      'hasDynamicData' => false,
      'inline'      => true,
      'tab' => 'content',
      'label' => esc_html__( 'CSS Easing', 'bricks' ),
      'type'  => 'text',
      'css'     => [
        [
            'property' => '--opacity-easing',
            'selector' => '',
        ],
      ],
      'placeholder' => 'ease',
    ];

    //Transform Animation
    $this->controls['transformAnimationSeparator'] = [
      'label'       => esc_html__( 'Transform Animation', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['scale'] = [
      'hasDynamicData' => false,
      'inline'      => true,
      'tab' => 'content',
      'label' => esc_html__( 'Scale', 'bricks' ),
      'type'  => 'text',
      'css'     => [
        [
            'property' => '--scale',
            'selector' => '',
        ],
      ],
      'placeholder' => '0',
    ];
    $this->controls['x'] = [
      'hasDynamicData' => false,
      'inline'      => true,
      'tab' => 'content',
      'label' => esc_html__( 'Transform X', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'     => [
        [
            'property' => '--x',
            'selector' => '',
        ],
      ],
      'placeholder' => '0px',
    ];
    $this->controls['y'] = [
      'hasDynamicData' => false,
      'inline'      => true,
      'tab' => 'content',
      'label' => esc_html__( 'Transform Y', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'     => [
        [
            'property' => '--y',
            'selector' => '',
        ],
      ],
      'placeholder' => '-30px',
    ];
    $this->controls['transformDuration'] = [
      'hasDynamicData' => false,
      'inline'      => true,
      'tab' => 'content',
      'label' => esc_html__( 'Duration', 'bricks' ),
      'type'  => 'number',
      'unit' => 's',
      'css'     => [
        [
            'property' => '--transform-duration',
            'selector' => '',
        ],
      ],
      'placeholder' => '0.2s',
    ];
    $this->controls['transformDelay'] = [
      'hasDynamicData' => false,
      'inline'      => true,
      'tab' => 'content',
      'label' => esc_html__( 'Delay', 'bricks' ),
      'type'  => 'number',
      'unit' => 's',
      'css'     => [
        [
            'property' => '--transform-delay',
            'selector' => '',
        ],
      ],
      'placeholder' => '0s',
    ];
    $this->controls['transformEasing'] = [
      'hasDynamicData' => false,
      'inline'      => true,
      'tab' => 'content',
      'label' => esc_html__( 'CSS Easing', 'bricks' ),
      'type'  => 'text',
      'css'     => [
        [
            'property' => '--transform-easing',
            'selector' => '',
        ],
      ],
      'placeholder' => 'ease',
    ];
  }
  
/*Render children*/
public function get_nestable_children() {
    return [
        [
            'name'     => 'heading',
        ],
        [
            'name'     => 'heading',
        ],
        [
            'name'     => 'heading',
        ],
    ];
}

  public function enqueue_scripts() {
    wp_enqueue_script( 'next-dropdown', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_dropdown.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $openbuilder = ! empty( $settings['openbuilder'] ) ? $settings['openbuilder'] : 0;
    $closeclick = ! empty( $settings['closeclick'] ) ? $settings['closeclick'] : 0;
    $closeesc = ! empty( $settings['closeesc'] ) ? $settings['closeesc'] : 0;
    $toggle = ! empty( $settings['toggle'] ) ? $settings['toggle'] : 'classname';
    $trigger = ! empty( $settings['trigger'] ) ? $settings['trigger'] : 'hover';
    
    //Responsive style
    $positioningResponsive = ! empty( $settings['positioningResponsive'] ) ? $settings['positioningResponsive'] : 'relative';

    $this->set_attribute( '_root', 'class', 'next-dropdown' );
    $this->set_attribute( '_root', 'tabindex', '0' );

    $opendefault = ! empty( $settings['opendefault'] ) ? $settings['opendefault'] : 0;
    if($opendefault == 1 && $trigger == 'click'){
      $this->set_attribute( '_root', 'data-toggled', '' );
    }else{
      $this->set_attribute( '_root', 'inert', '' );
    }
    
    $this->set_attribute( '_root', 'data-closeclick', $closeclick );
    $this->set_attribute( '_root', 'data-closeesc', $closeesc );
    $this->set_attribute( '_root', 'data-toggle', $toggle );
    $this->set_attribute( '_root', 'data-trigger', $trigger );

    if ( bricks_is_builder_call() ){
      if($openbuilder == 1){
        $this->set_attribute( '_root', 'data-toggled-builder', '' );
      }
    }

    $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
    $output .= Frontend::render_children( $this );
    $output .= "</{$this->tag}>";

    echo $output;
  }
}