<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Dynamic_Copyright extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'next-dynamic-copyright';
  public $icon         = 'ti-text';
  public $tag      = 'h3';
  public $scripts      = ['next_dynamic_copyright'];

  public function get_label() {
    return esc_html__( 'Dynamic Copyright', 'bricks' );
  }

  public function set_controls() {
    $this->controls['prefix'] = [
        'label'       => esc_html__( 'Prefix', 'bricks' ),
        'tab'            => 'content',
        'type'           => 'text',
        'inline'         => true,
        'hasDynamicData' => 'text',
        'default'        => esc_html__( '©', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['suffix'] = [
        'label'       => esc_html__( 'Suffix', 'bricks' ),
        'tab'            => 'content',
        'type'           => 'text',
        'inline'         => true,
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Next Bricks', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];

    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'h1' => 'h1',
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
            'p' => 'p',
            'span' => 'span',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'h3',
        'default'     => 'h3',
    ];
    $this->controls['customTag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Custom tag', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'placeholder' => 'h3',
        'required'    => [ 'tag', '=', 'custom' ],
    ];

    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['generalTypography'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'General Typography', 'bricks' ),
      'type'  => 'typography',
      'css'   => [
        [
          'property' => 'typography',
          'selector' => '',
        ],
      ],
      'default' => [
        'font-size' => '32px',
        'text-transform' => 'uppercase',
      ],
    ];
    $this->controls['prefixTypography'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Prefix Typography', 'bricks' ),
      'type'  => 'typography',
      'css'   => [
        [
          'property' => 'typography',
          'selector' => '.next-dynamic-copyright__prefix',
        ],
      ],
      'default' => [
        'color' => [
          'hex' => '#24a0ff',
        ],
      ],
    ];
    $this->controls['yearTypography'] = [
      'tab'   => 'content', 
      'label' => esc_html__( 'Year Typography', 'bricks' ),
      'type'  => 'typography',
      'css'   => [
        [
          'property' => 'typography',
          'selector' => '.next-dynamic-copyright__year',
        ],
      ],
    ];
    $this->controls['suffixTypography'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Suffix Typography', 'bricks' ),
      'type'  => 'typography', 
      'css'   => [
        [
          'property' => 'typography',
          'selector' => '.next-dynamic-copyright__suffix',
        ],
      ],
    ];
  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'next-dynamic-copyright', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_dynamic_copyright.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $is_builder = bricks_is_builder();
    $prefix    = ! empty( $settings['prefix'] ) ? $settings['prefix'] : '';
    $suffix    = ! empty( $settings['suffix'] ) ? $settings['suffix'] : '';

    $this->set_attribute( '_root', 'class', 'next-dynamic-copyright' );

    if ( ! $is_builder ) {
      $this->set_attribute( '_root', 'data-flickering', '1' );
    }

    if ( ! empty( $settings['link'] ) ) {
        $this->set_link_attributes( '_link', $settings['link'] );
        $output ="
        <{$this->tag} {$this->render_attributes( '_root' )}>
            <a class='next-dynamic-copyright__anchor' {$this->render_attributes( '_link' )}>
                <span class='next-dynamic-copyright__prefix'>$prefix</span>
                <span class='next-dynamic-copyright__year'>20??</span>
                <span class='next-dynamic-copyright__suffix'>$suffix</span>
            </a>
        </{$this->tag}>
        ";
    }else{
        $output ="
        <{$this->tag} {$this->render_attributes( '_root' )}>
            <span class='next-dynamic-copyright__prefix'>$prefix</span>
            <span class='next-dynamic-copyright__year'>20??</span>
            <span class='next-dynamic-copyright__suffix'>$suffix</span>
        </{$this->tag}>
        ";
    }

    echo $output;
  }
}
