<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Figures extends \Bricks\Element {
  public $category     = 'Next Bricks - Backgrounds';
  public $name         = 'next_figures';
  public $icon         = 'fas fa-shapes';
  public $tag      = 'div';
  public $scripts      = ['next_figures'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Figures', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
        'div' => 'div',
        'section' => 'section',
        'article' => 'article',
        'aside' => 'aside',
        'header' => 'header',
        'footer' => 'footer',
        'main' => 'main',
        'nav' => 'nav',
        'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];

    /*css*/
    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Block Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['widthStyle'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'width',
            'selector' => '',
          ]
        ],
        'default' => '100%',
        'rerender' => true,
    ];
    $this->controls['heightStyle'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'height',
            'selector' => '',
          ]
        ],
        'default' => '500px',
        'rerender' => true,
    ];

    /*js settings*/
    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Figures Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['disablebuilder'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Disable in the Builder', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'default' => false,
    ];
    $this->controls['type'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Type', 'bricks' ),
        'type' => 'select',
        'options' => [
            'type1' => esc_html__( 'Type 1', 'bricks' ),
            'type2' => esc_html__( 'Type 2', 'bricks' ),
            'type3' => esc_html__( 'Type 3', 'bricks' ),
            'type4' => esc_html__( 'Type 4', 'bricks' ),
        ],
        'inline' => true,
        'default' => 'type1',
    ];
    // Common settings for all types
    $this->controls['figureSize'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Figure Size', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => 40,
    ];
    $this->controls['metalness'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Metalness', 'bricks' ),
        'type' => 'number',
        'min' => 0,
        'max' => 1,
        'step' => 0.1,
        'inline' => true,
        'default' => 0.8,
    ];
    $this->controls['roughness'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Roughness', 'bricks' ),
        'type' => 'number',
        'min' => 0,
        'max' => 1,
        'step' => 0.1,
        'inline' => true,
        'default' => 0.5,
    ];
    $this->controls['clearcoat'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Clearcoat', 'bricks' ),
        'type' => 'number',
        'min' => 0,
        'max' => 1,
        'step' => 0.1,
        'inline' => true,
        'default' => 1,
    ];
    $this->controls['clearcoatRoughness'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Clearcoat Roughness', 'bricks' ),
        'type' => 'number',
        'min' => 0,
        'max' => 1,
        'step' => 0.1,
        'inline' => true,
        'default' => 0.1,
    ];
    $this->controls['firstColor'] = [
        'tab' => 'content',
        'label' => esc_html__( 'First Color', 'bricks' ),
        'type' => 'color',
        'inline' => true,
        'css' => [
          [
            'property' => '--first-color',
            'selector' => '',
          ]
        ],
        'default' => [
            'hex' => '#0000FF',
        ],
        'rerender' => true,
    ];
    $this->controls['firstColorIntensity'] = [
        'tab' => 'content',
        'label' => esc_html__( 'First Color Intensity', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => 2500,
    ];
    $this->controls['secondColor'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Second Color', 'bricks' ),
        'type' => 'color',
        'inline' => true,
        'css' => [
            [
              'property' => '--second-color',
              'selector' => '',
            ]
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
        'rerender' => true,
    ];
    $this->controls['secondColorIntensity'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Second Color Intensity', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => 250,
    ];
    $this->controls['lightColor'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Light Color', 'bricks' ),
        'type' => 'color',
        'inline' => true,
        'css' => [
            [
              'property' => '--light-color',
              'selector' => '',
            ]
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
        'rerender' => true,
    ];
    $this->controls['lightPositionZ'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Light Position Z', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => 10,
    ];
    $this->controls['speed'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Speed', 'bricks' ),
        'type' => 'number',
        'step' => 0.1,
        'inline' => true,
        'default' => 0.5,
    ];
    $this->controls['height'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type' => 'number',
        'step' => 0.1,
        'inline' => true,
        'default' => 2.5,
    ];
    $this->controls['figureShape'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Figure Shape', 'bricks' ),
        'type' => 'select',
        'options' => [
            'triangle' => esc_html__( 'Triangle', 'bricks' ),
            'square' => esc_html__( 'Square', 'bricks' ),
            'pentagon' => esc_html__( 'Pentagon', 'bricks' ),
            'hexagon' => esc_html__( 'Hexagon', 'bricks' ),
            'circle' => esc_html__( 'Circle', 'bricks' ),
        ],
        'inline' => true,
        'default' => 'square',
        'required' => ['type', '=', ['type1', 'type2']],
    ];
    $this->controls['mouseovertilt'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Mouse Over Tilt', 'bricks' ),
        'type' => 'number',
        'step' => 0.01,
        'inline' => true,
        'default' => 0.15,
        'required' => ['type', '=', 'type1'],
    ];
    $this->controls['mouseoverradius'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Mouse Over Radius', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => 10,
        'required' => ['type', '=', 'type2'],
    ];
    $this->controls['density'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Density', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => 20,
        'required' => ['type', '=', 'type2'],
    ];
    $this->controls['padding'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Padding', 'bricks' ),
        'type' => 'number',
        'step' => 0.1,
        'inline' => true,
        'default' => 0.1,
        'required' => ['type', '=', 'type2'],
    ];
    $this->controls['bgColor'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Background Color', 'bricks' ),
        'type' => 'color',
        'inline' => true,
        'css' => [
            [
              'property' => '--bg-color',
              'selector' => '',
            ]
        ],
        'default' => [
            'hex' => '#000000',
        ],
        'rerender' => true,
        'required' => ['type', '=', 'type2'],
    ];
    $this->controls['count'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Count', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => 100,
        'required' => ['type', '=', ['type3', 'type4']],
    ];
    $this->controls['lightIntensity'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Light Intensity', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => 5,
        'required' => ['type', '=', ['type3', 'type4']],
    ];
    $this->controls['sphereminSize'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Min Size', 'bricks' ),
        'type' => 'number',
        'step' => 0.05,
        'inline' => true,
        'default' => 0.25,
        'required' => ['type', '=', ['type3', 'type4']],
    ];
    $this->controls['spheremaxSize'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Max Size', 'bricks' ),
        'type' => 'number',
        'step' => 0.1,
        'inline' => true,
        'default' => 1,
        'required' => ['type', '=', ['type3', 'type4']],
    ];
    $this->controls['sphereSize0'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Sphere Size 0', 'bricks' ),
        'type' => 'number',
        'step' => 0.1,
        'inline' => true,
        'default' => 2,
        'required' => ['type', '=', ['type3', 'type4']],
    ];
    $this->controls['sphereFriction'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Friction', 'bricks' ),
        'type' => 'number',
        'step' => 0.001,
        'inline' => true,
        'default' => 0.999,
        'required' => ['type', '=', ['type3', 'type4']],
    ];
    $this->controls['sphereMaxVelocity'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Max Velocity', 'bricks' ),
        'type' => 'number',
        'step' => 0.01,
        'inline' => true,
        'default' => 0.15,
        'required' => ['type', '=', ['type3', 'type4']],
    ];
    $this->controls['sphereAttraction'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Attraction', 'bricks' ),
        'type' => 'number',
        'step' => 0.1,
        'inline' => true,
        'default' => 1.2,
        'required' => ['type', '=', 'type3'],
    ];
    $this->controls['gravity'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Gravity', 'bricks' ),
        'type' => 'number',
        'step' => 0.1,
        'inline' => true,
        'default' => 0.5,
        'required' => ['type', '=', 'type4'],
    ];
    $this->controls['wallBounce'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Wall Bounce', 'bricks' ),
        'type' => 'number',
        'step' => 0.01,
        'inline' => true,
        'default' => 0.95,
        'required' => ['type', '=', 'type4'],
    ];
    $this->controls['createMaxX'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Max X', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => 5,
        'required' => ['type', '=', 'type4'],
    ];
    $this->controls['createMaxY'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Max Y', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => 5,
        'required' => ['type', '=', 'type4'],
    ];
    $this->controls['createMaxZ'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Max Z', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => 2,
        'required' => ['type', '=', 'type4'],
    ];
  }
  public function get_nestable_children() {
    return [
        [
            'name'     => 'block',
            'label'    => esc_html__( 'Content', 'bricks' ),
            'settings' => [
                '_hidden'  => [
                    '_cssClasses' => 'nb-figures__content',
                ],
            ],
            'children' => [
                [
                    'name'     => 'heading',
                    'label'    => esc_html__( 'Heading', 'bricks' ),
                    'settings' => [
                        'text' => esc_html__( 'Figures', 'bricks' ),
                        'tag'  => 'h3',
                    ],
                ]
            ]
        ],
    ];
}

  public function enqueue_scripts() {
    wp_register_script( 'next_figures_1', NEXTBRICKS_PLUGIN_URL . 'elements/js/figures-type1.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    wp_register_script( 'next_figures_2', NEXTBRICKS_PLUGIN_URL . 'elements/js/figures-type2.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    wp_register_script( 'next_figures_3', NEXTBRICKS_PLUGIN_URL . 'elements/js/figures-type3.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    wp_register_script( 'next_figures_4', NEXTBRICKS_PLUGIN_URL . 'elements/js/figures-type4.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    wp_register_script( 'next_figures', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_figures.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    
    // Ensure scripts are treated as ES modules by WordPress core
    if ( function_exists( 'wp_script_add_data' ) ) {
      wp_script_add_data( 'next_figures_1', 'type', 'module' );
      wp_script_add_data( 'next_figures_2', 'type', 'module' );
      wp_script_add_data( 'next_figures_3', 'type', 'module' );
      wp_script_add_data( 'next_figures_4', 'type', 'module' );
      wp_script_add_data( 'next_figures',   'type', 'module' );
    }
    
    // Add module type to scripts
    add_filter('script_loader_tag', function($tag, $handle, $src) {
      if (in_array($handle, ['next_figures_1', 'next_figures_2', 'next_figures_3', 'next_figures_4', 'next_figures'])) {
        $tag = '<script type="module" src="' . esc_url($src) . '" id="' . $handle . '"></script>';
      }
      return $tag;
    }, 10, 3);
    
    wp_enqueue_script('next_figures_1');
    wp_enqueue_script('next_figures_2');
    wp_enqueue_script('next_figures_3');
    wp_enqueue_script('next_figures_4');
    wp_enqueue_script('next_figures');
  }

  public function render() {
    $settings = $this->settings;
    $is_builder = bricks_is_builder();
    $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
    $type = ! empty( $settings['type'] ) ? $settings['type'] : 'type1';
    $figureSize = ! empty( $settings['figureSize'] ) ? $settings['figureSize'] : 40;
    $metalness = ! empty( $settings['metalness'] ) ? $settings['metalness'] : 0.8;
    $roughness = ! empty( $settings['roughness'] ) ? $settings['roughness'] : 0.5;
    $clearcoat = ! empty( $settings['clearcoat'] ) ? $settings['clearcoat'] : 1;
    $clearcoatRoughness = ! empty( $settings['clearcoatRoughness'] ) ? $settings['clearcoatRoughness'] : 0.1;
    $firstColorIntensity = ! empty( $settings['firstColorIntensity'] ) ? $settings['firstColorIntensity'] : 2500;
    $secondColorIntensity = ! empty( $settings['secondColorIntensity'] ) ? $settings['secondColorIntensity'] : 250;
    $lightPositionZ = ! empty( $settings['lightPositionZ'] ) ? $settings['lightPositionZ'] : 10;
    $speed = ! empty( $settings['speed'] ) ? $settings['speed'] : 0.5;
    $height = ! empty( $settings['height'] ) ? $settings['height'] : 2.5;
    $figureShape = ! empty( $settings['figureShape'] ) ? $settings['figureShape'] : 'square';
    $mouseovertilt = ! empty( $settings['mouseovertilt'] ) ? $settings['mouseovertilt'] : 0.15;
    $mouseoverradius = ! empty( $settings['mouseoverradius'] ) ? $settings['mouseoverradius'] : 10;
    $density = ! empty( $settings['density'] ) ? $settings['density'] : 20;
    $padding = ! empty( $settings['padding'] ) ? $settings['padding'] : 0.1;
    $bgColor = ! empty( $settings['bgColor'] ) ? $settings['bgColor'] : '#000000';
    $count = ! empty( $settings['count'] ) ? $settings['count'] : 100;
    $lightIntensity = ! empty( $settings['lightIntensity'] ) ? $settings['lightIntensity'] : 5;
    $sphereminSize = ! empty( $settings['sphereminSize'] ) ? $settings['sphereminSize'] : 0.25;
    $spheremaxSize = ! empty( $settings['spheremaxSize'] ) ? $settings['spheremaxSize'] : 1;
    $sphereSize0 = ! empty( $settings['sphereSize0'] ) ? $settings['sphereSize0'] : 2;
    $sphereFriction = ! empty( $settings['sphereFriction'] ) ? $settings['sphereFriction'] : 0.999;
    $sphereMaxVelocity = ! empty( $settings['sphereMaxVelocity'] ) ? $settings['sphereMaxVelocity'] : 0.15;
    $sphereAttraction = ! empty( $settings['sphereAttraction'] ) ? $settings['sphereAttraction'] : 1.2;
    $gravity = ! empty( $settings['gravity'] ) ? $settings['gravity'] : 0.5;
    $wallBounce = ! empty( $settings['wallBounce'] ) ? $settings['wallBounce'] : 0.95;
    $createMaxX = ! empty( $settings['createMaxX'] ) ? $settings['createMaxX'] : 5;
    $createMaxY = ! empty( $settings['createMaxY'] ) ? $settings['createMaxY'] : 5;
    $createMaxZ = ! empty( $settings['createMaxZ'] ) ? $settings['createMaxZ'] : 2;

    $this->set_attribute( '_root', 'class', "nb-figures");

    if ( ! $is_builder ) {
        $this->set_attribute( '_root', 'data-flickering', '1');
    }
    $this->set_attribute( '_root', 'data-disable-builder', $disablebuilder);
    $this->set_attribute( '_root', 'data-type', $type);
    $this->set_attribute( '_root', 'data-figure-size', $figureSize);
    $this->set_attribute( '_root', 'data-metalness', $metalness);
    $this->set_attribute( '_root', 'data-roughness', $roughness);
    $this->set_attribute( '_root', 'data-clearcoat', $clearcoat);
    $this->set_attribute( '_root', 'data-clearcoat-roughness', $clearcoatRoughness);
    $this->set_attribute( '_root', 'data-first-color-intensity', $firstColorIntensity);
    $this->set_attribute( '_root', 'data-second-color-intensity', $secondColorIntensity);
    $this->set_attribute( '_root', 'data-light-position-z', $lightPositionZ);
    $this->set_attribute( '_root', 'data-speed', $speed);
    $this->set_attribute( '_root', 'data-height', $height);
    $this->set_attribute( '_root', 'data-figure-shape', $figureShape);
    $this->set_attribute( '_root', 'data-mouseovertilt', $mouseovertilt);
    $this->set_attribute( '_root', 'data-mouseoverradius', $mouseoverradius);
    $this->set_attribute( '_root', 'data-density', $density);
    $this->set_attribute( '_root', 'data-padding', $padding);
    $this->set_attribute( '_root', 'data-bg-color', $bgColor);
    $this->set_attribute( '_root', 'data-count', $count);
    $this->set_attribute( '_root', 'data-light-intensity', $lightIntensity);
    $this->set_attribute( '_root', 'data-sphere-min-size', $sphereminSize);
    $this->set_attribute( '_root', 'data-sphere-max-size', $spheremaxSize);
    $this->set_attribute( '_root', 'data-sphere-size-0', $sphereSize0);
    $this->set_attribute( '_root', 'data-sphere-friction', $sphereFriction);
    $this->set_attribute( '_root', 'data-sphere-max-velocity', $sphereMaxVelocity);
    $this->set_attribute( '_root', 'data-sphere-attraction', $sphereAttraction);
    $this->set_attribute( '_root', 'data-gravity', $gravity);
    $this->set_attribute( '_root', 'data-wall-bounce', $wallBounce);
    $this->set_attribute( '_root', 'data-create-max-x', $createMaxX);
    $this->set_attribute( '_root', 'data-create-max-y', $createMaxY);
    $this->set_attribute( '_root', 'data-create-max-z', $createMaxZ);
    
    $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
    $output .= '<canvas class="nb-figures__canvas"></canvas>';
    $output .= Frontend::render_children( $this );
    $output .= "</{$this->tag}>";

	echo $output;
  }
}
