<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Image_Accordion extends \Bricks\Element {
    public $category     = 'Next Bricks - Medias';
    public $name         = 'next_image_accordion';
    public $icon         = 'ti-layout-slider-alt';
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Image Accordion', 'bricks' );
    }

    public function set_controls() {
        $this->controls['width'] = [
            'tab' => 'content',
            'label' => esc_html__('Width', 'bricks'),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'width',
                    'selector' => '',
                ],
            ],
            'default' => '100%',
        ];
        $this->controls['height'] = [
            'tab' => 'content',
            'label' => esc_html__('Height', 'bricks'),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'height',
                    'selector' => '',
                ],
            ],
            'default' => '500px',
        ];

        // ITEM SETTINGS
        $this->controls['itemSeparator'] = [
            'tab' => 'content',
            'label' => esc_html__('Item Settings', 'bricks'),
            'type' => 'separator',
        ];

        $this->controls['expandedFlex'] = [
            'tab' => 'content',
            'label' => esc_html__('Expanded Size', 'bricks'),
            'type' => 'number',
            'css' => [
                [
                    'property' => 'flex',
                    'selector' => '.next-image-accordion__item:hover',
                ],
            ],
            'default' => '3',
        ];

        $this->controls['scale'] = [
            'tab' => 'content',
            'label' => esc_html__('Scale', 'bricks'),
            'type' => 'text',
            'inline' => true,
            'small' => true,
            'css' => [
                [
                    'property' => '--scale',
                    'selector' => '.next-image-accordion__item',
                ],
            ],
            'default' => '1.1',
        ];

        $this->controls['grayscale'] = [
            'tab' => 'content',
            'label' => esc_html__('Grayscale', 'bricks'),
            'type' => 'text',
            'inline' => true,
            'small' => true,
            'css' => [
                [
                    'property' => '--gray',
                    'selector' => '.next-image-accordion__item',
                ],
            ],
            'default' => '100%',
        ];

        // ANIMATION SETTINGS
        $this->controls['animationSeparator'] = [
            'tab' => 'content',
            'label' => esc_html__('Expanding Animation', 'bricks'),
            'type' => 'separator',
        ];

        $this->controls['expandingDuration'] = [
            'tab' => 'content',
            'label' => esc_html__('Duration', 'bricks'),
            'type' => 'number',
            'unit' => 's',
            'css' => [
                [
                    'property' => '--expanding-duration',
                    'selector' => '.next-image-accordion__item',
                ],
            ],
            'default' => '0.5s',
        ];

        $this->controls['expandingEase'] = [
            'tab' => 'content',
            'label' => esc_html__('CSS Easing', 'bricks'),
            'type' => 'text',
            'css' => [
                [
                    'property' => '--expanding-ease',
                    'selector' => '.next-image-accordion__item',
                ],
            ],
            'default' => 'ease',
        ];

        // CONTENT SETTINGS
        $this->controls['contentSeparator'] = [
            'tab' => 'content',
            'label' => esc_html__('Content Style', 'bricks'),
            'type' => 'separator',
        ];

        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Text elements inside Content should have defined widths so that lines are already wrapped before expanding.', 'bricks' )))
        ];

        $this->controls['contentPadding'] = [
            'tab' => 'content',
            'label' => esc_html__('Padding', 'bricks'),
            'type' => 'spacing',
            'css' => [
                [
                    'property' => 'padding',
                    'selector' => '.next-image-accordion__content',
                ],
            ],
            'default' => [
                'top' => 20,
                'right' => 20,
                'bottom' => 20,
                'left' => 20,
            ],
        ];

        $this->controls['contentTop'] = [
            'tab' => 'content',
            'label' => esc_html__('Top', 'bricks'),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'top',
                    'selector' => '.next-image-accordion__content',
                ],
            ],
        ];

        $this->controls['contentLeft'] = [
            'tab' => 'content',
            'label' => esc_html__('Left', 'bricks'),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'left',
                    'selector' => '.next-image-accordion__content',
                ],
            ],
            'default' => '0',
        ];

        $this->controls['contentBottom'] = [
            'tab' => 'content',
            'label' => esc_html__('Bottom', 'bricks'),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'bottom',
                    'selector' => '.next-image-accordion__content',
                ],
            ],
            'default' => '0',
        ];

        $this->controls['contentRight'] = [
            'tab' => 'content',
            'label' => esc_html__('Right', 'bricks'),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'right',
                    'selector' => '.next-image-accordion__content',
                ],
            ],
        ];

        $this->controls['contentBackground'] = [
            'tab' => 'content',
            'label' => esc_html__('Background', 'bricks'),
            'type' => 'background',
            'css' => [
                [
                    'property' => 'background',
                    'selector' => '.next-image-accordion__content',
                ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#00000060',
                ],
            ],
        ];

        $this->controls['contentTypography'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Typography', 'bricks' ),
            'type'    => 'typography',
            'css'     => [
                [
                    'property' => 'typography',
                    'selector' => '.next-image-accordion__content',
                ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#fff',
                ],
            ],
        ];

        // CONTENT FADE ANIMATION
        $this->controls['fadeSeparator'] = [
            'tab' => 'content',
            'label' => esc_html__('Content Fade Animation', 'bricks'),
            'type' => 'separator',
        ];

        $this->controls['fadeDuration'] = [
            'tab' => 'content',
            'label' => esc_html__('Duration', 'bricks'),
            'type' => 'number',
            'unit' => 's',
            'css' => [
                [
                    'property' => '--fade-duration',
                    'selector' => '.next-image-accordion__content',
                ],
            ],
            'default' => '0.3s',
        ];

        $this->controls['fadeEase'] = [
            'tab' => 'content',
            'label' => esc_html__('CSS Easing', 'bricks'),
            'type' => 'text',
            'css' => [
                [
                    'property' => '--fade-ease',
                    'selector' => '.next-image-accordion__content',
                ],
            ],
            'default' => 'ease',
        ];
    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Item', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-image-accordion__item',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'image',
                        'label'    => esc_html__( 'Image', 'bricks' ),
                        'settings' => [
                            'image'  => [
                                'url' => 'https://images.pexels.com/photos/2626665/pexels-photo-2626665.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2',
                            ],
                            'alt' => 'BMW Serie 1'
                        ],
                    ],
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Content', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'next-image-accordion__content',
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'heading',
                                'settings' => [
                                    'text' => 'Robust 1',
                                    'tag' => 'h2'
                                ],
                            ],
                            [
                                'name'     => 'text',
                                'settings' => [
                                    'text' => 'Lorem ipsum dolor sit amet.',
                                ],
                            ],
                        ]
                    ],
                ]
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Item', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-image-accordion__item',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'image',
                        'label'    => esc_html__( 'Image', 'bricks' ),
                        'settings' => [
                            'image'  => [
                                'url' => 'https://images.pexels.com/photos/2116475/pexels-photo-2116475.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2',
                            ],
                            'alt' => 'BMW Serie 2'
                        ],
                    ],
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Content', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'next-image-accordion__content',
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'heading',
                                'settings' => [
                                    'text' => 'Robust 2',
                                    'tag' => 'h2'
                                ],
                            ],
                            [
                                'name'     => 'text',
                                'settings' => [
                                    'text' => 'Lorem ipsum dolor sit amet.',
                                ],
                            ],
                        ]
                    ],
                ]
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Item', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-image-accordion__item',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'image',
                        'label'    => esc_html__( 'Image', 'bricks' ),
                        'settings' => [
                            'image'  => [
                                'url' => 'https://images.pexels.com/photos/1715184/pexels-photo-1715184.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2',
                            ],
                            'alt' => 'BMW Serie 3'
                        ],
                    ],
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Content', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'next-image-accordion__content',
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'heading',
                                'settings' => [
                                    'text' => 'Robust 3',
                                    'tag' => 'h2'
                                ],
                            ],
                            [
                                'name'     => 'text',
                                'settings' => [
                                    'text' => 'Lorem ipsum dolor sit amet.',
                                ],
                            ],
                        ]
                    ],
                ]
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Item', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-image-accordion__item',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'image',
                        'label'    => esc_html__( 'Image', 'bricks' ),
                        'settings' => [
                            'image'  => [
                                'url' => 'https://images.pexels.com/photos/347149/pexels-photo-347149.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2',
                            ],
                            'alt' => 'BMW Serie 4'
                        ],
                    ],
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Content', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'next-image-accordion__content',
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'heading',
                                'settings' => [
                                    'text' => 'Robust 4',
                                    'tag' => 'h2'
                                ],
                            ],
                            [
                                'name'     => 'text',
                                'settings' => [
                                    'text' => 'Lorem ipsum dolor sit amet.',
                                ],
                            ],
                        ]
                    ],
                ]
            ],
        ];
    }

    public function render() {
        $settings = $this->settings;

        $this->set_attribute( '_root', 'class', "next-image-accordion");

        $output = "<div {$this->render_attributes( '_root' )}>";
        $output .= Frontend::render_children( $this );
        $output .= '</div>';

        echo $output;
    }
}