<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Interactive_Lines_v4 extends \Bricks\Element {
  public $category     = 'Next Bricks - Backgrounds';
  public $name         = 'next_interactive_lines_v4';
  public $icon         = 'fas fa-slash';
  public $tag      = 'div';
  public $scripts      = ['next_interactive_lines_v4'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Interactive Lines v4', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
        'div' => 'div',
        'section' => 'section',
        'article' => 'article',
        'aside' => 'aside',
        'header' => 'header',
        'footer' => 'footer',
        'main' => 'main',
        'nav' => 'nav',
        'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];

    /*css*/
    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Block Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['width'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'width',
            'selector' => '',
          ]
        ],
        'default' => '100%',
    ];
    $this->controls['height'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'height',
            'selector' => '',
          ]
        ],
        'default' => '500px',
    ];
    $this->controls['background'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Background', 'bricks' ),
        'type'  => 'color',
        'inline' => true,
        'css' => [
          [
            'property' => 'background',
            'selector' => '',
          ]
        ],
        'default' => [
            'hex' => '#111111',
        ],
    ];

    $this->controls['linesSeparator'] = [
        'label'      => esc_html__( 'Lines Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['lineColor'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Color', 'bricks' ),
        'type'  => 'color',
        'inline' => true,
        'css' => [
          [
            'property' => '--line-color',
            'selector' => '',
          ]
        ],
        'default' => [
            'hex' => '#333333',
        ],
    ];


    /*js settings*/
    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Interactive Lines Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['note'] = [
        'tab' => 'content',
        'description' => sprintf(html_entity_decode(esc_html__( 'Interactive Lines v4 can only be visible on the front.', 'bricks' )))
      ];
    $this->controls['waveSpeedX'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Wave Speed X', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => 0.0125,
    ];
    $this->controls['waveSpeedY'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Wave Speed Y', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => 0.005,
    ];
    $this->controls['waveAmpX'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Wave Amplitude X', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => 32,
    ];
    $this->controls['waveAmpY'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Wave Amplitude Y', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => 16,
    ];
    $this->controls['xGap'] = [
        'tab' => 'content',
        'label' => esc_html__( 'X Gap', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => 10,
    ];
    $this->controls['yGap'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Y Gap', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => 32,
    ];
    $this->controls['friction'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Friction', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => 0.925,
    ];
    $this->controls['tension'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Tension', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => 0.005,
    ];
    $this->controls['maxCursorMove'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Max Cursor Move', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => 100,
    ];
  }

  public function get_nestable_children() {
    return [
        [
            'name'     => 'block',
            'label'    => esc_html__( 'Content', 'bricks' ),
            'settings' => [
                '_hidden'  => [
                    '_cssClasses' => 'nb-interactive-lines-v4__content',
                ],
            ],
            'children' => [
                [
                    'name'     => 'heading',
                    'label'    => esc_html__( 'Heading', 'bricks' ),
                    'settings' => [
                        'text' => esc_html__( 'Interactive Lines v4', 'bricks' ),
                        'tag'  => 'h3',
                    ],
                ]
            ]
        ],
    ];
}

  public function enqueue_scripts() {
    wp_enqueue_script( 'next_interactive_lines_v4', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_interactive_lines_v4.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $wave_speed_x = ! empty( $settings['waveSpeedX'] ) ? $settings['waveSpeedX'] : 0.0125;
    $wave_speed_y = ! empty( $settings['waveSpeedY'] ) ? $settings['waveSpeedY'] : 0.005;
    $wave_amp_x = ! empty( $settings['waveAmpX'] ) ? $settings['waveAmpX'] : 32;
    $wave_amp_y = ! empty( $settings['waveAmpY'] ) ? $settings['waveAmpY'] : 16;
    $x_gap = ! empty( $settings['xGap'] ) ? $settings['xGap'] : 10;
    $y_gap = ! empty( $settings['yGap'] ) ? $settings['yGap'] : 32;
    $friction = ! empty( $settings['friction'] ) ? $settings['friction'] : 0.925;
    $tension = ! empty( $settings['tension'] ) ? $settings['tension'] : 0.005;
    $max_cursor_move = ! empty( $settings['maxCursorMove'] ) ? $settings['maxCursorMove'] : 100;

    $this->set_attribute( '_root', 'class', "nb-interactive-lines-v4");
    $this->set_attribute( '_root', 'data-wave-speed-x', $wave_speed_x);
    $this->set_attribute( '_root', 'data-wave-speed-y', $wave_speed_y);
    $this->set_attribute( '_root', 'data-wave-amp-x', $wave_amp_x);
    $this->set_attribute( '_root', 'data-wave-amp-y', $wave_amp_y);
    $this->set_attribute( '_root', 'data-x-gap', $x_gap);
    $this->set_attribute( '_root', 'data-y-gap', $y_gap);
    $this->set_attribute( '_root', 'data-friction', $friction);
    $this->set_attribute( '_root', 'data-tension', $tension);
    $this->set_attribute( '_root', 'data-max-cursor-move', $max_cursor_move);

    $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
    $output .= '<canvas class="nb-interactive-lines-v4__canvas"></canvas>';
    $output .= Frontend::render_children( $this );
    $output .= "</{$this->tag}>";

	echo $output;
  }
}