<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Link_Preview extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'next_link_preview';
  public $icon         = 'ion-ios-link';
  public $tag      = 'p';
  public $scripts      = ['next_link_preview'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Link Preview', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
        'p' => 'p',
        'div' => 'div',
        'section' => 'section',
        'article' => 'article',
        'aside' => 'aside',
        'header' => 'header',
        'footer' => 'footer',
        'main' => 'main',
        'nav' => 'nav',
        'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];

    /*css*/
    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Block Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['width'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'width',
            'selector' => '',
          ]
        ],
        'default' => '100%',
    ];
    $this->controls['maxWidth'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Max Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'max-width',
            'selector' => '',
          ]
        ],
        'default' => '500px',
    ];
    $this->controls['height'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'height',
            'selector' => '',
          ]
        ],
        'default' => 'auto',
    ];
    
    $this->controls['linkStyleSeparator'] = [
        'label'      => esc_html__( 'Link Text', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['linkTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '.nb-link-preview__text',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'font-weight' => '500',
            'color' => [
                'hex' => '#3b8ff0',
            ],
        ],
    ];
    $this->controls['linkHoverColor'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Hover Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--link-hover-color',
                'selector' => '.nb-link-preview__text',
            ],
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];
    $this->controls['linkHoverDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Hover Duration', 'bricks' ),
        'type'    => 'number',
        'unit'   => 's',
        'inline'  => true,
        'css'     => [
            [
                'property' => '--link-hover-duration',
                'selector' => '.nb-link-preview__text',
            ],
        ],
        'default' => '0.3s',
    ];
    $this->controls['linkHoverEasing'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Hover CSS Easing', 'bricks' ),
        'type'    => 'text',
        'inline'  => true,
        'css'     => [
            [
                'property' => '--link-hover-easing',
                'selector' => '.nb-link-preview__text',
            ],
        ],
        'default' => 'ease',
    ];

    $this->controls['linkImageStyleSeparator'] = [
        'label'      => esc_html__( 'Link Image', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['imageWidth'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Width', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'inline'  => true,
        'css'     => [
            [
                'property' => '--width',
                'selector' => '.nb-link-preview__image',
            ],
        ],
        'default' => '200px',
    ];
    $this->controls['imageHeight'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Height', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'inline'  => true,
        'css'     => [
            [
                'property' => '--height',
                'selector' => '.nb-link-preview__image',
            ],
        ],
        'default' => 'auto',
    ];
    $this->controls['imageTop'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Top', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'inline'  => true,
        'css'     => [
            [
                'property' => 'top',
                'selector' => '.nb-link-preview__image',
            ],
        ],
    ];
    $this->controls['imageBottom'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Bottom', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'inline'  => true,
        'css'     => [
            [
                'property' => 'bottom',
                'selector' => '.nb-link-preview__image',
            ],
        ],
        'default' => '0',
    ];
    $this->controls['imageHoverTop'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Hover Top', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'inline'  => true,
        'css'     => [
            [
                'property' => 'top',
                'selector' => '.nb-link-preview__text:hover + .nb-link-preview__image',
            ],
        ],
    ];
    $this->controls['imageHoverBottom'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Hover Bottom', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'inline'  => true,
        'css'     => [
            [
                'property' => 'bottom',
                'selector' => '.nb-link-preview__text:hover + .nb-link-preview__image',
            ],
        ],
        'default' => '100%',
    ];
    $this->controls['imageBorderRadius'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Border', 'bricks' ),
        'type'    => 'border',
        'css'     => [
            [
                'property' => 'border',
                'selector' => '.nb-link-preview__image',
            ],
        ],
        'default' => [
            'radius' => [
                'top' => '6',
                'right' => '6',
                'bottom' => '6',
                'left' => '6',
            ],
        ],
    ];
    $this->controls['fadeDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Fade Duration', 'bricks' ),
        'type'    => 'number',
        'unit'   => 's',
        'inline'  => true,
        'css'     => [
            [
                'property' => '--fade-duration',
                'selector' => '.nb-link-preview__image',
            ],
        ],
        'default' => '0.3s',
    ];
    $this->controls['fadeEasing'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Fade CSS Easing', 'bricks' ),
        'type'    => 'text',
        'inline'  => true,
        'css'     => [
            [
                'property' => '--fade-easing',
                'selector' => '.nb-link-preview__image',
            ],
        ],
        'default' => 'ease',
    ];
    $this->controls['transformDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Transform Duration', 'bricks' ),
        'type'    => 'number',
        'unit'   => 's',
        'inline'  => true,
        'css'     => [
            [
                'property' => '--transform-duration',
                'selector' => '.nb-link-preview__image',
            ],
        ],
        'default' => '0.3s',
    ];
    $this->controls['transformEasing'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Transform CSS Easing', 'bricks' ),
        'type'    => 'text',
        'inline'  => true,
        'css'     => [
            [
                'property' => '--transform-easing',
                'selector' => '.nb-link-preview__image',
            ],
        ],
        'default' => 'ease',
    ];
  }

  public function get_nestable_children() {
    return [
        [
            'name'     => 'text-basic',
            'label'    => esc_html__( 'Paragraph', 'bricks' ),
            'settings' => [
                'text' => esc_html__( 'Lorem ipsum dolor sit amet consectetur adipisicing elit. Quisquam, quos. ', 'bricks' ),
                'tag'  => 'span',
            ],
        ],
        [
            'name'     => 'block',
            'label'    => esc_html__( 'Link', 'bricks' ),
            'settings' => [
                'tag'  => 'a',
                'link' => [
                    'type' => 'external',
                    'url' => 'https://nextbricks.io',
                ],
                '_hidden'  => [
                    '_cssClasses' => 'nb-link-preview__wrapper',
                ],
            ],
            'children' => [
                [
                    'name'     => 'text-basic',
                    'label'    => esc_html__( 'Text', 'bricks' ),
                    'settings' => [
                        'text' => esc_html__( 'nextbricks.io', 'bricks' ),
                        'tag'  => 'span',
                        '_hidden' => [
                            '_cssClasses' => 'nb-link-preview__text',
                        ],
                    ],
                ],
                [
                    'name'     => 'image',
                    'label'    => esc_html__( 'Image', 'bricks' ),
                    'settings' => [
                        'image'  => [
                            'url' => 'https://bricksdirectory.com/wp-content/uploads/2023/07/next-bricks.jpg',
                        ],
                        '_hidden' => [
                            '_cssClasses' => 'nb-link-preview__image',
                        ],
                    ],
                ],
            ],
        ],
        [
            'name'     => 'text-basic',
            'label'    => esc_html__( 'Paragraph', 'bricks' ),
            'settings' => [
                'text' => esc_html__( ' Lorem ipsum dolor sit amet consectetur adipisicing elit. Quisquam, quos. ', 'bricks' ),
                'tag'  => 'span',
            ],
        ],
        [
            'name'     => 'block',
            'label'    => esc_html__( 'Link', 'bricks' ),
            'settings' => [
                'tag'  => 'a',
                'link' => [
                    'type' => 'external',
                    'url' => 'https://nextbricks.io',
                ],
                '_hidden'  => [
                    '_cssClasses' => 'nb-link-preview__wrapper',
                ],
            ],
            'children' => [
                [
                    'name'     => 'text-basic',
                    'label'    => esc_html__( 'Text', 'bricks' ),
                    'settings' => [
                        'text' => esc_html__( 'nextbricks.io', 'bricks' ),
                        'tag'  => 'span',
                        '_hidden' => [
                            '_cssClasses' => 'nb-link-preview__text',
                        ],
                    ],
                ],
                [
                    'name'     => 'image',
                    'label'    => esc_html__( 'Image', 'bricks' ),
                    'settings' => [
                        'image'  => [
                            'url' => 'https://bricksdirectory.com/wp-content/uploads/2023/07/next-bricks.jpg',
                        ],
                        '_hidden' => [
                            '_cssClasses' => 'nb-link-preview__image',
                        ],
                    ],
                ],
            ],
        ],
    ];
}

  public function render() {
    $settings = $this->settings;
    
    $this->set_attribute( '_root', 'class', "nb-link-preview");

    $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
    $output .= Frontend::render_children( $this );
    $output .= "</{$this->tag}>";

	echo $output;
  }
}