<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Marquee_Button_v2 extends \Bricks\Element {
    public $category     = 'Next Bricks - Buttons';
    public $name         = 'marquee_button_v2';
    public $icon         = 'fa-solid fa-square-minus';
    public $tag      = 'div';
    public $scripts      = ['marquee_button_v2'];

    public function get_label() {
        return esc_html__( 'Marquee Button v2', 'bricks' );
    }

    public function set_controls() {
        $this->controls['tag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'HTML tag', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'div' => 'div',
                'span' => 'span',
                'button' => 'button',
                'custom' => 'custom',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'div',
            'default'     => 'div',
        ];
        $this->controls['customTag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Custom tag', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'placeholder' => 'div',
            'required'    => [ 'tag', '=', 'custom' ],
        ];
        $this->controls['link'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Link to', 'bricks' ),
            'type'  => 'link',
        ];

        /*General style*/
        $this->controls['generalStyleSeparator'] = [
            'label'      => esc_html__( 'General style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['padding'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Padding', 'bricks' ),
            'type'        => 'spacing',
            'css'     => [
                [
                    'property' => '--padding',
                    'selector' => '',
                ],
            ],
            'rerender' => true,
        ];
        $this->controls['typography'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Typography', 'bricks' ),
            'type'        => 'typography',
            'inline'      => true,
            'css'     => [
                [
                  'property' => 'typography',
                  'selector' => '',
                ],
              ],
            'exclude' => [
              'color',
            ],
            'rerender' => true,
        ];
        $this->controls['border'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Border', 'bricks' ),
            'type'        => 'border',
            'css'     => [
                [
                    'property' => 'border',
                    'selector' => '',
                ],
            ],
            'rerender' => true,
        ];

        /*Marquee style*/
        $this->controls['marqueeStyleSeparator'] = [
            'label'      => esc_html__( 'Marquee', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['marqueeInnerTitle'] = [
            'tab'            => 'content',
            'type'           => 'text',
            'hasDynamicData' => 'text',
            'default'        => esc_html__( 'Marquee Button v2', 'bricks' ),
            'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
        ];
        $this->controls['marqueeColor'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Color', 'bricks' ),
            'type'        => 'color',
            'inline'      => true,
            'css'     => [
                [
                  'property' => 'color',
                  'selector' => '&{pseudo} .next-marquee-button-v2__marquee > span',
                ],
            ],
      'default' => [
        'hex' => '#000000',
      ],
    ];
        $this->controls['marqueeBackground'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Background', 'bricks' ),
            'type'        => 'background',
            'inline'      => true,
            'css'     => [
                [
                  'property' => 'background',
                  'selector' => '',
                ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#ffffff',
                ],
            ],
        ];
        $this->controls['marqueeGap'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Gap', 'bricks' ),
            'type'        => 'number',
            'units'      => true,
            'inline'      => true,
            'css'     => [
                [
                  'property' => '--gap',
                  'selector' => '',
                ],
            ],
            'placeholder' => '15px',
            'default' => '15px',
        ];
        /*Marquee Animation*/
        $this->controls['marqueeAnimationSeparator'] = [
            'label'      => esc_html__( 'Marquee Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['marqueeAnimationDuration'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Speed', 'bricks' ),
            'type'        => 'number',
            'unit'        => 's',
            'inline'      => true,
            'css'     => [
                [
                    'property' => '--marquee-speed',
                    'selector' => '',
                ],
            ],
            'placeholder' => '3s',
            'default' => '3s',
        ];
        $this->controls['marqueeAnimationEasing'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'CSS Easing', 'bricks' ),
            'type'        => 'text',
            'css'     => [
                [
                    'property' => '--marquee-easing',
                    'selector' => '',
                ],
            ],
            'inline'      => true,
            'placeholder' => 'linear',
            'default' => 'linear',
        ];
        $this->controls['marqueeReverse'] = [
            'hasDynamicData' => false,
            'tab'         => 'content',
            'label'       => esc_html__( 'Reverse', 'bricks' ),
            'type'        => 'checkbox',
            'inline'      => true,
            'default'     => false,
            'css'     => [
                [
                    'property' => 'animation-direction',
                    'selector' => '& .next-marquee-button-v2__marquee',
                    'value' => 'reverse',
                ],
            ],
        ];
        /*Marquee Translate Animation*/
        $this->controls['marqueeTranslateAnimationSeparator'] = [
            'label'      => esc_html__( 'Marquee Translate Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['marqueeTranslateAnimationDuration'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Duration', 'bricks' ),
            'type'        => 'number',
            'unit'        => 's',
            'inline'      => true,
            'css'     => [
                [
                    'property' => '--marquee-translate-duration',
                    'selector' => '',
                ],
            ],
            'placeholder' => '0.75s',
            'default' => '0.75s',
        ];
        $this->controls['marqueeTranslateAnimationDelay'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Delay', 'bricks' ),
            'type'        => 'number',
            'unit'        => 's',
            'inline'      => true,
            'css'     => [
                [
                    'property' => '--marquee-translate-delay',
                    'selector' => '',
                ],
            ],
            'placeholder' => '0s',
            'default' => '0s',
        ];
        $this->controls['marqueeTranslateAnimationEasing'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'CSS Easing', 'bricks' ),
            'type'        => 'text',
            'css'     => [
                [
                    'property' => '--marquee-translate-easing',
                    'selector' => '',
                ],
            ],
            'inline'      => true,
            'placeholder' => 'ease-out',
            'default' => 'ease-out',
        ];

        /*Swap*/
        $this->controls['swapSeparator'] = [
            'label'      => esc_html__( 'Swap Title', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['swapTitle'] = [
            'tab'            => 'content',
            'type'           => 'text',
            'hasDynamicData' => 'text',
            'default'        => esc_html__( 'Swapped!', 'bricks' ),
            'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
        ];
        $this->controls['swapColor'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Color', 'bricks' ),
            'type'        => 'color',
            'inline'      => true,
            'css'     => [
                [
                  'property' => 'color',
                  'selector' => '&{pseudo} .next-marquee-button-v2__swap',
                ],
            ],
      'default' => [
        'hex' => '#fff',
      ],
    ];
        $this->controls['swapBackground'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Background', 'bricks' ),
            'type'        => 'color',
            'inline'      => true,
            'css'     => [
                [
                  'property' => '--background-hover',
                  'selector' => '&:hover',
                ],
            ],
        ];

        /*Swap Animation*/
        $this->controls['swapAnimationSeparator'] = [
            'label'      => esc_html__( 'Swap Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['swapType'] = [
            'hasDynamicData' => false,
            'tab'         => 'content',
            'label'       => esc_html__( 'Type', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'line' => 'line',
                'words' => 'words',
                'chars' => 'chars',
            ],
            'inline'      => true,
            'placeholder' => 'chars',
            'default' => 'chars',
        ];
        $this->controls['swapStagger'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Stagger', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'placeholder' => '0.02',
        ];
        $this->controls['swapAnimationDuration'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Duration', 'bricks' ),
            'type'        => 'number',
            'unit'        => 's',
            'inline'      => true,
            'css'     => [
                [
                    'property' => '--swap-duration',
                    'selector' => '',
                ],
            ],
            'placeholder' => '0.25s',
            'default' => '0.25s',
        ];
        $this->controls['swapAnimationDelay'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Delay', 'bricks' ),
            'type'        => 'number',
            'unit'        => 's',
            'inline'      => true,
            'css'     => [
                [
                    'property' => '--swap-delay',
                    'selector' => '',
                ],
            ],
            'placeholder' => '0s',
            'default' => '0s',
        ];
        $this->controls['swapAnimationEasing'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'CSS Easing', 'bricks' ),
            'type'        => 'text',
            'css'     => [
                [
                    'property' => '--swap-easing',
                    'selector' => '',
                ],
            ],
            'inline'      => true,
            'placeholder' => 'ease-out',
            'default' => 'ease-out',
        ];

        /*Background Animation*/
        $this->controls['backgroundAnimationSeparator'] = [
            'label'      => esc_html__( 'Background Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['backgroundAnimationDuration'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Duration', 'bricks' ),
            'type'        => 'number',
            'unit'        => 's',
            'inline'      => true,
            'css'     => [
                [
                    'property' => '--background-duration',
                    'selector' => '',
                ],
            ],
            'placeholder' => '0.25s',
            'default' => '0.25s',
        ];
        $this->controls['backgroundAnimationDelay'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Delay', 'bricks' ),
            'type'        => 'number',
            'unit'        => 's',
            'inline'      => true,
            'css'     => [
                [
                    'property' => '--background-delay',
                    'selector' => '',
                ],
            ],
            'placeholder' => '0s',
            'default' => '0s',
        ];
        $this->controls['backgroundAnimationEasing'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'CSS Easing', 'bricks' ),
            'type'        => 'text',
            'css'     => [
                [
                    'property' => '--background-easing',
                    'selector' => '',
                ],
            ],
            'inline'      => true,
            'placeholder' => 'ease-out',
            'default' => 'ease-out',
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next-marquee-button-v2', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_marquee_button_v2.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $marqueeInnerTitle    = ! empty( $settings['marqueeInnerTitle'] ) ? $settings['marqueeInnerTitle'] : 'Marquee Button v2';
        $swapTitle    = ! empty( $settings['swapTitle'] ) ? $settings['swapTitle'] : 'Swapped!';

        $swapType    = ! empty( $settings['swapType'] ) ? $settings['swapType'] : 'chars';
        $swapStagger    = ! empty( $settings['swapStagger'] ) ? $settings['swapStagger'] : 0.02;

        if ( ! empty( $settings['link'] ) ) {
            $this->set_link_attributes( '_root', $settings['link'] );
            $root_tag = 'a';
        }else{
            $root_tag = $this->tag;
        }

        $this->set_attribute( '_root', 'class', 'next-marquee-button-v2' );
        $this->set_attribute( '_root', 'data-next-hide', '' );
        $this->set_attribute( '_root', 'data-type', $swapType );
        $this->set_attribute( '_root', 'data-stagger', $swapStagger );

        $output = "
        <$root_tag {$this->render_attributes( '_root' )}>
            <div class='next-marquee-button-v2__wrapper'>
                <div class='next-marquee-button-v2__marquee'>
                    <span>$marqueeInnerTitle</span>
                    <span>$marqueeInnerTitle</span>
                </div>

                <div class='next-marquee-button-v2__swap'>
                    $swapTitle
                </div>
            </div>
        </$root_tag>
        ";

        echo $output;
    }
}