<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Nudge_Button extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'next-nudge-button';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';
  public $scripts      = ['next_nudge_button'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Nudge Button', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Nudge Button', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['iconsSeparator'] = [
        'label'      => esc_html__( 'Icons', 'bricks' ),
        'type'       => 'separator',
      ];
      $this->controls['includeLeftIcon'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Left Icon', 'bricks' ),
        'type' => 'checkbox',
        'default' => false,
      ];
      $this->controls['leftIcon'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Icon', 'bricks' ),
        'type' => 'icon',
        'css' => [
          [
            'selector' => '&{pseudo} .nb-nudge-button__left-icon',
          ],
        ],
        'required'   => [ 'includeLeftIcon', '=', true ],
      ];
      $this->controls['leftIconMargin'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Margin', 'bricks' ),
        'type'  => 'spacing',
        'css'   => [
          [
            'property' => 'margin',
            'selector' => '&{pseudo} .nb-nudge-button__left-icon',
          ],
        ],
        'required' => [ 'includeLeftIcon', '=', true ],
      ];
      $this->controls['leftIconSize'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Size', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'css'   => [
          [
            'property' => 'font-size',
            'selector' => '&{pseudo} .nb-nudge-button__left-icon',
          ],
        ],
        'required' => [ 'includeLeftIcon', '=', true ],
      ];
      $this->controls['leftIconColor'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Color', 'bricks' ),
        'type'  => 'color',
        'css'   => [
          [
            'property' => 'color',
            'selector' => '&{pseudo} .nb-nudge-button__left-icon',
          ],
        ],
        'required' => [ 'includeLeftIcon', '=', true ],
      ];
      $this->controls['includeRightIcon'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Right Icon', 'bricks' ),
        'type' => 'checkbox',
        'default' => false,
      ];
      $this->controls['rightIcon'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Icon', 'bricks' ),
        'type' => 'icon',
        'css' => [
          [
            'selector' => '&{pseudo} .nb-nudge-button__right-icon',
          ],
        ],
        'required'   => [ 'includeRightIcon', '=', true ],
      ];
      $this->controls['rightIconMargin'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Margin', 'bricks' ),
        'type'  => 'spacing',
        'css'   => [
          [
            'property' => 'margin',
            'selector' => '&{pseudo} .nb-nudge-button__right-icon',
          ],
        ],
        'required' => [ 'includeRightIcon', '=', true ],
      ];
      $this->controls['rightIconSize'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Size', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'css'   => [
          [
            'property' => 'font-size',
            'selector' => '&{pseudo} .nb-nudge-button__right-icon',
          ],
        ],
        'required' => [ 'includeRightIcon', '=', true ],
      ];
      $this->controls['rightIconColor'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Color', 'bricks' ),
        'type'  => 'color',
        'css'   => [
          [
            'property' => 'color',
            'selector' => '&{pseudo} .nb-nudge-button__right-icon',
          ],
        ],
        'required' => [ 'includeRightIcon', '=', true ],
      ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['padding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '&{pseudo} .nb-nudge-button__button',
            ],
        ],
        'default' => [
            'top'    => 10,
            'right'  => 15, 
            'bottom' => 10,
            'left'   => 15,
        ],
    ];
    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '&{pseudo} .nb-nudge-button__button',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'font-weight' => '500',
            'color' => [
                'hex' => '#000000',
              ]
        ],
    ];
    $this->controls['background'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&{pseudo} .nb-nudge-button__button',
            ],
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];
    $this->controls['border'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Border', 'bricks'),
        'type'    => 'border',
        'css'     => [
          [
            'property' => 'border',
            'selector' => '&{pseudo} .nb-nudge-button__button',
          ],
        ],
        'default' => [
            'radius' => [
                'top' => 6,
                'right' => 6,
                'bottom' => 6,
                'left' => 6,
            ],
        ]
    ];

    $this->controls['nudgeSeparator'] = [
        'label'      => esc_html__( 'Nudge', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['nudgeHeight'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Height', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => '--nudge-height',
                'selector' => '',
            ],
        ],
        'default' => '30px',
    ];
    $this->controls['nudgeBackground'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'background',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&, .nb-nudge-button__nudge',
            ],
        ],
        'default' => [
            'color' => [
                'hex' => '#b1b1b1',
            ],
        ],
    ];
    $this->controls['nudgePaddingVertical'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Vertical Padding', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => '--padding-vertical',
                'selector' => '',
            ],
        ],
        'default' => '4px',
    ];
    $this->controls['nudgePaddingHorizontal'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Horizontal Padding', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => '--padding-horizontal',
                'selector' => '',
            ],
        ],
        'default' => '4px',
    ];
    $this->controls['nudgeBorderRadius'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Border Radius', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => '--control-border-radius',
                'selector' => '',
            ],
        ],
        'default' => '10px',
    ];
    $this->controls['nudgeDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Duration', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => '--nudge-duration',
                'selector' => '&{pseudo} .nb-nudge-button__nudge',
            ],
        ],
        'default' => '0.2s',
    ];
    
    $this->controls['nudgeEasing'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'CSS Easing', 'bricks' ),
        'type'    => 'text',
        'inline'  => true,
        'css'     => [
            [
                'property' => '--nudge-easing',
                'selector' => '&{pseudo} .nb-nudge-button__nudge',
            ],
        ],
        'default' => 'cubic-bezier(0.25, 0.46, 0.45, 0.94)',
    ];
  }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'next-text-shimmer',
                'settings' => [
                    'inner_title' => 'great shimmer',
                    'textColor' => [
                        'rgb' => 'rgba(0, 0, 0, 0.4)',
                    ],
                    'shimmerSize' => 50,
                    'shimmerColor'=> [
                        'rgb' => 'rgba(255, 255, 255, 0.9)',
                    ],
                    'padding' => [
                        'top'    => 0,
                        'right'  => 0, 
                        'bottom' => 0,
                        'left'   => 0,
                    ],
                    'titleTypography' => [
                        'font-size' => '12px',
                        'font-weight' => '500',
                    ],
                    'duration' => '1.7s',
                    'delayBetweenShimmers' => '1.5s',
                    'ease' => 'sine',
                ],
            ],
        ];
    }

  public function enqueue_scripts() {
    wp_enqueue_script( 'next_nudge_button', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_nudge_button.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Nudge Button';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $includeLeftIcon = ! empty( $settings['includeLeftIcon'] ) ? $settings['includeLeftIcon'] : 0;
    $includeRightIcon = ! empty( $settings['includeRightIcon'] ) ? $settings['includeRightIcon'] : 0;
    if ( $includeLeftIcon !== 0 ) {
      $leftIcon = self::render_icon( $settings['leftIcon'], [ 'nb-nudge-button__left-icon' ] );
    }else{
      $leftIcon = '';
    }
    if ( $includeRightIcon !== 0 ) {
      $rightIcon = self::render_icon( $settings['rightIcon'], [ 'nb-nudge-button__right-icon' ] );
    }else{
      $rightIcon = '';
    }

    $this->set_attribute( '_root', 'class', 'nb-nudge-button' );

    $output = "
    <$root_tag  {$this->render_attributes( '_root' )}>
        <div class='nb-nudge-button__nudge'>
            <div class='nb-nudge-button__nudge-children'>";
            $output .= Frontend::render_children( $this );
            $output .= "</div>
        </div>
        <div class='nb-nudge-button__button'>$leftIcon$inner_title$rightIcon</div>
    </$root_tag>
    ";

	echo $output;
  }
}