<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Prism_Button_V2 extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'next-prism-button-v2';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';

  public function get_label() {
    return esc_html__( 'Prism Button v2', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Prism Button v2', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['padding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '&{pseudo} .nb-prism-button-v2__text',
            ],
        ],
        'default' => [
            'top'    => 10,
            'right'  => 15, 
            'bottom' => 10,
            'left'   => 15,
        ],
    ];
    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'color' => [
                'hex' => '#ffffff',
              ]
        ],
    ];
    $this->controls['background'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&{pseudo} .nb-prism-button-v2__text',
            ],
            [
                'property' => 'background',
                'selector' => '&{pseudo} .nb-prism-button-v2__inner::before',
            ],
            [
                'property' => 'background',
                'selector' => '&{pseudo} .nb-prism-button-v2__inner::after',
            ],
        ],
        'default' => [
            'hex' => '#000000',
        ],
    ];
    $this->controls['border'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Border', 'bricks'),
        'type'    => 'border',
        'css'     => [
          [
            'property' => 'border',
            'selector' => '&{pseudo} .nb-prism-button-v2__text',
          ],
          [
            'property' => 'border',
            'selector' => '&{pseudo} .nb-prism-button-v2__inner::before',
          ],
          [
            'property' => 'border',
            'selector' => '&{pseudo} .nb-prism-button-v2__inner::after',
          ],
        ],
        'default' => [
            'radius' => [
                'top' => 5,
                'right' => 5,
                'bottom' => 5,
                'left' => 5,
            ],
        ]
    ];

    $this->controls['prismAnimationSeparator'] = [
        'label'      => esc_html__( 'Prism Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['perspective'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Perspective', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'perspective',
                'selector' => '',
            ],
        ],
        'default' => '40em',
    ];
    $this->controls['prismTranslate'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Translate', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => '--translate',
                'selector' => '',
            ],
        ],
        'default' => '10px',
    ];
    $this->controls['reelDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Duration', 'bricks' ),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
            [
                'property' => '--translate-duration',
                'selector' => '',
            ],
        ],
        'default' => '0.7s',
    ];
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Prism Button v2';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $this->set_attribute( '_root', 'class', 'nb-prism-button-v2' );

    $output = "
    <$root_tag  {$this->render_attributes( '_root' )}>
        <span data-text='$inner_title' class='nb-prism-button-v2__inner'>
            <span class='nb-prism-button-v2__text'>$inner_title</span>
        </span>
    </$root_tag>
    ";

	echo $output;
  }
}