<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Progress_Bar_v2 extends \Bricks\Element {
    public $category     = 'Next Bricks - Cores';
    public $name         = 'next_progress_bar_v2';
    public $icon         = 'fas fa-grip-lines';
    public $scripts      = ['next_progress_bar_v2'];

    public function get_label() {
        return esc_html__( 'Progress Bar v2', 'bricks' );
    }

    public function set_controls() {
        $this->controls['height'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => 'height',
                    'selector' => '',
                ],
            ],
            'default' => 4,
        ];

        /*Position*/
        $this->controls['Position'] = [
            'label'      => esc_html__( 'Position', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['zIndex'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'z-index', 'bricks' ),
            'type'  => 'text',
            'inline' => true,
            'small' => true,
            'css'   => [
                [
                    'property' => 'z-index',
                    'selector' => '',
                ],
            ],
            'default' => '9999',
        ];
        $this->controls['top'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Top', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => 'top',
                    'selector' => '',
                ],
            ],
            'default' => '0',
        ];
        $this->controls['bottom'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Bottom', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => 'bottom',
                    'selector' => '',
                ],
            ],
        ];

        /*Gradient*/
        $this->controls['Gradient'] = [
            'label'      => esc_html__( 'Gradient', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['colors'] = [
            'tab'           => 'content',
            'type'          => 'repeater',
            'label'         => esc_html__( 'Colors', 'bricks' ),
            'titleProperty' => 'title',
            'fields'        => [
                'gradientcolor'       => [
                    'type'    => 'color',
                    'label'   => esc_html__( 'Color', 'bricks' ),
                ],
            ],
            'default'       => [
                [
                    'gradientcolor' => [
                        'hex' => '#A97CF8'
                    ]
                ],
                [
                    'gradientcolor' => [
                        'hex' => '#F38CB8'
                    ]
                ],
                [
                    'gradientcolor' => [
                        'hex' => '#FDCC92'
                    ]
                ]
            ]
        ];

        /*Animation*/
        $this->controls['Animation'] = [
            'label'      => esc_html__( 'Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['duration'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type'  => 'number',
            'default' => '0.5',
        ];
        $this->controls['ease'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'GSAP easing', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'none' => 'none',
                'power1' => 'power1',
                'power2' => 'power2',
                'power3' => 'power3',
                'power4' => 'power4',
                'back' => 'back',
                'bounce' => 'bounce',
                'circ' => 'circ',
                'elastic' => 'elastic',
                'expo' => 'expo',
                'sine' => 'sine',
                'steps' => 'steps',
                'custom' => 'custom'
            ],
            'inline' => true,
            'default' => 'expo',
        ];
    $this->controls['customEase'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'ease', '=', 'custom' ],
    ];



    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_progress_bar_v2', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_progress_bar_v2.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $colors = ! empty( $settings['colors'] ) ? $settings['colors'] : '';
        $duration = ! empty( $settings['duration'] ) ? $settings['duration'] : '0.5';
        $ease = ! empty( $settings['ease'] ) ? $settings['ease'] : 'expo';
        if ($ease === 'custom') {
      $ease = ! empty( $settings['customEase'] ) ? $settings['customEase'] : 'expo';
    }

        $this->set_attribute( '_root', 'class', "next-progress-bar-v2");
        $this->set_attribute( '_root', 'data-duration', $duration);
        $this->set_attribute( '_root', 'data-ease', $ease);
    
        if ($colors) {
            $gradientcolors = '';
            foreach ( $colors as $color ) {
                if ( isset($color['gradientcolor']) && is_array($color['gradientcolor'])) {
                    if (isset($color['gradientcolor']['rgb'])) {
                      $gradientcolor = $color['gradientcolor']['rgb'];
                    }else if(isset($color['gradientcolor']['raw'])){
                      $gradientcolor = $color['gradientcolor']['raw'];
                    }else if(isset($color['gradientcolor']['hex'])){
                      $gradientcolor = $color['gradientcolor']['hex'];
                    }
                    $gradientcolors .= $gradientcolor . 'next11';
                }else{
                    $gradientcolors .= 'unset' . 'next11';
                }
            }
            $gradientcolors .= '';
        }else{
            $gradientcolors = 'unset';
        }
        $this->set_attribute( '_root', 'data-gradient-colors', $gradientcolors);

        $output = "<div {$this->render_attributes( '_root' )}></div>";

        echo $output;
    }
}