<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Ripple_Button_V6 extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'next-ripple-button-v6';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';

  public function get_label() {
    return esc_html__( 'Ripple Button v6', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Ripple Button v6', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['padding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '&{pseudo}::after',
            ],
            [
                'property' => 'padding',
                'selector' => '&{pseudo} .nb-ripple-button-v6__inner',
            ],
        ],
        'default' => [
            'top'    => 10,
            'right'  => 15, 
            'bottom' => 10,
            'left'   => 15,
        ],
    ];
    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'color' => [
                'hex' => '#000000',
              ]
        ],
    ];
    $this->controls['swapTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Swap Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '&{pseudo}::after',
            ],
        ],
        'default' => [
            'color' => [
                'hex' => '#ffffff',
              ]
        ],
    ];
    $this->controls['background'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&{pseudo} .nb-ripple-button-v6__inner',
            ],
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];
    $this->controls['border'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Border', 'bricks'),
        'type'    => 'border',
        'css'     => [
          [
            'property' => 'border',
            'selector' => '&{pseudo}::after',
          ],
          [
            'property' => 'border',
            'selector' => '&{pseudo} .nb-ripple-button-v6__inner',
          ],
        ],
        'default' => [
            'radius' => [
                'top' => 8,
                'right' => 8,
                'bottom' => 8,
                'left' => 8,
            ],
        ]
    ];

    $this->controls['rippleAnimationSeparator'] = [
        'label'      => esc_html__( 'Ripple Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['rippleColor'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&{pseudo}::after',
            ],
        ],
        'default' => [
            'hex' => '#0080ff',
        ],
    ];
    $this->controls['rippleTranslate'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Translate', 'bricks' ),
        'type'    => 'number',
        'units'    => true,
        'css'     => [
            [
                'property' => '--ripple-translate',
                'selector' => '',
            ],
        ],
        'default' => '0.5em',
    ];
    $this->controls['rippleDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Duration', 'bricks' ),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
            [
                'property' => '--ripple-duration',
                'selector' => '',
            ],
        ],
        'default' => '0.4s',
    ];
    $this->controls['rippleDelay'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Delay', 'bricks' ),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
            [
                'property' => '--ripple-delay',
                'selector' => '',
            ],
        ],
        'default' => '0.08s',
    ];
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Ripple Button v6';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $this->set_attribute( '_root', 'class', 'nb-ripple-button-v6' );
    $this->set_attribute( '_root', 'data-text', $inner_title );

    $output = "
    <$root_tag  {$this->render_attributes( '_root' )}>
        <span class='nb-ripple-button-v6__inner'>
            <span class='nb-ripple-button-v6__text'>$inner_title</span>
        </span>
    </$root_tag>
    ";

	echo $output;
  }
}