<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Stacking_Cards extends \Bricks\Element {
    public $category     = 'Next Bricks - Cores';
    public $name         = 'next_stacking_cards';
    public $icon         = 'ion-ios-albums';
    public $scripts      = ['next_stacking_cards'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Stacking Cards', 'bricks' );
    }

    public function set_controls() {
        $this->controls['_children'] = [
            'type'          => 'repeater',
            'titleProperty' => 'label',
            'items'         => 'children',
        ];
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'If you want the last card to stack you will have to define a fixed height.', 'bricks' )))
        ];
        $this->controls['ROOTheight'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                    'property' => 'height',
                    'selector' => '',
                ]
            ],
            'placeholder' => 'auto',
        ];

        /*Style*/
        $this->controls['cardsStyleSeparator'] = [
            'label'      => esc_html__( 'Cards Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['noteStyle'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Cards styles can be set here at once or at their own style tab. They have a custom background already set.', 'bricks' )))
        ];
        $this->controls['padding'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type' => 'spacing',
            'css' => [
                [
                    'property' => 'padding',
                    'selector' => '.next-stacking-cards__card',
                ]
            ],
        ];
        $this->controls['width'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                    'property' => '--width',
                    'selector' => '',
                ]
            ],
            'placeholder' => '100vw',
        ];
        $this->controls['height'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                    'property' => '--height',
                    'selector' => '',
                ]
            ],
            'placeholder' => '100vh',
        ];
        $this->controls['typography'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Typography', 'bricks' ),
            'type' => 'typography',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                    'property' => 'typography',
                    'selector' => '.next-stacking-cards__card',
                ]
            ],
        ];
        $this->controls['boxShadow'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Box shadow', 'bricks' ),
            'type' => 'box-shadow',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                    'property' => 'box-shadow',
                    'selector' => '.next-stacking-cards__card',
                ]
            ],
        ];

        /*Animation*/
        $this->controls['animationSeparator'] = [
            'label'      => esc_html__( 'Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['noteOffset'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Top will define the general top distance the cards will stick to. In case you want a stacking effect you can customize top value at each card.', 'bricks' )))
        ];
        $this->controls['offset'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Top', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'css' => [
                [
                    'property' => '--offset',
                    'selector' => '',
                ]
            ],
            'placeholder' => '0px',
        ];
        $this->controls['finalBrightness'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Brightness to', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => '50%',
        ];
        $this->controls['scaleTo'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Scale to', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => '0.95',
        ];
        $this->controls['radiusTo'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Radius to', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => '40',
        ];

        /*ScrollTrigger*/
        $this->controls['scrolltriggerSeparator'] = [
            'label'      => esc_html__( 'ScrollTrigger', 'bricks' ),
            'type'       => 'separator',
            'description' => sprintf(esc_html__( 'Scrolltrigger %s', 'bricks' ), '<a href="https://greensock.com/docs/v3/Plugins/ScrollTrigger" target="_blank">documentation</a>'),
        ];
        $this->controls['noteStacking'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Start and End values are applied to Stacking Cards element, that wraps all the cards.', 'bricks' )))
        ];
        $this->controls['start'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Start', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => 'top top',
        ];
        $this->controls['end'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'End', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => '+=100%',
        ];
        $this->controls['easing'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'GSAP easing', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'none' => 'none',
                'power1' => 'power1',
                'power2' => 'power2',
                'power3' => 'power3',
                'power4' => 'power4',
                'back' => 'back',
                'bounce' => 'bounce',
                'circ' => 'circ',
                'elastic' => 'elastic',
                'expo' => 'expo',
                'sine' => 'sine',
                'steps' => 'steps'
            ],
            'inline' => true,
            'placeholder' => 'none',
        ];
    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Card', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-stacking-cards__card next-stacking-cards__card--1',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Heading', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Card', 'bricks' ),
                            'tag'  => 'h3',
                        ],
                    ]
                ]
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Card', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-stacking-cards__card next-stacking-cards__card--2',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Heading', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Card', 'bricks' ),
                            'tag'  => 'h3',
                        ],
                    ]
                ]
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Card', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-stacking-cards__card next-stacking-cards__card--3',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Heading', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Card', 'bricks' ),
                            'tag'  => 'h3',
                        ],
                    ]
                ]
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_stacking_cards', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_stacking_cards.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;

        $finalBrightness = ! empty( $settings['finalBrightness'] ) ? $settings['finalBrightness'] : 50;
        $scaleTo = ! empty( $settings['scaleTo'] ) ? $settings['scaleTo'] : 0.95;
        $radiusTo = ! empty( $settings['radiusTo'] ) ? $settings['radiusTo'] : 40;

        $start = ! empty( $settings['start'] ) ? $settings['start'] : 'top top';
        $end = ! empty( $settings['end'] ) ? $settings['end'] : '+=100%';
        $easing = ! empty( $settings['easing'] ) ? $settings['easing'] : 'none';

        $this->set_attribute( '_root', 'class', "next-stacking-cards");

        $this->set_attribute( '_root', 'data-final-brightness', $finalBrightness );
        $this->set_attribute( '_root', 'data-scale', $scaleTo );
        $this->set_attribute( '_root', 'data-border-radius', $radiusTo );

        $this->set_attribute( '_root', 'data-start', $start );
        $this->set_attribute( '_root', 'data-end', $end );
        $this->set_attribute( '_root', 'data-easing', $easing );

        $output = "<div {$this->render_attributes( '_root' )}>";
        $output .= Frontend::render_children( $this );
        $output .= '</div>';

        echo $output;
    }
}