<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Sticky_Footer extends \Bricks\Element {
    public $category     = 'Next Bricks - Cores';
    public $name         = 'next_sticky_footer';
    public $icon         = 'ti-layout-media-center-alt';
    public $tag          = 'div';
    public $scripts      = [ 'next_sticky_footer' ];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Sticky Footer', 'bricks' );
    }

    public function set_controls() {
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'All your content to be affected by the Sticky Footer has to be placed inside the Content block.', 'bricks' )))
        ];

        $this->controls['tag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'HTML tag', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'div'    => 'div',
                'footer' => 'footer',
                'section'=> 'section',
                'custom' => 'custom',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'div',
            'default'     => 'div',
        ];

        $this->controls['customTag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Custom tag', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'placeholder' => 'div',
            'required'    => [ 'tag', '=', 'custom' ],
        ];
    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Content', 'bricks' ),
                'settings' => [
                    '_cssClasses' => 'nb-sticky-footer__wrapper',
                    '_background' => [
                        'color' => [
                            'hex' => '#000000',
                        ],
                    ],
                    '_justifyContent' => 'center',
                    '_alignItems' => 'center',
                ],
                'children' => [
                    [
                        'name'     => 'text-basic',
                        'label'    => esc_html__( 'Text', 'bricks' ),
                        'settings' => [
                            'text' => 'Sticky Footer',
                            '_typography' => [
                                'font-size' => '64px',
                                'color' => [
                                    'hex' => '#ffffff',
                                ],
                            ],
                            '_margin' => [
                                'top' => '100px',
                                'bottom' => '100px',
                            ],
                        ],
                    ],
                ],
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_sticky_footer', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_sticky_footer.min.js', array( 'bricks-scripts' ), NEXTBRICKS_VERSION, false );
    }

    public function render() {
        $this->set_attribute( '_root', 'class', 'nb-sticky-footer' );

        $output  = "<{$this->tag} {$this->render_attributes( '_root' )}>";
        $output .= Frontend::render_children( $this );
        $output .= "</{$this->tag}>";

        echo $output;
    }
}
