<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Stories extends \Bricks\Element {
  public $category     = 'Next Bricks - Sliders';
  public $name         = 'next_stories';
  public $icon         = 'ti-layout-tab';
  public $tag      = 'div';
  public $scripts      = ['next_stories'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Stories', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'div' => 'div',
            'section' => 'section',
            'article' => 'article',
            'aside' => 'aside',
            'header' => 'header',
            'footer' => 'footer',
            'main' => 'main',
            'nav' => 'nav',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'div',
        'default'     => 'div',
    ];
    $this->controls['customTag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Custom tag', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'placeholder' => 'div',
        'required'    => [ 'tag', '=', 'custom' ],
    ];

    /*css*/
    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Block', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['width'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'width',
            'selector' => '',
          ]
        ],
        'default' => '250px',
    ];
    $this->controls['height'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'height',
            'selector' => '',
          ]
        ],
        'default' => '250px',
    ];
    $this->controls['border'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Border', 'bricks' ),
        'type'  => 'border',
        'css'   => [
            [
                'property' => 'border',
                'selector' => '',
            ],
        ],
        'default' => [
            'radius' => [
                'top' => '20',
                'right' => '20',
                'bottom' => '20',
                'left' => '20',
            ]
        ],
    ];
    $this->controls['boxShadow'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Box Shadow', 'bricks' ),
        'type'  => 'box-shadow',
        'css'   => [
            [
                'property' => 'box-shadow',
                'selector' => '',
            ],
        ],
    ];

    $this->controls['thumbsSeparator'] = [
        'label'      => esc_html__( 'Thumbs', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['thumbsPadding'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Padding', 'bricks' ),
        'type'  => 'spacing',
        'css' => [
            [
                'property' => 'padding',
                'selector' => '.nb-stories__controls .nb-stories__controls-thumb',
            ],
        ],
        'default' => [
            'top' => '12',
            'right' => '16',
            'bottom' => '12',
            'left' => '16',
        ],
    ];
    $this->controls['thumbsGap'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Gap', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
            [
                'property' => 'gap',
                'selector' => '.nb-stories__controls .nb-stories__controls-thumb',
            ],
        ],
        'default' => '4px',
    ];
    $this->controls['thumbHeight'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
            [
                'property' => 'height',
                'selector' => '.nb-stories__controls .nb-stories__controls-thumb > span',
            ],
        ],
        'default' => '4px',
    ];
    $this->controls['thumbBackground'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Color', 'bricks' ),
        'type'  => 'color',
        'css' => [
            [
                'property' => 'background',
                'selector' => '.nb-stories__controls .nb-stories__controls-thumb > span',
            ],
        ],
        'default' => [
            'rgb' => 'rgba(233, 232, 232, .2)',
        ],
    ];
    $this->controls['thumbActiveColor'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Active Color', 'bricks' ),
        'type'  => 'color',
        'css' => [
            [
                'property' => 'background',
                'selector' => '.nb-stories__controls .thumb-item.active',
            ],
        ],
        'default' => [
            'hex' => '#e9e8e8',
        ],
    ];
    $this->controls['thumbBorder'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Border', 'bricks' ),
        'type'  => 'border',
        'css' => [
            [
                'property' => 'border',
                'selector' => '.nb-stories__controls .nb-stories__controls-thumb > span',
            ],
        ],
        'default' => [
            'radius' => [
                'top' => '4',
                'right' => '4',
                'bottom' => '4',
                'left' => '4',
            ]
        ],
    ];
    $this->controls['thumbActiveBorder'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Active Border', 'bricks' ),
        'type'  => 'border',
        'css' => [
            [
                'property' => 'border',
                'selector' => '.nb-stories__controls .thumb-item.active',
            ],
        ],
        'default' => [
            'radius' => [
                'top' => '4',
                'right' => '4',
                'bottom' => '4',
                'left' => '4',
            ]
        ],
    ];

    $this->controls['storiesSeparator'] = [
        'label'      => esc_html__( 'Stories', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['storyBrightness'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Brightness', 'bricks' ),
        'type'  => 'number',
        'inline' => true,
        'css' => [
            [
                'property' => '--story-brightness',
                'selector' => '',
            ],
        ],
        'default' => '70%',
    ];

    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['disablebuilder'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
        'type'     => 'checkbox',
        'default' => false,
    ];
    $this->controls['duration'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type'  => 'number',
        'unit' => 's',
        'inline' => true,
        'css' => [
            [
                'property' => 'animation-duration',
                'selector' => '.nb-stories__controls .thumb-item',
            ],
        ],
        'default' => '5s',
    ];
    $this->controls['ease'] = [
        'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'GSAP Easing', 'bricks' ),
          'type' => 'select',
          'options'     => [
            'none' => 'none',
            'power1' => 'power1',
            'power2' => 'power2',
            'power3' => 'power3',
            'power4' => 'power4',
            'back' => 'back',
            'bounce' => 'bounce',
            'circ' => 'circ',
            'elastic' => 'elastic',
            'expo' => 'expo',
            'sine' => 'sine',
            'steps' => 'steps',
            'custom' => 'custom'
          ],
          'inline' => true,
          'default' => 'none',
      ];
    $this->controls['customEase'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'ease', '=', 'custom' ],
    ];



  }

  public function get_nestable_children() {
    return [
        [
            'name'     => 'block',
            'label'    => esc_html__( 'Story', 'bricks' ),
            'settings' => [
                '_hidden'  => [
                    '_cssClasses' => 'nb-stories__story',
                ],
            ],
            'children' => [
                [
                    'name'     => 'image',
                    'label'    => esc_html__( 'Image', 'bricks' ),
                    'settings' => [
                        'image'  => [
                            'url' => 'https://images.pexels.com/photos/31737046/pexels-photo-31737046.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2',
                        ],
                    ],
                ],
            ],
        ],
        [
            'name'     => 'block',
            'label'    => esc_html__( 'Story', 'bricks' ),
            'settings' => [
                '_hidden'  => [
                    '_cssClasses' => 'nb-stories__story',
                ],
            ],
            'children' => [
                [
                    'name'     => 'image',
                    'label'    => esc_html__( 'Image', 'bricks' ),
                    'settings' => [
                        'image'  => [
                            'url' => 'https://images.pexels.com/photos/27085501/pexels-photo-27085501/free-photo-of-planta-ventanas-descuidado-cubierto-de-vegetacion.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2',
                        ],
                    ],
                ],
            ],
        ],
        [
            'name'     => 'block',
            'label'    => esc_html__( 'Story', 'bricks' ),
            'settings' => [
                '_hidden'  => [
                    '_cssClasses' => 'nb-stories__story',
                ],
            ],
            'children' => [
                [
                    'name'     => 'video',
                    'label'    => esc_html__( 'Video', 'bricks' ),
                    'settings' => [
                        'videoType' => 'file',
                        'fileUrl' => 'https://videos.pexels.com/video-files/31565670/13452401_1440_2560_60fps.mp4',
                        'fileMute' => true,
                        'fileInline' => true,
                        'fileControls' => false,
                    ],
                ],
            ],
        ],
        [
            'name'     => 'block',
            'label'    => esc_html__( 'Story', 'bricks' ),
            'settings' => [
                '_hidden'  => [
                    '_cssClasses' => 'nb-stories__story',
                ],
            ],
            'children' => [
                [
                    'name'     => 'image',
                    'label'    => esc_html__( 'Image', 'bricks' ),
                    'settings' => [
                        'image'  => [
                            'url' => 'https://images.pexels.com/photos/31477151/pexels-photo-31477151.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2',
                        ],
                    ],
                ],
            ],
        ],
        [
            'name'     => 'block',
            'label'    => esc_html__( 'Story', 'bricks' ),
            'settings' => [
                '_hidden'  => [
                    '_cssClasses' => 'nb-stories__story',
                ],
            ],
            'children' => [
                [
                    'name'     => 'image',
                    'label'    => esc_html__( 'Image', 'bricks' ),
                    'settings' => [
                        'image'  => [
                            'url' => 'https://images.pexels.com/photos/31568335/pexels-photo-31568335/free-photo-of-majestuoso-resplandor-alpino-en-el-pico-de-la-montana-nevada.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2',
                        ],
                    ],
                ],
            ],
        ],
    ];
  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'next_stories', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_stories.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $is_builder = bricks_is_builder();
    $disablebuilder = !empty($settings['disablebuilder']) ? $settings['disablebuilder'] : 0;
    $duration = !empty($settings['duration']) ? $settings['duration'] : '5';
    $ease = !empty($settings['ease']) ? $settings['ease'] : 'none';
    if ($ease === 'custom') {
      $ease = ! empty( $settings['customEase'] ) ? $settings['customEase'] : 'none';
    }
    
    $this->set_attribute( '_root', 'class', "nb-stories");

    if ( ! $is_builder ) {
      $this->set_attribute('_root', 'data-flickering', '1');
    }
    $this->set_attribute('_root', 'data-disable-builder', $disablebuilder);
    $this->set_attribute('_root', 'data-duration', $duration);
    $this->set_attribute('_root', 'data-ease', $ease);

    $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
    $output .= "<div class='nb-stories__container'>";
    $output .= Frontend::render_children( $this );
    $output .= "</div>";
    $output .= "
    <div class='nb-stories__controls'>
        <div class='nb-stories__controls-thumb'>";
    $output .= "</div>
    </div>
    ";
    $output .= "</{$this->tag}>";

	echo $output;
  }
}
